/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.vendor.VendorMessageFactory;
import com.limegroup.gnutella.routing.RouteTableMessage;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.MessageSettings;
import com.limegroup.gnutella.statistics.ReceivedErrorStat;
import com.limegroup.gnutella.udpconnect.UDPConnectionMessage;
import com.limegroup.gnutella.util.DataUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageFactory {
    private static final Log LOG;
    private static final MessageParser[] PARSERS;
    private static final byte SOFT_MAX;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.messages.MessageFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        PARSERS = new MessageParser[255];
        SOFT_MAX = ConnectionSettings.SOFT_MAX.getValue();
        MessageFactory.setParser((byte)0, new PingRequestParser());
        MessageFactory.setParser((byte)1, new PingReplyParser());
        MessageFactory.setParser((byte)-128, new QueryRequestParser());
        MessageFactory.setParser((byte)-127, new QueryReplyParser());
        MessageFactory.setParser((byte)64, new PushRequestParser());
        MessageFactory.setParser((byte)48, new RouteTableUpdateParser());
        MessageFactory.setParser((byte)49, new VendorMessageParser());
        MessageFactory.setParser((byte)50, new VendorMessageStableParser());
        MessageFactory.setParser((byte)65, new UDPConnectionParser());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setParser(byte by, MessageParser messageParser) {
        if (messageParser == null) {
            throw new NullPointerException("MessageParser is null");
        }
        int n = by & 0xFF;
        MessageParser messageParser2 = null;
        MessageParser[] messageParserArray = PARSERS;
        synchronized (PARSERS) {
            messageParser2 = PARSERS[n];
            MessageFactory.PARSERS[n] = messageParser;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (messageParser2 != null && LOG.isErrorEnabled()) {
                LOG.error((Object)("There was already a MessageParser of type " + messageParser2.getClass() + " registered for functionId " + by));
            }
            return;
        }
    }

    public static MessageParser getParser(byte by) {
        return PARSERS[by & 0xFF];
    }

    public static Message read(InputStream inputStream) throws BadPacketException, IOException {
        return MessageFactory.read(inputStream, new byte[23], -1, SOFT_MAX);
    }

    public static Message read(InputStream inputStream, byte by) throws BadPacketException, IOException {
        return MessageFactory.read(inputStream, new byte[23], -1, by);
    }

    public static Message read(InputStream inputStream, int n) throws BadPacketException, IOException {
        return MessageFactory.read(inputStream, new byte[23], n, SOFT_MAX);
    }

    public static Message read(InputStream inputStream, byte[] byArray, byte by) throws BadPacketException, IOException {
        return MessageFactory.read(inputStream, byArray, -1, by);
    }

    public static Message read(InputStream inputStream, int n, byte[] byArray) throws BadPacketException, IOException {
        return MessageFactory.read(inputStream, byArray, n, SOFT_MAX);
    }

    public static Message read(InputStream inputStream, byte[] byArray, int n, byte by) throws BadPacketException, IOException {
        int n2 = 0;
        while (n2 < 23) {
            int n3;
            try {
                n3 = inputStream.read(byArray, n2, 23 - n2);
            }
            catch (InterruptedIOException interruptedIOException) {
                if (n2 == 0) {
                    return null;
                }
                throw interruptedIOException;
            }
            if (n3 == -1) {
                ReceivedErrorStat.CONNECTION_CLOSED.incrementStat();
                throw new IOException("Connection closed.");
            }
            n2 += n3;
        }
        n2 = ByteOrder.leb2int(byArray, 19);
        if (n2 < 0 || n2 > MessageSettings.MAX_LENGTH.getValue()) {
            ReceivedErrorStat.INVALID_LENGTH.incrementStat();
            throw new IOException("Unreasonable message length: " + n2);
        }
        byte[] byArray2 = null;
        if (n2 != 0) {
            byArray2 = new byte[n2];
            int n4 = 0;
            while (n4 < n2) {
                int n5 = inputStream.read(byArray2, n4, n2 - n4);
                if (n5 == -1) {
                    ReceivedErrorStat.CONNECTION_CLOSED.incrementStat();
                    throw new IOException("Connection closed.");
                }
                n4 += n5;
            }
        } else {
            byArray2 = DataUtils.EMPTY_BYTE_ARRAY;
        }
        return MessageFactory.createMessage(byArray, byArray2, by, n);
    }

    public static Message createMessage(byte[] byArray, byte[] byArray2, byte by, int n) throws BadPacketException, IOException {
        if (byArray.length < 19) {
            throw new IllegalArgumentException("header must be >= 19 bytes.");
        }
        byte by2 = byArray[16];
        MessageParser messageParser = MessageFactory.getParser(by2);
        if (messageParser == null) {
            ReceivedErrorStat.INVALID_CODE.incrementStat();
            throw new BadPacketException("Unrecognized function code: " + by2);
        }
        byte by3 = byArray[17];
        byte by4 = byArray[18];
        int n2 = 14;
        if (by4 < 0) {
            ReceivedErrorStat.INVALID_HOPS.incrementStat();
            throw new BadPacketException("Negative (or very large) hops");
        }
        if (by3 < 0) {
            ReceivedErrorStat.INVALID_TTL.incrementStat();
            throw new BadPacketException("Negative (or very large) TTL");
        }
        if (by4 > by && by2 != -127 && by2 != 1) {
            ReceivedErrorStat.HOPS_EXCEED_SOFT_MAX.incrementStat();
            throw new BadPacketException("func: " + by2 + ", ttl: " + by3 + ", hops: " + by4);
        }
        if (by3 + by4 > n2) {
            ReceivedErrorStat.HOPS_AND_TTL_OVER_HARD_MAX.incrementStat();
            throw new BadPacketException("TTL+hops exceeds hard max; probably spam");
        }
        if (by3 + by4 > by && by2 != -127 && by2 != 1) {
            by3 = (byte)(by - by4);
            Assert.that(by3 >= 0);
        }
        byte[] byArray3 = new byte[16];
        System.arraycopy(byArray, 0, byArray3, 0, byArray3.length);
        return messageParser.parse(byArray3, by3, by4, byArray2, n);
    }

    public static interface MessageParser {
        public Message parse(byte[] var1, byte var2, byte var3, byte[] var4, int var5) throws BadPacketException;
    }

    private static class PingRequestParser
    implements MessageParser {
        PingRequestParser() {
        }

        public Message parse(byte[] byArray, byte by, byte by2, byte[] byArray2, int n) throws BadPacketException {
            if (byArray2.length > 0) {
                return new PingRequest(byArray, by, by2, byArray2);
            }
            return new PingRequest(byArray, by, by2);
        }
    }

    private static class PingReplyParser
    implements MessageParser {
        PingReplyParser() {
        }

        public Message parse(byte[] byArray, byte by, byte by2, byte[] byArray2, int n) throws BadPacketException {
            return PingReply.createFromNetwork(byArray, by, by2, byArray2);
        }
    }

    private static class QueryRequestParser
    implements MessageParser {
        QueryRequestParser() {
        }

        public Message parse(byte[] byArray, byte by, byte by2, byte[] byArray2, int n) throws BadPacketException {
            if (byArray2.length < 3) {
                throw new BadPacketException("Query request too short: " + byArray2.length);
            }
            return QueryRequest.createNetworkQuery(byArray, by, by2, byArray2, n);
        }
    }

    private static class QueryReplyParser
    implements MessageParser {
        QueryReplyParser() {
        }

        public Message parse(byte[] byArray, byte by, byte by2, byte[] byArray2, int n) throws BadPacketException {
            if (byArray2.length < 26) {
                throw new BadPacketException("Query reply too short: " + byArray2.length);
            }
            return new QueryReply(byArray, by, by2, byArray2, n);
        }
    }

    private static class PushRequestParser
    implements MessageParser {
        PushRequestParser() {
        }

        public Message parse(byte[] byArray, byte by, byte by2, byte[] byArray2, int n) throws BadPacketException {
            return new PushRequest(byArray, by, by2, byArray2, n);
        }
    }

    private static class RouteTableUpdateParser
    implements MessageParser {
        RouteTableUpdateParser() {
        }

        public Message parse(byte[] byArray, byte by, byte by2, byte[] byArray2, int n) throws BadPacketException {
            return RouteTableMessage.read(byArray, by, by2, byArray2);
        }
    }

    private static class VendorMessageParser
    implements MessageParser {
        VendorMessageParser() {
        }

        public Message parse(byte[] byArray, byte by, byte by2, byte[] byArray2, int n) throws BadPacketException {
            return VendorMessageFactory.deriveVendorMessage(byArray, by, by2, byArray2, n);
        }
    }

    private static class VendorMessageStableParser
    implements MessageParser {
        VendorMessageStableParser() {
        }

        public Message parse(byte[] byArray, byte by, byte by2, byte[] byArray2, int n) throws BadPacketException {
            return VendorMessageFactory.deriveVendorMessage(byArray, by, by2, byArray2, n);
        }
    }

    private static class UDPConnectionParser
    implements MessageParser {
        UDPConnectionParser() {
        }

        public Message parse(byte[] byArray, byte by, byte by2, byte[] byArray2, int n) throws BadPacketException {
            return UDPConnectionMessage.createMessage(byArray, by, by2, byArray2);
        }
    }
}

