/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.MessageService;
import com.limegroup.gnutella.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class IOUtils {
    public static boolean handleException(IOException iOException, String string) {
        if (string == null) {
            string = "GENERIC";
        }
        return IOUtils.handle(iOException, string);
    }

    private static boolean handle(Throwable throwable, String string) {
        while (throwable != null) {
            String string2 = throwable.getMessage();
            if (string2 != null) {
                if (StringUtils.contains(string2 = string2.toLowerCase(), "no space left") || StringUtils.contains(string2, "not enough space")) {
                    MessageService.showError("ERROR_DISK_FULL_" + string);
                    return true;
                }
                if (StringUtils.contains(string2, "being used by another process") || StringUtils.contains(string2, "with a user-mapped section open")) {
                    MessageService.showError("ERROR_LOCKED_BY_PROCESS_" + string);
                    return true;
                }
                if (StringUtils.contains(string2, "access is denied") || StringUtils.contains(string2, "permission denied")) {
                    MessageService.showError("ERROR_ACCESS_DENIED_" + string);
                    return true;
                }
                if (StringUtils.contains(string2, "invalid argument")) {
                    MessageService.showError("ERROR_INVALID_NAME_" + string);
                    return true;
                }
            }
            throwable = throwable.getCause();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readWord(InputStream inputStream, int n) throws IOException {
        char[] cArray = new char[n];
        int n2 = 0;
        try {
            while (true) {
                int n3;
                if ((n3 = inputStream.read()) < 0) {
                    throw new IOException("unexpected end of file");
                }
                if ((char)n3 == ' ') {
                    return new String(cArray, 0, n2);
                }
                if (n2 >= n) {
                    throw new IOException("could not read word");
                }
                cArray[n2++] = (char)n3;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IOException("unexpected aioobe");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readLargestWord(InputStream inputStream, int n) throws IOException {
        char[] cArray = new char[n];
        int n2 = 0;
        try {
            while (true) {
                int n3;
                if ((n3 = inputStream.read()) == -1) {
                    if (n2 == 0) {
                        throw new IOException("could not read any word.");
                    }
                    return new String(cArray, 0, n2);
                }
                if (n3 < 0) {
                    throw new IOException("unknown got amount");
                }
                if ((char)n3 == ' ') {
                    return new String(cArray, 0, n2);
                }
                if (n2 >= n) {
                    throw new IOException("could not read word");
                }
                cArray[n2++] = (char)n3;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IOException("unexpected aioobe");
        }
    }

    public static long ensureSkip(InputStream inputStream, long l) throws IOException {
        long l2 = 0L;
        while (l2 < l) {
            long l3 = inputStream.skip(l - l2);
            if (l3 == -1L || l3 == 0L) {
                throw new EOFException("eof");
            }
            l2 += l3;
        }
        return l2;
    }

    public static void close(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void close(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void close(RandomAccessFile randomAccessFile) {
        if (randomAccessFile != null) {
            try {
                randomAccessFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void close(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
            try {
                IOUtils.close(socket.getInputStream());
            }
            catch (IOException iOException) {}
            try {
                IOUtils.close(socket.getOutputStream());
            }
            catch (IOException iOException) {}
        }
    }

    public static void close(ServerSocket serverSocket) {
        if (serverSocket != null) {
            try {
                serverSocket.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] deflate(byte[] byArray) {
        byte[] byArray2;
        DeflaterOutputStream deflaterOutputStream = null;
        try {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
                ((OutputStream)deflaterOutputStream).write(byArray, 0, byArray.length);
                ((OutputStream)deflaterOutputStream).close();
                byArray2 = byteArrayOutputStream.toByteArray();
                Object var3_6 = null;
            }
            catch (IOException iOException) {
                ErrorService.error(iOException);
                byte[] byArray3 = null;
                Object var3_7 = null;
                IOUtils.close(deflaterOutputStream);
                return byArray3;
            }
        }
        catch (Throwable throwable) {
            Object var3_8 = null;
            IOUtils.close(deflaterOutputStream);
            throw throwable;
        }
        IOUtils.close(deflaterOutputStream);
        return byArray2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] inflate(byte[] byArray) throws IOException {
        byte[] byArray2;
        InflaterInputStream inflaterInputStream = null;
        try {
            try {
                inflaterInputStream = new InflaterInputStream(new ByteArrayInputStream(byArray));
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray3 = new byte[64];
                while (true) {
                    int n;
                    if ((n = ((InputStream)inflaterInputStream).read(byArray3, 0, byArray3.length)) == -1) {
                        byArray2 = byteArrayOutputStream.toByteArray();
                        Object var5_7 = null;
                        break;
                    }
                    byteArrayOutputStream.write(byArray3, 0, n);
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new IOException(outOfMemoryError.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            IOUtils.close(inflaterInputStream);
            throw throwable;
        }
        IOUtils.close(inflaterInputStream);
        return byArray2;
    }
}

