/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.http.HTTPRequestMethod;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.statistics.HTTPStat;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.ThreadFactory;
import java.net.Socket;
import java.net.SocketException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConnectionDispatcher {
    private static final Log LOG;
    private static final int UNKNOWN = -1;
    private static final int GNUTELLA = 0;
    private static final int LIMEWIRE = 1;
    private static final int GET = 2;
    private static final int HEAD = 3;
    private static final int GIV = 4;
    private static final int CHAT = 5;
    private static final int MAGNET = 6;
    private static final int CONNECT = 7;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.ConnectionDispatcher");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    private int parseWord(String string) {
        if (string == null) {
            return -1;
        }
        if (string.equals("GNUTELLA")) {
            return 0;
        }
        if (ConnectionSettings.CONNECT_STRING.isDefault() && string.equals("LIMEWIRE")) {
            return 1;
        }
        if (string.equals("GET")) {
            return 2;
        }
        if (string.equals("HEAD")) {
            return 3;
        }
        if (string.equals("GIV")) {
            return 4;
        }
        if (string.equals("CHAT")) {
            return 5;
        }
        if (string.equals("MAGNET")) {
            return 6;
        }
        if (string.equals("CONNECT") || string.equals("\n\n")) {
            return 7;
        }
        return -1;
    }

    public int getMaximumWordSize() {
        return 8;
    }

    public void dispatch(final String string, final Socket socket, boolean bl) {
        try {
            socket.setSoTimeout(0);
        }
        catch (SocketException socketException) {
            IOUtils.close(socket);
            return;
        }
        final int n = this.parseWord(string);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Dispatching protocol: " + n + ", from word: " + string));
        }
        boolean bl2 = NetworkUtils.isLocalHost(socket);
        if (n != 6) {
            if (ConnectionSettings.LOCAL_IS_PRIVATE.getValue() && bl2) {
                LOG.trace((Object)"Killing localhost connection with non-magnet.");
                IOUtils.close(socket);
                return;
            }
        } else if (!bl2) {
            LOG.trace((Object)"Killing non-local ExternalControl request.");
            IOUtils.close(socket);
            return;
        }
        switch (n) {
            case 0: {
                HTTPStat.GNUTELLA_REQUESTS.incrementStat();
                RouterService.getConnectionManager().acceptConnection(socket);
                return;
            }
            case 1: {
                HTTPStat.GNUTELLA_LIMEWIRE_REQUESTS.incrementStat();
                RouterService.getConnectionManager().acceptConnection(socket);
                return;
            }
            case 7: {
                if (ConnectionSettings.UNSET_FIREWALLED_FROM_CONNECTBACK.getValue()) {
                    RouterService.getAcceptor().checkFirewall(socket.getInetAddress());
                }
                IOUtils.close(socket);
                return;
            }
            case 5: {
                HTTPStat.CHAT_REQUESTS.incrementStat();
                return;
            }
            case 4: {
                HTTPStat.GIV_REQUESTS.incrementStat();
                RouterService.getDownloadManager().acceptDownload(socket);
                return;
            }
            case -1: {
                HTTPStat.UNKNOWN_REQUESTS.incrementStat();
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)("Unknown protocol: " + string));
                }
                IOUtils.close(socket);
                return;
            }
        }
        Runnable runnable = new Runnable(){

            public void run() {
                switch (n) {
                    case 2: {
                        HTTPStat.GET_REQUESTS.incrementStat();
                        RouterService.getUploadManager().acceptUpload(HTTPRequestMethod.GET, socket, false);
                        break;
                    }
                    case 3: {
                        HTTPStat.HEAD_REQUESTS.incrementStat();
                        RouterService.getUploadManager().acceptUpload(HTTPRequestMethod.HEAD, socket, false);
                        break;
                    }
                    case 6: {
                        HTTPStat.MAGNET_REQUESTS.incrementStat();
                        break;
                    }
                    default: {
                        IOUtils.close(socket);
                        LOG.error((Object)("Parsed to unsupported protocol: " + n + ", word: " + string));
                    }
                }
            }
        };
        if (bl) {
            ThreadFactory.startThread(runnable, "IncomingConnection");
        } else {
            runnable.run();
        }
    }
}

