/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class UrnType
implements Serializable {
    private static final long serialVersionUID = -8211681448456483713L;
    public static final String SHA1_STRING = "sha1:";
    public static final String BITPRINT_STRING = "bitprint:";
    public static final UrnType INVALID = new UrnType("invalid");
    public static final UrnType SHA1 = new UrnType("sha1:");
    public static final UrnType BITPRINT = new UrnType("bitprint:");
    public static final UrnType ANY_TYPE = new UrnType("");
    public static final transient Set SHA1_SET = new HashSet();
    public static final transient Set ANY_TYPE_SET = new HashSet();
    public static final String URN_NAMESPACE_ID = "urn:";
    private transient String _urnType;

    static {
        SHA1_SET.add(SHA1);
        ANY_TYPE_SET.add(ANY_TYPE);
    }

    private UrnType(String string) {
        if (string == null) {
            throw new NullPointerException("UrnTypes cannot except null strings");
        }
        this._urnType = string;
    }

    public boolean isSHA1() {
        return this._urnType.equals(SHA1_STRING);
    }

    public String toString() {
        return URN_NAMESPACE_ID + this._urnType;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof UrnType)) {
            return false;
        }
        UrnType urnType = (UrnType)object;
        return this._urnType.equals(urnType._urnType);
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this._urnType.hashCode();
        return n;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this._urnType);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this._urnType = (String)objectInputStream.readObject();
        if (!(this._urnType.equals("") || this._urnType.equals(SHA1_STRING) || this._urnType.equals(BITPRINT_STRING))) {
            throw new InvalidObjectException("invalid urn type: " + this._urnType);
        }
    }

    public static UrnType createUrnType(String string) {
        String string2 = string.toLowerCase().trim();
        if (string2.equals(SHA1.toString())) {
            return SHA1;
        }
        if (string2.equals(ANY_TYPE.toString())) {
            return ANY_TYPE;
        }
        if (string2.equals(BITPRINT.toString())) {
            return BITPRINT;
        }
        return null;
    }

    public static boolean isSupportedUrnType(String string) {
        UrnType urnType = UrnType.createUrnType(string);
        return urnType != null;
    }
}

