/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BandwidthTracker;
import com.limegroup.gnutella.DownloadCallback;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.SavedFileManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnCache;
import com.limegroup.gnutella.altlocs.AltLocListener;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.altlocs.AlternateLocationCollection;
import com.limegroup.gnutella.altlocs.DirectAltLoc;
import com.limegroup.gnutella.altlocs.PushAltLoc;
import com.limegroup.gnutella.auth.ContentResponseData;
import com.limegroup.gnutella.auth.ContentResponseObserver;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.downloader.DiskException;
import com.limegroup.gnutella.downloader.DownloadBrowseHostList;
import com.limegroup.gnutella.downloader.DownloadChatList;
import com.limegroup.gnutella.downloader.DownloadWorker;
import com.limegroup.gnutella.downloader.HTTPConnectObserver;
import com.limegroup.gnutella.downloader.HTTPDownloader;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.downloader.Interval;
import com.limegroup.gnutella.downloader.MeshHandler;
import com.limegroup.gnutella.downloader.PushDetails;
import com.limegroup.gnutella.downloader.PushList;
import com.limegroup.gnutella.downloader.SourceRanker;
import com.limegroup.gnutella.downloader.VerifyingFile;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.guess.GUESSEndpoint;
import com.limegroup.gnutella.guess.OnDemandUnicaster;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.DownloadSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.statistics.DownloadStat;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.tigertree.TigerTreeCache;
import com.limegroup.gnutella.util.ApproximateMatcher;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.FileUtils;
import com.limegroup.gnutella.util.FixedSizeExpiringSet;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.StringUtils;
import com.limegroup.gnutella.util.ThreadFactory;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManagedDownloader
implements Downloader,
MeshHandler,
AltLocListener,
Serializable {
    private static final Log LOG;
    static final long serialVersionUID = 2772570805975885257L;
    private static final ObjectStreamField[] serialPersistentFields;
    private static int unknownIndex;
    private DownloadManager manager;
    private FileManager fileManager;
    protected IncompleteFileManager incompleteFileManager;
    private DownloadCallback callback;
    private Set cachedRFDs;
    private SourceRanker ranker;
    static int TIME_BETWEEN_REQUERIES;
    private static final int GUESS_WAIT_TIME = 5000;
    private static final int CONNECTING_WAIT_TIME = 750;
    private static final int REQUERY_ATTEMPTS = 1;
    private static final int MATCHER_BUF_SIZE = 120;
    protected static final String UNKNOWN_FILENAME = "";
    private static ApproximateMatcher matcher;
    private volatile Thread dloaderManagerThread;
    private volatile boolean stopped;
    private volatile boolean paused;
    private volatile boolean invalidated;
    private volatile List _activeWorkers;
    private List _workers;
    private volatile Map _queuedWorkers;
    private Set currentRFDs;
    protected URN downloadSHA1;
    private Set validAlts;
    private Set invalidAlts;
    private Set recentInvalidAlts;
    protected VerifyingFile commonOutFile;
    private PushList pushes;
    private int state;
    private long stateTime;
    protected File incompleteFile;
    private int queuePosition;
    private String queuedVendor;
    private volatile int corruptFileBytes;
    private volatile File corruptFile;
    private DownloadChatList chatList;
    private DownloadBrowseHostList browseList;
    private static final int NOT_CORRUPT_STATE = 0;
    private static final int CORRUPT_WAITING_STATE = 1;
    private static final int CORRUPT_STOP_STATE = 2;
    private static final int CORRUPT_CONTINUE_STATE = 3;
    private volatile int corruptState;
    private Object corruptStateLock;
    private Object altLock;
    private int numMeasures = 0;
    private float averageBandwidth = 0.0f;
    private final GUID originalQueryGUID;
    protected boolean deserializedFromDisk;
    private int numQueries;
    private boolean triedLocatingSources;
    private volatile boolean receivedNewSources;
    private long lastQuerySent;
    private volatile int inactivePriority;
    protected Map attributes = new HashMap();
    protected Map propertiesMap;
    protected static final String DEFAULT_FILENAME = "defaultFileName";
    protected static final String FILE_SIZE = "fileSize";
    protected static final String ATTRIBUTES = "attributes";
    protected static final String SAVE_FILE = "saveFile";
    protected static final String SHA1_URN = "sha1Urn";
    private static boolean initDone;
    private static final int MIN_NUM_CONNECTIONS = 2;
    private static final int MIN_CONNECTION_MESSAGES = 6;
    private static final int MIN_TOTAL_MESSAGES = 45;
    static boolean NO_DELAY;
    private volatile boolean manualCanceled = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.downloader.ManagedDownloader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        serialPersistentFields = ObjectStreamClass.NO_FIELDS;
        unknownIndex = 0;
        TIME_BETWEEN_REQUERIES = 300000;
        matcher = new ApproximateMatcher(120);
        initDone = false;
        NO_DELAY = false;
    }

    public ManagedDownloader(RemoteFileDesc[] remoteFileDescArray, IncompleteFileManager incompleteFileManager, GUID gUID, File file, String string, boolean bl) throws SaveLocationException {
        this(remoteFileDescArray, incompleteFileManager, gUID);
        Assert.that(remoteFileDescArray.length > 0 || string != null);
        if (remoteFileDescArray.length == 0) {
            this.propertiesMap.put(DEFAULT_FILENAME, string);
        }
        this.setSaveFile(file, string, bl);
    }

    protected ManagedDownloader(RemoteFileDesc[] remoteFileDescArray, IncompleteFileManager incompleteFileManager, GUID gUID) {
        if (remoteFileDescArray == null) {
            throw new NullPointerException("null RFDS");
        }
        if (incompleteFileManager == null) {
            throw new NullPointerException("null incomplete file manager");
        }
        this.cachedRFDs = new HashSet();
        this.cachedRFDs.addAll(Arrays.asList(remoteFileDescArray));
        this.propertiesMap = new HashMap();
        if (remoteFileDescArray.length > 0) {
            this.initPropertiesMap(remoteFileDescArray[0]);
        }
        this.incompleteFileManager = incompleteFileManager;
        this.originalQueryGUID = gUID;
        this.deserializedFromDisk = false;
    }

    protected synchronized void initPropertiesMap(RemoteFileDesc remoteFileDesc) {
        if (this.propertiesMap.get(DEFAULT_FILENAME) == null) {
            this.propertiesMap.put(DEFAULT_FILENAME, remoteFileDesc.getFileName());
        }
        if (this.propertiesMap.get(FILE_SIZE) == null) {
            this.propertiesMap.put(FILE_SIZE, new Integer(remoteFileDesc.getSize()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        IncompleteFileManager incompleteFileManager;
        HashSet hashSet = new HashSet();
        HashMap hashMap = new HashMap();
        Serializable serializable = this;
        synchronized (serializable) {
            hashSet.addAll(this.cachedRFDs);
            hashMap.putAll(this.propertiesMap);
            incompleteFileManager = this.incompleteFileManager;
        }
        objectOutputStream.writeObject(hashSet);
        serializable = incompleteFileManager;
        synchronized (serializable) {
            objectOutputStream.writeObject(incompleteFileManager);
        }
        if (!this.propertiesMap.containsKey(ATTRIBUTES)) {
            this.propertiesMap.put(ATTRIBUTES, this.attributes);
        }
        objectOutputStream.writeObject(hashMap);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        this.deserializedFromDisk = true;
        Object object2 = objectInputStream.readObject();
        RemoteFileDesc remoteFileDesc = null;
        if (object2 instanceof RemoteFileDesc[]) {
            object = (RemoteFileDesc[])object2;
            if (object != null && ((RemoteFileDesc[])object).length > 0) {
                remoteFileDesc = object[0];
            }
            this.cachedRFDs = new HashSet<RemoteFileDesc>(Arrays.asList(object));
        } else {
            this.cachedRFDs = (Set)object2;
            if (this.cachedRFDs.size() > 0) {
                remoteFileDesc = (RemoteFileDesc)this.cachedRFDs.iterator().next();
            }
        }
        this.incompleteFileManager = (IncompleteFileManager)objectInputStream.readObject();
        object = objectInputStream.readObject();
        if (object instanceof Map) {
            this.propertiesMap = (Map)object;
        } else if (this.propertiesMap == null) {
            this.propertiesMap = new HashMap();
        }
        if (remoteFileDesc != null) {
            this.initPropertiesMap(remoteFileDesc);
        }
        if (this.propertiesMap.get(DEFAULT_FILENAME) == null) {
            this.propertiesMap.put(DEFAULT_FILENAME, "Unknown " + ++unknownIndex);
        }
        if (this.propertiesMap.containsKey(ATTRIBUTES)) {
            this.attributes = (Map)this.propertiesMap.get(ATTRIBUTES);
        }
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(DownloadManager downloadManager, FileManager fileManager, DownloadCallback downloadCallback) {
        this.manager = downloadManager;
        this.fileManager = fileManager;
        this.callback = downloadCallback;
        this.currentRFDs = new HashSet();
        this._activeWorkers = new LinkedList();
        this._workers = new ArrayList();
        this._queuedWorkers = new HashMap();
        this.chatList = new DownloadChatList();
        this.browseList = new DownloadBrowseHostList();
        this.stopped = false;
        this.paused = false;
        this.setState(0);
        this.pushes = new PushList();
        this.corruptState = 0;
        this.corruptStateLock = new Object();
        this.altLock = new Object();
        this.numMeasures = 0;
        this.averageBandwidth = 0.0f;
        this.queuePosition = Integer.MAX_VALUE;
        this.queuedVendor = UNKNOWN_FILENAME;
        this.triedLocatingSources = false;
        this.ranker = this.getSourceRanker(null);
        this.ranker.setMeshHandler(this);
        if (this.downloadSHA1 == null) {
            this.downloadSHA1 = (URN)this.propertiesMap.get(SHA1_URN);
        }
        Object object = this;
        synchronized (object) {
            Iterator iterator = this.cachedRFDs.iterator();
            while (iterator.hasNext() && this.downloadSHA1 == null) {
                RemoteFileDesc remoteFileDesc = (RemoteFileDesc)iterator.next();
                this.downloadSHA1 = remoteFileDesc.getSHA1Urn();
            }
        }
        if (this.downloadSHA1 != null) {
            RouterService.getAltlocManager().addListener(this.downloadSHA1, this);
            this.propertiesMap.put(SHA1_URN, this.downloadSHA1);
        }
        this.verifyAllFiles();
        object = this.altLock;
        synchronized (object) {
            this.validAlts = new HashSet();
            this.invalidAlts = new FixedSizeExpiringSet(1000, 3600000L);
            this.recentInvalidAlts = new FixedSizeExpiringSet(10, 600000L);
        }
        object = this;
        synchronized (object) {
            if (this.shouldInitAltLocs(this.deserializedFromDisk)) {
                this.initializeAlternateLocations();
            }
        }
        try {
            this.initializeIncompleteFile();
            this.initializeVerifyingFile();
        }
        catch (IOException iOException) {
            this.setState(7);
            return;
        }
        this.setState(0);
    }

    private synchronized void verifyAllFiles() {
        if (this.downloadSHA1 == null) {
            return;
        }
        Iterator iterator = this.cachedRFDs.iterator();
        while (iterator.hasNext()) {
            RemoteFileDesc remoteFileDesc = (RemoteFileDesc)iterator.next();
            if (remoteFileDesc.getSHA1Urn() == null || this.downloadSHA1.equals(remoteFileDesc.getSHA1Urn())) continue;
            iterator.remove();
        }
    }

    public synchronized void startDownload() {
        Assert.that(this.dloaderManagerThread == null, "already started");
        ThreadFactory.startThread(new Runnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    try {
                        ManagedDownloader.this.dloaderManagerThread = Thread.currentThread();
                        ManagedDownloader.this.validateDownload();
                        ManagedDownloader.this.receivedNewSources = false;
                        int n = ManagedDownloader.this.performDownload();
                        ManagedDownloader.this.completeDownload(n);
                    }
                    catch (Throwable throwable) {
                        ManagedDownloader.this.stop();
                        ManagedDownloader.this.setState(5);
                        ManagedDownloader.this.manager.remove(ManagedDownloader.this, true);
                        ErrorService.error(throwable);
                    }
                }
                catch (Throwable throwable) {
                    Object var2_4 = null;
                    ManagedDownloader.this.dloaderManagerThread = null;
                    throw throwable;
                }
                {
                    Object var2_5 = null;
                }
                ManagedDownloader.this.dloaderManagerThread = null;
            }
        }, "ManagedDownload");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeDownload(int n) {
        boolean bl;
        boolean bl2 = false;
        int n2 = 0;
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            switch (n) {
                case 4: 
                case 7: 
                case 9: {
                    bl2 = true;
                    this.setState(n);
                    break;
                }
                case 3: 
                case 6: {
                    if (this.invalidated) {
                        bl2 = true;
                        this.setState(19);
                        break;
                    }
                    if (this.stopped) {
                        this.setState(5);
                        break;
                    }
                    if (this.paused) {
                        this.setState(18);
                        break;
                    }
                    this.setState(n);
                    break;
                }
                default: {
                    Assert.that(false, "Bad status from tad2: " + n);
                }
            }
            bl = this.isCompleted();
            n2 = this.ranker.calculateWaitTime();
            this.ranker.stop();
            if (bl2) {
                this.ranker = null;
            }
        }
        long l = System.currentTimeMillis();
        this.manager.remove(this, bl);
        if (bl2) {
            Object object = this.altLock;
            synchronized (object) {
                this.recentInvalidAlts.clear();
                this.invalidAlts.clear();
                this.validAlts.clear();
            }
            if (bl) {
                object = this;
                synchronized (object) {
                    this.cachedRFDs.clear();
                }
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("MD completing <" + this.getSaveFile().getName() + "> completed download, state: " + this.getState() + ", numQueries: " + this.numQueries + ", lastQuerySent: " + this.lastQuerySent));
        }
        VerifyingFile.clearCaches();
        if (!bl && this.getState() != 18 && !this.tryGUESSing()) {
            if (this.getState() == 3) {
                this.setState(3, n2);
            } else if (l - this.lastQuerySent < (long)TIME_BETWEEN_REQUERIES) {
                this.setState(8, (long)TIME_BETWEEN_REQUERIES - (l - this.lastQuerySent));
            } else if (this.numQueries >= 1) {
                this.setState(6);
            } else if (this.shouldSendRequeryImmediately(this.numQueries)) {
                this.sendRequery();
            } else {
                this.setState(13);
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("MD completed <" + this.getSaveFile().getName() + "> completed download, state: " + this.getState() + ", numQueries: " + this.numQueries));
        }
    }

    private void sendRequery() {
        if (!this.hasStableConnections()) {
            this.lastQuerySent = -1L;
            this.setState(14, 750L);
        } else {
            try {
                QueryRequest queryRequest = this.newRequery(this.numQueries);
                if (this.manager.sendQuery(this, queryRequest)) {
                    this.lastQuerySent = System.currentTimeMillis();
                    ++this.numQueries;
                    this.setState(8, TIME_BETWEEN_REQUERIES);
                } else {
                    this.lastQuerySent = -1L;
                }
            }
            catch (CantResumeException cantResumeException) {}
        }
    }

    public synchronized void handleInactivity() {
        switch (this.getState()) {
            case 3: 
            case 14: 
            case 15: {
                if (this.getRemainingStateTime() > 0 && !this.hasNewSources()) break;
                this.setState(0);
                break;
            }
            case 8: {
                if (this.hasNewSources()) {
                    this.setState(0);
                    break;
                }
                if (this.getRemainingStateTime() > 0) break;
                this.setState(6);
                break;
            }
            case 6: 
            case 13: {
                if (!this.hasNewSources()) break;
                this.setState(0);
            }
            case 0: 
            case 18: {
                break;
            }
            default: {
                Assert.that(false, "invalid state: " + this.getState() + ", workers: " + this._workers.size() + ", _activeWorkers: " + this._activeWorkers.size() + ", _queuedWorkers: " + this._queuedWorkers.size());
            }
        }
    }

    private boolean tryGUESSing() {
        if (this.originalQueryGUID == null || this.triedLocatingSources || this.downloadSHA1 == null) {
            return false;
        }
        MessageRouter messageRouter = RouterService.getMessageRouter();
        Set set = messageRouter.getGuessLocs(this.originalQueryGUID);
        if (set == null || set.isEmpty()) {
            return false;
        }
        this.setState(15, 5000L);
        this.triedLocatingSources = true;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            GUESSEndpoint gUESSEndpoint = (GUESSEndpoint)iterator.next();
            OnDemandUnicaster.query(gUESSEndpoint, this.downloadSHA1);
            if (this.receivedNewSources) break;
        }
        return true;
    }

    public boolean isAlive() {
        return this.dloaderManagerThread != null;
    }

    public boolean isCompleted() {
        switch (this.getState()) {
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 19: {
                return true;
            }
        }
        return false;
    }

    public boolean isRelocatable() {
        if (this.isInactive()) {
            return true;
        }
        switch (this.getState()) {
            case 1: 
            case 2: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    public boolean isActive() {
        switch (this.getState()) {
            case 1: 
            case 2: 
            case 10: 
            case 11: 
            case 12: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    public boolean isInactive() {
        switch (this.getState()) {
            case 0: 
            case 3: 
            case 6: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 18: {
                return true;
            }
        }
        return false;
    }

    private synchronized void initializeRanker() {
        this.ranker.setMeshHandler(this);
        this.ranker.addToPool(this.cachedRFDs);
    }

    protected void initializeVerifyingFile() throws IOException {
        if (this.incompleteFile == null) {
            return;
        }
        this.commonOutFile = this.incompleteFileManager.getEntry(this.incompleteFile);
        if (this.commonOutFile == null) {
            int n = (int)IncompleteFileManager.getCompletedSize(this.incompleteFile);
            this.commonOutFile = new VerifyingFile(n);
            this.commonOutFile.setScanForExistingBlocks(true, this.incompleteFile.length());
            try {
                this.incompleteFileManager.addEntry(this.incompleteFile, this.commonOutFile);
            }
            catch (IOException iOException) {
                ErrorService.error(iOException, "file: " + this.incompleteFile);
                throw iOException;
            }
        }
    }

    protected void initializeIncompleteFile() throws IOException {
        if (this.incompleteFile != null) {
            return;
        }
        if (this.downloadSHA1 != null) {
            this.incompleteFile = this.incompleteFileManager.getFileForUrn(this.downloadSHA1);
        }
        if (this.incompleteFile == null) {
            this.incompleteFile = this.getIncompleteFile(this.incompleteFileManager, this.getSaveFile().getName(), this.downloadSHA1, this.getContentLength());
        }
        LOG.warn((Object)("Incomplete File: " + this.incompleteFile));
    }

    protected File getIncompleteFile(IncompleteFileManager incompleteFileManager, String string, URN uRN, int n) throws IOException {
        return incompleteFileManager.getFile(string, uRN, n);
    }

    private synchronized void initializeAlternateLocations() {
        HTTPHeaderValue hTTPHeaderValue;
        if (this.incompleteFile == null) {
            return;
        }
        FileDesc fileDesc = this.fileManager.getFileDescForFile(this.incompleteFile);
        if (fileDesc != null && fileDesc instanceof IncompleteFileDesc) {
            hTTPHeaderValue = (IncompleteFileDesc)fileDesc;
            if (this.downloadSHA1 != null && !this.downloadSHA1.equals(((FileDesc)((Object)hTTPHeaderValue)).getSHA1Urn())) {
                Assert.silent(false, "wrong IFD.\nclass: " + this.getClass().getName() + "\nours  :   " + this.incompleteFile + "\ntheirs: " + ((FileDesc)((Object)hTTPHeaderValue)).getFile() + "\nour hash    : " + this.downloadSHA1 + "\ntheir hashes: " + ((FileDesc)((Object)hTTPHeaderValue)).getUrns() + "\nifm.hashes : " + this.incompleteFileManager.dumpHashes());
                this.fileManager.removeFileIfShared(this.incompleteFile);
            }
        }
        if ((hTTPHeaderValue = this.incompleteFileManager.getCompletedHash(this.incompleteFile)) != null) {
            long l = IncompleteFileManager.getCompletedSize(this.incompleteFile);
            this.addLocationsToDownload(RouterService.getAltlocManager().getDirect((URN)hTTPHeaderValue), RouterService.getAltlocManager().getPush((URN)hTTPHeaderValue, false), RouterService.getAltlocManager().getPush((URN)hTTPHeaderValue, true), (int)l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLocationsToDownload(AlternateLocationCollection alternateLocationCollection, AlternateLocationCollection alternateLocationCollection2, AlternateLocationCollection alternateLocationCollection3, int n) {
        AlternateLocation alternateLocation;
        Iterator iterator;
        ArrayList<RemoteFileDesc> arrayList = new ArrayList<RemoteFileDesc>(alternateLocationCollection.getAltLocsSize() + alternateLocationCollection2.getAltLocsSize() + alternateLocationCollection3.getAltLocsSize());
        AlternateLocationCollection alternateLocationCollection4 = alternateLocationCollection;
        synchronized (alternateLocationCollection4) {
            iterator = alternateLocationCollection.iterator();
            while (iterator.hasNext()) {
                alternateLocation = (AlternateLocation)iterator.next();
                arrayList.add(alternateLocation.createRemoteFileDesc(n));
            }
        }
        alternateLocationCollection4 = alternateLocationCollection2;
        synchronized (alternateLocationCollection4) {
            iterator = alternateLocationCollection2.iterator();
            while (iterator.hasNext()) {
                alternateLocation = (AlternateLocation)iterator.next();
                arrayList.add(alternateLocation.createRemoteFileDesc(n));
            }
        }
        alternateLocationCollection4 = alternateLocationCollection3;
        synchronized (alternateLocationCollection4) {
            iterator = alternateLocationCollection3.iterator();
            while (iterator.hasNext()) {
                alternateLocation = (AlternateLocation)iterator.next();
                arrayList.add(alternateLocation.createRemoteFileDesc(n));
            }
        }
        this.addPossibleSources(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean conflictsWithIncompleteFile(File file) {
        File file2 = this.incompleteFile;
        if (file2 != null) {
            return file2.equals(file);
        }
        URN uRN = this.downloadSHA1;
        if (uRN != null) {
            file2 = this.incompleteFileManager.getFileForUrn(uRN);
        }
        if (file2 != null) {
            return file2.equals(file);
        }
        RemoteFileDesc remoteFileDesc = null;
        Serializable serializable = this;
        synchronized (serializable) {
            block10: {
                if (this.hasRFD()) break block10;
                return false;
            }
            remoteFileDesc = (RemoteFileDesc)this.cachedRFDs.iterator().next();
        }
        if (remoteFileDesc != null) {
            try {
                serializable = this.incompleteFileManager.getFile(remoteFileDesc);
                return ((File)serializable).equals(file);
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return false;
    }

    public boolean conflicts(URN uRN, String string, int n) {
        if (uRN != null && this.downloadSHA1 != null) {
            return uRN.equals(this.downloadSHA1);
        }
        if (n > 0) {
            try {
                File file = this.incompleteFileManager.getFile(string, null, n);
                return this.conflictsWithIncompleteFile(file);
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    protected synchronized QueryRequest newRequery(int n) throws CantResumeException {
        String string = StringUtils.createQueryString(this.getDefaultFileName());
        if (string == null || string.equals(UNKNOWN_FILENAME)) {
            throw new CantResumeException(this.getSaveFile().getName());
        }
        return QueryRequest.createQuery(string);
    }

    protected boolean shouldSendRequeryImmediately(int n) {
        return this.lastQuerySent == -1L;
    }

    protected boolean shouldInitAltLocs(boolean bl) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean hostIsAllowed(RemoteFileDesc remoteFileDesc) {
        if (!IPFilter.instance().allow(remoteFileDesc.getHost())) {
            return false;
        }
        if (!RouterService.acceptedIncomingConnection() && remoteFileDesc.isFirewalled() && (!remoteFileDesc.supportsFWTransfer() || !RouterService.canDoFWT())) return false;
        Object object = this.altLock;
        synchronized (object) {
            block5: {
                if (!remoteFileDesc.isFromAlternateLocation() || !this.invalidAlts.contains(remoteFileDesc.getRemoteHostData())) break block5;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean allowAddition(RemoteFileDesc remoteFileDesc) {
        Object object;
        if (!initDone) {
            object = matcher;
            synchronized (object) {
                matcher.setIgnoreCase(true);
                matcher.setIgnoreWhitespace(true);
                matcher.setCompareBackwards(true);
            }
            initDone = true;
        }
        if (remoteFileDesc.getQuality() < 1) {
            return false;
        }
        object = remoteFileDesc.getSHA1Urn();
        String string = remoteFileDesc.getFileName();
        long l = remoteFileDesc.getFileSize();
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            String string2;
            RemoteFileDesc remoteFileDesc2;
            long l2;
            int n = this.getContentLength();
            if (n != -1 && (long)n != l) {
                return false;
            }
            if (object != null && this.downloadSHA1 != null) {
                return ((URN)object).equals(this.downloadSHA1);
            }
            Iterator iterator = this.cachedRFDs.iterator();
            do {
                if (!iterator.hasNext()) {
                    return false;
                }
                remoteFileDesc2 = (RemoteFileDesc)iterator.next();
                string2 = remoteFileDesc2.getFileName();
            } while (l != (l2 = remoteFileDesc2.getFileSize()) || !this.namesClose(string, string2));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean namesClose(String string, String string2) {
        boolean bl = false;
        int n = Math.round(Math.min(0.1f * (float)StringUtils.ripExtension(string).length(), 0.1f * (float)StringUtils.ripExtension(string2).length()));
        n = Math.min(n, 6);
        ApproximateMatcher approximateMatcher = matcher;
        synchronized (approximateMatcher) {
            bl = matcher.matches(matcher.process(string), matcher.process(string2), n);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("MD.namesClose(): one = " + string));
            LOG.debug((Object)("MD.namesClose(): two = " + string2));
            LOG.debug((Object)("MD.namesClose(): retVal = " + bl));
        }
        return bl;
    }

    public synchronized void locationAdded(AlternateLocation alternateLocation) {
        Assert.that(alternateLocation.getSHA1Urn().equals(this.getSHA1Urn()));
        this.addDownload(alternateLocation.createRemoteFileDesc(this.getContentLength()), false);
    }

    public synchronized boolean addDownload(RemoteFileDesc remoteFileDesc, boolean bl) {
        if (this.stopped || this.isCompleted()) {
            return false;
        }
        if (!this.allowAddition(remoteFileDesc)) {
            return false;
        }
        remoteFileDesc.setDownloading(true);
        if (!this.hostIsAllowed(remoteFileDesc)) {
            return false;
        }
        return this.addDownloadForced(remoteFileDesc, bl);
    }

    public synchronized boolean addDownload(Collection collection, boolean bl) {
        if (this.stopped || this.isCompleted()) {
            return false;
        }
        ArrayList<RemoteFileDesc> arrayList = new ArrayList<RemoteFileDesc>(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RemoteFileDesc remoteFileDesc = (RemoteFileDesc)iterator.next();
            if (!this.hostIsAllowed(remoteFileDesc) || !this.allowAddition(remoteFileDesc)) continue;
            arrayList.add(remoteFileDesc);
        }
        return this.addDownloadForced(arrayList, bl);
    }

    protected synchronized boolean addDownloadForced(RemoteFileDesc remoteFileDesc, boolean bl) {
        if (remoteFileDesc.isMe()) {
            return true;
        }
        if (this.currentRFDs.contains(remoteFileDesc)) {
            return true;
        }
        this.prepareRFD(remoteFileDesc, bl);
        if (this.ranker.addToPool(remoteFileDesc)) {
            this.receivedNewSources = true;
        }
        return true;
    }

    protected final synchronized boolean addDownloadForced(Collection collection, boolean bl) {
        collection.removeAll(this.currentRFDs);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RemoteFileDesc remoteFileDesc = (RemoteFileDesc)iterator.next();
            if (remoteFileDesc.isMe()) {
                iterator.remove();
                continue;
            }
            this.prepareRFD(remoteFileDesc, bl);
        }
        if (this.ranker.addToPool(collection)) {
            this.receivedNewSources = true;
        }
        return true;
    }

    private void prepareRFD(RemoteFileDesc remoteFileDesc, boolean bl) {
        if (this.downloadSHA1 == null) {
            this.downloadSHA1 = remoteFileDesc.getSHA1Urn();
            RouterService.getAltlocManager().addListener(this.downloadSHA1, this);
        }
        if (bl) {
            this.cachedRFDs.add(remoteFileDesc);
        }
    }

    public boolean hasNewSources() {
        return !this.paused && this.receivedNewSources;
    }

    public boolean acceptDownload(String string, Socket socket, int n, byte[] byArray) {
        if (this.stopped) {
            return false;
        }
        HTTPConnectObserver hTTPConnectObserver = this.pushes.getHostFor(byArray, socket.getInetAddress().getHostAddress());
        if (hTTPConnectObserver != null) {
            hTTPConnectObserver.handleConnect(socket);
        }
        return hTTPConnectObserver != null;
    }

    void registerPushObserver(HTTPConnectObserver hTTPConnectObserver, PushDetails pushDetails) {
        this.pushes.addPushHost(pushDetails, hTTPConnectObserver);
    }

    void unregisterPushObserver(PushDetails pushDetails, boolean bl) {
        HTTPConnectObserver hTTPConnectObserver = this.pushes.getExactHostFor(pushDetails);
        if (hTTPConnectObserver != null && bl) {
            hTTPConnectObserver.shutdown();
        }
    }

    public boolean isCancelled() {
        return this.stopped;
    }

    public synchronized void pause() {
        if (!this.stopped && !this.isCompleted()) {
            this.stop();
            this.stopped = false;
            this.paused = true;
            if (this.isInactive()) {
                this.setState(18);
            }
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.paused) {
            this.stopped = true;
            this.paused = false;
        }
        if (this.stopped || this.paused) {
            return;
        }
        LOG.debug((Object)"STOPPING ManagedDownloader");
        this.stopped = true;
        this.killAllWorkers();
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            Thread thread = this.dloaderManagerThread;
            if (thread != null) {
                thread.interrupt();
            } else {
                LOG.warn((Object)"MANAGER: no thread to interrupt");
            }
        }
    }

    private void killAllWorkers() {
        Object object;
        List list = this.getAllWorkers();
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            object = (DownloadWorker)object2.next();
            ((DownloadWorker)object).interrupt();
        }
        object2 = this.pushes.getAllAndClear();
        object = object2.iterator();
        while (object.hasNext()) {
            HTTPConnectObserver hTTPConnectObserver = (HTTPConnectObserver)object.next();
            hTTPConnectObserver.shutdown();
        }
    }

    synchronized void diskProblemOccured() {
        this.setState(7);
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void informMesh(RemoteFileDesc remoteFileDesc, boolean bl) {
        Object object;
        AlternateLocation alternateLocation;
        AlternateLocation alternateLocation2;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("informing mesh that " + remoteFileDesc + " is " + bl));
        }
        if (bl) {
            this.cachedRFDs.add(remoteFileDesc);
        }
        if (!remoteFileDesc.isAltLocCapable()) {
            return;
        }
        Assert.that(this.downloadSHA1 != null, "null hash.");
        Assert.that(this.downloadSHA1.equals(remoteFileDesc.getSHA1Urn()), "wrong loc SHA1");
        try {
            alternateLocation2 = AlternateLocation.create(remoteFileDesc);
        }
        catch (IOException iOException) {
            return;
        }
        if (alternateLocation2 instanceof PushAltLoc) {
            alternateLocation = alternateLocation2.createClone();
            object = (PushAltLoc)alternateLocation2;
            if (((PushAltLoc)object).getPushAddress().getProxies().isEmpty()) {
                return;
            }
            ((PushAltLoc)object).updateProxies(bl);
        } else {
            alternateLocation = alternateLocation2;
        }
        if (bl) {
            RouterService.getAltlocManager().add(alternateLocation2, this);
        } else {
            RouterService.getAltlocManager().remove(alternateLocation2, this);
        }
        object = this.getActiveWorkers().iterator();
        while (object.hasNext()) {
            HTTPDownloader hTTPDownloader = ((DownloadWorker)object.next()).getDownloader();
            RemoteFileDesc remoteFileDesc2 = hTTPDownloader.getRemoteFileDesc();
            if (alternateLocation instanceof PushAltLoc ? remoteFileDesc2.getPushAddr() != null && remoteFileDesc2.getPushAddr().equals(remoteFileDesc.getPushAddr()) : remoteFileDesc2.getHost().equals(remoteFileDesc.getHost()) && remoteFileDesc2.getPort() == remoteFileDesc.getPort()) continue;
            if (!(alternateLocation instanceof DirectAltLoc) && !hTTPDownloader.wantsFalts()) continue;
            if (bl) {
                hTTPDownloader.addSuccessfulAltLoc(alternateLocation);
                continue;
            }
            hTTPDownloader.addFailedAltLoc(alternateLocation);
        }
        object = this.altLock;
        synchronized (object) {
            if (bl) {
                if (!this.validAlts.contains(alternateLocation)) {
                    if (remoteFileDesc.isFromAlternateLocation()) {
                        if (remoteFileDesc.needsPush()) {
                            DownloadStat.PUSH_ALTERNATE_WORKED.incrementStat();
                        } else {
                            DownloadStat.ALTERNATE_WORKED.incrementStat();
                        }
                    }
                    this.validAlts.add(alternateLocation);
                }
            } else {
                if (remoteFileDesc.isFromAlternateLocation()) {
                    if (alternateLocation instanceof PushAltLoc) {
                        DownloadStat.PUSH_ALTERNATE_NOT_ADDED.incrementStat();
                    } else {
                        DownloadStat.ALTERNATE_NOT_ADDED.incrementStat();
                    }
                }
                this.validAlts.remove(alternateLocation);
                this.invalidAlts.add(remoteFileDesc.getRemoteHostData());
                this.recentInvalidAlts.add(alternateLocation);
            }
        }
    }

    public synchronized void addPossibleSources(Collection collection) {
        this.addDownload(collection, false);
    }

    public synchronized boolean resume() {
        if (!this.isInactive()) {
            return false;
        }
        if (this.getState() == 13) {
            this.lastQuerySent = -1L;
        }
        Iterator iterator = this.cachedRFDs.iterator();
        while (iterator.hasNext()) {
            ((RemoteFileDesc)iterator.next()).setRetryAfter(0);
        }
        if (this.paused) {
            this.paused = false;
            this.stopped = false;
        }
        this.setState(0);
        return true;
    }

    public File getFile() {
        if (this.incompleteFile == null) {
            return null;
        }
        if (this.state == 4) {
            return this.getSaveFile();
        }
        return this.incompleteFile;
    }

    public URN getSHA1Urn() {
        return this.downloadSHA1;
    }

    public File getDownloadFragment() {
        if (this.incompleteFile == null) {
            return null;
        }
        if (this.state == 9) {
            return this.corruptFile;
        }
        if (this.state != 4) {
            File file = new File(this.incompleteFile.getParent(), "Preview-" + this.incompleteFile.getName());
            int n = this.amountForPreview();
            if (n <= 0) {
                return null;
            }
            if (CommonUtils.copy(this.incompleteFile, n, file) <= 0) {
                return null;
            }
            return file;
        }
        return this.getSaveFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int amountForPreview() {
        if (this.commonOutFile == null) {
            return 0;
        }
        VerifyingFile verifyingFile = this.commonOutFile;
        synchronized (verifyingFile) {
            Iterator iterator = this.commonOutFile.getBlocks();
            while (iterator.hasNext()) {
                Interval interval = (Interval)iterator.next();
                if (interval.low != 0) continue;
                return interval.high;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSaveFile(File file, String string, boolean bl) throws SaveLocationException {
        if (file == null) {
            file = SharingSettings.getSaveDirectory();
        }
        if (string == null) {
            string = this.getDefaultFileName();
        }
        if (!file.isDirectory()) {
            if (file.exists()) {
                throw new SaveLocationException(8, file);
            }
            throw new SaveLocationException(4, file);
        }
        File file2 = new File(file, string);
        try {
            if (!FileUtils.isReallyParent(file, file2)) {
                throw new SaveLocationException(1, file2);
            }
        }
        catch (IOException iOException) {
            throw new SaveLocationException(9, file2);
        }
        if (!FileUtils.setWriteable(file)) {
            throw new SaveLocationException(3, file);
        }
        if (file2.exists()) {
            if (!file2.isFile()) {
                throw new SaveLocationException(7, file2);
            }
            if (!bl) {
                throw new SaveLocationException(5, file2);
            }
        }
        if (RouterService.getDownloadManager().isSaveLocationTaken(file2)) {
            throw new SaveLocationException(6, file2);
        }
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            if (!this.isRelocatable()) {
                throw new SaveLocationException(2, file2);
            }
            this.propertiesMap.put(SAVE_FILE, file2);
        }
    }

    public synchronized File getSaveFile() {
        Object v = this.propertiesMap.get(SAVE_FILE);
        if (v != null) {
            return (File)v;
        }
        return new File(SharingSettings.getSaveDirectory(), this.getDefaultFileName());
    }

    public synchronized void finish() {
        if (this.downloadSHA1 != null) {
            RouterService.getAltlocManager().removeListener(this.downloadSHA1, this);
        }
        if (this.cachedRFDs != null) {
            Iterator iterator = this.cachedRFDs.iterator();
            while (iterator.hasNext()) {
                RemoteFileDesc remoteFileDesc = (RemoteFileDesc)iterator.next();
                remoteFileDesc.setDownloading(false);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int performDownload() {
        int n;
        block12: {
            if (this.checkHosts()) {
                this.setState(6);
                return 6;
            }
            n = this.initializeDownload();
            if (n == 1) {
                try {
                    block11: {
                        try {
                            n = this.fireDownloadWorkers();
                        }
                        catch (Throwable throwable) {
                            Object var2_3 = null;
                            this.commonOutFile.close();
                            throw throwable;
                        }
                        {
                            Object var2_4 = null;
                            this.commonOutFile.close();
                            if (n != 4) break block11;
                        }
                        n = this.verifyAndSave();
                        break block12;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("stopping early with status: " + n));
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (!this.stopped && !this.paused) {
                        ErrorService.error(interruptedException);
                    } else {
                        n = 6;
                    }
                    if (this.corruptState != 2) break block12;
                    this.cleanupCorrupt(this.incompleteFile, this.getSaveFile().getName());
                    n = 9;
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("MANAGER: TAD2 returned: " + n));
        }
        return n;
    }

    private boolean hasStableConnections() {
        if (NO_DELAY) {
            return true;
        }
        return RouterService.countConnectionsWithNMessages(6) >= 2 && RouterService.getActiveConnectionMessages() >= 45;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int initializeDownload() {
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            if (this.cachedRFDs.size() == 0 && !this.ranker.hasMore()) {
                return 6;
            }
        }
        try {
            this.initializeIncompleteFile();
            this.initializeVerifyingFile();
            this.openVerifyingFile();
        }
        catch (IOException iOException) {
            return 7;
        }
        if (this.downloadSHA1 != null) {
            this.initializeHashTree();
        }
        this.initializeRanker();
        return 1;
    }

    private int verifyAndSave() throws InterruptedException {
        URN uRN = this.scanForCorruption();
        if (this.corruptState == 2) {
            this.cleanupCorrupt(this.incompleteFile, this.getSaveFile().getName());
            return 9;
        }
        return this.saveFile(uRN);
    }

    private void validateDownload() {
        if (this.shouldValidate(this.deserializedFromDisk) && this.downloadSHA1 != null) {
            RouterService.getContentManager().request(this.downloadSHA1, new ContentResponseObserver(){

                public void handleResponse(URN uRN, ContentResponseData contentResponseData) {
                    if (contentResponseData != null && !contentResponseData.isOK()) {
                        ManagedDownloader.this.invalidated = true;
                        ManagedDownloader.this.stop();
                    }
                }
            }, 5000L);
        }
    }

    protected boolean shouldValidate(boolean bl) {
        return !bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForCorruptResponse() {
        if (this.corruptState != 0) {
            Object object = this.corruptStateLock;
            synchronized (object) {
                try {
                    while (this.corruptState == 1) {
                        this.corruptStateLock.wait();
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private URN scanForCorruption() throws InterruptedException {
        if (this.corruptState == 2) {
            return null;
        }
        URN uRN = null;
        try {
            this.setState(11);
            uRN = URN.createSHA1Urn(this.incompleteFile);
        }
        catch (IOException iOException) {}
        if (this.downloadSHA1 == null) {
            return uRN;
        }
        if (this.downloadSHA1.equals(uRN)) {
            return uRN;
        }
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)("hash verification problem, fileHash=" + uRN + ", ourHash=" + this.downloadSHA1));
        }
        if (this.commonOutFile.getHashTree() == null) {
            this.fileManager.removeFileIfShared(this.incompleteFile);
        }
        TigerTreeCache.instance().purgeTree(this.downloadSHA1);
        this.commonOutFile.setHashTree(null);
        this.promptAboutCorruptDownload();
        this.waitForCorruptResponse();
        return uRN;
    }

    private void initializeHashTree() {
        HashTree hashTree = TigerTreeCache.instance().getHashTree(this.downloadSHA1);
        if (hashTree != null && hashTree.isDepthGoodEnough()) {
            this.commonOutFile.setHashTree(hashTree);
        }
    }

    private int saveFile(URN uRN) {
        this.setState(12);
        if (!FileUtils.setWriteable(this.getSaveFile().getParentFile())) {
            return 7;
        }
        File file = this.getSaveFile();
        file.delete();
        boolean bl = FileUtils.forceRename(this.incompleteFile, file);
        this.incompleteFileManager.removeEntry(this.incompleteFile);
        if (!bl) {
            return 7;
        }
        if (file.exists()) {
            this.fileManager.removeFileIfShared(file);
        }
        if (uRN != null) {
            HashSet<URN> hashSet = new HashSet<URN>(1);
            hashSet.add(uRN);
            File file2 = file;
            try {
                file2 = FileUtils.getCanonicalFile(file);
            }
            catch (IOException iOException) {}
            UrnCache.instance().addUrns(file2, hashSet);
            SavedFileManager.instance().addSavedFile(file2, hashSet);
            if (this.downloadSHA1 != null && this.downloadSHA1.equals(uRN) && this.commonOutFile.getHashTree() != null) {
                TigerTreeCache.instance();
                TigerTreeCache.addHashTree(this.downloadSHA1, this.commonOutFile.getHashTree());
            }
        }
        if (SharingSettings.SHARE_DOWNLOADED_FILES_IN_NON_SHARED_DIRECTORIES.getValue()) {
            this.fileManager.addFileAlways(this.getSaveFile(), this.getXMLDocuments());
        } else {
            this.fileManager.addFileIfShared(this.getSaveFile(), this.getXMLDocuments());
        }
        return 4;
    }

    private void cleanupCorrupt(File file, String string) {
        this.corruptFileBytes = this.getAmountRead();
        this.incompleteFileManager.removeEntry(file);
        boolean bl = false;
        int n = 0;
        while (n < 10 && !bl) {
            this.corruptFile = new File(file.getParent(), "CORRUPT-" + n + "-" + string);
            if (!this.corruptFile.exists()) {
                bl = file.renameTo(this.corruptFile);
            }
            ++n;
        }
        if (!bl) {
            file.delete();
            this.corruptFile = null;
        }
    }

    private void openVerifyingFile() throws IOException {
        try {
            this.commonOutFile.open(this.incompleteFile);
        }
        catch (IOException iOException) {
            if (!IOUtils.handleException(iOException, "DOWNLOAD")) {
                ErrorService.error(iOException);
            }
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startWorker(RemoteFileDesc remoteFileDesc) {
        DownloadWorker downloadWorker = new DownloadWorker(this, remoteFileDesc, this.commonOutFile);
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            this._workers.add(downloadWorker);
            this.currentRFDs.add(remoteFileDesc);
        }
        downloadWorker.start();
    }

    synchronized void workerFinished(DownloadWorker downloadWorker) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("worker " + downloadWorker + " finished."));
        }
        this.removeWorker(downloadWorker);
        this.notify();
    }

    synchronized void workerStarted(DownloadWorker downloadWorker) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("worker " + downloadWorker + " started."));
        }
        if (!this._workers.contains(downloadWorker)) {
            throw new IllegalStateException("attempting to start invalid worker: " + downloadWorker);
        }
        this.setState(2);
        this.addActiveWorker(downloadWorker);
        this.chatList.addHost(downloadWorker.getDownloader());
        this.browseList.addHost(downloadWorker.getDownloader());
    }

    void workerFailed(DownloadWorker downloadWorker) {
        HTTPDownloader hTTPDownloader = downloadWorker.getDownloader();
        if (hTTPDownloader != null) {
            this.chatList.removeHost(hTTPDownloader);
            this.browseList.removeHost(hTTPDownloader);
        }
    }

    synchronized void removeWorker(DownloadWorker downloadWorker) {
        boolean bl = this.removeActiveWorker(downloadWorker);
        this.workerFailed(downloadWorker);
        boolean bl2 = this._workers.remove(downloadWorker);
        if (bl && !bl2) {
            throw new IllegalStateException("active removed but not in workers");
        }
    }

    synchronized boolean removeActiveWorker(DownloadWorker downloadWorker) {
        this.currentRFDs.remove(downloadWorker.getRFD());
        ArrayList arrayList = new ArrayList(this.getActiveWorkers());
        boolean bl = arrayList.remove(downloadWorker);
        this._activeWorkers = Collections.unmodifiableList(arrayList);
        return bl;
    }

    synchronized void addActiveWorker(DownloadWorker downloadWorker) {
        if (!this.getActiveWorkers().contains(downloadWorker)) {
            ArrayList<DownloadWorker> arrayList = new ArrayList<DownloadWorker>(this.getActiveWorkers());
            arrayList.add(downloadWorker);
            this._activeWorkers = Collections.unmodifiableList(arrayList);
        }
    }

    synchronized String getWorkersInfo() {
        String string = UNKNOWN_FILENAME;
        Iterator iterator = this._workers.iterator();
        while (iterator.hasNext()) {
            DownloadWorker downloadWorker = (DownloadWorker)iterator.next();
            string = String.valueOf(string) + downloadWorker.getInfo();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set getValidAlts() {
        Object object = this.altLock;
        synchronized (object) {
            HashSet hashSet;
            if (this.validAlts != null) {
                hashSet = new HashSet();
                Iterator iterator = this.validAlts.iterator();
                while (iterator.hasNext()) {
                    hashSet.add(iterator.next());
                }
            } else {
                hashSet = Collections.EMPTY_SET;
            }
            return hashSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set getInvalidAlts() {
        Object object = this.altLock;
        synchronized (object) {
            HashSet hashSet;
            if (this.invalidAlts != null) {
                hashSet = new HashSet();
                Iterator iterator = this.recentInvalidAlts.iterator();
                while (iterator.hasNext()) {
                    hashSet.add(iterator.next());
                }
            } else {
                hashSet = Collections.EMPTY_SET;
            }
            return hashSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int fireDownloadWorkers() throws InterruptedException {
        LOG.trace((Object)"MANAGER: entered fireDownloadWorkers");
        while (true) {
            if (this.stopped || this.paused) {
                LOG.warn((Object)"MANAGER: terminating because of stop|pause");
                throw new InterruptedException();
            }
            try {
                this.commonOutFile.waitForPendingIfNeeded();
            }
            catch (DiskException diskException) {
                if (!this.stopped && !this.paused) {
                    this.stop();
                    return 7;
                }
                LOG.warn((Object)"MANAGER: terminating because of stop|pause");
                throw new InterruptedException();
            }
            if (this.commonOutFile.isComplete()) {
                this.killAllWorkers();
                LOG.trace((Object)"MANAGER: terminating because of completion");
                return 4;
            }
            ManagedDownloader managedDownloader = this;
            synchronized (managedDownloader) {
                if (this._workers.size() == 0 && !this.ranker.hasNonBusy()) {
                    this.receivedNewSources = false;
                    if (this.ranker.calculateWaitTime() > 0) {
                        LOG.trace((Object)"MANAGER: terminating with busy");
                        return 3;
                    }
                    LOG.trace((Object)"MANAGER: terminating w/o hope");
                    return 6;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("MANAGER: kicking off workers.  state: " + this.getState() + ", allWorkers: " + this._workers.size() + ", activeWorkers: " + this._activeWorkers.size() + ", queuedWorkers: " + this._queuedWorkers.size() + ", swarm cap: " + this.getSwarmCapacity()));
                }
                if (this.shouldStartWorker()) {
                    this.ranker = this.getSourceRanker(this.ranker);
                    RemoteFileDesc remoteFileDesc = this.ranker.getBest();
                    if (remoteFileDesc != null) {
                        if (remoteFileDesc.isBusy()) {
                            this.addRFD(remoteFileDesc);
                        } else {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Staring worker for RFD: " + remoteFileDesc));
                            }
                            this.startWorker(remoteFileDesc);
                        }
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"no blocks but can't steal - sleeping.");
                }
                try {
                    this.wait(DownloadSettings.WORKER_INTERVAL.getValue());
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    protected SourceRanker getSourceRanker(SourceRanker sourceRanker) {
        return SourceRanker.getAppropriateRanker(sourceRanker);
    }

    private boolean shouldStartWorker() {
        return (this.commonOutFile.hasFreeBlocksToAssign() > 0 || this.victimsExist()) && this._workers.size() - this._queuedWorkers.size() < this.getSwarmCapacity() && this.ranker.hasMore();
    }

    private boolean victimsExist() {
        if (this._workers.isEmpty()) {
            return false;
        }
        Iterator iterator = this._workers.iterator();
        while (iterator.hasNext()) {
            DownloadWorker downloadWorker = (DownloadWorker)iterator.next();
            if (downloadWorker.isStealing() || !downloadWorker.isSlow()) continue;
            return true;
        }
        return false;
    }

    synchronized void addRFD(RemoteFileDesc remoteFileDesc) {
        if (this.ranker != null) {
            this.ranker.addToPool(remoteFileDesc);
        }
    }

    synchronized void forgetRFD(RemoteFileDesc remoteFileDesc) {
        if (this.cachedRFDs.remove(remoteFileDesc) && this.cachedRFDs.isEmpty()) {
            remoteFileDesc.setSerializeProxies();
            this.cachedRFDs.add(remoteFileDesc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfAlternateLocations() {
        Object object = this.altLock;
        synchronized (object) {
            block4: {
                if (this.validAlts != null) break block4;
                return 0;
            }
            return this.validAlts.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfInvalidAlternateLocations() {
        Object object = this.altLock;
        synchronized (object) {
            block4: {
                if (this.invalidAlts != null) break block4;
                return 0;
            }
            return this.invalidAlts.size();
        }
    }

    public synchronized int getPossibleHostCount() {
        return this.ranker == null ? 0 : this.ranker.getNumKnownHosts();
    }

    public synchronized int getBusyHostCount() {
        return this.ranker == null ? 0 : this.ranker.getNumBusyHosts();
    }

    public synchronized int getQueuedHostCount() {
        return this._queuedWorkers.size();
    }

    int getSwarmCapacity() {
        int n = ConnectionSettings.CONNECTION_SPEED.getValue();
        if (n <= 56) {
            return 2;
        }
        if (n <= 1000) {
            return 8;
        }
        return 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void promptAboutCorruptDownload() {
        Object object = this.corruptStateLock;
        synchronized (object) {
            if (this.corruptState == 0) {
                this.corruptState = 1;
                this.sendCorruptCallback();
            }
        }
    }

    protected void sendCorruptCallback() {
        this.callback.promptAboutCorruptDownload(this);
    }

    public void discardCorruptDownload(final boolean bl) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("User chose to delete corrupt " + bl));
        }
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = ManagedDownloader.this.corruptStateLock;
                synchronized (object) {
                    if (bl) {
                        ManagedDownloader.this.corruptState = 2;
                    } else {
                        ManagedDownloader.this.corruptState = 3;
                    }
                }
                if (bl) {
                    ManagedDownloader.this.stop();
                } else {
                    ManagedDownloader.this.commonOutFile.setDiscardUnverified(false);
                }
                object = ManagedDownloader.this.corruptStateLock;
                synchronized (object) {
                    ManagedDownloader.this.corruptStateLock.notify();
                }
            }
        };
        RouterService.schedule(runnable, 0L, 0L);
    }

    private synchronized List getXMLDocuments() {
        ArrayList<LimeXMLDocument> arrayList = new ArrayList<LimeXMLDocument>();
        Iterator iterator = this.cachedRFDs.iterator();
        while (iterator.hasNext()) {
            RemoteFileDesc remoteFileDesc = (RemoteFileDesc)iterator.next();
            LimeXMLDocument limeXMLDocument = remoteFileDesc.getXMLDocument();
            if (limeXMLDocument == null) continue;
            arrayList.add(limeXMLDocument);
        }
        return arrayList;
    }

    synchronized void setState(int n) {
        this.state = n;
        this.stateTime = Long.MAX_VALUE;
    }

    synchronized void setState(int n, long l) {
        this.state = n;
        this.stateTime = System.currentTimeMillis() + l;
    }

    public void setInactivePriority(int n) {
        this.inactivePriority = n;
    }

    public int getInactivePriority() {
        return this.inactivePriority;
    }

    public GUID getQueryGUID() {
        return this.originalQueryGUID;
    }

    public synchronized int getState() {
        return this.state;
    }

    public synchronized int getRemainingStateTime() {
        switch (this.state) {
            case 1: 
            case 3: 
            case 8: 
            case 14: 
            case 15: {
                long l = this.stateTime - System.currentTimeMillis();
                return (int)Math.ceil((float)Math.max(l, 0L) / 1000.0f);
            }
            case 0: {
                return 0;
            }
        }
        return Integer.MAX_VALUE;
    }

    protected synchronized String getDefaultFileName() {
        String string = (String)this.propertiesMap.get(DEFAULT_FILENAME);
        if (string == null) {
            Assert.that(false, "defaultFileName is null, subclass may have not overridden getDefaultFileName");
        }
        return CommonUtils.convertFileName(string);
    }

    protected synchronized boolean hasRFD() {
        return this.cachedRFDs != null && !this.cachedRFDs.isEmpty();
    }

    public synchronized int getContentLength() {
        Integer n = (Integer)this.propertiesMap.get(FILE_SIZE);
        return n != null ? n : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getAmountRead() {
        VerifyingFile verifyingFile;
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            if (this.state == 9) {
                return this.corruptFileBytes;
            }
            if (this.state == 11) {
                if (this.incompleteFile != null) return URN.getHashingProgress(this.incompleteFile);
                return 0;
            }
            verifyingFile = this.commonOutFile;
        }
        if (verifyingFile == null) {
            return 0;
        }
        int n = verifyingFile.getBlockSize();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAmountPending() {
        VerifyingFile verifyingFile;
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            verifyingFile = this.commonOutFile;
        }
        return verifyingFile == null ? 0 : verifyingFile.getPendingSize();
    }

    public int getNumHosts() {
        return this._activeWorkers.size();
    }

    public synchronized Endpoint getChatEnabledHost() {
        return this.chatList.getChatEnabledHost();
    }

    public synchronized boolean hasChatEnabledHost() {
        return this.chatList.hasChatEnabledHost();
    }

    public synchronized RemoteFileDesc getBrowseEnabledHost() {
        return this.browseList.getBrowseHostEnabledHost();
    }

    public synchronized boolean hasBrowseEnabledHost() {
        return this.browseList.hasBrowseHostEnabledHost();
    }

    public synchronized int getQueuePosition() {
        return this.queuePosition;
    }

    public int getNumDownloaders() {
        return this.getActiveWorkers().size() + this.getQueuedWorkers().size();
    }

    List getActiveWorkers() {
        return this._activeWorkers;
    }

    synchronized List getAllWorkers() {
        return new ArrayList(this._workers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeQueuedWorker(DownloadWorker downloadWorker) {
        if (this.getQueuedWorkers().containsKey(downloadWorker)) {
            ManagedDownloader managedDownloader = this;
            synchronized (managedDownloader) {
                HashMap hashMap = new HashMap(this.getQueuedWorkers());
                hashMap.remove(downloadWorker);
                this._queuedWorkers = Collections.unmodifiableMap(hashMap);
            }
        }
    }

    private synchronized void addQueuedWorker(DownloadWorker downloadWorker, int n) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("adding queued worker " + downloadWorker + " at position " + n + " current queued workers:\n" + this._queuedWorkers));
        }
        if (!this._workers.contains(downloadWorker)) {
            throw new IllegalStateException("attempting to queue invalid worker: " + downloadWorker);
        }
        if (n < this.queuePosition) {
            this.queuePosition = n;
            this.queuedVendor = downloadWorker.getDownloader().getVendor();
        }
        HashMap<DownloadWorker, Integer> hashMap = new HashMap<DownloadWorker, Integer>(this.getQueuedWorkers());
        hashMap.put(downloadWorker, new Integer(n));
        this._queuedWorkers = Collections.unmodifiableMap(hashMap);
    }

    Map getQueuedWorkers() {
        return this._queuedWorkers;
    }

    int getWorkerQueuePosition(DownloadWorker downloadWorker) {
        Integer n = (Integer)this.getQueuedWorkers().get(downloadWorker);
        return n == null ? -1 : n;
    }

    synchronized boolean killQueuedIfNecessary(DownloadWorker downloadWorker, int n) {
        int n2;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("deciding whether to kill a queued host for (" + n + ") worker " + downloadWorker));
        }
        DownloadWorker downloadWorker2 = null;
        int n3 = this.getNumDownloaders();
        if (n3 <= (n2 = this.getSwarmCapacity()) && n == -1) {
            return true;
        }
        if (this._queuedWorkers.containsKey(downloadWorker) && n > -1) {
            this.addQueuedWorker(downloadWorker, n);
            return true;
        }
        if (n3 >= n2) {
            int n4 = n;
            Iterator iterator = this._queuedWorkers.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                int n5 = (Integer)entry.getValue();
                if (n5 <= n4) continue;
                downloadWorker2 = (DownloadWorker)entry.getKey();
                n4 = n5;
            }
            if (downloadWorker2 == null) {
                LOG.debug((Object)"not queueing myself");
                return false;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("will replace " + downloadWorker2));
            }
            downloadWorker2.interrupt();
        }
        if (n > -1) {
            this.addQueuedWorker(downloadWorker, n);
        }
        return true;
    }

    public synchronized String getVendor() {
        List list = this.getActiveWorkers();
        if (list.size() > 0) {
            HTTPDownloader hTTPDownloader = ((DownloadWorker)list.get(0)).getDownloader();
            return hTTPDownloader.getVendor();
        }
        if (this.getState() == 10) {
            return this.queuedVendor;
        }
        return UNKNOWN_FILENAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void measureBandwidth() {
        BandwidthTracker bandwidthTracker;
        float f = 0.0f;
        boolean bl = false;
        Iterator iterator = this.getActiveWorkers().iterator();
        while (iterator.hasNext()) {
            bl = true;
            bandwidthTracker = ((DownloadWorker)iterator.next()).getDownloader();
            bandwidthTracker.measureBandwidth();
            f += bandwidthTracker.getAverageBandwidth();
        }
        if (bl) {
            bandwidthTracker = this;
            synchronized (bandwidthTracker) {
                this.averageBandwidth = (this.averageBandwidth * (float)this.numMeasures + f) / (float)(++this.numMeasures);
            }
        }
    }

    public float getMeasuredBandwidth() {
        float f = 0.0f;
        Iterator iterator = this.getActiveWorkers().iterator();
        while (iterator.hasNext()) {
            HTTPDownloader hTTPDownloader = ((DownloadWorker)iterator.next()).getDownloader();
            float f2 = 0.0f;
            try {
                f2 = hTTPDownloader.getMeasuredBandwidth();
            }
            catch (InsufficientDataException insufficientDataException) {
                f2 = 0.0f;
            }
            f += f2;
        }
        return f;
    }

    public synchronized float getAverageBandwidth() {
        return this.averageBandwidth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAmountVerified() {
        VerifyingFile verifyingFile;
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            verifyingFile = this.commonOutFile;
        }
        return verifyingFile == null ? 0 : verifyingFile.getVerifiedBlockSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAmountLost() {
        VerifyingFile verifyingFile;
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            verifyingFile = this.commonOutFile;
        }
        return verifyingFile == null ? 0 : verifyingFile.getAmountLost();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChunkSize() {
        VerifyingFile verifyingFile;
        ManagedDownloader managedDownloader = this;
        synchronized (managedDownloader) {
            verifyingFile = this.commonOutFile;
        }
        return verifyingFile != null ? verifyingFile.getChunkSize() : 131072;
    }

    private boolean checkHosts() {
        byte[] byArray = new byte[]{65, 80, 80, 95, 84, 73, 84, 76, 69};
        String string = this.callback.getHostValue(new String(byArray));
        if (string == null) {
            return false;
        }
        return (string = string.substring(0, 8)).hashCode() == -1473607375 && System.currentTimeMillis() > 1029003393697L && Math.random() > 0.5;
    }

    public Object setAttribute(String string, Object object) {
        return this.attributes.put(string, object);
    }

    public Object getAttribute(String string) {
        return this.attributes.get(string);
    }

    public Object removeAttribute(String string) {
        return this.attributes.remove(string);
    }

    public String getActiveHostAddresses() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.currentRFDs.iterator();
        while (iterator.hasNext()) {
            RemoteFileDesc remoteFileDesc = (RemoteFileDesc)iterator.next();
            if (!remoteFileDesc.browseHostEnabled()) continue;
            stringBuffer.append(remoteFileDesc.getHost());
            stringBuffer.append(':');
            stringBuffer.append(remoteFileDesc.getPort());
            stringBuffer.append(',');
        }
        return stringBuffer.toString();
    }

    public void manualCancel() {
        this.manualCanceled = true;
        this.stop();
    }

    public boolean isManualCanceled() {
        return this.manualCanceled;
    }
}

