/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.spam;

import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.spam.AddressToken;
import com.limegroup.gnutella.spam.KeywordToken;
import com.limegroup.gnutella.spam.SizeToken;
import com.limegroup.gnutella.spam.Token;
import com.limegroup.gnutella.spam.UrnToken;
import com.limegroup.gnutella.spam.VendorToken;
import com.limegroup.gnutella.spam.XMLKeywordToken;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Tokenizer {
    private static final Log LOG;
    private static int MIN_KEYWORD_LENGTH;
    private static int MAX_KEYWORD_LENGTH;
    private static final String KEYWORD_DELIMITERS = " -._+/*()\\,\t";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.spam.Tokenizer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        MIN_KEYWORD_LENGTH = 3;
        MAX_KEYWORD_LENGTH = 8;
    }

    private Tokenizer() {
    }

    public static Token[] getTokens(RemoteFileDesc remoteFileDesc) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("tokenizing: " + remoteFileDesc));
        }
        HashSet<Token> hashSet = new HashSet<Token>();
        hashSet.addAll(Tokenizer.getKeywordTokens(remoteFileDesc));
        if (remoteFileDesc.getSHA1Urn() != null) {
            hashSet.add(Tokenizer.getUrnToken(remoteFileDesc));
        }
        hashSet.add(Tokenizer.getSizeToken(remoteFileDesc));
        hashSet.add(Tokenizer.getVendorToken(remoteFileDesc));
        hashSet.add(Tokenizer.getAddressToken(remoteFileDesc));
        Token[] tokenArray = new Token[hashSet.size()];
        tokenArray = hashSet.toArray(tokenArray);
        return tokenArray;
    }

    public static Token[] getTokens(RemoteFileDesc[] remoteFileDescArray) {
        HashSet<Token> hashSet = new HashSet<Token>();
        int n = 0;
        while (n < remoteFileDescArray.length) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("tokenizing: " + remoteFileDescArray[n]));
            }
            hashSet.addAll(Tokenizer.getKeywordTokens(remoteFileDescArray[n]));
            if (remoteFileDescArray[n].getSHA1Urn() != null) {
                hashSet.add(Tokenizer.getUrnToken(remoteFileDescArray[n]));
            }
            hashSet.add(Tokenizer.getSizeToken(remoteFileDescArray[n]));
            hashSet.add(Tokenizer.getVendorToken(remoteFileDescArray[n]));
            hashSet.add(Tokenizer.getAddressToken(remoteFileDescArray[n]));
            ++n;
        }
        Token[] tokenArray = new Token[hashSet.size()];
        tokenArray = hashSet.toArray(tokenArray);
        return tokenArray;
    }

    public static Token[] getTokens(QueryRequest queryRequest) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("tokenizing: " + queryRequest));
        }
        HashSet hashSet = new HashSet();
        hashSet.addAll(Tokenizer.getKeywordTokens(queryRequest));
        hashSet.addAll(Tokenizer.getUrnTokens(queryRequest));
        Token[] tokenArray = new Token[hashSet.size()];
        tokenArray = hashSet.toArray(tokenArray);
        return tokenArray;
    }

    private static Token getUrnToken(RemoteFileDesc remoteFileDesc) {
        if (remoteFileDesc.getSHA1Urn() != null) {
            return new UrnToken(remoteFileDesc.getSHA1Urn());
        }
        return null;
    }

    private static Set getUrnTokens(QueryRequest queryRequest) {
        if (queryRequest.getQueryUrns().isEmpty()) {
            return Collections.EMPTY_SET;
        }
        Set set = queryRequest.getQueryUrns();
        HashSet<UrnToken> hashSet = new HashSet<UrnToken>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            hashSet.add(new UrnToken((URN)iterator.next()));
        }
        return hashSet;
    }

    private static Token getSizeToken(RemoteFileDesc remoteFileDesc) {
        return new SizeToken(remoteFileDesc.getSize());
    }

    private static Token getVendorToken(RemoteFileDesc remoteFileDesc) {
        return VendorToken.getToken(remoteFileDesc.getVendor());
    }

    private static Token getAddressToken(RemoteFileDesc remoteFileDesc) {
        return new AddressToken(remoteFileDesc.getInetAddress().getAddress(), remoteFileDesc.getPort());
    }

    private static Set getKeywordTokens(RemoteFileDesc remoteFileDesc) {
        return Tokenizer.getKeywordTokens(remoteFileDesc.getFileName(), remoteFileDesc.getXMLDocument());
    }

    private static Set getKeywordTokens(QueryRequest queryRequest) {
        return Tokenizer.getKeywordTokens(queryRequest.getQuery(), queryRequest.getRichQuery());
    }

    private static Set getKeywordTokens(String string, LimeXMLDocument limeXMLDocument) {
        Set set = Tokenizer.getKeywordTokens(string.toLowerCase(Locale.US));
        if (limeXMLDocument != null) {
            Iterator iterator = limeXMLDocument.getNameValueSet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                set.addAll(Tokenizer.getXMLKeywords(entry.getKey().toString().toLowerCase(Locale.US), entry.getValue().toString().toLowerCase(Locale.US)));
            }
        }
        return set;
    }

    private static Set getXMLKeywords(String string, String string2) {
        string = Tokenizer.extractSimpleFieldName(string);
        HashSet<XMLKeywordToken> hashSet = new HashSet<XMLKeywordToken>();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, KEYWORD_DELIMITERS);
        while (stringTokenizer.hasMoreTokens()) {
            byte[] byArray = stringTokenizer.nextToken().getBytes();
            if (byArray.length < MIN_KEYWORD_LENGTH) continue;
            if (byArray.length > MAX_KEYWORD_LENGTH) {
                byArray = Tokenizer.truncateArray(byArray, MAX_KEYWORD_LENGTH);
            }
            hashSet.add(new XMLKeywordToken(string, byArray));
        }
        return hashSet;
    }

    private static byte[] truncateArray(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    private static byte[] mergeArrays(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length + 1];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        byArray3[byArray.length] = 0;
        System.arraycopy(byArray2, 0, byArray3, byArray.length + 1, byArray2.length);
        return byArray3;
    }

    private static String extractSimpleFieldName(String string) {
        int n = string.lastIndexOf("__");
        int n2 = string.lastIndexOf("__", n - 1);
        return string.substring(n2 + "__".length(), n);
    }

    private static Set getKeywordTokens(String string) {
        HashSet<KeywordToken> hashSet = new HashSet<KeywordToken>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, KEYWORD_DELIMITERS);
        byte[] byArray = null;
        while (stringTokenizer.hasMoreTokens()) {
            KeywordToken keywordToken;
            byte[] byArray2 = stringTokenizer.nextToken().getBytes();
            if (byArray2.length < MIN_KEYWORD_LENGTH) {
                if (byArray != null) {
                    keywordToken = new KeywordToken(Tokenizer.mergeArrays(byArray, byArray2));
                    hashSet.add(keywordToken);
                }
                byArray = byArray2;
                continue;
            }
            if (byArray2.length > MAX_KEYWORD_LENGTH) {
                byArray2 = Tokenizer.truncateArray(byArray2, MAX_KEYWORD_LENGTH);
            }
            keywordToken = new KeywordToken(byArray2);
            hashSet.add(keywordToken);
            if (byArray != null) {
                keywordToken = new KeywordToken(Tokenizer.mergeArrays(byArray, byArray2));
                hashSet.add(keywordToken);
            }
            byArray = byArray2;
        }
        return hashSet;
    }
}

