/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.io.ConnectObserver;
import com.limegroup.gnutella.io.NBSocket;
import com.limegroup.gnutella.io.SocketFactory;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.ProxyUtils;
import com.limegroup.gnutella.util.SocketController;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;

class SimpleSocketController
implements SocketController {
    SimpleSocketController() {
    }

    public Socket connect(InetSocketAddress inetSocketAddress, int n, ConnectObserver connectObserver) throws IOException {
        int n2 = ProxyUtils.getProxyType(inetSocketAddress.getAddress());
        if (n2 != 0) {
            return this.connectProxy(n2, inetSocketAddress, n, connectObserver);
        }
        return this.connectPlain(inetSocketAddress, n, connectObserver);
    }

    public int getNumAllowedSockets() {
        return Integer.MAX_VALUE;
    }

    public boolean removeConnectObserver(ConnectObserver connectObserver) {
        return false;
    }

    public int getNumWaitingSockets() {
        return 0;
    }

    protected Socket connectPlain(InetSocketAddress inetSocketAddress, int n, ConnectObserver connectObserver) throws IOException {
        NBSocket nBSocket = SocketFactory.newSocket();
        if (connectObserver == null) {
            nBSocket.connect(inetSocketAddress, n);
        } else {
            nBSocket.connect(inetSocketAddress, n, connectObserver);
        }
        return nBSocket;
    }

    protected Socket connectProxy(int n, InetSocketAddress inetSocketAddress, int n2, ConnectObserver connectObserver) throws IOException {
        String string = ConnectionSettings.PROXY_HOST.getValue();
        int n3 = ConnectionSettings.PROXY_PORT.getValue();
        InetSocketAddress inetSocketAddress2 = new InetSocketAddress(string, n3);
        if (connectObserver != null) {
            return this.connectPlain(inetSocketAddress2, n2, new ProxyUtils.ProxyConnector(n, connectObserver, inetSocketAddress, n2));
        }
        Socket socket = this.connectPlain(inetSocketAddress2, n2, null);
        try {
            return ProxyUtils.establishProxy(n, socket, inetSocketAddress, n2);
        }
        catch (IOException iOException) {
            try {
                socket.close();
            }
            catch (IOException iOException2) {}
            throw iOException;
        }
    }
}

