/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.cabos;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.MessageService;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UPnPManager;
import com.limegroup.gnutella.io.NIODispatcher;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.FileUtils;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import jp.sourceforge.cabos.AqDispatcher;
import jp.sourceforge.cabos.AqEvent;
import jp.sourceforge.cabos.AqEventHandler;
import jp.sourceforge.cabos.ConnectionUpdate;
import jp.sourceforge.cabos.TransferUpdate;

public class AqMain {
    private static InputStreamReader reader = null;
    private static OutputStreamWriter writer = null;
    private static boolean isShuttingdown = false;

    public static void main(String[] stringArray) {
        try {
            reader = new InputStreamReader(System.in, "UTF-8");
            writer = new OutputStreamWriter((OutputStream)System.out, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.exit(0);
        }
        AqEvent.signalEvent(98);
        AqEventHandler aqEventHandler = new AqEventHandler();
        ErrorService.setErrorCallback(aqEventHandler);
        MessageService.setCallback(aqEventHandler);
        if (CommonUtils.getUserHomeDir().exists()) {
            FileUtils.setWriteable(CommonUtils.getUserHomeDir());
        }
        if (CommonUtils.getUserSettingsDir().exists()) {
            FileUtils.setWriteable(CommonUtils.getUserSettingsDir());
        }
        if (!NIODispatcher.instance().isRunning()) {
            System.exit(0);
        }
        if (!ConnectionSettings.DISABLE_UPNP.getValue()) {
            UPnPManager.instance().start();
        }
        RouterService routerService = new RouterService(aqEventHandler);
        routerService.start();
        RouterService.schedule(new ConnectionUpdate(), 60000L, 60000L);
        RouterService.schedule(new TransferUpdate(), 1000L, 1000L);
        AqEvent.signalEvent(99);
        AqMain.readLoop();
        System.exit(0);
    }

    private static void readLoop() {
        LinkedList<String> linkedList = new LinkedList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        try {
            while (!isShuttingdown) {
                char c = (char)reader.read();
                if (c == '|' || c == '\n' || c == '\r') {
                    linkedList.add(stringBuffer.toString());
                    stringBuffer.setLength(0);
                    if (c != '\n' && c != '\r') continue;
                    try {
                        AqDispatcher.dispatchCommand(linkedList);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    linkedList.clear();
                    continue;
                }
                stringBuffer.append(c);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeEvent(String string) {
        OutputStreamWriter outputStreamWriter = writer;
        synchronized (outputStreamWriter) {
            try {
                writer.write(string);
                writer.flush();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void shutdown() {
        OutputStreamWriter outputStreamWriter = writer;
        synchronized (outputStreamWriter) {
            try {
                reader.close();
                writer.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        isShuttingdown = true;
    }
}

