/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BandwidthTrackerImpl;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.HorizonCounter;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.PushProxyInterface;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.connection.MessageQueue;
import com.limegroup.gnutella.connection.PriorityMessageQueue;
import com.limegroup.gnutella.connection.SimpleMessageQueue;
import com.limegroup.gnutella.filters.SpamFilter;
import com.limegroup.gnutella.handshaking.BadHandshakeException;
import com.limegroup.gnutella.handshaking.HandshakeResponder;
import com.limegroup.gnutella.handshaking.LeafHandshakeResponder;
import com.limegroup.gnutella.handshaking.LeafHeaders;
import com.limegroup.gnutella.handshaking.NoGnutellaOkException;
import com.limegroup.gnutella.handshaking.UltrapeerHandshakeResponder;
import com.limegroup.gnutella.handshaking.UltrapeerHeaders;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.vendor.HopsFlowVendorMessage;
import com.limegroup.gnutella.messages.vendor.MessagesSupportedVendorMessage;
import com.limegroup.gnutella.messages.vendor.PushProxyAcknowledgement;
import com.limegroup.gnutella.messages.vendor.PushProxyRequest;
import com.limegroup.gnutella.messages.vendor.QueryStatusResponse;
import com.limegroup.gnutella.messages.vendor.TCPConnectBackVendorMessage;
import com.limegroup.gnutella.messages.vendor.UDPConnectBackVendorMessage;
import com.limegroup.gnutella.messages.vendor.UDPCrawlerPong;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.routing.PatchTableMessage;
import com.limegroup.gnutella.routing.QueryRouteTable;
import com.limegroup.gnutella.routing.ResetTableMessage;
import com.limegroup.gnutella.search.SearchResultHandler;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.statistics.OutOfBandThroughputStat;
import com.limegroup.gnutella.statistics.ReceivedMessageStatHandler;
import com.limegroup.gnutella.util.BandwidthThrottle;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.ThrottledOutputStream;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Hashtable;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Properties;

public class ManagedConnection
extends Connection
implements ReplyHandler,
PushProxyInterface {
    private long LEAF_QUERY_ROUTE_UPDATE_TIME = 300000L;
    private long ULTRAPEER_QUERY_ROUTE_UPDATE_TIME = 60000L;
    private static final int CONNECT_TIMEOUT = 6000;
    private static final int TOTAL_OUTGOING_MESSAGING_BANDWIDTH = 8000;
    private static final int MAX_UDP_CONNECT_BACK_ATTEMPTS = 15;
    private static final int MAX_TCP_CONNECT_BACK_ATTEMPTS = 10;
    private ConnectionManager _manager;
    private volatile SpamFilter _routeFilter = SpamFilter.newRouteFilter();
    private volatile SpamFilter _personalFilter = SpamFilter.newPersonalFilter();
    private final Object QRP_LOCK = new Object();
    private Object _outputQueueLock = new Object();
    private MessageQueue[] _outputQueue = new MessageQueue[8];
    private int _queued = 0;
    private boolean _runnerDied = false;
    int _lastPriority = 0;
    private static final int BIG_QUEUE_SIZE = 100;
    private static final int QUEUE_SIZE = 1;
    private static int BIG_QUEUE_TIME = 10000;
    static int QUEUE_TIME = 5000;
    private static final int PRIORITIES = 8;
    private static final int PRIORITY_WATCHDOG = 0;
    private static final int PRIORITY_PUSH = 1;
    private static final int PRIORITY_QUERY_REPLY = 2;
    private static final int PRIORITY_QUERY = 3;
    private static final int PRIORITY_PING_REPLY = 4;
    private static final int PRIORITY_PING = 5;
    private static final int PRIORITY_OTHER = 6;
    private static final int PRIORITY_OUR_QUERY = 7;
    private static final BandwidthThrottle _throttle = new BandwidthThrottle(8000.0f);
    private static final int REJECT_TIMEOUT = 500;
    private int _numMessagesSent;
    private int _numMessagesReceived;
    private int _numReceivedMessagesDropped;
    private int _numSentMessagesDropped;
    private int _lastReceived;
    private int _lastRecvDropped;
    private int _lastSent;
    private int _lastSentDropped;
    private long _nextQRPForwardTime;
    private BandwidthTrackerImpl _upBandwidthTracker = new BandwidthTrackerImpl();
    private BandwidthTrackerImpl _downBandwidthTracker = new BandwidthTrackerImpl();
    private boolean _isKillable = true;
    private Set _domains = null;
    private int softMaxHops = -1;
    private InetAddress pushProxyAddr = null;
    private int pushProxyPort = -1;
    private static int _numUDPConnectBackRequests = 0;
    private static int _numTCPConnectBackRequests = 0;
    private QueryRouteTable _lastQRPTableReceived;
    private QueryRouteTable _lastQRPTableSent;
    private Map _guidMap = null;
    private static long TIMED_GUID_LIFETIME = 600000L;
    private boolean _horizonEnabled = true;

    public ManagedConnection(String string, int n) {
        this(string, n, RouterService.isSupernode() ? new UltrapeerHeaders(string) : new LeafHeaders(string), RouterService.isSupernode() ? new UltrapeerHandshakeResponder(string) : new LeafHandshakeResponder(string));
    }

    static ManagedConnection createTestConnection(String string, int n, Properties properties, HandshakeResponder handshakeResponder) {
        return new ManagedConnection(string, n, properties, handshakeResponder);
    }

    private ManagedConnection(String string, int n, Properties properties, HandshakeResponder handshakeResponder) {
        super(string, n, properties, handshakeResponder);
        this._manager = RouterService.getConnectionManager();
    }

    ManagedConnection(Socket socket) {
        super(socket, RouterService.isSupernode() ? new UltrapeerHandshakeResponder(socket.getInetAddress().getHostAddress()) : new LeafHandshakeResponder(socket.getInetAddress().getHostAddress()));
        this._manager = RouterService.getConnectionManager();
    }

    public void initialize() throws IOException, NoGnutellaOkException, BadHandshakeException {
        super.initialize(6000);
    }

    public void resetQueryRouteTable(ResetTableMessage resetTableMessage) {
        if (this._lastQRPTableReceived == null) {
            this._lastQRPTableReceived = new QueryRouteTable(resetTableMessage.getTableSize(), resetTableMessage.getInfinity());
        } else {
            this._lastQRPTableReceived.reset(resetTableMessage);
        }
    }

    public void patchQueryRouteTable(PatchTableMessage patchTableMessage) {
        if (this._lastQRPTableReceived == null) {
            this._lastQRPTableReceived = new QueryRouteTable();
        }
        try {
            this._lastQRPTableReceived.patch(patchTableMessage);
        }
        catch (BadPacketException badPacketException) {}
    }

    public boolean shouldForwardQuery(QueryRequest queryRequest) {
        if (queryRequest.getCapabilitySelector() > 0) {
            if (this.isSupernodeClientConnection()) {
                return this.getRemoteHostCapabilitySelector() >= queryRequest.getCapabilitySelector();
            }
            if (this.isSupernodeSupernodeConnection()) {
                return this.getRemoteHostCapabilitySelector() >= 1;
            }
            return false;
        }
        return this.hitsQueryRouteTable(queryRequest);
    }

    protected boolean hitsQueryRouteTable(QueryRequest queryRequest) {
        if (this._lastQRPTableReceived == null) {
            return false;
        }
        return this._lastQRPTableReceived.contains(queryRequest);
    }

    public QueryRouteTable getQueryRouteTableReceived() {
        return this._lastQRPTableReceived;
    }

    public double getQueryRouteTablePercentFull() {
        return this._lastQRPTableReceived == null ? 0.0 : this._lastQRPTableReceived.getPercentFull();
    }

    public int getQueryRouteTableSize() {
        return this._lastQRPTableReceived == null ? 0 : this._lastQRPTableReceived.getSize();
    }

    protected OutputStream getOutputStream() throws IOException {
        return new ThrottledOutputStream(super.getOutputStream(), _throttle);
    }

    public Message receive() throws IOException, BadPacketException {
        Message message = null;
        try {
            message = super.receive();
        }
        catch (IOException iOException) {
            if (this._manager != null) {
                this._manager.remove(this);
            }
            throw iOException;
        }
        this.addReceived();
        return message;
    }

    public Message receive(int n) throws IOException, BadPacketException, InterruptedIOException {
        Message message = null;
        try {
            message = super.receive(n);
        }
        catch (InterruptedIOException interruptedIOException) {
            throw interruptedIOException;
        }
        catch (IOException iOException) {
            if (this._manager != null) {
                this._manager.remove(this);
            }
            throw iOException;
        }
        this.addReceived();
        return message;
    }

    public void send(Message message) {
        this.send(message, this.calculatePriority(message));
    }

    public void originateQuery(QueryRequest queryRequest) {
        this.send(queryRequest, 7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(Message message, int n) {
        if (!this.supportsGGEP()) {
            message = message.stripExtendedPayload();
        }
        if (this.softMaxHops > -1 && message instanceof QueryRequest && message.getHops() >= this.softMaxHops) {
            return;
        }
        this.repOk();
        Assert.that(this._outputQueue != null, "Connection not initialized");
        Object object = this._outputQueueLock;
        synchronized (object) {
            ++this._numMessagesSent;
            this._outputQueue[n].add(message);
            int n2 = this._outputQueue[n].resetDropped();
            this.addSentDropped(n2);
            this._queued += 1 - n2;
            this._lastPriority = n;
            this._outputQueueLock.notify();
        }
        this.repOk();
    }

    private void addSentDropped(int n) {
        this._numSentMessagesDropped += n;
    }

    public void addReceivedDropped() {
        ++this._numReceivedMessagesDropped;
    }

    public void addReceived() {
        ++this._numMessagesReceived;
    }

    private int calculatePriority(Message message) {
        byte by = message.getFunc();
        switch (by) {
            case -128: {
                return 3;
            }
            case -127: {
                return 2;
            }
            case 1: {
                return message.getHops() == 0 && message.getTTL() <= 2 ? 0 : 4;
            }
            case 0: {
                return message.getHops() == 0 && message.getTTL() == 1 ? 0 : 5;
            }
            case 64: {
                return 1;
            }
        }
        return 6;
    }

    public void flush() throws IOException {
    }

    public void buildAndStartQueues() {
        this._outputQueue[0] = new SimpleMessageQueue(1, Integer.MAX_VALUE, 100, true);
        this._outputQueue[1] = new PriorityMessageQueue(6, BIG_QUEUE_TIME, 100);
        this._outputQueue[2] = new PriorityMessageQueue(6, BIG_QUEUE_TIME, 100);
        this._outputQueue[3] = new PriorityMessageQueue(3, QUEUE_TIME, 100);
        this._outputQueue[4] = new PriorityMessageQueue(1, QUEUE_TIME, 1);
        this._outputQueue[5] = new PriorityMessageQueue(1, QUEUE_TIME, 1);
        this._outputQueue[7] = new PriorityMessageQueue(10, BIG_QUEUE_TIME, 100);
        this._outputQueue[6] = new SimpleMessageQueue(1, Integer.MAX_VALUE, 100, false);
        this.startOutputRunner();
    }

    protected void startOutputRunner() {
        new OutputRunner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpQueueStats() {
        Object object = this._outputQueueLock;
        synchronized (object) {
            int n = 0;
            while (n < 8) {
                System.out.println(String.valueOf(n) + " " + this._outputQueue[n].size());
                ++n;
            }
            System.out.println("* " + this._queued + "\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this._outputQueueLock;
        synchronized (object) {
            super.close();
            this._outputQueueLock.notify();
        }
        if (this._guidMap != null) {
            GuidMapExpirer.removeMap(this._guidMap);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void loopToReject() {
        try {
            try {
                int n = 0;
                while (n < 10) {
                    block13: {
                        block12: {
                            Message message;
                            block11: {
                                message = null;
                                try {
                                    message = super.receive(500);
                                    if (message != null) break block11;
                                }
                                catch (BadPacketException badPacketException) {
                                    break block12;
                                }
                                break block12;
                            }
                            if (!(message instanceof PingRequest) || message.getHops() != 0 || message.getTTL() != 2) break block13;
                            this.handleCrawlerPing((PingRequest)message);
                        }
                        Object var3_3 = null;
                        this.close();
                        return;
                    }
                    ++n;
                }
            }
            catch (IOException iOException) {}
            Object var3_5 = null;
            this.close();
            return;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.close();
            throw throwable;
        }
    }

    private void handleCrawlerPing(PingRequest pingRequest) throws IOException {
        List list = this._manager.getInitializedConnections();
        this.supersendNeighborPongs(pingRequest, list);
        List list2 = this._manager.getInitializedClientConnections();
        this.supersendNeighborPongs(pingRequest, list2);
    }

    private void supersendNeighborPongs(PingRequest pingRequest, List list) throws IOException {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            PingReply pingReply = managedConnection.isSupernodeConnection() ? PingReply.createExternal(pingRequest.getGUID(), (byte)2, managedConnection.getPort(), managedConnection.getInetAddress().getAddress(), true) : (managedConnection.isLeafConnection() || managedConnection.isOutgoing() ? PingReply.createExternal(pingRequest.getGUID(), (byte)2, managedConnection.getPort(), managedConnection.getInetAddress().getAddress(), false) : PingReply.createExternal(pingRequest.getGUID(), (byte)2, 0, managedConnection.getInetAddress().getAddress(), false));
            pingReply.hop();
            super.send(pingReply);
        }
        super.flush();
    }

    void loopForMessages() throws IOException {
        MessageRouter messageRouter = RouterService.getMessageRouter();
        boolean bl = this.isSupernodeClientConnection();
        while (true) {
            Message message = null;
            try {
                message = this.receive();
                if (message == null) {
                }
            }
            catch (BadPacketException badPacketException) {}
            continue;
            if (this.isSpam(message)) {
                if (!CommonUtils.isJava118()) {
                    ReceivedMessageStatHandler.TCP_FILTERED_MESSAGES.addMessage(message);
                }
                this.addReceivedDropped();
                continue;
            }
            if (bl && message instanceof QueryRequest) {
                message = this.tryToProxy((QueryRequest)message);
            }
            if (bl && message instanceof QueryStatusResponse) {
                message = this.morphToStopQuery((QueryStatusResponse)message);
            }
            messageRouter.handleMessage(message, this);
        }
    }

    private QueryRequest tryToProxy(QueryRequest queryRequest) {
        if (this.remoteHostSupportsLeafGuidance() < 1) {
            return queryRequest;
        }
        if (queryRequest.desiresOutOfBandReplies()) {
            return queryRequest;
        }
        if (queryRequest.doNotProxy()) {
            return queryRequest;
        }
        if (!(RouterService.isOOBCapable() && OutOfBandThroughputStat.isSuccessRateGreat() && OutOfBandThroughputStat.isOOBEffectiveForProxy())) {
            return queryRequest;
        }
        byte[] byArray = queryRequest.getGUID();
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        GUID.addressEncodeGuid(byArray2, RouterService.getAddress(), RouterService.getPort());
        queryRequest = QueryRequest.createProxyQuery(queryRequest, byArray2);
        if (this._guidMap == null) {
            this._guidMap = new Hashtable();
            GuidMapExpirer.addMapToExpire(this._guidMap);
        }
        GUID.TimedGUID timedGUID = new GUID.TimedGUID(new GUID(byArray2), TIMED_GUID_LIFETIME);
        this._guidMap.put((Object)timedGUID, (Object)new GUID(byArray));
        OutOfBandThroughputStat.OOB_QUERIES_SENT.incrementStat();
        return queryRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryStatusResponse morphToStopQuery(QueryStatusResponse queryStatusResponse) {
        if (this._guidMap == null) {
            return queryStatusResponse;
        }
        GUID gUID = queryStatusResponse.getQueryGUID();
        GUID gUID2 = null;
        Map map = this._guidMap;
        synchronized (map) {
            Iterator iterator = this._guidMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (!gUID.equals(entry.getValue())) continue;
                gUID2 = ((GUID.TimedGUID)entry.getKey()).getGUID();
                break;
            }
        }
        if (gUID2 != null) {
            return new QueryStatusResponse(gUID2, queryStatusResponse.getNumResults());
        }
        return queryStatusResponse;
    }

    public boolean isSpam(Message message) {
        return !this._routeFilter.allow(message);
    }

    public void countDroppedMessage() {
        ++this._numReceivedMessagesDropped;
    }

    public boolean isPersonalSpam(Message message) {
        return !this._personalFilter.allow(message);
    }

    public void setRouteFilter(SpamFilter spamFilter) {
        this._routeFilter = spamFilter;
    }

    public void setPersonalFilter(SpamFilter spamFilter) {
        this._personalFilter = spamFilter;
    }

    public void handlePingReply(PingReply pingReply, ReplyHandler replyHandler) {
        this.send(pingReply);
    }

    public void handleQueryReply(QueryReply queryReply, ReplyHandler replyHandler) {
        GUID.TimedGUID timedGUID;
        GUID gUID;
        if (this._guidMap != null && (gUID = (GUID)this._guidMap.get((Object)(timedGUID = new GUID.TimedGUID(new GUID(queryReply.getGUID()), TIMED_GUID_LIFETIME)))) != null) {
            byte by = queryReply.getHops();
            queryReply = new QueryReply(gUID.bytes(), queryReply);
            queryReply.setTTL((byte)2);
            queryReply.setHops(by);
        }
        this.send(queryReply);
    }

    public void handlePushRequest(PushRequest pushRequest, ReplyHandler replyHandler) {
        this.send(pushRequest);
    }

    protected void handleVendorMessage(VendorMessage vendorMessage) {
        super.handleVendorMessage(vendorMessage);
        if (vendorMessage instanceof HopsFlowVendorMessage) {
            HopsFlowVendorMessage hopsFlowVendorMessage = (HopsFlowVendorMessage)vendorMessage;
            this.softMaxHops = hopsFlowVendorMessage.getHopValue();
        } else if (vendorMessage instanceof PushProxyAcknowledgement) {
            PushProxyAcknowledgement pushProxyAcknowledgement = (PushProxyAcknowledgement)vendorMessage;
            if (Arrays.equals((byte[])pushProxyAcknowledgement.getGUID(), (byte[])RouterService.getMessageRouter()._clientGUID)) {
                this.pushProxyPort = pushProxyAcknowledgement.getListeningPort();
                this.pushProxyAddr = pushProxyAcknowledgement.getListeningAddress();
            }
        } else if (vendorMessage instanceof MessagesSupportedVendorMessage) {
            Object object;
            Object object2;
            if (this.isClientSupernodeConnection() && this.remoteHostSupportsLeafGuidance() >= 0) {
                object2 = RouterService.getSearchResultHandler();
                object = ((SearchResultHandler)object2).getQueriesToReSend();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    this.send((Message)iterator.next());
                }
            }
            if (this.remoteHostSupportsPushProxy() > -1) {
                object2 = new GUID(RouterService.getMessageRouter()._clientGUID);
                object = new PushProxyRequest((GUID)object2);
                this.send((Message)object);
            }
            if (ConnectionSettings.LOCAL_IS_PRIVATE.getValue() && (this.isLocal() || !this.isConnectBackCapable())) {
                return;
            }
            if (!UDPService.instance().canReceiveUnsolicited() && _numUDPConnectBackRequests < 15 && this.remoteHostSupportsUDPConnectBack() > -1) {
                object2 = RouterService.getUDPConnectBackGUID();
                object = new UDPConnectBackVendorMessage(RouterService.getPort(), (GUID)object2);
                this.send((Message)object);
                ++_numUDPConnectBackRequests;
            }
            if (!RouterService.acceptedIncomingConnection() && _numTCPConnectBackRequests < 10 && this.remoteHostSupportsTCPConnectBack() > -1) {
                object2 = new TCPConnectBackVendorMessage(RouterService.getPort());
                this.send((Message)object2);
                ++_numTCPConnectBackRequests;
            }
        }
    }

    public int getNumMessagesSent() {
        return this._numMessagesSent;
    }

    public int getNumMessagesReceived() {
        return this._numMessagesReceived;
    }

    public int getNumSentMessagesDropped() {
        return this._numSentMessagesDropped;
    }

    public long getNumReceivedMessagesDropped() {
        return this._numReceivedMessagesDropped;
    }

    public synchronized float getPercentReceivedDropped() {
        int n = this._numMessagesReceived - this._lastReceived;
        int n2 = this._numReceivedMessagesDropped - this._lastRecvDropped;
        float f = n == 0 ? 0.0f : (float)n2 / (float)n * 100.0f;
        this._lastReceived = this._numMessagesReceived;
        this._lastRecvDropped = this._numReceivedMessagesDropped;
        return f;
    }

    public synchronized float getPercentSentDropped() {
        int n = this._numMessagesSent - this._lastSent;
        int n2 = this._numSentMessagesDropped - this._lastSentDropped;
        float f = n == 0 ? 0.0f : (float)n2 / (float)n * 100.0f;
        this._lastSent = this._numMessagesSent;
        this._lastSentDropped = this._numSentMessagesDropped;
        return f;
    }

    public void measureBandwidth() {
        this._upBandwidthTracker.measureBandwidth(ByteOrder.long2int(this.getBytesSent()));
        this._downBandwidthTracker.measureBandwidth(ByteOrder.long2int(this.getBytesReceived()));
    }

    public float getMeasuredUpstreamBandwidth() {
        float f = 0.0f;
        try {
            f = this._upBandwidthTracker.getMeasuredBandwidth();
        }
        catch (InsufficientDataException insufficientDataException) {
            return 0.0f;
        }
        return f;
    }

    public float getMeasuredDownstreamBandwidth() {
        float f = 0.0f;
        try {
            f = this._downBandwidthTracker.getMeasuredBandwidth();
        }
        catch (InsufficientDataException insufficientDataException) {
            return 0.0f;
        }
        return f;
    }

    public synchronized void setHorizonEnabled(boolean bl) {
        this._horizonEnabled = bl;
    }

    public synchronized void updateHorizonStats(PingReply pingReply) {
        if (!this._horizonEnabled) {
            return;
        }
        HorizonCounter.instance().addPong(pingReply);
    }

    public long getNextQRPForwardTime() {
        return this._nextQRPForwardTime;
    }

    public void incrementNextQRPForwardTime(long l) {
        this._nextQRPForwardTime = this.isLeafConnection() ? l + this.LEAF_QUERY_ROUTE_UPDATE_TIME : l + this.ULTRAPEER_QUERY_ROUTE_UPDATE_TIME;
    }

    public boolean isKillable() {
        return this._isKillable;
    }

    public QueryRouteTable getQueryRouteTableSent() {
        return this._lastQRPTableSent;
    }

    public void setQueryRouteTableSent(QueryRouteTable queryRouteTable) {
        this._lastQRPTableSent = queryRouteTable;
    }

    public int getPushProxyPort() {
        return this.pushProxyPort;
    }

    public InetAddress getPushProxyAddress() {
        return this.pushProxyAddr;
    }

    private final void repOk() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void stopOutputRunner() {
        var1_1 = this._outputQueueLock;
        synchronized (var1_1) {
            this._closed = true;
            this._outputQueueLock.notify();
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : var1_1
            if (true) ** GOTO lbl12
        }
        do {
            Thread.yield();
lbl12:
            // 2 sources

        } while (!this._runnerDied);
        this._runnerDied = false;
        this._closed = false;
    }

    boolean runnerDied() {
        return this._runnerDied;
    }

    public Object getQRPLock() {
        return this.QRP_LOCK;
    }

    public void setLocalePreferencing(boolean bl) {
        this.RESPONSE_HEADERS.setLocalePreferencing(bl);
    }

    public void handleUDPCrawlerPong(UDPCrawlerPong uDPCrawlerPong) {
        this.send(uDPCrawlerPong);
    }

    private class OutputRunner
    extends ManagedThread {
        public OutputRunner() {
            this.setName("OutputRunner");
            this.setDaemon(true);
            this.start();
        }

        public void managedRun() {
            try {
                while (true) {
                    ManagedConnection.this.repOk();
                    this.waitForQueued();
                    this.sendQueued();
                    ManagedConnection.this.repOk();
                }
            }
            catch (IOException iOException) {
                if (ManagedConnection.this._manager != null) {
                    ManagedConnection.this._manager.remove(ManagedConnection.this);
                }
                ManagedConnection.this._runnerDied = true;
            }
            catch (Throwable throwable) {
                if (ManagedConnection.this._manager != null) {
                    ManagedConnection.this._manager.remove(ManagedConnection.this);
                }
                ManagedConnection.this._runnerDied = true;
                ErrorService.error(throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private final void waitForQueued() throws IOException {
            Object object = ManagedConnection.this._outputQueueLock;
            synchronized (object) {
                while (ManagedConnection.this.isOpen() && ManagedConnection.this._queued == 0) {
                    try {
                        ManagedConnection.this._outputQueueLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Assert.that(false, "OutputRunner Interrupted");
                    }
                }
            }
            if (!ManagedConnection.this.isOpen()) {
                throw Connection.CONNECTION_CLOSED;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void sendQueued() throws IOException {
            boolean bl;
            int n;
            int n2 = n = ManagedConnection.this._lastPriority;
            block3: do {
                MessageQueue messageQueue = ManagedConnection.this._outputQueue[n2];
                messageQueue.resetCycle();
                bl = false;
                while (true) {
                    Message message = null;
                    Object object = ManagedConnection.this._outputQueueLock;
                    synchronized (object) {
                        message = messageQueue.removeNext();
                        int n3 = messageQueue.resetDropped();
                        ManagedConnection.this.addSentDropped(n3);
                        ManagedConnection managedConnection = ManagedConnection.this;
                        managedConnection._queued = managedConnection._queued - ((message == null ? 0 : 1) + n3);
                        if (ManagedConnection.this._queued == 0) {
                            bl = true;
                        }
                        if (message == null) {
                            continue block3;
                        }
                    }
                    ManagedConnection.super.send(message);
                }
            } while (!bl && (n2 = (n2 + 1) % 8) != n);
            ManagedConnection.super.flush();
        }
    }

    private static class GuidMapExpirer
    implements Runnable {
        private static List toExpire = new LinkedList();
        private static boolean scheduled = false;
        static /* synthetic */ Class class$0;

        public static synchronized void addMapToExpire(Map map) {
            if (!scheduled) {
                RouterService.schedule(new GuidMapExpirer(), 0L, TIMED_GUID_LIFETIME);
                scheduled = true;
            }
            toExpire.add((Object)map);
        }

        public static synchronized void removeMap(Map map) {
            toExpire.remove((Object)map);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.limegroup.gnutella.ManagedConnection$GuidMapExpirer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> clazz2 = clazz;
            synchronized (clazz) {
                Iterator iterator = toExpire.iterator();
                while (iterator.hasNext()) {
                    Map map;
                    Map map2 = map = (Map)iterator.next();
                    synchronized (map2) {
                        Iterator iterator2 = map.keySet().iterator();
                        while (iterator2.hasNext()) {
                            if (!((GUID.TimedGUID)iterator2.next()).shouldExpire()) continue;
                            iterator2.remove();
                        }
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }
}

