/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.util.StringComparator;
import com.limegroup.gnutella.util.StringUtils;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.TreeMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.util.BitSet;

public class UDataFileCreator {
    int numEx = 0;

    public static void main(String[] stringArray) {
        UDataFileCreator uDataFileCreator = new UDataFileCreator();
        uDataFileCreator.createFile();
    }

    public void createFile() {
        BitSet bitSet = new BitSet();
        TreeMap treeMap = new TreeMap((Comparator)new StringComparator());
        HashMap hashMap = new HashMap();
        BitSet bitSet2 = new BitSet();
        BitSet bitSet3 = new BitSet();
        HashMap hashMap2 = new HashMap();
        try {
            this.readNonExclusion(bitSet);
            this.dealWithUnicodeData((Map)treeMap, bitSet, bitSet2, bitSet3);
            this.readNTestPopKD((Map)treeMap, (Map)hashMap2);
            this.readCaseFolding((Map)hashMap);
            this.replaceCase((Map)treeMap, (Map)hashMap, bitSet2);
            this.writeOutObjects((Map)treeMap, (Map)hashMap, bitSet2, bitSet3, hashMap2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println("number of excluded code points : " + this.numEx);
    }

    private void writeOutObjects(Map map, Map map2, BitSet bitSet, BitSet bitSet2, HashMap hashMap) throws IOException {
        Object object;
        FileOutputStream fileOutputStream = new FileOutputStream(new File("nudata.txt"));
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileOutputStream));
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            udata udata2 = (udata)map.get(object);
            if (udata2.deKomp.equals("")) continue;
            bufferedWriter.write(String.valueOf(object) + ";");
            String string = (String)hashMap.get((Object)udata2.deKomp);
            string = string == null || string.equals(udata2.deKomp) ? "" : string;
            bufferedWriter.write(String.valueOf(udata2.deKomp) + ";" + string + ";\n");
        }
        bufferedWriter.flush();
        bufferedWriter.close();
        fileOutputStream = new FileOutputStream(new File("excluded.dat"));
        object = new ObjectOutputStream(fileOutputStream);
        ((ObjectOutputStream)object).writeObject(bitSet);
        fileOutputStream = new FileOutputStream(new File("caseMap.dat"));
        object = new ObjectOutputStream(fileOutputStream);
        ((ObjectOutputStream)object).writeObject(map2);
        fileOutputStream = new FileOutputStream(new File("replaceSpace.dat"));
        object = new ObjectOutputStream(fileOutputStream);
        ((ObjectOutputStream)object).writeObject(bitSet2);
    }

    private void readNonExclusion(BitSet bitSet) throws IOException {
        String string;
        BufferedReader bufferedReader = this.getBR("MnKeep.txt");
        while ((string = bufferedReader.readLine()) != null) {
            int n = string.indexOf(59);
            String string2 = string.substring(0, n).trim();
            if (string2.indexOf("..") > -1) {
                String[] stringArray = StringUtils.split(string2, "..");
                int n2 = Integer.parseInt(stringArray[0], 16) - 1;
                int n3 = Integer.parseInt(stringArray[1], 16);
                while (n3 != n2) {
                    bitSet.set(n3--);
                }
                continue;
            }
            bitSet.set(Integer.parseInt(string2, 16));
        }
        bufferedReader.close();
    }

    private void dealWithUnicodeData(Map map, BitSet bitSet, BitSet bitSet2, BitSet bitSet3) throws IOException {
        String string;
        BufferedReader bufferedReader = this.getBR("UnicodeData.txt");
        boolean bl = true;
        while ((string = bufferedReader.readLine()) != null && bl) {
            bl = this.processLine(map, bitSet, string, bitSet2, bitSet3);
        }
        bufferedReader.close();
    }

    private boolean processLine(Map map, BitSet bitSet, String string, BitSet bitSet2, BitSet bitSet3) {
        String[] stringArray = StringUtils.splitNoCoalesce(string, ";");
        if (stringArray[0].equals("FFEE")) {
            return false;
        }
        if (stringArray[2].charAt(0) == 'P' || stringArray[2].equals("Zs")) {
            if (this.excludedPClass(stringArray[0])) {
                ++this.numEx;
                bitSet2.set(Integer.parseInt(stringArray[0], 16));
            } else if (!this.isExcluded(stringArray, bitSet)) {
                udata udata2 = new udata();
                udata2.cat = stringArray[2];
                udata2.CC = stringArray[3];
                map.put((Object)stringArray[0], (Object)udata2);
            } else {
                bitSet3.set(Integer.parseInt(stringArray[0], 16));
                udata udata3 = new udata();
                udata3.cat = stringArray[2];
                udata3.CC = stringArray[3];
                map.put((Object)stringArray[0], (Object)udata3);
            }
        } else if (this.isExcluded(stringArray, bitSet)) {
            ++this.numEx;
            bitSet2.set(Integer.parseInt(stringArray[0], 16));
        } else {
            udata udata4 = new udata();
            udata4.cat = stringArray[2];
            udata4.CC = stringArray[3];
            map.put((Object)stringArray[0], (Object)udata4);
        }
        return true;
    }

    private boolean excludedPClass(String string) {
        return string.equals("0027");
    }

    private boolean isExcluded(String[] stringArray, BitSet bitSet) {
        String string = stringArray[2];
        String string2 = stringArray[3];
        char c = string.charAt(0);
        if (bitSet.get(Integer.parseInt(stringArray[0].trim(), 16))) {
            return false;
        }
        if (string.equals("Lu") || string.equals("Ll") || string.equals("Lt") || string.equals("Lo") || string.equals("Lm") || string.equals("Nd") || string.equals("Mc") || string.equals("Cs") || string.equals("Co") || string.equals("Zs") || string.equals("So") || c == 'P') {
            return false;
        }
        return !string.equals("Mn") || !string2.equals("0");
    }

    private void readCaseFolding(Map map) throws IOException {
        String string;
        BufferedReader bufferedReader = this.getBR("CaseFolding.txt");
        while ((string = bufferedReader.readLine()) != null) {
            int n;
            String[] stringArray;
            String string2;
            if (string.length() <= 0 || string.charAt(0) == '#' || !(string2 = (stringArray = StringUtils.split(string = string.substring(0, n = string.indexOf(35)).trim(), ";"))[1].trim()).equals("C") && !string2.equals("F")) continue;
            map.put((Object)this.code2char(stringArray[0].trim()), (Object)this.code2char(stringArray[2].trim()));
        }
        bufferedReader.close();
    }

    private String code2char(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string.indexOf(" ") > -1) {
            String[] stringArray = StringUtils.split(string, " ");
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append((char)Integer.parseInt(stringArray[n], 16));
                ++n;
            }
        } else {
            stringBuffer.append((char)Integer.parseInt(string, 16));
        }
        return stringBuffer.toString();
    }

    private String char2code(String string) {
        if (string == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            String string2 = Integer.toString(string.charAt(n), 16);
            if (string2.length() < 4) {
                stringBuffer.append("00");
                stringBuffer.append(string2);
            } else {
                stringBuffer.append(string2);
            }
            stringBuffer.append(" ");
            ++n;
        }
        return stringBuffer.toString().trim();
    }

    private void replaceCase(Map map, Map map2, BitSet bitSet) {
        Iterator iterator = map.keySet().iterator();
        Integer.parseInt("3400", 16);
        Integer.parseInt("9FA5", 16);
        while (iterator.hasNext()) {
            String string;
            String string2 = (String)iterator.next();
            udata udata2 = (udata)map.get((Object)string2);
            if (udata2.cat.indexOf("P") > -1 || udata2.cat.equals("Zs")) {
                udata2.deKomp = "0020";
                continue;
            }
            if (udata2.deKomp.equals("")) {
                string = (String)map2.get((Object)this.code2char(string2));
                if (string == null) continue;
                udata2.deKomp = this.char2code(string);
                continue;
            }
            StringBuffer stringBuffer = new StringBuffer();
            String[] stringArray = StringUtils.split(udata2.deKomp, " ");
            int n = 0;
            while (n < stringArray.length) {
                int n2 = Integer.parseInt(stringArray[n], 16);
                if (!bitSet.get(n2)) {
                    string = this.char2code((String)map2.get((Object)this.code2char(stringArray[n])));
                    if (string != null) {
                        stringBuffer.append(String.valueOf(string) + " ");
                    } else {
                        udata udata3 = (udata)map.get((Object)stringArray[n]);
                        String string3 = udata3 == null ? "" : udata3.cat;
                        string = string3.indexOf("P") > -1 ? "0020" : stringArray[n];
                        stringBuffer.append(String.valueOf(string) + " ");
                    }
                }
                ++n;
            }
            udata2.deKomp = stringBuffer.toString().trim();
        }
    }

    private void readNTestPopKD(Map map, Map map2) throws IOException {
        String string;
        BufferedReader bufferedReader = this.getBR("NormalizationTest-3.2.0.txt");
        boolean bl = false;
        while ((string = bufferedReader.readLine()) != null) {
            char c = string.charAt(0);
            if (c == '#') continue;
            if (c == '@') {
                if (string.indexOf("Part2") > -1) break;
                if (string.indexOf("Part0") > -1) {
                    bl = true;
                    continue;
                }
                bl = false;
                continue;
            }
            if (bl) continue;
            String[] stringArray = StringUtils.split(string = string.substring(0, string.indexOf(35)).trim(), ";");
            udata udata2 = (udata)map.get((Object)stringArray[0].trim());
            if (udata2 != null) {
                udata2.deKomp = stringArray[4].trim();
            }
            map2.put((Object)stringArray[4].trim(), (Object)stringArray[3].trim());
        }
        bufferedReader.close();
    }

    private BufferedReader getBR(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        return new BufferedReader(new InputStreamReader(fileInputStream));
    }

    private class udata {
        public String cat;
        public String CC;
        public String deKomp = "";

        private udata() {
        }
    }
}

