/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.mp3.ID3Reader;
import com.limegroup.gnutella.util.Comparators;
import com.limegroup.gnutella.util.NameValue;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import com.limegroup.gnutella.xml.XMLStringUtils;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;
import com.sun.java.util.collections.TreeMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LimeXMLDocument
implements Serializable {
    public static final String XML_ID_ATTRIBUTE_STRING = "identifier";
    public static final String XML_HEADER = "<?xml version=\"1.0\"?>";
    private static DOMParser parser = new DOMParser();
    private volatile transient int hashCode = 0;
    static final long serialVersionUID = 7396170507085078485L;
    private final Map fieldToValue = new TreeMap(Comparators.stringComparator());
    private String schemaUri;
    private String xmlString;
    private String identifier;
    private String action = "";
    private boolean supportsID3v2 = true;
    private transient List CACHED_KEYWORDS = null;

    public boolean supportsID3v2() {
        return this.supportsID3v2;
    }

    public void setIdentifier(String string) {
        this.identifier = string;
    }

    public void setSchemaURI(String string) {
        this.schemaUri = string;
    }

    public LimeXMLDocument(String string) throws SAXException, SchemaNotFoundException, IOException {
        if (string == null || string.equals("")) {
            throw new SAXException("null or empty string");
        }
        InputSource inputSource = new InputSource(new StringReader(string));
        this.initialize(inputSource);
        this.xmlString = LimeXMLDocument.ripIdentifier(string.trim());
        if (this.xmlString.equals("")) {
            throw new SAXException("empty after identifier ripped");
        }
    }

    public LimeXMLDocument(Node node, Node node2) throws SchemaNotFoundException, IOException {
        this.grabDocInfo(node2, true);
        this.grabDocInfo(node, false);
        this.createMap(node, node2.getNodeName());
        if (this.fieldToValue.isEmpty()) {
            throw new IOException("no elements.");
        }
        if (this.getXMLString().equals("")) {
            throw new IOException("invalid elements.");
        }
    }

    public LimeXMLDocument(Collection collection, String string) {
        this.schemaUri = string;
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("empty list");
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object;
            String string2;
            Object object2 = iterator.next();
            if (object2 instanceof NameValue) {
                string2 = ((NameValue)object2).getName();
                object = ((NameValue)object2).getValue();
            } else if (object2 instanceof Map.Entry) {
                string2 = (String)((Map.Entry)object2).getKey();
                object = ((Map.Entry)object2).getValue();
            } else {
                throw new IllegalArgumentException("Invalid Collection");
            }
            this.fieldToValue.put((Object)string2.trim(), object);
        }
        try {
            if (this.getXMLString().equals("")) {
                throw new IllegalArgumentException("invalid collection data.");
            }
        }
        catch (SchemaNotFoundException schemaNotFoundException) {
            throw new IllegalArgumentException(schemaNotFoundException.getMessage());
        }
    }

    boolean isValid() {
        try {
            return !this.getXMLString().equals("") && !this.fieldToValue.isEmpty();
        }
        catch (SchemaNotFoundException schemaNotFoundException) {
            return false;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.xmlString != null) {
            this.xmlString = this.xmlString.trim();
        }
    }

    private static String ripIdentifier(String string) {
        String string2 = string;
        int n = string.indexOf(XML_ID_ATTRIBUTE_STRING);
        if (n > -1) {
            int n2 = string.indexOf("\"", n + 1);
            n2 = string.indexOf("\"", n2 + 1);
            String string3 = string.substring(0, n);
            String string4 = string.substring(n2 + 1);
            string2 = String.valueOf(string3) + string4;
        }
        if (string2.indexOf(XML_HEADER) < 0) {
            string2 = XML_HEADER + string2;
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(InputSource inputSource) throws SchemaNotFoundException, IOException, SAXException {
        Document document = null;
        Object object = parser;
        synchronized (object) {
            parser.parse(inputSource);
            document = parser.getDocument();
        }
        object = document.getDocumentElement();
        this.grabDocInfo((Node)object, true);
        Node node = object.getFirstChild();
        this.grabDocInfo(node, false);
        this.createMap((Node)object);
    }

    private void grabDocInfo(Node node, boolean bl) throws SchemaNotFoundException, IOException {
        if (node == null) {
            throw new IOException("null doc element");
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null) {
            throw new IOException("invalid doc element -- null namednodemap");
        }
        List list = LimeXMLUtils.getAttributes(namedNodeMap);
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            Object object;
            Node node2 = (Node)list.get(n2);
            String string = node2.getNodeName();
            String string2 = string.toLowerCase(Locale.US);
            if (string2.indexOf("schemalocation") >= 0) {
                this.schemaUri = node2.getNodeValue();
            } else if (string2.indexOf(XML_ID_ATTRIBUTE_STRING) >= 0) {
                this.identifier = node2.getNodeValue();
                object = (Element)node;
                object.removeAttribute(string);
            } else if (string2.indexOf("action") >= 0) {
                this.action = node2.getNodeValue();
            } else if (string2.indexOf("index") >= 0) {
                object = (Element)node;
                object.removeAttribute(string);
            } else if (bl) {
                object = String.valueOf(node.getNodeName()) + "__" + node2.getNodeName() + "__";
                this.fieldToValue.put((Object)((String)object).trim(), (Object)node2.getNodeValue().trim());
            }
            ++n2;
        }
        if (this.schemaUri == null) {
            throw new SchemaNotFoundException();
        }
    }

    public int getNumFields() {
        return this.fieldToValue.size();
    }

    public List getKeyWords() {
        if (this.CACHED_KEYWORDS != null) {
            return this.CACHED_KEYWORDS;
        }
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.fieldToValue.values().iterator();
        while (iterator.hasNext()) {
            boolean bl = true;
            String string = (String)iterator.next();
            try {
                new Double(string);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
            if (bl || string == null || string.equals("")) continue;
            arrayList.add((Object)string);
        }
        this.CACHED_KEYWORDS = arrayList;
        return arrayList;
    }

    private void createMap(Node node) {
        this.doAllChildren(node, "");
    }

    private void createMap(Node node, String string) {
        this.doAllChildren(node, string);
    }

    private void doAllChildren(Node node, String string) {
        if (!node.hasChildNodes()) {
            this.doEntry(node, string);
            return;
        }
        String string2 = this.doEntry(node, string);
        List list = LimeXMLUtils.getElements(node.getChildNodes());
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            Node node2 = (Node)list.get(n2);
            this.doAllChildren(node2, string2);
            ++n2;
        }
    }

    private String doEntry(Node node, String string) {
        String string2 = !string.equals("") ? String.valueOf(string) + "__" + node.getNodeName() : node.getNodeName();
        Element element = (Element)node;
        String string3 = LimeXMLUtils.getText(element.getChildNodes());
        if (string3 != null && !string3.equals("")) {
            this.fieldToValue.put((Object)string2.trim(), (Object)string3.trim());
        }
        if (!string.equals("")) {
            List list = LimeXMLUtils.getAttributes(node.getAttributes());
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                Node node2 = (Node)list.get(n2);
                String string4 = node2.getNodeName();
                String string5 = String.valueOf(string2) + "__" + string4 + "__";
                String string6 = node2.getNodeValue();
                this.fieldToValue.put((Object)string5.trim(), (Object)string6.trim());
                ++n2;
            }
        }
        return string2;
    }

    public String getSchemaURI() {
        return this.schemaUri;
    }

    public LimeXMLSchema getSchema() {
        return LimeXMLSchemaRepository.instance().getSchema(this.schemaUri);
    }

    public String getSchemaDescription() {
        LimeXMLSchema limeXMLSchema = this.getSchema();
        if (limeXMLSchema != null) {
            return limeXMLSchema.getDescription();
        }
        return LimeXMLSchema.getDisplayString(this.schemaUri);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getAction() {
        return this.action;
    }

    public Set getNameValueSet() {
        return this.fieldToValue.entrySet();
    }

    public Set getNameSet() {
        return this.fieldToValue.keySet();
    }

    public Collection getValueList() {
        return this.fieldToValue.values();
    }

    public List getOrderedNameValueList() throws SchemaNotFoundException {
        LinkedList linkedList = new LinkedList();
        if (this.schemaUri == null) {
            throw new SchemaNotFoundException("no schema given.");
        }
        LimeXMLSchema limeXMLSchema = LimeXMLSchemaRepository.instance().getSchema(this.schemaUri);
        if (limeXMLSchema == null) {
            throw new SchemaNotFoundException("invalid schema: " + this.schemaUri);
        }
        String[] stringArray = limeXMLSchema.getCanonicalizedFieldNames();
        int n = 0;
        while (n < stringArray.length) {
            Object object = this.fieldToValue.get((Object)stringArray[n].trim());
            if (object != null) {
                linkedList.add((Object)new NameValue(stringArray[n].trim(), object));
            }
            ++n;
        }
        return linkedList;
    }

    public String getValueFast(String string) {
        return (String)this.fieldToValue.get((Object)string);
    }

    public String getValue(String string) {
        String string2 = null;
        string = string.trim();
        string2 = (String)this.fieldToValue.get((Object)string);
        if (string.equals("audios__audio__genre__") && string2 != null) {
            try {
                short s = Short.parseShort(string2);
                string2 = ID3Reader.getGenreString(s);
                this.fieldToValue.put((Object)string, (Object)string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return string2;
    }

    public String getXMLString() throws SchemaNotFoundException {
        if (this.xmlString == null || this.xmlString.equals("")) {
            this.xmlString = LimeXMLDocument.constructXML(this.getOrderedNameValueList(), this.schemaUri);
            this.xmlString = this.xmlString.trim();
        }
        return this.xmlString;
    }

    public String getXMLStringWithIdentifier() throws SchemaNotFoundException {
        String string = this.getXMLString();
        int n = string.indexOf(">");
        if (n < 0) {
            return string;
        }
        ++n;
        n = string.indexOf(">", n);
        ++n;
        n = string.indexOf(">", n);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n);
        String string4 = " identifier=\"" + this.identifier + "\"";
        string = String.valueOf(string2) + string4 + string3;
        return string;
    }

    public static String constructXML(List list, String string) {
        String string2;
        if (list.size() == 0) {
            return "";
        }
        string = LimeXMLUtils.encodeXML(string);
        int n = list.size();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        String string3 = "";
        ArrayList arrayList = new ArrayList();
        boolean bl = false;
        NameValue nameValue = (NameValue)list.get(0);
        String string4 = nameValue.getName();
        boolean bl2 = string4.endsWith("__");
        StringTokenizer stringTokenizer = new StringTokenizer(string4, "__");
        int n2 = stringTokenizer.countTokens();
        boolean bl3 = bl2 && n2 == 2;
        int n3 = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int n4;
            NameValue nameValue2 = (NameValue)iterator.next();
            string2 = nameValue2.getName();
            String string5 = LimeXMLUtils.encodeXML((String)nameValue2.getValue());
            List list2 = XMLStringUtils.split(string2);
            int n5 = 0;
            List list3 = null;
            boolean bl4 = false;
            if (string2.endsWith("__")) {
                bl4 = true;
            }
            if (bl && !bl4) {
                stringBuffer.append(">");
            }
            if (n3 > 0) {
                list3 = XMLStringUtils.split(string3);
                n5 = LimeXMLDocument.getCommonCount(list2, list3);
            }
            int n6 = list2.size();
            int n7 = arrayList.size();
            if (n5 < n7) {
                n4 = n7 - n5;
                int n8 = n7 - 1;
                int n9 = 0;
                while (n9 < n4) {
                    String string6 = (String)arrayList.remove(n8);
                    --n8;
                    stringBuffer2.append("</" + string6 + ">");
                    ++n9;
                }
            }
            if (stringBuffer2.length() != 0) {
                stringBuffer.append(stringBuffer2);
                stringBuffer2.setLength(0);
            }
            n4 = n5;
            while (n4 < n6 - 1) {
                String string7 = (String)list2.get(n4);
                stringBuffer.append("<" + string7);
                if (n3 == 0 && n4 == 0) {
                    stringBuffer.append(" xsi:noNamespaceSchemaLocation=\"" + string + "\"");
                    if (!bl3) {
                        stringBuffer.append(">");
                    }
                } else if (!bl4) {
                    stringBuffer.append(">");
                }
                arrayList.add((Object)string7);
                ++n4;
            }
            String string8 = (String)list2.get(n6 - 1);
            if (!bl4) {
                stringBuffer.append("<" + string8 + ">" + string5 + "</" + string8 + ">");
            } else {
                stringBuffer.append(" " + string8 + "=\"" + string5 + "\"");
                if (n3 == n - 1) {
                    stringBuffer.append(">");
                }
            }
            string3 = string2;
            bl = bl4;
            ++n3;
        }
        int n10 = arrayList.size();
        int n11 = n10 - 1;
        while (n11 >= 0) {
            string2 = (String)arrayList.remove(n11);
            stringBuffer.append("</" + string2 + ">");
            --n11;
        }
        stringBuffer.insert(0, XML_HEADER);
        return stringBuffer.toString();
    }

    private static int getCommonCount(List list, List list2) {
        int n = 0;
        int n2 = list.size() < list2.size() ? list.size() : list2.size();
        int n3 = 0;
        while (n3 < n2) {
            if (!list.get(n3).equals(list2.get(n3))) break;
            ++n;
            ++n3;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof LimeXMLDocument)) {
            return false;
        }
        LimeXMLDocument limeXMLDocument = (LimeXMLDocument)object;
        return (this.schemaUri == null ? limeXMLDocument.schemaUri == null : this.schemaUri.equals(limeXMLDocument.schemaUri)) && (this.identifier == null ? limeXMLDocument.identifier == null : this.identifier.equals(limeXMLDocument.identifier)) && (this.action == null ? limeXMLDocument.action == null : this.action.equals(limeXMLDocument.action)) && (this.fieldToValue == null ? limeXMLDocument.fieldToValue == null : this.fieldToValue.equals((Object)limeXMLDocument.fieldToValue));
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int n = 17;
            if (this.fieldToValue != null) {
                n = 37 * n + this.fieldToValue.hashCode();
            }
            if (this.schemaUri != null) {
                n = 37 * n + this.schemaUri.hashCode();
            }
            if (this.identifier != null) {
                n = 37 * n + this.identifier.hashCode();
            }
            if (this.action != null) {
                n = 37 * n + this.action.hashCode();
            }
            this.hashCode = n;
        }
        return this.hashCode;
    }

    public String toString() {
        try {
            return this.getXMLString();
        }
        catch (SchemaNotFoundException schemaNotFoundException) {
            return "no schema.";
        }
    }
}

