/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.guess;

import com.limegroup.gnutella.guess.QueryKeyGenerator;
import com.limegroup.gnutella.guess.TEAQueryKeyGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class QueryKey {
    private static final Log LOG;
    private static QueryKeyGenerator secretKey;
    private static QueryKeyGenerator oldSecretKey;
    public static final int MIN_QK_SIZE_IN_BYTES = 4;
    public static final int MAX_QK_SIZE_IN_BYTES = 16;
    private byte[] _queryKey;
    private final int _hashCode;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.guess.QueryKey");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        secretKey = null;
        oldSecretKey = null;
        oldSecretKey = secretKey = QueryKey.createKeyGenerator();
    }

    private QueryKey(byte[] byArray, boolean bl) throws IllegalArgumentException {
        int n;
        if (!QueryKey.isValidQueryKeyBytes(byArray)) {
            throw new IllegalArgumentException();
        }
        byArray = (byte[])byArray.clone();
        if (bl) {
            n = byArray.length - 1;
            while (n >= 0) {
                if (byArray[n] == 28) {
                    byArray[n] = -6;
                }
                --n;
            }
        }
        n = 0x5A5A5A5A;
        int n2 = byArray.length - 1;
        while (n2 >= 0) {
            n ^= 0xFF & byArray[n2];
            n *= (n << 1) + 1;
            n = n >>> 27 | n << 5;
            --n2;
        }
        this._queryKey = byArray;
        this._hashCode = n;
    }

    public boolean isFor(SocketAddress socketAddress) {
        InetAddress inetAddress = ((InetSocketAddress)socketAddress).getAddress();
        int n = ((InetSocketAddress)socketAddress).getPort();
        return this.isFor(inetAddress, n);
    }

    public boolean isFor(InetAddress inetAddress, int n) {
        if (secretKey.checkKeyBytes(this._queryKey, inetAddress, n)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("QueryKey valid:" + this));
            }
            return true;
        }
        if (oldSecretKey.checkKeyBytes(this._queryKey, inetAddress, n)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("QueryKey old but valid:" + this));
            }
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("QueryKey corrupt or expired:" + this));
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object.hashCode() != this._hashCode) {
            return false;
        }
        if (!(object instanceof QueryKey)) {
            return false;
        }
        QueryKey queryKey = (QueryKey)object;
        return Arrays.equals(this._queryKey, queryKey._queryKey);
    }

    public int hashCode() {
        return this._hashCode;
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this._queryKey);
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[this._queryKey.length];
        System.arraycopy(this._queryKey, 0, byArray, 0, this._queryKey.length);
        return byArray;
    }

    public String toString() {
        return "{Query Key: " + new BigInteger(1, this._queryKey).toString(16) + "}";
    }

    public static boolean isValidQueryKeyBytes(byte[] byArray) {
        return byArray != null && byArray.length >= 4 && byArray.length <= 16;
    }

    public static QueryKey getQueryKey(byte[] byArray, boolean bl) throws IllegalArgumentException {
        return new QueryKey(byArray, bl);
    }

    public static QueryKey getQueryKey(SocketAddress socketAddress) {
        InetAddress inetAddress = ((InetSocketAddress)socketAddress).getAddress();
        int n = ((InetSocketAddress)socketAddress).getPort();
        return QueryKey.getQueryKey(inetAddress, n);
    }

    public static QueryKey getQueryKey(InetAddress inetAddress, int n) {
        return new QueryKey(secretKey.getKeyBytes(inetAddress, n), true);
    }

    public static QueryKey getQueryKey(InetAddress inetAddress, int n, QueryKeyGenerator queryKeyGenerator) {
        return new QueryKey(queryKeyGenerator.getKeyBytes(inetAddress, n), true);
    }

    public static QueryKeyGenerator createKeyGenerator() {
        return new TEAQueryKeyGenerator();
    }
}

