/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.io;

import com.limegroup.gnutella.io.Timeoutable;
import com.limegroup.gnutella.util.BinaryHeap;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TimeoutController {
    private static final Log LOG;
    private final BinaryHeap items = new BinaryHeap(20, true);
    private final List timedout = new ArrayList(100);
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.io.TimeoutController");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    synchronized int getNumPendingTimeouts() {
        return this.items.size();
    }

    public synchronized void addTimeout(Timeoutable timeoutable, long l, long l2) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding timeoutable: " + timeoutable + ", now: " + l + ", timeout: " + l2));
        }
        this.items.insert(new Timeout(timeoutable, l, l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processTimeouts(long l) {
        Timeout timeout;
        TimeoutController timeoutController = this;
        synchronized (timeoutController) {
            while (!this.items.isEmpty()) {
                timeout = (Timeout)this.items.getMax();
                if (timeout != null && l >= timeout.expireTime) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Timing out: " + timeout + ", expired: " + timeout.expireTime + ", now: " + l + ", length: " + timeout.timeoutLength));
                    }
                } else {
                    if (timeout == null || !LOG.isDebugEnabled()) break;
                    LOG.debug((Object)("Breaking -- next timeout at: " + timeout.expireTime + ", now: " + l));
                    break;
                }
                this.timedout.add(timeout);
                this.items.extractMax();
            }
        }
        int n = 0;
        while (n < this.timedout.size()) {
            timeout = (Timeout)this.timedout.get(n);
            timeout.timeoutable.notifyTimeout(l, timeout.expireTime, timeout.timeoutLength);
            ++n;
        }
        this.timedout.clear();
    }

    public synchronized long getNextExpireTime() {
        if (this.items.isEmpty()) {
            return -1L;
        }
        return ((Timeout)this.items.getMax()).expireTime;
    }

    private static class Timeout
    implements Comparable {
        private long expireTime;
        private Timeoutable timeoutable;
        private long timeoutLength;

        Timeout(Timeoutable timeoutable, long l, long l2) {
            this.expireTime = l + l2;
            this.timeoutLength = l2;
            this.timeoutable = timeoutable;
        }

        public int compareTo(Object object) {
            Timeout timeout = (Timeout)object;
            return this.expireTime < timeout.expireTime ? 1 : (this.expireTime > timeout.expireTime ? -1 : 0);
        }

        public String toString() {
            return "TimeoutWrapper for: " + this.timeoutable;
        }
    }
}

