/*
 * Decompiled with CFR 0.152.
 */
package de.vdheide.mp3;

import de.vdheide.mp3.ByteBuilder;
import de.vdheide.mp3.FrameDamagedException;
import de.vdheide.mp3.ID3v2;
import de.vdheide.mp3.ID3v2DecompressionException;
import de.vdheide.mp3.ID3v2Exception;
import de.vdheide.mp3.ID3v2Frame;
import de.vdheide.mp3.ParseException;
import de.vdheide.mp3.Parser;
import de.vdheide.mp3.TagContent;
import de.vdheide.mp3.TagFormatException;

public abstract class TextFrame {
    protected ID3v2 id3v2;
    protected String type;
    protected ID3v2Frame frame;
    protected TagContent content;
    protected boolean use_compression;
    protected boolean encoding;

    public TextFrame(boolean encoding, ID3v2 id3v2, String type, TagContent content, boolean use_compression) throws TagFormatException {
        if (content.getTextContent() == null) {
            throw new TagFormatException();
        }
        this.id3v2 = id3v2;
        this.type = type;
        this.content = content;
        this.use_compression = use_compression;
        this.encoding = encoding;
        ByteBuilder build = new ByteBuilder(encoding ? (byte)1 : -1, encoding ? content.getTextContent().length() * 2 + 1 : content.getTextContent().length());
        build.put(content.getTextContent());
        byte[] v2cont = build.getBytes();
        try {
            this.frame = new ID3v2Frame(type, v2cont, false, false, false, use_compression ? (byte)2 : 0, 0, 0, true);
        }
        catch (ID3v2DecompressionException e) {
            // empty catch block
        }
    }

    public void write() {
        try {
            this.id3v2.removeFrame(this.type);
        }
        catch (ID3v2Exception iD3v2Exception) {
            // empty catch block
        }
        this.id3v2.addFrame(this.frame);
    }

    public static TagContent read(boolean encoding, ID3v2 id3v2, String type) throws FrameDamagedException {
        TagContent ret = new TagContent();
        try {
            byte[] v2cont = ((ID3v2Frame)id3v2.getFrame(type).elementAt(0)).getContent();
            if (v2cont.length == 0) {
                encoding = false;
            }
            Parser parse = new Parser(v2cont, encoding);
            try {
                ret.setContent(parse.parseText());
            }
            catch (ParseException e) {
                throw new FrameDamagedException();
            }
        }
        catch (ID3v2Exception e) {
            // empty catch block
        }
        return ret;
    }
}

