/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ByteOrder {
    public static byte[] reverse(byte[] byArray) {
        int n = byArray.length;
        if (n > 0) {
            byte[] byArray2 = new byte[n];
            int n2 = 0;
            int n3 = n - 1;
            while (n3 >= 0) {
                byArray2[n2++] = byArray[n3--];
            }
            return byArray2;
        }
        return byArray;
    }

    public static short leb2short(byte[] byArray, int n) {
        return (short)(byArray[n] & 0xFF | byArray[n + 1] << 8);
    }

    public static short beb2short(byte[] byArray, int n) {
        return (short)(byArray[n] << 8 | byArray[n + 1] & 0xFF);
    }

    public static short leb2short(InputStream inputStream) throws IOException {
        return (short)(inputStream.read() & 0xFF | inputStream.read() << 8);
    }

    public static short beb2short(InputStream inputStream) throws IOException {
        return (short)(inputStream.read() << 8 | inputStream.read() & 0xFF);
    }

    public static int leb2int(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | byArray[n + 3] << 24;
    }

    public static int beb2int(byte[] byArray, int n) {
        return byArray[n] << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    public static int leb2int(InputStream inputStream) throws IOException {
        return inputStream.read() & 0xFF | (inputStream.read() & 0xFF) << 8 | (inputStream.read() & 0xFF) << 16 | inputStream.read() << 24;
    }

    public static int beb2int(InputStream inputStream) throws IOException {
        return inputStream.read() << 24 | (inputStream.read() & 0xFF) << 16 | (inputStream.read() & 0xFF) << 8 | inputStream.read() & 0xFF;
    }

    public static int leb2int(byte[] byArray, int n, int n2) throws IndexOutOfBoundsException, IllegalArgumentException {
        switch (n2) {
            case 1: {
                return byArray[n] & 0xFF;
            }
            case 2: {
                return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
            }
            case 3: {
                return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16;
            }
            case 4: {
                return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | byArray[n + 3] << 24;
            }
        }
        throw new IllegalArgumentException("No bytes specified");
    }

    public static long leb2long(byte[] byArray, int n, int n2) throws IndexOutOfBoundsException, IllegalArgumentException {
        switch (n2) {
            case 1: {
                return (long)byArray[n] & 0xFFL;
            }
            case 2: {
                return (long)byArray[n] & 0xFFL | ((long)byArray[n + 1] & 0xFFL) << 8;
            }
            case 3: {
                return (long)byArray[n] & 0xFFL | ((long)byArray[n + 1] & 0xFFL) << 8 | ((long)byArray[n + 2] & 0xFFL) << 16;
            }
            case 4: {
                return (long)byArray[n] & 0xFFL | ((long)byArray[n + 1] & 0xFFL) << 8 | ((long)byArray[n + 2] & 0xFFL) << 16 | ((long)byArray[n + 3] & 0xFFL) << 24;
            }
            case 5: {
                return (long)byArray[n] & 0xFFL | ((long)byArray[n + 1] & 0xFFL) << 8 | ((long)byArray[n + 2] & 0xFFL) << 16 | ((long)byArray[n + 3] & 0xFFL) << 24 | ((long)byArray[n + 4] & 0xFFL) << 32;
            }
            case 6: {
                return (long)byArray[n] & 0xFFL | ((long)byArray[n + 1] & 0xFFL) << 8 | ((long)byArray[n + 2] & 0xFFL) << 16 | ((long)byArray[n + 3] & 0xFFL) << 24 | ((long)byArray[n + 4] & 0xFFL) << 32 | ((long)byArray[n + 5] & 0xFFL) << 40;
            }
            case 7: {
                return (long)byArray[n] & 0xFFL | ((long)byArray[n + 1] & 0xFFL) << 8 | ((long)byArray[n + 2] & 0xFFL) << 16 | ((long)byArray[n + 3] & 0xFFL) << 24 | ((long)byArray[n + 4] & 0xFFL) << 32 | ((long)byArray[n + 5] & 0xFFL) << 40 | ((long)byArray[n + 6] & 0xFFL) << 48;
            }
            case 8: {
                return (long)byArray[n] & 0xFFL | ((long)byArray[n + 1] & 0xFFL) << 8 | ((long)byArray[n + 2] & 0xFFL) << 16 | ((long)byArray[n + 3] & 0xFFL) << 24 | ((long)byArray[n + 4] & 0xFFL) << 32 | ((long)byArray[n + 5] & 0xFFL) << 40 | ((long)byArray[n + 6] & 0xFFL) << 48 | (long)byArray[n + 7] << 56;
            }
        }
        throw new IllegalArgumentException("No bytes specified");
    }

    public static int beb2int(byte[] byArray, int n, int n2) throws IndexOutOfBoundsException, IllegalArgumentException {
        switch (n2) {
            case 1: {
                return byArray[n] & 0xFF;
            }
            case 2: {
                return (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
            }
            case 3: {
                return (byArray[n] & 0xFF) << 16 | (byArray[n + 1] & 0xFF) << 8 | byArray[n + 2] & 0xFF;
            }
            case 4: {
                return byArray[n] << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
            }
        }
        throw new IllegalArgumentException("No bytes specified");
    }

    public static void short2leb(short s, byte[] byArray, int n) {
        byArray[n] = (byte)s;
        byArray[n + 1] = (byte)(s >> 8);
    }

    public static void short2beb(short s, byte[] byArray, int n) {
        byArray[n] = (byte)(s >> 8);
        byArray[n + 1] = (byte)s;
    }

    public static void short2leb(short s, OutputStream outputStream) throws IOException {
        outputStream.write((byte)s);
        outputStream.write((byte)(s >> 8));
    }

    public static void short2beb(short s, OutputStream outputStream) throws IOException {
        outputStream.write((byte)(s >> 8));
        outputStream.write((byte)s);
    }

    public static void int2leb(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)n;
        byArray[n2 + 1] = (byte)(n >> 8);
        byArray[n2 + 2] = (byte)(n >> 16);
        byArray[n2 + 3] = (byte)(n >> 24);
    }

    public static void int2beb(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >> 24);
        byArray[n2 + 1] = (byte)(n >> 16);
        byArray[n2 + 2] = (byte)(n >> 8);
        byArray[n2 + 3] = (byte)n;
    }

    public static void int2beb(int n, OutputStream outputStream, int n2) throws IOException {
        switch (n2) {
            case 1: {
                outputStream.write((byte)n);
                break;
            }
            case 2: {
                outputStream.write((byte)(n >> 8));
                outputStream.write((byte)n);
                break;
            }
            case 3: {
                outputStream.write((byte)(n >> 16));
                outputStream.write((byte)(n >> 8));
                outputStream.write((byte)n);
                break;
            }
            case 4: {
                outputStream.write((byte)(n >> 24));
                outputStream.write((byte)(n >> 16));
                outputStream.write((byte)(n >> 8));
                outputStream.write((byte)n);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid n: " + n2);
            }
        }
    }

    public static void int2leb(int n, OutputStream outputStream) throws IOException {
        outputStream.write((byte)n);
        outputStream.write((byte)(n >> 8));
        outputStream.write((byte)(n >> 16));
        outputStream.write((byte)(n >> 24));
    }

    public static void int2beb(int n, OutputStream outputStream) throws IOException {
        outputStream.write((byte)(n >> 24));
        outputStream.write((byte)(n >> 16));
        outputStream.write((byte)(n >> 8));
        outputStream.write((byte)n);
    }

    public static byte[] int2minLeb(int n) throws IllegalArgumentException {
        if (n <= 65535) {
            if (n <= 255) {
                if (n < 0) {
                    throw new IllegalArgumentException();
                }
                return new byte[]{(byte)n};
            }
            return new byte[]{(byte)n, (byte)(n >> 8)};
        }
        if (n <= 0xFFFFFF) {
            return new byte[]{(byte)n, (byte)(n >> 8), (byte)(n >> 16)};
        }
        return new byte[]{(byte)n, (byte)(n >> 8), (byte)(n >> 16), (byte)(n >> 24)};
    }

    public static byte[] long2minLeb(long l) throws IllegalArgumentException {
        if (l <= 0xFFFFFFFFFFFFFFL) {
            if (l <= 0xFFFFFFFFFFFFL) {
                if (l <= 0xFFFFFFFFFFL) {
                    if (l <= 0xFFFFFFFFL) {
                        if (l <= 0xFFFFFFL) {
                            if (l <= 65535L) {
                                if (l <= 255L) {
                                    if (l < 0L) {
                                        throw new IllegalArgumentException();
                                    }
                                    return new byte[]{(byte)l};
                                }
                                return new byte[]{(byte)l, (byte)(l >> 8)};
                            }
                            return new byte[]{(byte)l, (byte)(l >> 8), (byte)(l >> 16)};
                        }
                        return new byte[]{(byte)l, (byte)(l >> 8), (byte)(l >> 16), (byte)(l >> 24)};
                    }
                    return new byte[]{(byte)l, (byte)(l >> 8), (byte)(l >> 16), (byte)(l >> 24), (byte)(l >> 32)};
                }
                return new byte[]{(byte)l, (byte)(l >> 8), (byte)(l >> 16), (byte)(l >> 24), (byte)(l >> 32), (byte)(l >> 40)};
            }
            return new byte[]{(byte)l, (byte)(l >> 8), (byte)(l >> 16), (byte)(l >> 24), (byte)(l >> 32), (byte)(l >> 40), (byte)(l >> 48)};
        }
        return new byte[]{(byte)l, (byte)(l >> 8), (byte)(l >> 16), (byte)(l >> 24), (byte)(l >> 32), (byte)(l >> 40), (byte)(l >> 48), (byte)(l >> 56)};
    }

    public static byte[] int2minBeb(int n) throws IllegalArgumentException {
        if (n <= 65535) {
            if (n <= 255) {
                if (n < 0) {
                    throw new IllegalArgumentException();
                }
                return new byte[]{(byte)n};
            }
            return new byte[]{(byte)(n >> 8), (byte)n};
        }
        if (n <= 0xFFFFFF) {
            return new byte[]{(byte)(n >> 16), (byte)(n >> 8), (byte)n};
        }
        return new byte[]{(byte)(n >> 24), (byte)(n >> 16), (byte)(n >> 8), (byte)n};
    }

    public static int ubyte2int(byte by) {
        return by & 0xFF;
    }

    public static int ubytes2int(short s) {
        return s & 0xFFFF;
    }

    public static long ubytes2long(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    public static int long2int(long l) {
        int n = Integer.MAX_VALUE;
        if (l < (long)Integer.MAX_VALUE) {
            n = Integer.MIN_VALUE;
            if (l > (long)Integer.MIN_VALUE) {
                return (int)l;
            }
        }
        return n;
    }
}

