/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.routing;

import com.limegroup.gnutella.util.I18NConvert;
import com.limegroup.gnutella.util.StringUtils;

public class HashFunction {
    private static final int A_INT = 1327217884;

    private static int hashFast(int n, byte by) {
        return n * 1327217884 >>> 32 - by;
    }

    public static int hash(String string, byte by) {
        return HashFunction.hash(string, 0, string.length(), by);
    }

    public static int hash(String string, int n, int n2, byte by) {
        int n3 = 0;
        int n4 = 0;
        int n5 = n;
        while (n5 < n2) {
            n3 ^= (Character.toLowerCase(string.charAt(n5)) & 0xFF) << n4;
            n4 = n4 + 8 & 0x18;
            ++n5;
        }
        return HashFunction.hashFast(n3, by);
    }

    public static String[] keywords(String string) {
        return StringUtils.split(I18NConvert.instance().getNorm(string), " -._+/*()\\");
    }

    public static int keywordStart(String string, int n) {
        while (n < string.length()) {
            char c = string.charAt(n);
            if (" -._+/*()\\".indexOf(c) < 0) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static int keywordEnd(String string, int n) {
        while (n < string.length()) {
            char c = string.charAt(n);
            if (" -._+/*()\\".indexOf(c) >= 0) {
                return n;
            }
            ++n;
        }
        return string.length();
    }

    public static String[] getPrefixes(String[] stringArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].length() > 4) {
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            return stringArray;
        }
        String[] stringArray2 = new String[stringArray.length + n * 2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < stringArray.length) {
            String string = stringArray[n4];
            stringArray2[n3++] = string;
            int n5 = string.length();
            if (n5 > 4) {
                stringArray2[n3++] = string.substring(0, n5 - 1);
                stringArray2[n3++] = string.substring(0, n5 - 2);
            }
            ++n4;
        }
        return stringArray2;
    }
}

