/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.util.DoublyLinkedList;
import com.sun.java.util.collections.AbstractSet;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;
import com.sun.java.util.collections.UnsupportedOperationException;

public class FixedsizeForgetfulHashMap
implements Map {
    private Map map;
    private DoublyLinkedList removeList = new DoublyLinkedList();
    private int maxSize;
    private int currentSize;

    public FixedsizeForgetfulHashMap(int n) {
        this.map = new HashMap(n * 4 / 3 + 10, 0.75f);
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this.currentSize = 0;
        this.maxSize = n;
    }

    public Object get(Object object) {
        ValueElement valueElement = (ValueElement)this.map.get(object);
        return valueElement == null ? null : valueElement.getValue();
    }

    public Object put(Object object, Object object2) {
        if (object == null || object2 == null) {
            return null;
        }
        Object object3 = this.addMapping(object, object2);
        return object3;
    }

    private Object addMapping(Object object, Object object2) {
        DoublyLinkedList.ListElement listElement = this.removeList.addLast(object);
        ValueElement valueElement = (ValueElement)this.map.put(object, (Object)new ValueElement(object2, listElement));
        if (valueElement != null) {
            this.removeList.remove(valueElement.getListElement());
        } else {
            ++this.currentSize;
        }
        if (this.currentSize > this.maxSize) {
            DoublyLinkedList.ListElement listElement2 = this.removeList.removeFirst();
            this.map.remove(listElement2.getKey());
            --this.currentSize;
        }
        if (valueElement == null) {
            return null;
        }
        return valueElement.getValue();
    }

    public boolean isFull() {
        return this.currentSize >= this.maxSize;
    }

    public Object removeLRUEntry() {
        if (this.isEmpty()) {
            return null;
        }
        DoublyLinkedList.ListElement listElement = this.removeList.removeFirst();
        ValueElement valueElement = (ValueElement)this.map.remove(listElement.getKey());
        --this.currentSize;
        return valueElement.getValue();
    }

    public void putAll(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            this.put(object, map.get(object));
        }
    }

    public Object clone() {
        HashMap hashMap = new HashMap(this.map.size() * 4 / 3 + 10, 0.75f);
        Set set = this.map.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            hashMap.put(entry.getKey(), ((ValueElement)entry.getValue()).getValue());
        }
        return hashMap;
    }

    public Object remove(Object object) {
        ValueElement valueElement = (ValueElement)this.map.remove(object);
        if (valueElement != null) {
            --this.currentSize;
            this.removeList.remove(valueElement.getListElement());
            return valueElement.getValue();
        }
        return null;
    }

    public void clear() {
        this.map.clear();
        this.currentSize = 0;
        this.removeList.clear();
    }

    public boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FixedsizeForgetfulHashMap)) {
            return false;
        }
        FixedsizeForgetfulHashMap fixedsizeForgetfulHashMap = (FixedsizeForgetfulHashMap)object;
        return this.map.equals((Object)fixedsizeForgetfulHashMap.map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int size() {
        return this.map.size();
    }

    public Set keySet() {
        return new KeySet(this.map.keySet());
    }

    public Collection values() {
        throw new UnsupportedOperationException();
    }

    public boolean containsValue(Object object) {
        throw new UnsupportedOperationException();
    }

    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    public void repOk() {
        Object object;
        Object object2;
        Iterator iterator = this.map.keySet().iterator();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            Assert.that(object2 != null, "Null key (1)");
            object = (ValueElement)this.map.get(object2);
            Assert.that(object != null, "Null value element (1)");
            Assert.that(((ValueElement)object).getValue() != null, "Null real value (1)");
            Assert.that(this.removeList.contains(((ValueElement)object).getListElement()), "Invariant 1a failed");
            Assert.that(((ValueElement)object).getListElement().getKey().equals(object2), "Invariant 1b failed");
        }
        iterator = this.removeList.iterator();
        while (iterator.hasNext()) {
            object2 = (DoublyLinkedList.ListElement)iterator.next();
            object = ((DoublyLinkedList.ListElement)object2).getKey();
            Assert.that(object != null, "Null key (2)");
            ValueElement valueElement = (ValueElement)this.map.get(object);
            Assert.that(valueElement != null, "Null value element (2)");
            Assert.that(valueElement.getListElement().equals(object2), "Invariant 2b failed");
        }
    }

    private static class ValueElement {
        DoublyLinkedList.ListElement listElement;
        Object value;

        public ValueElement(Object object, DoublyLinkedList.ListElement listElement) {
            this.value = object;
            this.listElement = listElement;
        }

        public DoublyLinkedList.ListElement getListElement() {
            return this.listElement;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof ValueElement)) {
                return false;
            }
            ValueElement valueElement = (ValueElement)object;
            return this.value.equals(valueElement.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    class KeySet
    extends AbstractSet {
        Set real;

        KeySet(Set set) {
            this.real = set;
        }

        public Iterator iterator() {
            return new KeyIterator(this.real.iterator());
        }

        public int size() {
            return FixedsizeForgetfulHashMap.this.size();
        }
    }

    class KeyIterator
    implements Iterator {
        Iterator real;
        Object lastYielded = null;

        KeyIterator(Iterator iterator) {
            this.real = iterator;
        }

        public Object next() {
            Object object;
            this.lastYielded = object = this.real.next();
            return object;
        }

        public boolean hasNext() {
            return this.real.hasNext();
        }

        public void remove() {
            if (this.lastYielded == null) {
                return;
            }
            ValueElement valueElement = (ValueElement)FixedsizeForgetfulHashMap.this.map.get(this.lastYielded);
            if (valueElement != null) {
                FixedsizeForgetfulHashMap fixedsizeForgetfulHashMap = FixedsizeForgetfulHashMap.this;
                fixedsizeForgetfulHashMap.currentSize = fixedsizeForgetfulHashMap.currentSize - 1;
                FixedsizeForgetfulHashMap.this.removeList.remove(valueElement.getListElement());
            }
            this.real.remove();
        }
    }
}

