/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap.chunks;

import de.kapsi.net.daap.ByteUtil;
import de.kapsi.net.daap.chunks.AbstractChunk;
import java.io.IOException;
import java.io.OutputStream;

public class ShortChunk
extends AbstractChunk {
    private int value;

    protected ShortChunk(String type, String name, int value) {
        super(type, name);
        this.value = value & 0xFFFF;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value & 0xFFFF;
    }

    public int getLength() {
        return 2;
    }

    public int getType() {
        return 3;
    }

    public void serialize(OutputStream out) throws IOException {
        super.serialize(out);
        byte[] dst = new byte[2];
        ByteUtil.toByte16BE(this.value, dst, 0);
        out.write(dst, 0, dst.length);
    }

    public String toString() {
        return super.toString() + "=" + this.value;
    }
}

