/* Copyright 1992 NEC Corporation, Tokyo, Japan.
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without
 * fee, provided that the above copyright notice appear in all copies
 * and that both that copyright notice and this permission notice
 * appear in supporting documentation, and that the name of NEC
 * Corporation not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission.  NEC Corporation makes no representations about the
 * suitability of this software for any purpose.  It is provided "as
 * is" without express or implied warranty.
 *
 * NEC CORPORATION DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN 
 * NO EVENT SHALL NEC CORPORATION BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF 
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR 
 * OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR 
 * PERFORMANCE OF THIS SOFTWARE. 
 */

/* sccs_id[]="%Z% NEC UNIX( PC-UX/EWS-UX ) %M% %R%.%L% %E% %U%"; */
/* $Id: IR.h,v 1.3.2.1 2003/01/06 04:36:58 aida_s Exp $ */

#include "cannaconf.h"
#define EXTENSION
#define DEBUG
#include "ccompat.h"
#include <sys/types.h>

#ifdef pcux

#include     <sys/kdef.h>

#else /* pcux */

#include    <sys/param.h>

#ifdef __STDC__
#include <time.h>
#else
extern char *ctime(), *strtok();
#endif

#ifdef WCHAR_T
#undef WCHAR_T
#define WCHAR_was_defined
#endif
#ifdef _WCHAR_T
#undef _WCHAR_T
#define WCHAR_was_defined
#endif
#ifdef _WCHAR_T_
#undef _WCHAR_T_
#define WCHAR_was_defined
#endif
#ifdef __WCHAR_T
#undef __WCHAR_T
#define WCHAR_was_defined
#endif
#ifdef _GCC_WCHAR_T
#undef _GCC_WCHAR_T
#define WCHAR_was_defined
#endif
#ifdef _WCHAR_T_DEFINED
#undef _WCHAR_T_DEFINED
#define WCHAR_was_defined
#endif

#ifdef hpux
typedef int FDSET_T;
#else
typedef fd_set FDSET_T;
#endif

#include    "protodefs.h"
#include    "canna/RK.h"
#include    "IRproto.h"
#include    "IRwproto.h"

#if defined(__STDC__) && defined(WCHAR_was_defined)
/* RK.h  wchar_t ϢδؿΥץȥˤ */
extern void	RkwFinalize(void);
extern int	RkwInitialize(char *),
		RkwCreateContext(void),
		RkwCloseContext(int),
		RkwDuplicateContext(int), 
		RkwSetDicPath(int, char *),
		RkwGetDirList(int, char *,int),
		RkwGetDicList(int, char *,int),
		RkwMountDic(int, char *, int),
		RkwUnmountDic(int, char *),
		RkwRemountDic(int, char *, int),
		RkwGetMountList(int, char *, int),
		RkwDefineDic(int, char *, Ushort *),
		RkwDeleteDic(int, char *, Ushort *),
		RkwBgnBun(int, Ushort *, int, int),
		RkwEndBun(int, int),
		RkwGoTo(int, int),
		RkwLeft(int),
		RkwRight(int),
		RkwXfer(int, int),
		RkwNfer(int),
		RkwNext(int),
		RkwPrev(int),
		RkwResize(int, int),
		RkwEnlarge(int),
		RkwShorten(int),
		RkwSubstYomi(int, int, int, Ushort *, int),
		RkwStoreYomi(int, Ushort *, int),
		RkwGetLastYomi(int, Ushort *, int),
		RkwFlushYomi(int),
		RkwRemoveBun(int, int),
		RkwGetStat(int, RkStat *),
		RkwGetYomi(int, Ushort *, int),
		RkwGetKanji(int, Ushort *, int),
		RkwGetKanjiList(int, Ushort *, int),
		RkwGetLex(int, RkLex *, int),
		RkwCvtHira(Ushort *, int, Ushort *, int),
		RkwCvtKana(Ushort *, int, Ushort *, int),
		RkwCvtHan(Ushort *, int, Ushort *, int),
		RkwCvtZen(Ushort *, int, Ushort *, int),
		RkwCvtEuc(Ushort *, int, Ushort *, int),
		RkwKillServer(void);
/* struct DicInfo *RkwQueryDic(int, Ushort *, struct DicInfo *); */
# define WCHAR_T
# define _WCHAR_T
# define _WCHAR_T_
# define __WCHAR_T
# define _GCC_WCHAR_T
#endif

#ifdef DEBUG
#define ir_debug( cannadebug )	 cannadebug
#else
#define ir_debug( cannadebug )	
#endif

#define DDPATH              "canna"
#define DDUSER              "user"
#define DDGROUP             "group"
#define DDPATHLEN           (sizeof(DDPATH) - 1)
#define DDUSERLEN           (sizeof(DDUSER) - 1)
#define DDGROUPLEN          (sizeof(DDGROUP) - 1)

#define DATE_LENGH	    29
#define GETDATE 	    1
#define CONNECT 	    2
#define SETTIME 	    3
#define GETTIME 	    4

#define N_INIT_CONTEXTS	    8 /* 饤ȤϣĤ餤Ȥ */
#define N_ADD_CONTEXTS	    4

/* 桼Υ饤ȴơ֥ */
typedef struct _Client {
    int 	id ;			     /* åֹ */
    int 	usr_no ;		     /* 桼ֹ */
    short 	version_hi ;		     /* protocol major version */
    short 	version_lo ;		     /* protocol miner version */
    long	used_time ;		     /* 桼 */
    long	idle_date ;		     /* ɥ */
    long	connect_date ;		     /* ͥȤ */
    char	*username ;		     /* 桼̾  */
    char	*groupname;		     /* 롼̾  */
    char	*hostname ;		     /* ۥ̾  */
    unsigned long	hostaddr;	     /* ۥȥɥ쥹 */
    int 	pcount[ W_MAXREQUESTNO ] ;   /* ץȥ륫 */
    int		*context_flag;               /* ƥȴե饰 */
    int		cfsize, ncon;		     /* Υơ֥礭 */
    char	*clientname ;		     /* 饤̾  */
} ClientRec ;			

typedef struct _UserTabl {
    char *username ;
    int count ;
} UsrTabl ;

typedef struct _ClientStat {
    int 	id ;			     /* åֹ */
    int 	usr_no ;		     /* 桼ֹ */
    long	used_time ;		     /* 桼 */
    long	idle_date ;		     /* ɥ */
    long	connect_date ;		     /* ͥȤ */
    int 	pcount[ OLD_MAXREQUESTNO ] ; /* ץȥ륫 */
    char	username[ NAME_LENGTH+1] ;   /* 桼̾  */
    char	hostname[ HOST_NAME ] ;      /* ۥ̾  */
    char	context_flag[ OLD_MAX_CX ] ;	 /* ƥȴե饰 */
} ClientStatRec ;		

#define IR_NO_ADDRESS   ((unsigned long)-1)
#define IR_UNIX_ADDRESS 0

typedef struct _AccessControlList {
    struct _AccessControlList  *prev ;
    struct _AccessControlList  *next ;
    char *hostname ;
    char *usernames ;
    int  usercnt ;
    unsigned long hostaddr;		/* host address */
} ACLRec ;

typedef struct _Client *ClientPtr ;
typedef struct _ClientStat *ClientStatPtr ;
typedef struct _UserTabl *UserTblPtr ;
typedef struct _AccessControlList *ACLPtr ;

#define LOCAL_BUFSIZE		2048
/*
#define BUFWATERMARK		8192	
#define MAXBUFSIZE (1 << 18)
*/

/* long  64 ӥåȤäꤹȤޤ */
#define LENTODATA( len, data ) { \
				long work ; \
				work = htonl( (len) ) ; \
				bcopy( (char *)&work, (char *)(data), sizeof( long ) ) ; \
				}

/* long  64 ӥåȤäꤹȤޤ */
#define DATATOLEN( data, len ) { \
				long work ; \
				bcopy( (char *)(data), (char *)&work, sizeof( long ) ) ; \
				len = ntohl( (work) ) ; \
				}

#endif /* pcux */

#define INITSOCKS 32
#define ADDSOCKS 32
/* checkohmori */

extern unsigned long mskcnt, connow_socks;

#define BITMASK(i) ((mskcnt == 1) ? (1 << (i)) : (1 << ((i) & 31)))
#define MASKIDX(i) ((mskcnt == 1) ? 0 : ((i) >> 5))

#define MASKWORD(buf, i) buf[MASKIDX(i)]
#define BITSET(buf, i) MASKWORD(buf, i) |= BITMASK(i)
#define BITCLEAR(buf, i) MASKWORD(buf, i) &= ~BITMASK(i)
#define GETBIT(buf, i) (MASKWORD(buf, i) & BITMASK(i))

#define COPYBITS(src, dst) \
  bcopy((caddr_t)src, (caddr_t)dst, mskcnt * sizeof(long))
#define CLEARBITS(buf) bzero((caddr_t)buf, mskcnt * sizeof(long))
#define MASKANDSETBITS(dst, b1, b2)  \
		      { int cri;			\
			for (cri=0; cri<mskcnt; cri++)	\
			  dst[cri] = (b1[cri] & b2[cri]); }
#define ORBITS(dst, b1, b2)  \
		      { int cri;			\
		      for (cri=0; cri<mskcnt; cri++)	\
			  dst[cri] = (b1[cri] | b2[cri]); }
#define UNSETBITS(dst, b1) \
		      { int cri;			\
		      for (cri=0; cri<mskcnt; cri++)	\
			  dst[cri] &= ~b1[cri];  }


