.\" Copyright 1994 NEC Corporation, Tokyo, Japan.
.\"
.\" Permission to use, copy, modify, distribute and sell this software
.\" and its documentation for any purpose is hereby granted without
.\" fee, provided that the above copyright notice appear in all copies
.\" and that both that copyright notice and this permission notice
.\" appear in supporting documentation, and that the name of NEC
.\" Corporation not be used in advertising or publicity pertaining to
.\" distribution of the software without specific, written prior
.\" permission.  NEC Corporation makes no representations about the
.\" suitability of this software for any purpose.  It is provided "as
.\" is" without express or implied warranty.
.\"
.\" NEC CORPORATION DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
.\" INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN 
.\" NO EVENT SHALL NEC CORPORATION BE LIABLE FOR ANY SPECIAL, INDIRECT OR
.\" CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF 
.\" USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR 
.\" OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR 
.\" PERFORMANCE OF THIS SOFTWARE. 
.\"
.\" $Id: server.man,v 1.6 2002/11/01 08:32:06 zu2 Exp $
.TH CANNASERVER 1M
.SH "NAME"
cannaserver \- Kana-Kanji conversion server
.SH "SYNOPSIS"
.B "cannaserver [\-d] [\-u \fIuserid\fP] [\-inet] [\-l \fIn\fP] [\-syslog] [\-p \fInum\fP] [\fIddpath\fP] "
.SH "DESCRIPTION"
.PP
cannaserver provides the Kana-Kanji conversion service.  Usually all
users on the network can access cannaserver(1M).  The scope of
accessing sources (hosts, users) can be restricted using the
/etc/hosts.canna file.
.PP
After starting, cannaserver(1M) immediately forks and enters the
background process.  Thus, you do not need to use '&' to set the
background process explicitly.
.PP
When starting, cannaserver(1M) creates the UNIX domain socket
@(UnixSockDir)/@(UnixSockName) to communicate clients.  The
socket is deleted automatically at the end of cannaserver(1M) if no
trouble occurs.  The socket may exist although cannaserver(1M) is
not in operation (because cannaserver(1M) terminates abnormally, for
example).  In this case, delete the file manually.
.PP
Specification of the dictionary to use is determined by referencing
the dics.dir file of the dictionary directory according to the
request from the client.
.SH "OPTIONS"
.IP "\fIddpath\fP" 12
Specifies the directory that contains the dictionary.
.IP "\-inet" 12
The remote host can connect with the cannaserver(1M) using
the inet domain socket.
By the default, the cannaserver(1M) uses only UNIX domain socket.
i.e. Only clients in your local machine can connect to the server.
.IP "\-l \fIn\fP" 12
Outputs the cannaserver(1M) log to /tmp/canna.log.  n (1 to 5)
specifies the log level.
.IP "\-d" 12
Starts cannaserver(1M) in debug mode.  It is executed as the
foreground process.  Log data at log level 5 is output to the standard
output.
.IP "\-u \fIuserid\fP" 12
Specifies which user cannaserver(1M) runs as.  By default, cannaserver(1M)
runs as the user who started cannaserver(1M).
.IP "\-syslog" 12
Outputs the cannaserver(1M) log to syslogd(8).
.IP "\-p \fInum\fP" 12
If specified, cannaserver(1M) will use the port number 5680 + num.  By
default, cannaserver(1M) uses the port number 5680.
.SH "FILES"
.IP "@(UnixSockDir)/@(UnixSockName)[:num]" 36
Socket
.IP "@(cannaLibDir)/dic/*/dics.dir" 36
Dictionary directory
.IP "@(AccessFile)" 36
Access control file
.SH "SEE ALSO"
.PP
cannakill(1M), cannastat(1), cannacheck(1)
