/*
 * Decompiled with CFR 0.152.
 */
package lu.luz.jzopfli;

import lu.luz.jzopfli.Deflate;
import lu.luz.jzopfli.Gzip_containerH;
import lu.luz.jzopfli.Util;
import lu.luz.jzopfli.ZopfliH;

final class Gzip_container
extends Gzip_containerH {
    private static final int[] crc_table = new int[256];
    private static boolean crc_table_computed = false;

    Gzip_container() {
    }

    private static void MakeCRCTable() {
        for (int i = 0; i < 256; ++i) {
            int n = i;
            for (int j = 0; j < 8; ++j) {
                if ((n & 1) != 0) {
                    n = 0xEDB88320 ^ n >>> 1;
                    continue;
                }
                n >>>= 1;
            }
            Gzip_container.crc_table[i] = n;
        }
        crc_table_computed = true;
    }

    private static int UpdateCRC(int n, byte[] byArray, int n2) {
        int n3 = ~n;
        if (!crc_table_computed) {
            Gzip_container.MakeCRCTable();
        }
        for (int i = 0; i < n2; ++i) {
            n3 = crc_table[(n3 ^ byArray[i]) & 0xFF] ^ n3 >>> 8;
        }
        return ~n3;
    }

    private static int CRC(byte[] byArray, int n) {
        return Gzip_container.UpdateCRC(0, byArray, n);
    }

    public static void ZopfliGzipCompress(ZopfliH.ZopfliOptions zopfliOptions, byte[] byArray, int n, byte[][] byArray2, int[] nArray) {
        int n2 = Gzip_container.CRC(byArray, n);
        byte[] byArray3 = new byte[]{0};
        Util.ZOPFLI_APPEND_DATA((byte)31, byArray2, nArray);
        Util.ZOPFLI_APPEND_DATA((byte)-117, byArray2, nArray);
        Util.ZOPFLI_APPEND_DATA((byte)8, byArray2, nArray);
        Util.ZOPFLI_APPEND_DATA((byte)0, byArray2, nArray);
        Util.ZOPFLI_APPEND_DATA((byte)0, byArray2, nArray);
        Util.ZOPFLI_APPEND_DATA((byte)0, byArray2, nArray);
        Util.ZOPFLI_APPEND_DATA((byte)0, byArray2, nArray);
        Util.ZOPFLI_APPEND_DATA((byte)0, byArray2, nArray);
        Util.ZOPFLI_APPEND_DATA((byte)2, byArray2, nArray);
        Util.ZOPFLI_APPEND_DATA((byte)3, byArray2, nArray);
        Deflate.ZopfliDeflate(zopfliOptions, 2, true, byArray, n, byArray3, byArray2, nArray);
        Util.ZOPFLI_APPEND_DATA((byte)n2, byArray2, nArray);
        Util.ZOPFLI_APPEND_DATA((byte)(n2 >> 8), byArray2, nArray);
        Util.ZOPFLI_APPEND_DATA((byte)(n2 >> 16), byArray2, nArray);
        Util.ZOPFLI_APPEND_DATA((byte)(n2 >> 24), byArray2, nArray);
        Util.ZOPFLI_APPEND_DATA((byte)n, byArray2, nArray);
        Util.ZOPFLI_APPEND_DATA((byte)(n >> 8), byArray2, nArray);
        Util.ZOPFLI_APPEND_DATA((byte)(n >> 16), byArray2, nArray);
        Util.ZOPFLI_APPEND_DATA((byte)(n >> 24), byArray2, nArray);
        if (zopfliOptions.verbose) {
            System.err.printf("Original Size: %d, Gzip: %d, Compression: %f%% Removed\n", n, nArray[0], 100.0 * (double)(n - nArray[0]) / (double)n);
        }
    }
}

