/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.javafx.fxml;

import java.io.IOException;
import java.io.UncheckedIOException;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuBar;
import net.osdn.util.javafx.scene.control.ContextMenuUtil;

public class Fxml {
    public static <T> T load(Class<?> cls) {
        boolean isContextClassLoaderReplaced = false;
        try {
            Object object;
            isContextClassLoaderReplaced = Fxml.setContextClassLoaderIfNeeded();
            String fxmlFilename = cls.getSimpleName() + ".fxml";
            FXMLLoader loader = new FXMLLoader(cls.getResource(fxmlFilename));
            try {
                Object obj = loader.load();
                Fxml.fix(obj);
                object = obj;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return (T)object;
        }
        finally {
            if (isContextClassLoaderReplaced) {
                Thread.currentThread().setContextClassLoader(null);
            }
        }
    }

    public static <T> T load(Object root, Class<?> cls) {
        boolean isContextClassLoaderReplaced = false;
        try {
            Object object;
            isContextClassLoaderReplaced = Fxml.setContextClassLoaderIfNeeded();
            String fxmlFilename = cls.getSimpleName() + ".fxml";
            FXMLLoader loader = new FXMLLoader(cls.getResource(fxmlFilename));
            loader.setRoot(root);
            try {
                Object obj = loader.load();
                Fxml.fix(obj);
                object = obj;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return (T)object;
        }
        finally {
            if (isContextClassLoaderReplaced) {
                Thread.currentThread().setContextClassLoader(null);
            }
        }
    }

    public static <T> T load(Object controller) {
        boolean isContextClassLoaderReplaced = false;
        try {
            Object object;
            isContextClassLoaderReplaced = Fxml.setContextClassLoaderIfNeeded();
            String fxmlFilename = controller.getClass().getSimpleName() + ".fxml";
            FXMLLoader loader = new FXMLLoader(controller.getClass().getResource(fxmlFilename));
            loader.setController(controller);
            try {
                Object obj = loader.load();
                Fxml.fix(obj);
                object = obj;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return (T)object;
        }
        finally {
            if (isContextClassLoaderReplaced) {
                Thread.currentThread().setContextClassLoader(null);
            }
        }
    }

    public static <T> T load(Object root, Object controller) {
        Class<?> cls = null;
        if (controller != null) {
            cls = controller.getClass();
        } else if (root != null) {
            cls = root.getClass();
        } else {
            throw new NullPointerException();
        }
        boolean isContextClassLoaderReplaced = false;
        try {
            Object object;
            isContextClassLoaderReplaced = Fxml.setContextClassLoaderIfNeeded();
            String fxmlFilename = cls.getSimpleName() + ".fxml";
            FXMLLoader loader = new FXMLLoader(cls.getResource(fxmlFilename));
            if (root != null) {
                loader.setRoot(root);
            }
            if (controller != null) {
                loader.setController(controller);
            }
            try {
                Object obj = loader.load();
                Fxml.fix(obj);
                object = obj;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return (T)object;
        }
        finally {
            if (isContextClassLoaderReplaced) {
                Thread.currentThread().setContextClassLoader(null);
            }
        }
    }

    public static <T> T load(Object controller, String fxmlFilename) {
        boolean isContextClassLoaderReplaced = false;
        try {
            Object object;
            isContextClassLoaderReplaced = Fxml.setContextClassLoaderIfNeeded();
            FXMLLoader loader = new FXMLLoader(controller.getClass().getResource(fxmlFilename));
            loader.setController(controller);
            try {
                Object obj = loader.load();
                Fxml.fix(obj);
                object = obj;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return (T)object;
        }
        finally {
            if (isContextClassLoaderReplaced) {
                Thread.currentThread().setContextClassLoader(null);
            }
        }
    }

    public static <T> T load(Object root, Object controller, String fxmlFilename) {
        Class<?> cls = null;
        if (controller != null) {
            cls = controller.getClass();
        } else if (root != null) {
            cls = root.getClass();
        } else {
            throw new NullPointerException();
        }
        boolean isContextClassLoaderReplaced = false;
        try {
            Object object;
            isContextClassLoaderReplaced = Fxml.setContextClassLoaderIfNeeded();
            FXMLLoader loader = new FXMLLoader(cls.getResource(fxmlFilename));
            if (root != null) {
                loader.setRoot(root);
            }
            if (controller != null) {
                loader.setController(controller);
            }
            try {
                Object obj = loader.load();
                Fxml.fix(obj);
                object = obj;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return (T)object;
        }
        finally {
            if (isContextClassLoaderReplaced) {
                Thread.currentThread().setContextClassLoader(null);
            }
        }
    }

    private static boolean setContextClassLoaderIfNeeded() {
        ClassLoader systemClassLoader;
        if (Thread.currentThread().getContextClassLoader() == null && (systemClassLoader = ClassLoader.getSystemClassLoader()) != null) {
            Thread.currentThread().setContextClassLoader(systemClassLoader);
            return true;
        }
        return false;
    }

    private static void fix(Object obj) {
        if (obj == null) {
            return;
        }
        if (obj instanceof MenuBar) {
            ContextMenuUtil.fix((MenuBar)obj);
        } else if (obj instanceof ContextMenu) {
            ContextMenuUtil.fix((ContextMenu)obj);
        } else if (obj instanceof Parent) {
            for (Node child : ((Parent)obj).getChildrenUnmodifiable()) {
                Fxml.fix(child);
            }
        }
    }
}

