/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.chaplet;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.sf.chaplet.Configuration;
import jp.sf.chaplet.DisplayMode;
import jp.sf.chaplet.Plugin;
import jp.sf.chaplet.StorageUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigLoader {
    private static ConfigLoader instance = new ConfigLoader();
    private Configuration conf;
    private static Logger logger = Logger.getLogger(ConfigLoader.class.getName());

    private ConfigLoader() {
    }

    public static ConfigLoader getInstance() {
        if (ConfigLoader.instance.conf == null) {
            try {
                ConfigLoader.instance.conf = instance.loadInternal();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "ConfigLoader failed to load", e);
            }
        }
        return instance;
    }

    private Configuration loadInternal() throws IOException {
        FileInputStream inStream = null;
        File workDir = this.getWorkDir();
        try {
            inStream = new FileInputStream(String.valueOf(workDir.getAbsolutePath()) + File.separator + "chaplet.properties");
            Properties prop = new Properties();
            prop.load(inStream);
            this.conf = new Configuration();
            this.conf.setSessionId(prop.getProperty("user.sessionId"));
            this.conf.setName(prop.getProperty("user.name"));
            if (this.conf.getName() == null) {
                this.conf.setName("");
            }
            this.conf.setUrl(prop.getProperty("server.url"));
            if (this.conf.getUrl() == null) {
                this.conf.setUrl("");
            }
            try {
                this.conf.setPort(Integer.parseInt(prop.getProperty("server.port")));
            }
            catch (NumberFormatException e1) {
                this.conf.setPort(10001);
            }
            this.conf.setPrimaryPluginId(prop.getProperty("server.primaryPluginId"));
            this.conf.setProperties(prop);
        }
        catch (FileNotFoundException e) {
            this.conf = new Configuration();
            Properties prop = new Properties();
            this.conf.setProperties(prop);
        }
        this.conf.pluginList = this.loadPlugins();
        this.instansiatePlugins();
        HashMap dispMap = (HashMap)StorageUtils.load("plugin.xml");
        if (dispMap != null) {
            for (Plugin plugin : this.conf.pluginList) {
                DisplayMode mode = (DisplayMode)((Object)dispMap.get(plugin.getPluginId()));
                if (mode == null) continue;
                plugin.getClientPlugin().setDisplayMode(mode);
            }
        }
        return this.conf;
    }

    public Configuration load() {
        return this.conf;
    }

    public synchronized void store(Configuration conf) throws IOException {
        File workDir = this.getWorkDir();
        String fileName = String.valueOf(workDir.getAbsolutePath()) + File.separator + "chaplet.properties";
        Properties prop = conf.getProperties();
        if (conf.getSessionId() != null) {
            prop.setProperty("user.sessionId", conf.getSessionId());
        }
        if (conf.getName() != null) {
            prop.setProperty("user.name", conf.getName());
        }
        if (conf.getUrl() != null) {
            prop.setProperty("server.url", conf.getUrl());
        }
        if (conf.getPrimaryPluginId() != null) {
            prop.setProperty("server.primaryPluginId", conf.getPrimaryPluginId());
        } else {
            prop.setProperty("server.primaryPluginId", "");
        }
        prop.setProperty("server.port", String.valueOf(conf.getPort()));
        FileOutputStream outStream = new FileOutputStream(fileName);
        try {
            prop.store(outStream, null);
        }
        finally {
            outStream.close();
        }
        HashMap<String, DisplayMode> dispMap = new HashMap<String, DisplayMode>();
        for (Plugin plugin : conf.pluginList) {
            dispMap.put(plugin.getPluginId(), (DisplayMode)((Object)dispMap.get(plugin.getPluginId())));
        }
    }

    public File getWorkDir() {
        File file;
        String workdir = System.getProperty("jp.sf.chaplet.workdir");
        if (workdir == null) {
            workdir = String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + ".chaplet";
        }
        if (!(file = new File(workdir)).exists() && !file.mkdir()) {
            logger.log(Level.SEVERE, "cannot create workdir : " + workdir);
            return null;
        }
        return file;
    }

    public InputStream openConfigFileForRead(String fileName) throws IOException {
        File file = new File(this.getWorkDir(), fileName);
        if (!file.exists() && file.createNewFile()) {
            throw new IOException(String.valueOf(fileName) + " is not found and not failed to creat.");
        }
        return new FileInputStream(file);
    }

    public InputStream openSystemFileForRead(String fileName) throws IOException {
        File file = new File("." + File.separator + fileName);
        if (!file.exists() && file.createNewFile()) {
            throw new IOException(String.valueOf(fileName) + " is not found and not failed to creat.");
        }
        return new FileInputStream(file);
    }

    ArrayList<Plugin> loadPlugins() {
        ArrayList<Plugin> list = new ArrayList<Plugin>();
        String dirName = System.getProperty("java.ext.dirs", System.getProperty("user.dir"));
        if (dirName.indexOf(File.pathSeparatorChar) >= 0) {
            dirName = dirName.substring(0, dirName.indexOf(File.pathSeparatorChar));
        }
        File systemDir = new File(dirName);
        File[] files = systemDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        int i = 0;
        while (i < files.length) {
            try {
                JarFile file = new JarFile(files[i]);
                Attributes attributes = file.getManifest().getAttributes("plugin");
                if (attributes != null) {
                    String pluginId = attributes.getValue("plugin-id");
                    String version = attributes.getValue("plugin-version");
                    String clientName = attributes.getValue("client");
                    String serverName = attributes.getValue("server");
                    String primary = attributes.getValue("primary");
                    if (pluginId != null && version != null && clientName != null && serverName != null) {
                        Plugin plugin = new Plugin(pluginId, version, serverName, clientName, primary != null && primary.equals("yes"));
                        list.add(plugin);
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "ConfigLoader failed to loadPlugin", e);
            }
            ++i;
        }
        return list;
    }

    void instansiatePlugins() {
        Iterator iter = this.conf.pluginIterator();
        while (iter.hasNext()) {
            Plugin plugin = (Plugin)iter.next();
            try {
                plugin.instansiate();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "ConfigLoader failed to instansiatePlugin", e);
            }
        }
    }
}

