/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.chaplet.core.ui;

import java.util.List;
import javax.swing.table.AbstractTableModel;
import jp.sf.chaplet.ConfigLoader;
import jp.sf.chaplet.DisplayMode;
import jp.sf.chaplet.Plugin;

public class PluginTableModel
extends AbstractTableModel {
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_ID = 1;
    public static final int COLUMN_DISPLAYMODE = 2;
    private static final String[] COLUMN_NAMES = new String[]{"\u540d\u524d", "ID", "\u8868\u793a"};
    private List<Plugin> pluginList = ConfigLoader.getInstance().load().getPlugins();

    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    public int getColumnCount() {
        return 3;
    }

    public int getRowCount() {
        return this.pluginList.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Plugin plugin = this.pluginList.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return plugin.getClientPlugin().getName();
            }
            case 1: {
                return plugin.getPluginId();
            }
            case 2: {
                return plugin.getClientPlugin().getDisplayMode();
            }
        }
        return null;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 2;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 2) {
            Plugin plugin = this.pluginList.get(rowIndex);
            plugin.getClientPlugin().setDisplayMode((DisplayMode)((Object)aValue));
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }
}

