/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.chaplet.swing;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.AbstractListModel;
import javax.swing.MutableComboBoxModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniqueComboBoxModel<T>
extends AbstractListModel
implements MutableComboBoxModel {
    private LinkedList<T> items = new LinkedList();
    private Object selectedItem;
    private int max = 0;

    @Override
    public Object getElementAt(int index) {
        return this.items.get(index);
    }

    @Override
    public int getSize() {
        return this.items.size();
    }

    public void add(int index, Object element) {
        if (!this.items.contains(element)) {
            this.items.add(index, element);
            this.fireIntervalAdded(this, index, index);
            if (this.max > 0 && this.items.size() > this.max) {
                this.items.removeLast();
                this.fireIntervalRemoved(this, this.items.size() - 1, this.items.size() - 1);
            }
        }
    }

    public void add(T e) {
        int index = this.items.indexOf(e);
        if (index >= 0) {
            this.items.remove(index);
            this.fireIntervalRemoved(this, index, index);
        }
        this.items.addFirst(e);
        this.fireIntervalAdded(this, 0, 0);
        if (this.max > 0 && this.items.size() > this.max) {
            this.items.removeLast();
            this.fireIntervalRemoved(this, this.items.size() - 1, this.items.size() - 1);
        }
    }

    public void addAll(Collection<T> c) {
        int sz = this.items.size();
        for (T e : c) {
            this.add(e);
        }
        if (sz < this.items.size()) {
            this.fireIntervalAdded(this, sz, this.items.size() - 1);
        }
    }

    public void clear() {
        int sz = this.items.size();
        this.items.clear();
        this.fireIntervalRemoved(this, 0, sz - 1);
    }

    public boolean contains(T o) {
        return this.items.contains(o);
    }

    public Iterator<T> iterator() {
        return this.items.iterator();
    }

    public ListIterator<T> listIterator() {
        return this.items.listIterator();
    }

    public T remove(int index) {
        T item = this.items.remove(index);
        if (item != null) {
            this.fireIntervalRemoved(this, index, index);
        }
        return item;
    }

    public void remove(T value) {
        int index = this.items.indexOf(value);
        if (index >= 0) {
            this.items.remove(index);
            this.fireIntervalRemoved(this, index, index);
        }
    }

    public void addElement(Object obj) {
        this.add(obj);
    }

    public void insertElementAt(Object obj, int index) {
        this.add(index, obj);
    }

    @Override
    public void removeElement(Object obj) {
        this.remove(obj);
    }

    @Override
    public void removeElementAt(int index) {
        this.remove(index);
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItem;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.selectedItem = anItem;
    }

    public Collection<T> getAll() {
        return this.items;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }
}

