/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.AbstractBean;
import application.Application;
import application.ApplicationAction;
import application.ApplicationActionMap;
import application.ApplicationContext;
import application.ResourceMap;
import application.TextActions;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;

public class ActionManager
extends AbstractBean {
    private static final Logger logger = Logger.getLogger(ActionManager.class.getName());
    private final WeakHashMap<Object, WeakReference<ApplicationActionMap>> actionMaps = new WeakHashMap();
    private ApplicationActionMap globalActionMap = null;

    private ApplicationActionMap createApplicationActionMap(Class resourcesClass, Class actionsClass, Object actionsObject, ApplicationActionMap parent) {
        if (actionsClass == null) {
            throw new IllegalArgumentException("null actionsClass");
        }
        ApplicationContext ac = ApplicationContext.getInstance();
        ResourceMap resourceMap = ac.getResourceMap(resourcesClass);
        ApplicationActionMap appAM = new ApplicationActionMap(actionsClass, actionsObject, resourceMap);
        appAM.setParent(parent);
        return appAM;
    }

    public ApplicationActionMap getActionMap() {
        if (this.globalActionMap == null) {
            ApplicationContext ac = ApplicationContext.getInstance();
            Application appObject = ac.getApplication();
            Class appClass = ac.getApplicationClass();
            List<Class> appClasses = ac.getApplicationClasses(appClass);
            Collections.reverse(appClasses);
            ApplicationActionMap parent = null;
            for (Class cls : appClasses) {
                parent = this.createApplicationActionMap(appClass, cls, appObject, parent);
            }
            this.globalActionMap = parent;
            this.initProxyActionSupport();
        }
        return this.globalActionMap;
    }

    private void initProxyActionSupport() {
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        kfm.addPropertyChangeListener(new KeyboardFocusPCL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationActionMap getActionMap(Class actionsClass, Object actionsObject) {
        if (actionsClass == null) {
            throw new IllegalArgumentException("null actionsClass");
        }
        WeakHashMap<Object, WeakReference<ApplicationActionMap>> weakHashMap = this.actionMaps;
        synchronized (weakHashMap) {
            ApplicationActionMap classActionMap;
            WeakReference<ApplicationActionMap> ref = this.actionMaps.get(actionsObject);
            ApplicationActionMap applicationActionMap = classActionMap = ref != null ? (ApplicationActionMap)ref.get() : null;
            if (classActionMap == null) {
                classActionMap = this.createApplicationActionMap(actionsClass, actionsClass, actionsObject, this.getActionMap());
                this.actionMaps.put(actionsObject, new WeakReference<ApplicationActionMap>(classActionMap));
            }
            return classActionMap;
        }
    }

    private void updateAllProxyActions(JComponent oldFocusOwner, JComponent newFocusOwner) {
        ActionMap ownerActionMap;
        if (newFocusOwner != null && (ownerActionMap = newFocusOwner.getActionMap()) != null) {
            this.updateProxyActions(this.getActionMap(), ownerActionMap, newFocusOwner);
            for (WeakReference<ApplicationActionMap> appAMRef : this.actionMaps.values()) {
                ApplicationActionMap appAM = (ApplicationActionMap)appAMRef.get();
                if (appAM == null) continue;
                this.updateProxyActions(appAM, ownerActionMap, newFocusOwner);
            }
        }
    }

    private void updateProxyActions(ApplicationActionMap appAM, ActionMap ownerActionMap, JComponent focusOwner) {
        for (ApplicationAction proxyAction : appAM.getProxyActions()) {
            String proxyActionName = proxyAction.getName();
            Action proxy = ownerActionMap.get(proxyActionName);
            if (proxy != null) {
                proxyAction.setProxy(proxy);
                proxyAction.setProxySource(focusOwner);
                continue;
            }
            proxyAction.setProxy(null);
            proxyAction.setProxySource(null);
        }
    }

    private final class KeyboardFocusPCL
    implements PropertyChangeListener {
        private final TextActions textActions = new TextActions();

        KeyboardFocusPCL() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName() == "permanentFocusOwner") {
                ApplicationContext ac = ApplicationContext.getInstance();
                JComponent oldOwner = ac.getFocusOwner();
                Object newValue = e.getNewValue();
                JComponent newOwner = newValue instanceof JComponent ? (JComponent)newValue : null;
                this.textActions.updateFocusOwner(oldOwner, newOwner);
                ac.setFocusOwner(newOwner);
                ActionManager.this.updateAllProxyActions(oldOwner, newOwner);
            }
        }
    }
}

