/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.Action;
import application.ApplicationActionMap;
import application.ApplicationContext;
import application.ResourceMap;
import application.Task;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class ApplicationAction
extends AbstractAction {
    private final ApplicationActionMap appAM;
    private final ResourceMap resourceMap;
    private final String actionName;
    private final Method actionMethod;
    private final String enabledProperty;
    private final Method isEnabledMethod;
    private final Method setEnabledMethod;
    private final String selectedProperty;
    private final Action.Block block;
    private boolean blocking = false;
    private Action proxy = null;
    private Object proxySource = null;
    private PropertyChangeListener proxyPCL = null;
    private static final String SELECTED_KEY = "SwingSelectedKey";
    private static final String DISPLAYED_MNEMONIC_INDEX_KEY = "SwingDisplayedMnemonicIndexKey";
    private static final String LARGE_ICON_KEY = "SwingLargeIconKey";

    public ApplicationAction(ApplicationActionMap appAM, ResourceMap resourceMap, String baseName, Method actionMethod, String enabledProperty, String selectedProperty, Action.Block block) {
        if (appAM == null) {
            throw new IllegalArgumentException("null appAM");
        }
        if (baseName == null) {
            throw new IllegalArgumentException("null baseName");
        }
        this.appAM = appAM;
        this.resourceMap = resourceMap;
        this.actionName = baseName;
        this.actionMethod = actionMethod;
        this.enabledProperty = enabledProperty;
        this.selectedProperty = selectedProperty;
        this.block = block;
        if (this.enabledProperty != null) {
            this.setEnabledMethod = this.propertySetMethod(enabledProperty, Boolean.TYPE);
            this.isEnabledMethod = this.propertyGetMethod(enabledProperty);
            if (this.isEnabledMethod == null) {
                String acn = appAM.getActionsClass().getName();
                String eps = "\"is/get" + enabledProperty + "\"";
                throw new IllegalArgumentException("no property named " + eps + " in " + acn);
            }
        } else {
            this.isEnabledMethod = null;
            this.setEnabledMethod = null;
        }
        if (resourceMap != null) {
            this.initActionProperties(resourceMap, baseName);
            if (block != Action.Block.NONE) {
                Icon icon;
                String message;
                String title = resourceMap.getString(baseName + ".Action.BlockingDialog.title", new Object[0]);
                if (title != null) {
                    this.putValue("BlockingDialog.title", title);
                }
                if ((message = resourceMap.getString(baseName + ".Action.BlockingDialog.message", new Object[0])) != null) {
                    this.putValue("BlockingDialog.message", message);
                }
                if ((icon = resourceMap.getIcon(baseName + ".Action.BlockingDialog.icon")) != null) {
                    this.putValue("BlockingDialog.icon", icon);
                }
            }
        }
    }

    ApplicationAction(ApplicationActionMap appAM, ResourceMap resourceMap, String actionName) {
        this(appAM, resourceMap, actionName, null, null, null, Action.Block.NONE);
    }

    String getEnabledProperty() {
        return this.enabledProperty;
    }

    String getSelectedProperty() {
        return this.selectedProperty;
    }

    public Action getProxy() {
        return this.proxy;
    }

    public void setProxy(Action proxy) {
        Action oldProxy = this.proxy;
        this.proxy = proxy;
        if (oldProxy != null) {
            oldProxy.removePropertyChangeListener(this.proxyPCL);
            this.proxyPCL = null;
        }
        if (this.proxy != null) {
            this.updateProxyProperties();
            this.proxyPCL = new ProxyPCL();
            proxy.addPropertyChangeListener(this.proxyPCL);
        } else if (oldProxy != null) {
            this.setEnabled(false);
        }
        this.firePropertyChange("proxy", oldProxy, this.proxy);
    }

    public Object getProxySource() {
        return this.proxySource;
    }

    public void setProxySource(Object source) {
        Object oldValue = this.proxySource;
        this.proxySource = source;
        this.firePropertyChange("proxySource", oldValue, this.proxySource);
    }

    private void maybePutDescriptionValue(String key, Action proxy) {
        Object s = proxy.getValue(key);
        if (s instanceof String) {
            this.putValue(key, (String)s);
        }
    }

    private void updateProxyProperties() {
        Action proxy = this.getProxy();
        if (proxy != null) {
            this.setEnabled(proxy.isEnabled());
            this.maybePutDescriptionValue("ShortDescription", proxy);
            this.maybePutDescriptionValue("LongDescription", proxy);
        }
    }

    private void initActionProperties(ResourceMap resourceMap, String baseName) {
        Icon largeIcon;
        Icon smallIcon;
        Icon icon;
        KeyStroke key;
        Integer index;
        Integer mnemonic;
        boolean iconOrNameSpecified = false;
        Object typedName = null;
        String text = resourceMap.getString(baseName + ".Action.text", new Object[0]);
        if (text != null) {
            int mnemonicIndex = text.indexOf("&");
            if (mnemonicIndex == -1) {
                mnemonicIndex = text.indexOf("_");
            }
            if (mnemonicIndex != -1 && mnemonicIndex + 1 < text.length()) {
                text = text.substring(0, mnemonicIndex) + text.substring(mnemonicIndex + 1);
                this.putValue("Name", text);
                this.putValue("MnemonicKey", new Integer(text.charAt(mnemonicIndex)));
                this.putValue(DISPLAYED_MNEMONIC_INDEX_KEY, mnemonicIndex);
            } else {
                this.putValue("Name", text);
            }
            iconOrNameSpecified = true;
        }
        if ((mnemonic = resourceMap.getKeyCode(baseName + ".Action.mnemonic")) != null) {
            this.putValue("MnemonicKey", mnemonic);
        }
        if ((index = resourceMap.getKeyCode(baseName + ".Action.displayedMnemonicIndex")) != null) {
            this.putValue(DISPLAYED_MNEMONIC_INDEX_KEY, index);
        }
        if ((key = resourceMap.getKeyStroke(baseName + ".Action.accelerator")) != null) {
            this.putValue("AcceleratorKey", key);
        }
        if ((icon = resourceMap.getIcon(baseName + ".Action.icon")) != null) {
            this.putValue("SmallIcon", icon);
            this.putValue(LARGE_ICON_KEY, icon);
            iconOrNameSpecified = true;
        }
        if ((smallIcon = resourceMap.getIcon(baseName + ".Action.smallIcon")) != null) {
            this.putValue("SmallIcon", smallIcon);
            iconOrNameSpecified = true;
        }
        if ((largeIcon = resourceMap.getIcon(baseName + ".Action.largeIcon")) != null) {
            this.putValue(LARGE_ICON_KEY, largeIcon);
            iconOrNameSpecified = true;
        }
        this.putValue("ShortDescription", resourceMap.getString(baseName + ".Action.shortDescription", new Object[0]));
        this.putValue("LongDescription", resourceMap.getString(baseName + ".Action.longDescription", new Object[0]));
        this.putValue("ActionCommandKey", resourceMap.getString(baseName + ".Action.command", new Object[0]));
        if (!iconOrNameSpecified) {
            this.putValue("Name", this.actionName);
        }
    }

    private String propertyMethodName(String prefix, String propertyName) {
        return prefix + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
    }

    private Method propertyGetMethod(String propertyName) {
        String[] getMethodNames = new String[]{this.propertyMethodName("is", propertyName), this.propertyMethodName("get", propertyName)};
        Class actionsClass = this.appAM.getActionsClass();
        for (String name : getMethodNames) {
            try {
                return actionsClass.getMethod(name, new Class[0]);
            }
            catch (NoSuchMethodException ignore) {
            }
        }
        return null;
    }

    private Method propertySetMethod(String propertyName, Class type) {
        Class actionsClass = this.appAM.getActionsClass();
        try {
            return actionsClass.getMethod(this.propertyMethodName("set", propertyName), type);
        }
        catch (NoSuchMethodException ignore) {
            return null;
        }
    }

    public String getName() {
        return this.actionName;
    }

    protected Object getActionArgument(Class pType, String pKey, ActionEvent actionEvent) {
        Object argument = null;
        if (pType == ActionEvent.class) {
            argument = actionEvent;
        } else if (pType == Action.class) {
            argument = this;
        } else if (pType == ActionMap.class) {
            argument = this.appAM;
        } else if (pType == ResourceMap.class) {
            argument = this.resourceMap;
        } else if (pType == ApplicationContext.class) {
            argument = ApplicationContext.getInstance();
        } else {
            IllegalArgumentException e = new IllegalArgumentException("unrecognized @Action method parameter");
            this.actionFailed(actionEvent, e);
        }
        return argument;
    }

    private JDialog getBlockingDialog(final Task task, ActionEvent event) {
        Window w;
        Component dialogOwner;
        String dialogTitle = (String)this.getValue("BlockingDialog.title");
        String message = (String)this.getValue("BlockingDialog.message");
        Icon icon = (Icon)this.getValue("BlockingDialog.icon");
        String cancelButtonText = UIManager.getString("OptionPane.cancelButtonText");
        JOptionPane optionPane = new JOptionPane(message, -1);
        if (task.getUserCanCancel()) {
            JButton cancelButton = new JButton(cancelButtonText);
            ActionListener doCancelTask = new ActionListener(){

                public void actionPerformed(ActionEvent ignore) {
                    task.cancel(true);
                }
            };
            cancelButton.addActionListener(doCancelTask);
            optionPane.setOptions(new Object[]{cancelButton});
        }
        if (icon != null) {
            optionPane.setIcon(icon);
        }
        if ((dialogOwner = (Component)event.getSource()) != null && (w = SwingUtilities.getWindowAncestor(dialogOwner)) != null) {
            dialogOwner = w;
        }
        JDialog dialog = optionPane.createDialog(dialogOwner, dialogTitle);
        dialog.setDefaultCloseOperation(0);
        return dialog;
    }

    private void noProxyActionPerformed(ActionEvent actionEvent) {
        Object taskObject = null;
        if (this.blocking) {
            return;
        }
        Annotation[][] allPAnnotations = this.actionMethod.getParameterAnnotations();
        Class<?>[] pTypes = this.actionMethod.getParameterTypes();
        Object[] arguments = new Object[pTypes.length];
        for (int i = 0; i < pTypes.length; ++i) {
            String pKey = null;
            for (Annotation pAnnotation : allPAnnotations[i]) {
                if (!(pAnnotation instanceof Action.Parameter)) continue;
                pKey = ((Action.Parameter)pAnnotation).value();
                break;
            }
            arguments[i] = this.getActionArgument(pTypes[i], pKey, actionEvent);
        }
        try {
            Object target = this.appAM.getActionsObject();
            taskObject = this.actionMethod.invoke(target, arguments);
        }
        catch (Exception e) {
            this.actionFailed(actionEvent, e);
        }
        if (taskObject instanceof Task) {
            Task task = (Task)((Object)taskObject);
            task.addPropertyChangeListener(new BlockPCL(task, actionEvent));
            ApplicationContext appContext = ApplicationContext.getInstance();
            appContext.getTaskService().execute(task);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Action proxy = this.getProxy();
        if (proxy != null) {
            actionEvent.setSource(this.getProxySource());
            proxy.actionPerformed(actionEvent);
        } else if (this.actionMethod != null) {
            this.noProxyActionPerformed(actionEvent);
        }
    }

    public boolean isEnabled() {
        if (this.getProxy() != null || this.isEnabledMethod == null) {
            return super.isEnabled();
        }
        try {
            Object b = this.isEnabledMethod.invoke(this.appAM.getActionsObject(), new Object[0]);
            return (Boolean)b;
        }
        catch (Exception e) {
            e.printStackTrace();
            return super.isEnabled();
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.getProxy() != null || this.setEnabledMethod == null) {
            super.setEnabled(enabled);
        } else {
            try {
                this.setEnabledMethod.invoke(this.appAM.getActionsObject(), enabled);
            }
            catch (Exception e) {
                e.printStackTrace();
                super.setEnabled(enabled);
            }
        }
    }

    void forwardPropertyChangeEvent(PropertyChangeEvent e, String actionPropertyName) {
        this.firePropertyChange(actionPropertyName, e.getOldValue(), e.getNewValue());
    }

    private void actionFailed(ActionEvent actionEvent, Exception e) {
        throw new Error(e);
    }

    public String toString() {
        Object nameValue;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append(" ");
        boolean enabled = this.isEnabled();
        if (!enabled) {
            sb.append("(");
        }
        sb.append(this.getName());
        Object selectedValue = this.getValue(SELECTED_KEY);
        if (selectedValue instanceof Boolean && ((Boolean)selectedValue).booleanValue()) {
            sb.append("+");
        }
        if (!enabled) {
            sb.append(")");
        }
        if ((nameValue = this.getValue("Name")) instanceof String) {
            sb.append("\"");
            sb.append((String)nameValue);
            sb.append("\"");
        }
        this.proxy = this.getProxy();
        if (this.proxy != null) {
            sb.append(" Proxy for: ");
            sb.append(this.proxy.toString());
        }
        return sb.toString();
    }

    private class BlockPCL
    implements PropertyChangeListener {
        private final Task task;
        private final ActionEvent event;
        private Component component = null;
        private JDialog dialog = null;

        BlockPCL(Task task, ActionEvent event) {
            this.task = task;
            this.event = event;
        }

        private void showDialog() {
            this.dialog = ApplicationAction.this.getBlockingDialog(this.task, this.event);
            this.dialog.setModal(true);
            this.dialog.pack();
            Runnable doShowDialog = new Runnable(){

                public void run() {
                    BlockPCL.this.dialog.setVisible(true);
                }
            };
            EventQueue.invokeLater(doShowDialog);
        }

        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if ("started".equals(propertyName)) {
                if (ApplicationAction.this.block != Action.Block.NONE) {
                    ApplicationAction.this.blocking = true;
                }
                switch (ApplicationAction.this.block) {
                    case ACTION: {
                        ApplicationAction.this.setEnabled(false);
                        break;
                    }
                    case COMPONENT: {
                        this.component = (Component)this.event.getSource();
                        if (this.component == null) break;
                        this.component.setEnabled(false);
                        break;
                    }
                    case WINDOW: 
                    case APPLICATION: {
                        this.showDialog();
                    }
                }
            } else if ("done".equals(propertyName)) {
                ApplicationAction.this.blocking = false;
                switch (ApplicationAction.this.block) {
                    case ACTION: {
                        ApplicationAction.this.setEnabled(true);
                        break;
                    }
                    case COMPONENT: {
                        if (this.component == null) break;
                        this.component.setEnabled(true);
                        break;
                    }
                    case WINDOW: 
                    case APPLICATION: {
                        if (this.dialog == null) break;
                        this.dialog.setVisible(false);
                    }
                }
            }
        }
    }

    private class ProxyPCL
    implements PropertyChangeListener {
        private ProxyPCL() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (propertyName == null || "enabled".equals(propertyName) || "ShortDescription".equals(propertyName) || "LongDescription".equals(propertyName)) {
                ApplicationAction.this.updateProxyProperties();
            }
        }
    }
}

