/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.Application;
import application.ApplicationContext;
import application.ResourceMap;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.RootPaneContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SingleFrameApplication
extends Application {
    private static final Logger logger = Logger.getLogger(SingleFrameApplication.class.getName());
    private ResourceMap appResources = null;
    private JFrame mainFrame = null;

    public final JFrame getMainFrame() {
        if (this.mainFrame == null) {
            ApplicationContext ac = ApplicationContext.getInstance();
            String title = ac.getResourceMap().getString("Application.title", new Object[0]);
            this.mainFrame = new JFrame(title);
            this.mainFrame.setName("mainFrame");
        }
        return this.mainFrame;
    }

    protected final void setMainFrame(JFrame mainFrame) {
        if (mainFrame == null) {
            throw new IllegalArgumentException("null JFrame");
        }
        if (this.mainFrame != null) {
            throw new IllegalStateException("mainFrame already set");
        }
        this.mainFrame = mainFrame;
        this.firePropertyChange("mainFrame", null, this.mainFrame);
    }

    private String sessionFilename(Window window) {
        if (window == null) {
            return null;
        }
        String name = window.getName();
        return name == null ? null : name + ".session.xml";
    }

    protected void configureWindow(Window root) {
        ApplicationContext ac = ApplicationContext.getInstance();
        ac.getResourceMap().injectComponents(root);
    }

    private void initRootPaneContainer(RootPaneContainer c) {
        String filename;
        Window window;
        String k;
        JRootPane rootPane = c.getRootPane();
        if (rootPane.getClientProperty(k = "SingleFrameApplication.initRootPaneContainer") != null) {
            return;
        }
        rootPane.putClientProperty(k, Boolean.TRUE);
        Container root = rootPane.getParent();
        if (root instanceof Window) {
            this.configureWindow((Window)root);
        }
        if (c == this.mainFrame) {
            this.mainFrame.addWindowListener(new MainFrameListener());
            this.mainFrame.setDefaultCloseOperation(0);
        } else if (root instanceof Window) {
            window = (Window)root;
            window.addHierarchyListener(new SecondaryWindowListener());
        }
        if (root instanceof Window && (root.getWidth() == 0 || root.getHeight() == 0)) {
            window = (Window)root;
            window.pack();
            if (!window.isLocationByPlatform()) {
                JFrame owner = c != this.mainFrame ? this.mainFrame : null;
                window.setLocationRelativeTo(owner);
            }
        }
        if (root instanceof Window && (filename = this.sessionFilename((Window)root)) != null) {
            try {
                ApplicationContext ac = ApplicationContext.getInstance();
                ac.getSessionStorage().restore(root, filename);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "couldn't restore sesssion", e);
            }
        }
    }

    protected void show(JComponent c) {
        if (c == null) {
            throw new IllegalArgumentException("null JComponent");
        }
        JFrame f = this.getMainFrame();
        f.getContentPane().add((Component)c, "Center");
        this.initRootPaneContainer(f);
        f.setVisible(true);
    }

    public void show(JDialog c) {
        if (c == null) {
            throw new IllegalArgumentException("null JDialog");
        }
        this.initRootPaneContainer(c);
        c.setVisible(true);
    }

    public void show(JFrame c) {
        if (c == null) {
            throw new IllegalArgumentException("null JFrame");
        }
        this.initRootPaneContainer(c);
        c.setVisible(true);
    }

    private void saveSession(Window window) {
        String filename = this.sessionFilename(window);
        if (filename != null) {
            ApplicationContext appContext = ApplicationContext.getInstance();
            try {
                appContext.getSessionStorage().save(window, filename);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "couldn't save sesssion", e);
            }
        }
    }

    private boolean isVisibleWindow(Window w) {
        return w.isVisible() && (w instanceof JFrame || w instanceof JDialog || w instanceof JWindow);
    }

    private List<Window> getVisibleSecondaryWindows() {
        ArrayList<Window> rv;
        block8: {
            block7: {
                rv = new ArrayList<Window>();
                Method getWindowsM = null;
                try {
                    getWindowsM = Window.class.getMethod("getWindows", new Class[0]);
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                if (getWindowsM == null) break block7;
                Window[] windows = null;
                try {
                    windows = (Window[])getWindowsM.invoke(null, new Object[0]);
                }
                catch (Exception e) {
                    throw new Error("HCTB - can't get top level windows list", e);
                }
                if (windows == null) break block8;
                for (Window window : windows) {
                    if (!this.isVisibleWindow(window)) continue;
                    rv.add(window);
                }
                break block8;
            }
            Frame[] frames = Frame.getFrames();
            if (frames != null) {
                for (Frame frame : frames) {
                    if (!this.isVisibleWindow(frame)) continue;
                    rv.add(frame);
                }
            }
        }
        return rv;
    }

    @Override
    protected void shutdown() {
        this.saveSession(this.mainFrame);
        for (Window window : this.getVisibleSecondaryWindows()) {
            this.saveSession(window);
        }
    }

    private class SecondaryWindowListener
    implements HierarchyListener {
        private SecondaryWindowListener() {
        }

        public void hierarchyChanged(HierarchyEvent e) {
            Window secondaryWindow;
            if ((e.getChangeFlags() & 4L) != 0L && e.getSource() instanceof Window && !(secondaryWindow = (Window)e.getSource()).isShowing()) {
                SingleFrameApplication.this.saveSession(secondaryWindow);
            }
        }
    }

    private class MainFrameListener
    extends WindowAdapter {
        private MainFrameListener() {
        }

        public void windowClosing(WindowEvent e) {
            SingleFrameApplication.this.exit(e);
        }
    }
}

