/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.AbstractBean;
import application.Task;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskService
extends AbstractBean {
    private final String name;
    private final ExecutorService executorService;
    private final List<Task> tasks;
    private final PropertyChangeListener taskPCL;

    public TaskService(String name, ExecutorService executorService) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        if (executorService == null) {
            throw new IllegalArgumentException("null executorService");
        }
        this.name = name;
        this.executorService = executorService;
        this.tasks = new ArrayList<Task>();
        this.taskPCL = new TaskPCL();
    }

    public TaskService(String name) {
        this(name, new ThreadPoolExecutor(3, 10, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>()));
    }

    public final String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Task> copyTasksList() {
        List<Task> list = this.tasks;
        synchronized (list) {
            if (this.tasks.isEmpty()) {
                return Collections.emptyList();
            }
            return new ArrayList<Task>(this.tasks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Task task) {
        List<Task> newTaskList;
        List<Task> oldTaskList;
        if (!task.isPending()) {
            throw new IllegalArgumentException("task has already been executed");
        }
        List<Task> list = this.tasks;
        synchronized (list) {
            oldTaskList = this.copyTasksList();
            this.tasks.add(task);
            newTaskList = this.copyTasksList();
            task.addPropertyChangeListener(this.taskPCL);
        }
        this.firePropertyChange("tasks", oldTaskList, newTaskList);
        this.executorService.execute((Runnable)((Object)task));
    }

    public List<Task> getTasks() {
        return this.copyTasksList();
    }

    public final void shutdown() {
        this.executorService.shutdown();
    }

    public final List<Runnable> shutdownNow() {
        return this.executorService.shutdownNow();
    }

    public final boolean isShutdown() {
        return this.executorService.isShutdown();
    }

    public final boolean isTerminated() {
        return this.executorService.isTerminated();
    }

    public final boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executorService.awaitTermination(timeout, unit);
    }

    private class TaskPCL
    implements PropertyChangeListener {
        private TaskPCL() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent e) {
            Task task;
            String propertyName = e.getPropertyName();
            if ("done".equals(propertyName) && (task = (Task)((Object)e.getSource())).isDone()) {
                List newTaskList;
                List oldTaskList;
                List list = TaskService.this.tasks;
                synchronized (list) {
                    oldTaskList = TaskService.this.copyTasksList();
                    TaskService.this.tasks.remove((Object)task);
                    task.removePropertyChangeListener(TaskService.this.taskPCL);
                    newTaskList = TaskService.this.copyTasksList();
                }
                TaskService.this.firePropertyChange("tasks", oldTaskList, newTaskList);
            }
        }
    }
}

