/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model;

import charactermanaj.util.BeanPropertiesUtilities;
import charactermanaj.util.ConfigurationDirUtilities;
import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AppConfig {
    private static final String CONFIG_NAME = "appConfig.xml";
    public static final String APP_VERSION = "1.0";
    public static final String COMMON_CHARACTER_DIR_PROPERTY_NAME = "character.dir";
    private static final Logger logger = Logger.getLogger(AppConfig.class.getName());
    private static final AppConfig singleton = new AppConfig();
    private String commonCharacterDataDir = "";
    private String defaultProfileId = "default";
    private Color sampleImageBgColor = Color.white;
    private Color defaultImageBgColor = Color.white;
    private Color checkedItemBgColor = Color.cyan.brighter();
    private Color selectedItemBgColor = Color.orange;
    private Color invalidBgColor = Color.red.brighter().brighter();
    private float compressionQuality = 0.8f;
    private Color exportPresetWarningsForegroundColor = Color.red;
    private int jarTransferBufferSize = 4096;
    private String zipNameEncoding = "csWindows31J";
    private Color disabledCellForegroundColor = Color.gray;
    private int dirWatchInterval = 7000;
    private boolean enableDirWatch = true;
    private int fileTransferBufferSize = 4096;
    private long previewIndeicatorDelay = 300L;
    private boolean informationDialogOpenMethod = true;
    private boolean noRemoveLog = false;
    private Color gridColor = Color.gray;
    private boolean enableAutoColorChange = true;
    Color authorEditConflictBgColor = Color.yellow;
    private int mainFrameMaxWidth = 800;
    private int mainFrameMaxHeight = 600;
    private boolean notDisableLayerTab;

    public static AppConfig getInstance() {
        return singleton;
    }

    private AppConfig() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadConfig() {
        Properties config = new Properties();
        try {
            URL[] urls;
            File codeBase = ConfigurationDirUtilities.getApplicationBaseDir();
            File userDataDir = ConfigurationDirUtilities.getUserDataDir();
            for (URL url : urls = new URL[]{this.getClass().getResource("/appConfig.xml"), new File(codeBase, CONFIG_NAME).getCanonicalFile().toURL(), new File(userDataDir, CONFIG_NAME).toURL()}) {
                File file;
                if (url == null) continue;
                if (url.getProtocol().equals("file") && !(file = new File(url.getPath())).exists()) {
                    logger.log(Level.INFO, "appConfig.xml is not found.:" + file);
                    continue;
                }
                try {
                    InputStream is = url.openStream();
                    try {
                        config.loadFromXML(is);
                        logger.log(Level.INFO, "appConfig.xml is loaded.:" + url);
                    }
                    finally {
                        is.close();
                    }
                }
                catch (FileNotFoundException ex) {
                    logger.log(Level.INFO, "appConfig.xml is not found.: " + url, ex);
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, "appConfig.xml loading failed.: " + url, ex);
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("appConfig.xml loading failed.", ex);
        }
        BeanPropertiesUtilities.loadFromProperties(this, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveConfig() throws IOException {
        Properties config = this.getProperties();
        File userDataDir = ConfigurationDirUtilities.getUserDataDir();
        File configStore = new File(userDataDir, CONFIG_NAME);
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(configStore));
        try {
            config.storeToXML((OutputStream)os, CONFIG_NAME, "UTF-8");
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    public static Set<String> checkProperties(Properties props) {
        if (props == null) {
            throw new IllegalArgumentException();
        }
        AppConfig dummy = new AppConfig();
        return BeanPropertiesUtilities.loadFromProperties(dummy, props);
    }

    public Set<String> update(Properties props) {
        if (props == null) {
            throw new IllegalArgumentException();
        }
        return BeanPropertiesUtilities.loadFromProperties(this, props);
    }

    public Properties getProperties() {
        Properties config = new Properties();
        BeanPropertiesUtilities.saveToProperties(this, config);
        return config;
    }

    public File getSystemCharactersDir() {
        File applicationBaseDir = ConfigurationDirUtilities.getApplicationBaseDir();
        File[] candidates = new File[]{this.getAbsoluteFile(applicationBaseDir, this.getCommonCharacterDataDir()), this.getAbsoluteFile(applicationBaseDir, System.getProperty(COMMON_CHARACTER_DIR_PROPERTY_NAME)), this.getAbsoluteFile(applicationBaseDir, "characters")};
        File systemCharacterDir = null;
        for (File dir : candidates) {
            if (dir == null || !dir.exists() || !dir.isDirectory()) continue;
            systemCharacterDir = dir;
            break;
        }
        return systemCharacterDir;
    }

    protected File getAbsoluteFile(File baseDir, String file) {
        if (baseDir == null) {
            throw new IllegalArgumentException();
        }
        if (file == null || file.trim().length() == 0) {
            return null;
        }
        File result = new File(file);
        if (!result.isAbsolute()) {
            try {
                result = new File(baseDir, file.trim()).getCanonicalFile();
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "invalid dir: base=" + baseDir + "/file=" + file, ex);
                return null;
            }
        }
        return result;
    }

    public File getUserCharactersDir() {
        File characterBaseDir = new File(ConfigurationDirUtilities.getUserDataDir(), "characters");
        if (!characterBaseDir.exists() && !characterBaseDir.mkdirs()) {
            logger.log(Level.WARNING, "can't create the charatcer base directory. " + characterBaseDir);
        }
        return characterBaseDir;
    }

    public String getCommonCharacterDataDir() {
        return this.commonCharacterDataDir;
    }

    public void setCommonCharacterDataDir(String commonCharacterDataDir) {
        if (commonCharacterDataDir == null) {
            commonCharacterDataDir = "";
        }
        this.commonCharacterDataDir = commonCharacterDataDir;
    }

    public String getDefaultProfileId() {
        return this.defaultProfileId;
    }

    public void setDefaultProfileId(String defaultProfileId) {
        if (defaultProfileId == null || defaultProfileId.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        this.defaultProfileId = defaultProfileId.trim();
    }

    public Color getSampleImageBgColor() {
        return this.sampleImageBgColor;
    }

    public void setSampleImageBgColor(Color sampleImageBgColor) {
        if (sampleImageBgColor == null) {
            throw new IllegalArgumentException();
        }
        this.sampleImageBgColor = sampleImageBgColor;
    }

    public Color getDefaultImageBgColor() {
        return this.defaultImageBgColor;
    }

    public void setDefaultImageBgColor(Color defaultImageBgColor) {
        if (defaultImageBgColor == null) {
            throw new IllegalArgumentException();
        }
        this.defaultImageBgColor = defaultImageBgColor;
    }

    public Color getCheckedItemBgColor() {
        return this.checkedItemBgColor;
    }

    public void setCheckedItemBgColor(Color checkedItemBgColor) {
        if (checkedItemBgColor == null) {
            throw new IllegalArgumentException();
        }
        this.checkedItemBgColor = checkedItemBgColor;
    }

    public Color getSelectedItemBgColor() {
        return this.selectedItemBgColor;
    }

    public void setSelectedItemBgColor(Color selectedItemBgColor) {
        this.selectedItemBgColor = selectedItemBgColor;
    }

    public Color getInvalidBgColor() {
        return this.invalidBgColor;
    }

    public void setInvalidBgColor(Color invalidBgColor) {
        if (invalidBgColor == null) {
            throw new IllegalArgumentException();
        }
        this.invalidBgColor = invalidBgColor;
    }

    public float getCompressionQuality() {
        return this.compressionQuality;
    }

    public void setCompressionQuality(float compressionQuality) {
        if (compressionQuality < 0.1f || compressionQuality > 1.0f) {
            throw new IllegalArgumentException();
        }
        this.compressionQuality = compressionQuality;
    }

    public Color getExportPresetWarningsForegroundColor() {
        return this.exportPresetWarningsForegroundColor;
    }

    public void setExportPresetWarningsForegroundColor(Color exportPresetWarningsForegroundColor) {
        this.exportPresetWarningsForegroundColor = exportPresetWarningsForegroundColor;
    }

    public int getJarTransferBufferSize() {
        return this.jarTransferBufferSize;
    }

    public void setJarTransferBufferSize(int jarTransferBufferSize) {
        if (jarTransferBufferSize <= 0) {
            throw new IllegalArgumentException();
        }
        this.jarTransferBufferSize = jarTransferBufferSize;
    }

    public String getZipNameEncoding() {
        return this.zipNameEncoding;
    }

    public void setZipNameEncoding(String zipNameEncoding) {
        if (zipNameEncoding == null) {
            throw new IllegalArgumentException();
        }
        try {
            Charset.forName(zipNameEncoding);
        }
        catch (Exception ex) {
            throw new RuntimeException("unsupported charset: " + zipNameEncoding);
        }
        this.zipNameEncoding = zipNameEncoding;
    }

    public Color getDisabledCellForgroundColor() {
        return this.disabledCellForegroundColor;
    }

    public void setDisabledCellForegroundColor(Color disabledCellForegroundColor) {
        if (disabledCellForegroundColor == null) {
            throw new IllegalArgumentException();
        }
        this.disabledCellForegroundColor = disabledCellForegroundColor;
    }

    public int getDirWatchInterval() {
        return this.dirWatchInterval;
    }

    public void setDirWatchInterval(int dirWatchInterval) {
        if (dirWatchInterval <= 0) {
            throw new IllegalArgumentException();
        }
        this.dirWatchInterval = dirWatchInterval;
    }

    public boolean isEnableDirWatch() {
        return this.enableDirWatch;
    }

    public void setEnableDirWatch(boolean enableDirWatch) {
        this.enableDirWatch = enableDirWatch;
    }

    public int getFileTransferBufferSize() {
        return this.fileTransferBufferSize;
    }

    public void setFileTransferBufferSize(int fileTransferBufferSize) {
        if (fileTransferBufferSize <= 0) {
            throw new IllegalArgumentException();
        }
        this.fileTransferBufferSize = fileTransferBufferSize;
    }

    public long getPreviewIndicatorDelay() {
        return this.previewIndeicatorDelay;
    }

    public void setPreviewIndeicatorDelay(long previewIndeicatorDelay) {
        if (previewIndeicatorDelay < 0L) {
            throw new IllegalArgumentException();
        }
        this.previewIndeicatorDelay = previewIndeicatorDelay;
    }

    public boolean isInformationDialogOpenMethod() {
        return this.informationDialogOpenMethod;
    }

    public void setInformationDialogOpenMethod(boolean informationDialogOpenMethod) {
        this.informationDialogOpenMethod = informationDialogOpenMethod;
    }

    public boolean isNoRemoveLog() {
        return this.noRemoveLog;
    }

    public void setNoRemoveLog(boolean noRemoveLog) {
        this.noRemoveLog = noRemoveLog;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setGridColor(Color gridColor) {
        if (gridColor == null) {
            throw new IllegalArgumentException();
        }
        this.gridColor = gridColor;
    }

    public boolean isEnableAutoColorChange() {
        return this.enableAutoColorChange;
    }

    public void setEnableAutoColorChange(boolean enableAutoColorChange) {
        this.enableAutoColorChange = enableAutoColorChange;
    }

    public void setAuthorEditConflictBgColor(Color authorEditConflictBgColor) {
        if (authorEditConflictBgColor == null) {
            throw new IllegalArgumentException();
        }
        this.authorEditConflictBgColor = authorEditConflictBgColor;
    }

    public Color getAuthorEditConflictBgColor() {
        return this.authorEditConflictBgColor;
    }

    public void setMainFrameMaxWidth(int width) {
        this.mainFrameMaxWidth = width;
    }

    public int getMainFrameMaxWidth() {
        return this.mainFrameMaxWidth;
    }

    public void setMainFrameMaxHeight(int height) {
        this.mainFrameMaxHeight = height;
    }

    public int getMainFrameMaxHeight() {
        return this.mainFrameMaxHeight;
    }

    public boolean isNotDisableLayerTab() {
        return this.notDisableLayerTab;
    }

    public void setNotDisableLayerTab(boolean notDisableLayerTab) {
        this.notDisableLayerTab = notDisableLayerTab;
    }
}

