/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.Main;
import charactermanaj.clipboardSupport.ClipboardUtil;
import charactermanaj.graphics.AsyncImageBuilder;
import charactermanaj.graphics.ColorConvertedImageCachedLoader;
import charactermanaj.graphics.ImageBuildJobAbstractAdaptor;
import charactermanaj.graphics.ImageBuilder;
import charactermanaj.graphics.io.ImageSaveHelper;
import charactermanaj.model.AppConfig;
import charactermanaj.model.CharacterData;
import charactermanaj.model.ColorGroup;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsColorInfo;
import charactermanaj.model.PartsColorManager;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSet;
import charactermanaj.model.WorkingSet;
import charactermanaj.model.io.CharacterDataPersistent;
import charactermanaj.model.io.PartsImageDirectoryWatchAgent;
import charactermanaj.model.io.PartsImageDirectoryWatchEvent;
import charactermanaj.model.io.PartsImageDirectoryWatchListener;
import charactermanaj.model.io.RecentDataPersistent;
import charactermanaj.ui.AboutBox;
import charactermanaj.ui.AppConfigDialog;
import charactermanaj.ui.ColorDialog;
import charactermanaj.ui.ExportWizardDialog;
import charactermanaj.ui.ImageSelectPanel;
import charactermanaj.ui.ImageSelectPanelList;
import charactermanaj.ui.ImportWizardDialog;
import charactermanaj.ui.InformationDialog;
import charactermanaj.ui.ManageFavoriteDialog;
import charactermanaj.ui.MenuData;
import charactermanaj.ui.MenuDataFactory;
import charactermanaj.ui.PartsManageDialog;
import charactermanaj.ui.PreviewPanel;
import charactermanaj.ui.ProfileSelectorDialog;
import charactermanaj.ui.SearchPartsDialog;
import charactermanaj.ui.model.ColorChangeEvent;
import charactermanaj.ui.model.ColorChangeListener;
import charactermanaj.ui.model.ColorGroupCoordinator;
import charactermanaj.ui.model.PartsColorCoordinator;
import charactermanaj.ui.model.PartsSelectionManager;
import charactermanaj.util.DesktopUtilities;
import charactermanaj.util.ErrorMessageHelper;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import charactermanaj.util.SystemUtil;
import charactermanaj.util.UIHelper;
import charactermanaj.util.UserData;
import charactermanaj.util.UserDataFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TooManyListenersException;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class MainFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(MainFrame.class.getName());
    protected static final String STRINGS_RESOURCE = "strings/mainframe";
    protected static final String MENU_STRINGS_RESOURCE = "menu/menu";
    protected BufferedImage icon;
    private static volatile MainFrame activedMainFrame;
    protected CharacterData characterData;
    private PreviewPanel previewPane;
    protected PartsSelectionManager partsSelectionManager;
    protected ImageSelectPanelList imageSelectPanels;
    protected ColorGroupCoordinator colorGroupCoordinator;
    protected PartsColorCoordinator partsColorCoordinator;
    private ColorConvertedImageCachedLoader imageLoader;
    private AsyncImageBuilder imageBuilder;
    private ImageSaveHelper imageSaveHelper = new ImageSaveHelper();
    private PartsImageDirectoryWatchAgent watchAgent;
    private String defaultPartsSetTitle;
    private PartsSet lastUsePresetParts;
    private static final HashMap<String, Integer> activeCharacterDatas;

    public static void setActivedMainFrame(MainFrame mainFrame) {
        if (mainFrame == null) {
            throw new IllegalArgumentException();
        }
        activedMainFrame = mainFrame;
    }

    public static MainFrame getActivedMainFrame() {
        return activedMainFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isUsingCharacterData(CharacterData characterData) {
        if (characterData == null) {
            return false;
        }
        URL characterDocBase = characterData.getDocBase();
        if (characterDocBase == null) {
            return false;
        }
        HashMap<String, Integer> hashMap = activeCharacterDatas;
        synchronized (hashMap) {
            Integer cnt = activeCharacterDatas.get(characterDocBase.toString());
            if (cnt != null && cnt > 0) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyChangeCharacterData(CharacterData cd, CharacterData newCd) {
        if (cd == null || newCd == null) {
            throw new IllegalArgumentException();
        }
        if (!newCd.isValid()) {
            return;
        }
        for (Frame frame : JFrame.getFrames()) {
            if (!frame.isDisplayable() || !(frame instanceof MainFrame)) continue;
            MainFrame mainFrame = (MainFrame)frame;
            if (!cd.getDocBase().equals(mainFrame.characterData.getDocBase())) continue;
            mainFrame.setCursor(Cursor.getPredefinedCursor(3));
            try {
                mainFrame.saveWorkingSet();
                mainFrame.initComponent(newCd);
            }
            finally {
                mainFrame.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyChangeFavorites(CharacterData cd) {
        if (cd == null) {
            throw new IllegalArgumentException();
        }
        for (Frame frame : JFrame.getFrames()) {
            if (!frame.isDisplayable() || !(frame instanceof MainFrame)) continue;
            MainFrame mainFrame = (MainFrame)frame;
            if (!cd.getDocBase().equals(mainFrame.characterData.getDocBase())) continue;
            mainFrame.setCursor(Cursor.getPredefinedCursor(3));
            try {
                mainFrame.refreshFavorites();
            }
            finally {
                mainFrame.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void registerUsedCharacterData(CharacterData characterData) {
        if (characterData == null) {
            return;
        }
        HashMap<String, Integer> hashMap = activeCharacterDatas;
        synchronized (hashMap) {
            URL characterDocBase = characterData.getDocBase();
            if (characterDocBase != null) {
                Integer cnt = activeCharacterDatas.get(characterDocBase.toString());
                if (cnt == null) {
                    cnt = 0;
                }
                cnt = cnt + 1;
                activeCharacterDatas.put(characterDocBase.toString(), cnt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void unregisterUsedCharacterData(CharacterData characterData) {
        if (characterData == null) {
            return;
        }
        HashMap<String, Integer> hashMap = activeCharacterDatas;
        synchronized (hashMap) {
            URL characterDocBase = characterData.getDocBase();
            if (characterDocBase != null) {
                int cnt = activeCharacterDatas.get(characterDocBase.toString());
                activeCharacterDatas.put(characterDocBase.toString(), --cnt);
            }
        }
    }

    public MainFrame(CharacterData characterData) {
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MainFrame.this.onCloseProfile();
            }

            public void windowClosed(WindowEvent e) {
                MainFrame.this.imageBuilder.stop();
                MainFrame.this.watchAgent.stop();
            }

            public void windowActivated(WindowEvent e) {
                MainFrame.setActivedMainFrame(MainFrame.this);
            }

            public void windowOpened(WindowEvent e) {
            }
        });
        this.icon = UIHelper.getInstance().getImage("icons/icon.png");
        this.setIconImage(this.icon);
        this.initComponent(characterData);
        JMenuBar menuBar = this.createMenuBar();
        this.setJMenuBar(menuBar);
        Dimension imageSize = characterData.getImageSize();
        AppConfig appConfig = AppConfig.getInstance();
        int maxWidth = appConfig.getMainFrameMaxWidth();
        int maxHeight = appConfig.getMainFrameMaxHeight();
        int imageWidth = Math.min(maxWidth, Math.max(300, imageSize != null ? imageSize.width : 0));
        int imageHeight = Math.min(maxHeight, Math.max(400, imageSize != null ? imageSize.height : 0));
        this.setSize(imageWidth - 300 + 600, imageHeight - 400 + 550);
        this.setLocationByPlatform(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initComponent(CharacterData characterData) {
        CharacterData oldCd;
        MainFrame mainFrame = this;
        synchronized (mainFrame) {
            oldCd = this.characterData;
            if (oldCd != null) {
                MainFrame.unregisterUsedCharacterData(oldCd);
            }
            this.characterData = characterData;
            MainFrame.registerUsedCharacterData(characterData);
        }
        AppConfig appConfig = AppConfig.getInstance();
        Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
        String title = Main.isMacOSX() ? "" : strings.getProperty("title");
        this.setTitle(title + characterData.getName());
        this.defaultPartsSetTitle = strings.getProperty("defaultPartsSetTitle");
        if (this.watchAgent != null) {
            this.watchAgent.stop();
        }
        if (this.imageBuilder != null) {
            this.imageBuilder.stop();
        }
        Container contentPane = this.getContentPane();
        for (Component comp : contentPane.getComponents()) {
            contentPane.remove(comp);
        }
        this.closeAllSearchDialog();
        PartsColorManager partsColorManager = characterData.getPartsColorManager();
        this.imageLoader = new ColorConvertedImageCachedLoader();
        this.imageBuilder = new AsyncImageBuilder(this.imageLoader);
        this.partsSelectionManager = new PartsSelectionManager(partsColorManager);
        this.colorGroupCoordinator = new ColorGroupCoordinator(this.partsSelectionManager, partsColorManager);
        this.partsColorCoordinator = new PartsColorCoordinator(characterData, partsColorManager, this.colorGroupCoordinator);
        this.watchAgent = new PartsImageDirectoryWatchAgent(characterData);
        this.previewPane = new PreviewPanel();
        this.previewPane.setTitle(this.defaultPartsSetTitle);
        this.previewPane.addPreviewPanelListener(new PreviewPanel.PreviewPanelListener(){

            public void addFavorite(PreviewPanel.PreviewPanelEvent e) {
                MainFrame.this.onRegisterFavorite();
            }

            public void changeBackgroundColor(PreviewPanel.PreviewPanelEvent e) {
                MainFrame.this.onChangeBgColor();
            }

            public void copyPicture(PreviewPanel.PreviewPanelEvent e) {
                MainFrame.this.onCopy();
            }

            public void savePicture(PreviewPanel.PreviewPanelEvent e) {
                MainFrame.this.onSavePicture();
            }

            public void showInformation(PreviewPanel.PreviewPanelEvent e) {
                MainFrame.this.onInformation();
            }

            public void flipHorizontal(PreviewPanel.PreviewPanelEvent e) {
                MainFrame.this.onFlipHolizontal();
            }
        });
        this.imageSelectPanels = new ImageSelectPanelList();
        JPanel imgSelectPanelsPanel = new JPanel();
        BoxLayout bl = new BoxLayout(imgSelectPanelsPanel, 3);
        imgSelectPanelsPanel.setLayout(bl);
        for (PartsCategory category : characterData.getPartsCategories()) {
            ImageSelectPanel imageSelectPanel = new ImageSelectPanel(category, characterData);
            imgSelectPanelsPanel.add(imageSelectPanel);
            this.imageSelectPanels.add(imageSelectPanel);
            this.partsSelectionManager.register(imageSelectPanel);
        }
        JScrollPane imgSelectPanelsPanelSp = new JScrollPane(imgSelectPanelsPanel){
            private static final long serialVersionUID = 1L;

            public JScrollBar createVerticalScrollBar() {
                JScrollBar sb = super.createVerticalScrollBar();
                sb.setUnitIncrement(12);
                return sb;
            }
        };
        imgSelectPanelsPanelSp.setVerticalScrollBarPolicy(22);
        JSplitPane splitPane = new JSplitPane(1, true, imgSelectPanelsPanelSp, this.previewPane);
        contentPane.add((Component)splitPane, "Center");
        imgSelectPanelsPanelSp.requestFocus();
        ArrayList<ColorGroup> colorGroups = new ArrayList<ColorGroup>();
        colorGroups.addAll(characterData.getColorGroups());
        ColorChangeListener colorChangeListener = new ColorChangeListener(){

            public void onColorGroupChange(ColorChangeEvent event) {
            }

            public void onColorChange(ColorChangeEvent event) {
                MainFrame.this.requestPreview();
            }
        };
        this.colorGroupCoordinator.addColorChangeListener(colorChangeListener);
        int idx = 0;
        while (idx < this.imageSelectPanels.size()) {
            ImageSelectPanel imageSelectPanel = this.imageSelectPanels.get(idx);
            PartsCategory partsCategory = imageSelectPanel.getPartsCategory();
            final ColorDialog colorDialog = new ColorDialog(this, partsCategory, colorGroups);
            this.colorGroupCoordinator.registerColorDialog(colorDialog);
            this.partsColorCoordinator.register(imageSelectPanel, colorDialog);
            final int curidx = idx++;
            imageSelectPanel.addImageSelectListener(new ImageSelectPanel.ImageSelectPanelListener(){

                public void onChangeColor(ImageSelectPanel.ImageSelectPanelEvent event) {
                    colorDialog.adjustLocation(curidx);
                    colorDialog.setVisible(!colorDialog.isVisible());
                }

                public void onPreferences(ImageSelectPanel.ImageSelectPanelEvent event) {
                }

                public void onChange(ImageSelectPanel.ImageSelectPanelEvent event) {
                    MainFrame.this.requestPreview();
                }

                public void onSelectChange(ImageSelectPanel.ImageSelectPanelEvent event) {
                }
            });
            imageSelectPanel.addAncestorListener(new AncestorListener(){

                public void ancestorAdded(AncestorEvent event) {
                }

                public void ancestorMoved(AncestorEvent event) {
                }

                public void ancestorRemoved(AncestorEvent event) {
                    colorDialog.setVisible(false);
                }
            });
        }
        this.partsSelectionManager.loadParts();
        if (!this.loadWorkingSet()) {
            String defaultPresetId = characterData.getDefaultPartsSetId();
            PartsSet presetParts = null;
            if (defaultPresetId != null) {
                presetParts = characterData.getPartsSets().get(defaultPresetId);
            }
            if (presetParts == null) {
                this.partsColorCoordinator.initColorDialog();
                this.requestPreview();
            } else {
                this.selectPresetParts(presetParts);
            }
        }
        this.scrollToSelectedParts();
        if (!this.imageBuilder.isAlive()) {
            this.imageBuilder.start();
        }
        DropTarget dt = new DropTarget();
        try {
            dt.addDropTargetListener(new DropTargetAdapter(){

                public void drop(DropTargetDropEvent dtde) {
                    MainFrame.this.onDrop(dtde);
                }
            });
        }
        catch (TooManyListenersException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        imgSelectPanelsPanelSp.setDropTarget(dt);
        this.watchAgent.addPartsImageDirectoryWatchListener(new PartsImageDirectoryWatchListener(){

            public void detectPartsImageChange(PartsImageDirectoryWatchEvent e) {
                Runnable refreshJob = new Runnable(){

                    public void run() {
                        MainFrame.this.onDetectPartsImageChange();
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    refreshJob.run();
                } else {
                    SwingUtilities.invokeLater(refreshJob);
                }
            }
        });
        if (appConfig.isEnableDirWatch() && characterData.isWatchDirectory()) {
            this.watchAgent.start();
        }
        if (oldCd != null) {
            this.validate();
        }
    }

    protected void onDetectPartsImageChange() {
        if (this.characterData.reloadPartsData()) {
            this.partsSelectionManager.loadParts();
            this.requestPreview();
        }
    }

    protected void scrollToSelectedParts() {
        this.partsSelectionManager.scrollToSelectedParts();
    }

    protected void selectPresetParts(PartsSet presetParts) {
        this.lastUsePresetParts = presetParts;
        this.partsSelectionManager.selectPartsSet(presetParts);
        this.partsColorCoordinator.initColorDialog();
        this.requestPreview();
    }

    protected void onSelectedFavoriteMenu(JMenu menu) {
        int mx = menu.getMenuComponentCount();
        int separatorIdx = -1;
        for (int idx = 0; idx < mx; ++idx) {
            Component item = menu.getMenuComponent(idx);
            if (!(item instanceof JSeparator)) continue;
            separatorIdx = idx;
            break;
        }
        if (separatorIdx > 0) {
            while (menu.getMenuComponentCount() > separatorIdx + 1) {
                menu.remove(separatorIdx + 1);
            }
        }
        ArrayList<PartsSet> partssets = new ArrayList<PartsSet>();
        partssets.addAll(this.characterData.getPartsSets().values());
        Collections.sort(partssets, new Comparator<PartsSet>(){

            @Override
            public int compare(PartsSet o1, PartsSet o2) {
                int ret = o1.getLocalizedName().compareTo(o2.getLocalizedName());
                if (ret == 0) {
                    ret = o1.getPartsSetId().compareTo(o2.getPartsSetId());
                }
                if (ret == 0) {
                    ret = o1.hashCode() - o2.hashCode();
                }
                return ret;
            }
        });
        final boolean needAntiAlias = this.isNeedAntialias();
        for (final PartsSet presetParts : partssets) {
            JMenuItem favoriteMenu = new JMenuItem(){
                private static final long serialVersionUID = 1L;

                public void paint(Graphics g) {
                    if (needAntiAlias) {
                        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    }
                    super.paint(g);
                }
            };
            favoriteMenu.setName(presetParts.getPartsSetId());
            favoriteMenu.setText(presetParts.getLocalizedName());
            if (presetParts.isPresetParts()) {
                Font font = favoriteMenu.getFont();
                favoriteMenu.setFont(font.deriveFont(1));
            }
            favoriteMenu.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.selectPresetParts(presetParts);
                }
            });
            menu.add(favoriteMenu);
        }
    }

    protected void showPresetName(PartsSet requestPartsSet) {
        this.previewPane.setTitle(this.getSuggestPartsSetName(requestPartsSet, true, this.defaultPartsSetTitle));
    }

    private String getSuggestPartsSetName(PartsSet requestPartsSet, boolean markColorChange, String defaultPartsSetName) {
        String partsSetTitle = null;
        if (this.lastUsePresetParts != null && PartsSet.isSameStructure(requestPartsSet, this.lastUsePresetParts)) {
            partsSetTitle = this.lastUsePresetParts.getLocalizedName();
            if (markColorChange && !PartsSet.isSameColor(requestPartsSet, this.lastUsePresetParts) && partsSetTitle != null) {
                partsSetTitle = partsSetTitle + "*";
            }
        }
        if (partsSetTitle != null && partsSetTitle.trim().length() > 0) {
            return partsSetTitle;
        }
        return defaultPartsSetName;
    }

    protected void requestPreview() {
        if (!this.characterData.isValid()) {
            return;
        }
        this.imageBuilder.requestJob(new ImageBuildJobAbstractAdaptor(this.characterData){
            private PartsSet requestPartsSet;
            private long ticket;

            public void onQueueing(long ticket) {
                this.ticket = ticket;
                MainFrame.this.previewPane.setLoadingRequest(ticket);
            }

            public void buildImage(ImageBuilder.ImageOutput output) {
                final BufferedImage img = output.getImageOutput();
                final Color bgColor = output.getImageBgColor();
                Runnable refreshJob = new Runnable(){

                    public void run() {
                        MainFrame.this.previewPane.setImageBgColor(bgColor);
                        MainFrame.this.previewPane.setPreviewImage(img);
                        MainFrame.this.previewPane.setLoadingComplete(ticket);
                        MainFrame.this.showPresetName(requestPartsSet);
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    refreshJob.run();
                } else {
                    try {
                        SwingUtilities.invokeAndWait(refreshJob);
                    }
                    catch (Exception ex) {
                        logger.log(Level.WARNING, "build image failed.", ex);
                    }
                }
            }

            public void handleException(final Throwable ex) {
                Runnable showExceptionJob = new Runnable(){

                    public void run() {
                        ErrorMessageHelper.showErrorDialog(MainFrame.this, ex);
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    showExceptionJob.run();
                } else {
                    SwingUtilities.invokeLater(showExceptionJob);
                }
            }

            protected PartsSet getPartsSet() {
                final PartsSet[] result = new PartsSet[1];
                Runnable collectPartsSetJob = new Runnable(){

                    public void run() {
                        PartsSet partsSet;
                        result[0] = partsSet = MainFrame.this.partsSelectionManager.createPartsSet();
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    collectPartsSetJob.run();
                } else {
                    try {
                        SwingUtilities.invokeAndWait(collectPartsSetJob);
                    }
                    catch (InvocationTargetException e) {
                        throw new RuntimeException(e.getMessage(), e);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException("interrupted:" + e, e);
                    }
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "preview: " + result[0]);
                }
                this.requestPartsSet = result[0];
                return this.requestPartsSet;
            }
        });
    }

    protected void onOpenProfile() {
        try {
            MainFrame main2 = ProfileSelectorDialog.openProfile(this);
            if (main2 != null) {
                Point pt = this.getLocation();
                pt.x += 100;
                main2.setLocation(pt);
                main2.setVisible(true);
            }
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onChangeBgColor() {
        this.getJMenuBar().setEnabled(false);
        try {
            Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
            Color color = this.partsSelectionManager.getImageBgColor();
            color = JColorChooser.showDialog(this, strings.getProperty("chooseBgColor"), color);
            if (color != null) {
                this.partsSelectionManager.setImageBgColor(color);
                this.requestPreview();
            }
        }
        finally {
            this.getJMenuBar().setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onSavePicture() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        BufferedImage img = this.previewPane.getPreviewImage();
        Color imgBgColor = this.partsSelectionManager.getImageBgColor();
        if (img == null) {
            tk.beep();
            return;
        }
        try {
            File outFile = this.imageSaveHelper.showSaveFileDialog(this);
            if (outFile == null) {
                return;
            }
            StringBuilder warnings = new StringBuilder();
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.imageSaveHelper.savePicture(img, imgBgColor, outFile, warnings);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
            if (warnings.length() > 0) {
                JOptionPane.showMessageDialog(this, warnings.toString(), "WARNINGS", 2);
            }
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected void onManageParts() {
        if (!this.characterData.isValid()) {
            return;
        }
        PartsManageDialog mrgDlg = new PartsManageDialog(this, this.characterData);
        mrgDlg.setVisible(true);
        if (mrgDlg.isUpdated() && this.characterData.reloadPartsData()) {
            this.partsSelectionManager.loadParts();
            this.requestPreview();
        }
    }

    protected void onSearch() {
        if (!this.characterData.isValid()) {
            return;
        }
        SearchPartsDialog searchPartsDlg = new SearchPartsDialog(this, this.characterData, this.partsSelectionManager);
        searchPartsDlg.setVisible(true);
    }

    protected void closeAllSearchDialog() {
        for (SearchPartsDialog dlg : SearchPartsDialog.getDialogs()) {
            if (dlg == null || !dlg.isDisplayable() || dlg.getParent() != this) continue;
            dlg.dispose();
        }
    }

    protected void onCopy() {
        try {
            BufferedImage img = this.previewPane.getPreviewImage();
            Color imgBgColor = this.partsSelectionManager.getImageBgColor();
            if (img == null) {
                Toolkit tk = Toolkit.getDefaultToolkit();
                tk.beep();
                return;
            }
            ClipboardUtil.setImage(img, imgBgColor);
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected void onPreferences() {
        AppConfigDialog appConfigDlg = new AppConfigDialog(this);
        appConfigDlg.setVisible(true);
    }

    protected void onDrop(DropTargetDropEvent dtde) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        if (this.characterData == null || !this.characterData.isValid()) {
            tk.beep();
            return;
        }
        try {
            File dropFile = null;
            for (DataFlavor flavor : dtde.getCurrentDataFlavors()) {
                if (!DataFlavor.javaFileListFlavor.equals(flavor)) continue;
                dtde.acceptDrop(1);
                List files = (List)dtde.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                if (files.size() != 1) break;
                dropFile = (File)files.get(0);
                break;
            }
            if (dropFile == null || !dropFile.exists()) {
                tk.beep();
                return;
            }
            final File file = dropFile;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MainFrame.this.onImport(file);
                }
            });
        }
        catch (UnsupportedFlavorException ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
        catch (IOException ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onImport(File initFile) {
        block10: {
            boolean stopped = this.watchAgent.stop();
            try {
                ImportWizardDialog importWizDialog = new ImportWizardDialog(this, this.characterData, initFile);
                importWizDialog.setVisible(true);
                if (importWizDialog.getExitCode() != 1) break block10;
                try {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        if (this.characterData.reloadPartsData()) {
                            this.partsSelectionManager.loadParts();
                            this.watchAgent.reset();
                        }
                        CharacterDataPersistent persiste = CharacterDataPersistent.getInstance();
                        persiste.loadFavorites(this.characterData);
                    }
                    finally {
                        this.setCursor(Cursor.getDefaultCursor());
                    }
                }
                catch (Exception ex) {
                    ErrorMessageHelper.showErrorDialog(this, ex);
                }
                this.requestPreview();
            }
            finally {
                if (stopped) {
                    this.watchAgent.start();
                }
            }
        }
    }

    protected void onExport() {
        ExportWizardDialog exportWizDlg = new ExportWizardDialog(this, this.characterData, this.previewPane.getPreviewImage());
        exportWizDlg.setVisible(true);
    }

    protected void onResetColor() {
        if (!this.characterData.isValid()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return;
        }
        Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
        if (JOptionPane.showConfirmDialog(this, strings.get("confirm.resetcolors"), strings.getProperty("confirm"), 0, 3) != 0) {
            return;
        }
        this.characterData.getPartsColorManager().resetPartsColorInfo();
        this.partsColorCoordinator.initColorDialog();
        this.requestPreview();
    }

    protected void onCloseProfile() {
        this.saveWorkingSet();
        MainFrame.unregisterUsedCharacterData(this.characterData);
        URL characterDocBase = this.characterData.getDocBase();
        if (characterDocBase != null) {
            RecentDataPersistent recentPersist = RecentDataPersistent.getInstance();
            try {
                recentPersist.saveRecent(this.characterData);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "recent data saving failed.", ex);
            }
        }
        this.imageBuilder.stop();
        this.watchAgent.stop();
        this.dispose();
        logger.log(Level.INFO, "dispose mainframe.");
    }

    public static void closeAllProfiles() {
        MainFrame mainFrame = activedMainFrame;
        SystemUtil.gc();
        for (Frame frame : JFrame.getFrames()) {
            try {
                if (!frame.isDisplayable() || !(frame instanceof MainFrame) || frame == mainFrame) continue;
                ((MainFrame)frame).onCloseProfile();
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "mainframe closing failed.", ex);
            }
        }
        if (activedMainFrame != null && activedMainFrame.isDisplayable()) {
            try {
                activedMainFrame.onCloseProfile();
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "mainframe closing failed.", ex);
            }
        }
    }

    protected UserData getWorkingSetUserData() {
        return MainFrame.getWorkingSetUserData(this.characterData);
    }

    public static UserData getWorkingSetUserData(CharacterData cd) {
        if (cd == null || !cd.isValid()) {
            return null;
        }
        String dataname = cd.getId() + "-workingset.ser";
        UserDataFactory userDataFactory = UserDataFactory.getInstance();
        UserData workingSetStore = userDataFactory.getMangledNamedUserData(cd.getDocBase(), dataname);
        return workingSetStore;
    }

    protected void saveWorkingSet() {
        if (!this.characterData.isValid()) {
            return;
        }
        try {
            WorkingSet workingSet = new WorkingSet();
            workingSet.setCharacterDocBase(this.characterData.getDocBase());
            workingSet.setCharacterDataRev(this.characterData.getRev());
            PartsSet partsSet = this.partsSelectionManager.createPartsSet();
            workingSet.setPartsSet(partsSet);
            workingSet.setPartsColorInfoMap(this.characterData.getPartsColorManager().getPartsColorInfoMap());
            workingSet.setLastUsedSaveDir(this.imageSaveHelper.getLastUsedSaveDir());
            workingSet.setLastUsedExportDir(ExportWizardDialog.getLastUsedDir());
            workingSet.setLastUsePresetParts(this.lastUsePresetParts);
            UserData workingSetStore = this.getWorkingSetUserData();
            workingSetStore.save(workingSet);
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected boolean loadWorkingSet() {
        if (!this.characterData.isValid()) {
            return false;
        }
        try {
            UserData workingSetStore = this.getWorkingSetUserData();
            if (workingSetStore != null && workingSetStore.exists()) {
                WorkingSet workingSet = (WorkingSet)workingSetStore.load();
                if (!this.characterData.getDocBase().toString().equals(workingSet.getCharacterDocBase().toString())) {
                    logger.info("workingset data mismatch:" + this.characterData);
                    return false;
                }
                String docRev = this.characterData.getRev();
                String workRev = workingSet.getCharacterDataRev();
                if (docRev == null || workRev == null || !docRev.equals(workRev)) {
                    logger.info("workingset revision mismatch: actual=" + this.characterData + "/workingSet=" + workingSet);
                    return false;
                }
                Map<PartsIdentifier, PartsColorInfo> partsColorInfoMap = this.characterData.getPartsColorManager().getPartsColorInfoMap();
                for (Map.Entry<PartsIdentifier, PartsColorInfo> entry : workingSet.getPartsColorInfoMap().entrySet()) {
                    PartsIdentifier partsIdentifier = entry.getKey();
                    PartsColorInfo partsColorInfo = entry.getValue();
                    partsColorInfoMap.put(partsIdentifier, partsColorInfo);
                }
                PartsSet partsSet = workingSet.getPartsSet();
                this.selectPresetParts(partsSet.createCompatible(this.characterData));
                PartsSet lastUsePresetParts = workingSet.getLastUsePresetParts();
                if (lastUsePresetParts != null && lastUsePresetParts.hasName() && lastUsePresetParts.isSameStructure(partsSet)) {
                    this.lastUsePresetParts = lastUsePresetParts;
                    this.showPresetName(lastUsePresetParts);
                }
                this.imageSaveHelper.setLastUseSaveDir(workingSet.getLastUsedSaveDir());
                ExportWizardDialog.setLastUsedDir(workingSet.getLastUsedExportDir());
                return true;
            }
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
        return false;
    }

    protected void onAbout() {
        try {
            AboutBox aboutBox = new AboutBox(this);
            aboutBox.showAboutBox();
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected void onHelp() {
        try {
            Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
            String helpURL = strings.getProperty("help.url");
            URI helpURI = new URI(helpURL);
            if (!DesktopUtilities.browse(helpURI)) {
                JPanel panel = new JPanel();
                BoxLayout layout = new BoxLayout(panel, 1);
                panel.setLayout(layout);
                panel.add(new JLabel(strings.getProperty("help.show")));
                JTextField txtURL = new JTextField(helpURL);
                panel.add(txtURL);
                JOptionPane.showMessageDialog(this, panel);
            }
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected void onFlipHolizontal() {
        if (!this.characterData.isValid()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return;
        }
        double[] affineTransformParameter = this.partsSelectionManager.getAffineTransformParameter();
        if (affineTransformParameter == null) {
            Dimension siz = this.characterData.getImageSize();
            if (siz != null) {
                affineTransformParameter = new double[]{-1.0, 0.0, 0.0, 1.0, siz.width, 0.0};
            }
        } else {
            affineTransformParameter = null;
        }
        this.partsSelectionManager.setAffineTransformParameter(affineTransformParameter);
        this.requestPreview();
    }

    protected void onInformation() {
        if (!this.characterData.isValid()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return;
        }
        PartsSet partsSet = this.partsSelectionManager.createPartsSet();
        InformationDialog infoDlg = new InformationDialog(this, this.characterData, partsSet);
        infoDlg.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onManageFavorites() {
        if (!this.characterData.isValid()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return;
        }
        this.refreshFavorites();
        ManageFavoriteDialog dlg = new ManageFavoriteDialog(this, this.characterData);
        dlg.setVisible(true);
        if (!dlg.isModified()) {
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                CharacterDataPersistent persiste = CharacterDataPersistent.getInstance();
                persiste.saveFavorites(this.characterData);
                MainFrame.notifyChangeFavorites(this.characterData);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshFavorites() {
        logger.log(Level.INFO, "refresh Favorites.: " + this.characterData);
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                CharacterDataPersistent persiste = CharacterDataPersistent.getInstance();
                this.characterData.clearPartsSets(true);
                persiste.loadFavorites(this.characterData);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "can't refresh favorites: " + this.characterData, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onRegisterFavorite() {
        if (!this.characterData.isValid()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return;
        }
        try {
            PartsSet partsSet = this.partsSelectionManager.createPartsSet();
            if (partsSet.isEmpty()) {
                return;
            }
            Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
            JCheckBox chkColorInfo = new JCheckBox(strings.getProperty("input.favoritesColorInfo"));
            chkColorInfo.setSelected(true);
            String initName = this.getSuggestPartsSetName(partsSet, false, "");
            String name = (String)JOptionPane.showInputDialog(this, chkColorInfo, strings.getProperty("input.favorites"), 3, null, null, initName);
            if (name == null || name.trim().length() == 0) {
                return;
            }
            boolean includeColorInfo = chkColorInfo.isSelected();
            if (!includeColorInfo) {
                partsSet.removeColorInfo();
            }
            String partsSetId = "ps" + UUID.randomUUID().toString();
            partsSet.setPartsSetId(partsSetId);
            partsSet.setLocalizedName(name);
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                CharacterDataPersistent persiste = CharacterDataPersistent.getInstance();
                this.characterData.clearPartsSets(true);
                persiste.loadFavorites(this.characterData);
                this.characterData.addPartsSet(partsSet);
                persiste.saveFavorites(this.characterData);
                MainFrame.notifyChangeFavorites(this.characterData);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
            this.lastUsePresetParts = partsSet;
            this.showPresetName(partsSet);
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected void onDeselectAll() {
        this.partsSelectionManager.deselectAll();
    }

    protected void onDeselectableAllCategory() {
        this.partsSelectionManager.setDeselectableSingleCategory(!this.partsSelectionManager.isDeselectableSingleCategory());
    }

    protected JMenuBar createMenuBar() {
        final boolean needAntiAlias = this.isNeedAntialias();
        logger.info("needAntiAlias=" + needAntiAlias);
        JMenuBar menuBar = new JMenuBar(){
            private static final long serialVersionUID = 1L;

            public void paint(Graphics g) {
                if (needAntiAlias) {
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                }
                super.paint(g);
            }
        };
        Properties menuProps = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(MENU_STRINGS_RESOURCE);
        MenuDataFactory[] menus = new MenuDataFactory[]{new MenuDataFactory("menu.file", new MenuDataFactory[]{new MenuDataFactory("file.openProfile", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onOpenProfile();
            }
        }), new MenuDataFactory("file.savePicture", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onSavePicture();
            }
        }), new MenuDataFactory("file.manageParts", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onManageParts();
            }
        }), new MenuDataFactory("file.import", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onImport(null);
            }
        }), new MenuDataFactory("file.export", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onExport();
            }
        }), new MenuDataFactory("file.preferences", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onPreferences();
            }
        }), null, new MenuDataFactory("file.closeProfile", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onCloseProfile();
            }
        })}), new MenuDataFactory("menu.edit", new MenuDataFactory[]{new MenuDataFactory("edit.search", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onSearch();
            }
        }), new MenuDataFactory("edit.copy", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onCopy();
            }
        }), new MenuDataFactory("edit.flipHorizontal", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onFlipHolizontal();
            }
        }), new MenuDataFactory("edit.resetcolor", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onResetColor();
            }
        }), null, new MenuDataFactory("edit.information", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onInformation();
            }
        }), null, new MenuDataFactory("edit.deselectall", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onDeselectAll();
            }
        }), new MenuDataFactory("edit.deselectparts", true, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onDeselectableAllCategory();
            }
        })}), new MenuDataFactory("menu.favorite", new MenuDataFactory[]{new MenuDataFactory("favorite.register", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onRegisterFavorite();
            }
        }), new MenuDataFactory("favorite.manage", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onManageFavorites();
            }
        }), null}), new MenuDataFactory("menu.help", new MenuDataFactory[]{new MenuDataFactory("help.help", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onHelp();
            }
        }), new MenuDataFactory("help.about", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onAbout();
            }
        })})};
        final HashMap<String, 33> menuMap = new HashMap<String, 33>();
        final HashMap<String, 34> menuItemMap = new HashMap<String, 34>();
        for (MenuDataFactory menuDataFactory : menus) {
            JMenu menu;
            MenuData menuData = menuDataFactory.createMenuData(menuProps);
            if (!menuData.makeMenu(menu = new JMenu(){
                private static final long serialVersionUID = 1L;

                public void paint(Graphics g) {
                    if (needAntiAlias) {
                        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    }
                    super.paint(g);
                }
            })) continue;
            menuBar.add(menu);
            menuMap.put(menuDataFactory.getName(), menu);
            for (MenuData child : menuData) {
                if (child == null) {
                    menu.add(new JSeparator());
                    continue;
                }
                JMenuItem menuItem = child.isCheckbox() ? new JCheckBoxMenuItem(){
                    private static final long serialVersionUID = 1L;

                    public void paint(Graphics g) {
                        if (needAntiAlias) {
                            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                        }
                        super.paint(g);
                    }
                } : new JMenuItem(){
                    private static final long serialVersionUID = 1L;

                    public void paint(Graphics g) {
                        if (needAntiAlias) {
                            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                        }
                        super.paint(g);
                    }
                };
                if (!child.makeMenu(menuItem)) continue;
                menu.add(menuItem);
                menuItemMap.put(child.getName(), menuItem);
            }
        }
        ((JMenu)menuMap.get("menu.edit")).addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent e) {
            }

            public void menuDeselected(MenuEvent e) {
            }

            public void menuSelected(MenuEvent e) {
                ((JMenuItem)menuItemMap.get("edit.copy")).setEnabled(MainFrame.this.previewPane.getPreviewImage() != null);
                ((JMenuItem)menuItemMap.get("edit.deselectparts")).setSelected(MainFrame.this.partsSelectionManager.isDeselectableSingleCategory());
            }
        });
        ((JMenu)menuMap.get("menu.favorite")).addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent e) {
            }

            public void menuDeselected(MenuEvent e) {
            }

            public void menuSelected(MenuEvent e) {
                JMenu menu = (JMenu)menuMap.get("menu.favorite");
                MainFrame.this.onSelectedFavoriteMenu(menu);
            }
        });
        return menuBar;
    }

    private boolean isNeedAntialias() {
        return System.getProperty("java.specification.version").startsWith("1.5");
    }

    static {
        activeCharacterDatas = new HashMap();
    }
}

