/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.util;

import charactermanaj.Main;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;

public final class ConfigurationDirUtilities {
    public static final String CONFIGURATION_DIR_NAME = "CharacterManaJ";
    private static File userDataDir;
    private static File applicationBaseDir;

    private ConfigurationDirUtilities() {
        throw new RuntimeException("utilities class.");
    }

    public static synchronized File getUserDataDir() {
        if (userDataDir == null) {
            String characterDirName;
            String appData = null;
            appData = System.getProperty("appdata.dir");
            if (appData == null) {
                appData = System.getenv("APPDATA");
            }
            if (appData == null && Main.isMacOSX()) {
                appData = new File(System.getProperty("user.home"), "Library").getPath();
            }
            if (appData == null) {
                appData = System.getProperty("user.home");
            }
            if (!(userDataDir = new File(appData, characterDirName = System.getProperty("characterdata.dirname", CONFIGURATION_DIR_NAME)).getAbsoluteFile()).exists() && !userDataDir.mkdirs()) {
                System.err.println("can't create the user data directory. " + userDataDir);
            }
        }
        return userDataDir;
    }

    public static synchronized File getApplicationBaseDir() {
        if (applicationBaseDir == null) {
            String appbaseDir = System.getProperty("appbase.dir");
            if (appbaseDir != null && appbaseDir.length() > 0) {
                try {
                    applicationBaseDir = new File(appbaseDir).getCanonicalFile();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            if (applicationBaseDir == null) {
                ProtectionDomain pdomain = ConfigurationDirUtilities.class.getProtectionDomain();
                CodeSource codeSource = pdomain.getCodeSource();
                if (codeSource == null) {
                    throw new RuntimeException("codeSource is null: domain=" + pdomain);
                }
                URL codeBaseUrl = codeSource.getLocation();
                if (!codeBaseUrl.getProtocol().equals("file")) {
                    throw new RuntimeException("codeLocation is not file protocol.: " + codeBaseUrl);
                }
                applicationBaseDir = new File(codeBaseUrl.getPath()).getParentFile();
            }
        }
        return applicationBaseDir;
    }
}

