/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.util;

import charactermanaj.util.ConfigurationDirUtilities;
import charactermanaj.util.FileUserData;
import charactermanaj.util.UserData;
import java.io.File;
import java.net.URL;
import java.util.UUID;

public class UserDataFactory {
    private static UserDataFactory inst = new UserDataFactory();

    public static UserDataFactory getInstance() {
        return inst;
    }

    private UserDataFactory() {
    }

    public UserData getUserData(String name) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        File userDataDir = ConfigurationDirUtilities.getUserDataDir();
        return new FileUserData(new File(userDataDir, name));
    }

    public UserData getMangledNamedUserData(URL docBase, String name) {
        String docBaseStr = docBase == null ? "" : docBase.toString();
        String prefix = UUID.nameUUIDFromBytes(docBaseStr.getBytes()).toString();
        return this.getUserData(prefix + "-" + name);
    }
}

