/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import java.util.LinkedList;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FirstItemInjectionComboBoxModelWrapper<T>
implements ComboBoxModel {
    private ComboBoxModel parent;
    private T selectedItem;
    private T firstItem;
    private LinkedList<ListDataListener> listDataListeners = new LinkedList();

    public FirstItemInjectionComboBoxModelWrapper(ComboBoxModel parent, T firstItem) {
        if (parent == null || firstItem == null) {
            throw new IllegalArgumentException();
        }
        this.parent = parent;
        this.firstItem = firstItem;
        parent.addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent e) {
                FirstItemInjectionComboBoxModelWrapper.this.fireListUpdated(this.convertRowIndex(e));
            }

            public void intervalAdded(ListDataEvent e) {
                FirstItemInjectionComboBoxModelWrapper.this.fireListAdded(this.convertRowIndex(e));
            }

            public void intervalRemoved(ListDataEvent e) {
                FirstItemInjectionComboBoxModelWrapper.this.fireListRemoved(this.convertRowIndex(e));
            }

            protected ListDataEvent convertRowIndex(ListDataEvent e) {
                return new ListDataEvent(e.getSource(), e.getType(), e.getIndex0() + 1, e.getIndex1() + 1);
            }
        });
    }

    protected void fireListUpdated(ListDataEvent e) {
        for (ListDataListener listener : this.listDataListeners) {
            listener.contentsChanged(e);
        }
    }

    protected void fireListAdded(ListDataEvent e) {
        for (ListDataListener listener : this.listDataListeners) {
            listener.intervalAdded(e);
        }
    }

    protected void fireListRemoved(ListDataEvent e) {
        for (ListDataListener listener : this.listDataListeners) {
            listener.intervalRemoved(e);
        }
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItem;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.selectedItem = anItem;
        if (!this.firstItem.equals(anItem)) {
            this.parent.setSelectedItem(anItem);
        }
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        if (l != null) {
            this.listDataListeners.add(l);
        }
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        if (l != null) {
            this.listDataListeners.remove(l);
        }
    }

    @Override
    public Object getElementAt(int index) {
        if (index == 0) {
            return this.firstItem;
        }
        return this.parent.getElementAt(index - 1);
    }

    @Override
    public int getSize() {
        return this.parent.getSize() + 1;
    }
}

