/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.Main;
import charactermanaj.clipboardSupport.ClipboardUtil;
import charactermanaj.graphics.AsyncImageBuilder;
import charactermanaj.graphics.ColorConvertedImageCachedLoader;
import charactermanaj.graphics.ImageBuildJobAbstractAdaptor;
import charactermanaj.graphics.ImageBuilder;
import charactermanaj.graphics.io.ImageSaveHelper;
import charactermanaj.model.AppConfig;
import charactermanaj.model.CharacterData;
import charactermanaj.model.ColorGroup;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsColorInfo;
import charactermanaj.model.PartsColorManager;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSet;
import charactermanaj.model.RecommendationURL;
import charactermanaj.model.WorkingSet;
import charactermanaj.model.io.CharacterDataPersistent;
import charactermanaj.model.io.PartsImageDirectoryWatchAgent;
import charactermanaj.model.io.PartsImageDirectoryWatchAgentFactory;
import charactermanaj.model.io.PartsImageDirectoryWatchEvent;
import charactermanaj.model.io.PartsImageDirectoryWatchListener;
import charactermanaj.model.io.RecentDataPersistent;
import charactermanaj.ui.AboutBox;
import charactermanaj.ui.AppConfigDialog;
import charactermanaj.ui.ColorDialog;
import charactermanaj.ui.ExportWizardDialog;
import charactermanaj.ui.ImageSelectPanel;
import charactermanaj.ui.ImageSelectPanelList;
import charactermanaj.ui.ImportWizardDialog;
import charactermanaj.ui.InformationDialog;
import charactermanaj.ui.ManageFavoriteDialog;
import charactermanaj.ui.MenuBuilder;
import charactermanaj.ui.MenuDataFactory;
import charactermanaj.ui.PartsManageDialog;
import charactermanaj.ui.PreviewPanel;
import charactermanaj.ui.ProfileListManager;
import charactermanaj.ui.SearchPartsDialog;
import charactermanaj.ui.model.ColorChangeEvent;
import charactermanaj.ui.model.ColorChangeListener;
import charactermanaj.ui.model.ColorGroupCoordinator;
import charactermanaj.ui.model.PartsColorCoordinator;
import charactermanaj.ui.model.PartsSelectionManager;
import charactermanaj.ui.util.FileDropTarget;
import charactermanaj.util.DesktopUtilities;
import charactermanaj.util.ErrorMessageHelper;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import charactermanaj.util.SystemUtil;
import charactermanaj.util.UIHelper;
import charactermanaj.util.UserData;
import charactermanaj.util.UserDataFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(MainFrame.class.getName());
    protected static final String STRINGS_RESOURCE = "languages/mainframe";
    protected static final String MENU_STRINGS_RESOURCE = "menu/menu";
    protected BufferedImage icon;
    private static volatile MainFrame activedMainFrame;
    protected CharacterData characterData;
    private PreviewPanel previewPane;
    protected PartsSelectionManager partsSelectionManager;
    private boolean minimizeMode;
    protected ImageSelectPanelList imageSelectPanels;
    protected JScrollPane imgSelectPanelsPanelSp;
    protected ColorGroupCoordinator colorGroupCoordinator;
    protected PartsColorCoordinator partsColorCoordinator;
    private ColorConvertedImageCachedLoader imageLoader;
    private AsyncImageBuilder imageBuilder;
    private ImageSaveHelper imageSaveHelper = new ImageSaveHelper();
    private PartsImageDirectoryWatchAgent watchAgent;
    private String defaultPartsSetTitle;
    private PartsSet lastUsePresetParts;
    private SearchPartsDialog lastUseSearchPartsDialog;

    public static void setActivedMainFrame(MainFrame mainFrame) {
        if (mainFrame == null) {
            throw new IllegalArgumentException();
        }
        activedMainFrame = mainFrame;
    }

    public static MainFrame getActivedMainFrame() {
        return activedMainFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyImportedPartsOrFavorites(CharacterData cd, CharacterData newCd, Component caller) throws IOException {
        if (cd == null || newCd == null || caller == null) {
            throw new IllegalArgumentException();
        }
        if (!cd.isValid() || !newCd.isValid()) {
            return;
        }
        logger.log(Level.INFO, "parts imported for active profiles: " + newCd);
        if (!cd.isSameStructure(newCd)) {
            MainFrame.notifyChangeCharacterData(cd, newCd, caller);
        } else {
            for (Frame frame : JFrame.getFrames()) {
                if (!frame.isDisplayable() || !(frame instanceof MainFrame)) continue;
                MainFrame mainFrame = (MainFrame)frame;
                if (mainFrame.characterData == null || !mainFrame.characterData.isValid()) continue;
                caller.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    mainFrame.reloadPartsAndFavorites(newCd, true);
                }
                finally {
                    caller.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyChangeCharacterData(CharacterData cd, CharacterData newCd, Component caller) throws IOException {
        if (cd == null || newCd == null || caller == null) {
            throw new IllegalArgumentException();
        }
        if (!cd.isValid() || !newCd.isValid()) {
            return;
        }
        logger.log(Level.INFO, "change active profile: " + newCd);
        if (!ProfileListManager.isUsingCharacterData(cd)) {
            return;
        }
        caller.setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (!newCd.isPartsLoaded()) {
                ProfileListManager.loadCharacterData(newCd);
                ProfileListManager.loadFavorites(newCd);
            }
            for (Frame frame : JFrame.getFrames()) {
                String docbaseMine;
                String docbaseOrg;
                if (!frame.isDisplayable() || !(frame instanceof MainFrame)) continue;
                MainFrame mainFrame = (MainFrame)frame;
                if (mainFrame.characterData == null || !mainFrame.characterData.isValid() || !(docbaseOrg = cd.getDocBase().toString()).equals(docbaseMine = mainFrame.characterData.getDocBase().toString())) continue;
                mainFrame.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    mainFrame.saveWorkingSet();
                    mainFrame.initComponent(newCd);
                }
                finally {
                    if (mainFrame != caller) {
                        mainFrame.setCursor(Cursor.getDefaultCursor());
                    }
                }
            }
        }
        finally {
            caller.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyChangeFavorites(CharacterData cd) {
        if (cd == null) {
            throw new IllegalArgumentException();
        }
        for (Frame frame : JFrame.getFrames()) {
            if (!frame.isDisplayable() || !(frame instanceof MainFrame)) continue;
            MainFrame mainFrame = (MainFrame)frame;
            if (!cd.getDocBase().equals(mainFrame.characterData.getDocBase())) continue;
            mainFrame.setCursor(Cursor.getPredefinedCursor(3));
            try {
                mainFrame.refreshFavorites();
            }
            finally {
                mainFrame.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    public MainFrame(CharacterData characterData) {
        try {
            if (characterData == null) {
                throw new IllegalArgumentException();
            }
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    MainFrame.this.onCloseProfile();
                }

                public void windowClosed(WindowEvent e) {
                    MainFrame.this.stopAgents();
                }

                public void windowActivated(WindowEvent e) {
                    MainFrame.setActivedMainFrame(MainFrame.this);
                }

                public void windowOpened(WindowEvent e) {
                }
            });
            this.icon = UIHelper.getInstance().getImage("icons/icon.png");
            this.setIconImage(this.icon);
            this.initComponent(characterData);
            JMenuBar menuBar = this.createMenuBar();
            this.setJMenuBar(menuBar);
            GraphicsEnvironment genv = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Rectangle desktopSize = genv.getMaximumWindowBounds();
            logger.log(Level.INFO, "desktopSize=" + desktopSize);
            Dimension imageSize = characterData.getImageSize();
            AppConfig appConfig = AppConfig.getInstance();
            int maxWidth = Math.min(desktopSize.width, appConfig.getMainFrameMaxWidth());
            int maxHeight = Math.min(desktopSize.height, appConfig.getMainFrameMaxHeight());
            int imageWidth = Math.min(maxWidth, Math.max(300, imageSize != null ? imageSize.width : 0));
            int imageHeight = Math.min(maxHeight, Math.max(400, imageSize != null ? imageSize.height : 0));
            this.setSize(imageWidth - 300 + 600, imageHeight - 400 + 550);
            this.setLocationByPlatform(true);
        }
        catch (RuntimeException ex) {
            logger.log(Level.SEVERE, "\u30e1\u30a4\u30f3\u30d5\u30ec\u30fc\u30e0\u306e\u69cb\u7bc9\u4e2d\u306b\u4e88\u671f\u305b\u306c\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", ex);
            this.dispose();
            throw ex;
        }
        catch (Error ex) {
            logger.log(Level.SEVERE, "\u30e1\u30a4\u30f3\u30d5\u30ec\u30fc\u30e0\u306e\u69cb\u7bc9\u4e2d\u306b\u81f4\u547d\u7684\u306a\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", ex);
            this.dispose();
            throw ex;
        }
    }

    public void showMainFrame() {
        GraphicsEnvironment genv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle desktopSize = genv.getMaximumWindowBounds();
        logger.log(Level.INFO, "desktopSize=" + desktopSize);
        this.setVisible(true);
        Point loc = this.getLocation();
        logger.log(Level.INFO, "windowLocation=" + loc);
        Dimension windowSize = this.getSize();
        if (loc.y + windowSize.height >= desktopSize.height) {
            loc.y = 0;
        }
        if (loc.x + windowSize.width >= desktopSize.width) {
            loc.x = 0;
        }
        if (loc.x == 0 || loc.y == 0) {
            this.setLocation(loc);
        }
        boolean resize = false;
        Dimension dim = this.getSize();
        if (dim.height > desktopSize.height) {
            dim.height = desktopSize.height;
            resize = true;
        }
        if (dim.width > desktopSize.width) {
            dim.width = desktopSize.width;
            resize = true;
        }
        if (resize) {
            this.setSize(dim);
        }
    }

    protected void stopAgents() {
        if (this.watchAgent != null) {
            try {
                this.watchAgent.disconnect();
            }
            catch (Throwable ex) {
                logger.log(Level.SEVERE, "\u30d5\u30a9\u30eb\u30c0\u76e3\u8996\u30b9\u30ec\u30c3\u30c9\u306e\u505c\u6b62\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", ex);
            }
            this.watchAgent = null;
        }
        if (this.imageBuilder != null) {
            try {
                this.imageBuilder.stop();
            }
            catch (Throwable ex) {
                logger.log(Level.SEVERE, "\u975e\u540c\u671f\u30a4\u30e1\u30fc\u30b8\u30d3\u30eb\u30c0\u30b9\u30ec\u30c3\u30c9\u306e\u505c\u6b62\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", ex);
            }
            this.imageBuilder = null;
        }
    }

    @Override
    public void dispose() {
        this.stopAgents();
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initComponent(CharacterData characterData) {
        CharacterData oldCd;
        MainFrame mainFrame = this;
        synchronized (mainFrame) {
            oldCd = this.characterData;
            if (oldCd != null) {
                ProfileListManager.unregisterUsedCharacterData(oldCd);
            }
            this.characterData = characterData;
            ProfileListManager.registerUsedCharacterData(characterData);
        }
        AppConfig appConfig = AppConfig.getInstance();
        Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
        String title = Main.isMacOSX() ? "" : strings.getProperty("title");
        this.setTitle(title + characterData.getName());
        this.defaultPartsSetTitle = strings.getProperty("defaultPartsSetTitle");
        this.stopAgents();
        Container contentPane = this.getContentPane();
        for (Component comp : contentPane.getComponents()) {
            contentPane.remove(comp);
        }
        this.closeSearchDialog();
        PartsColorManager partsColorManager = characterData.getPartsColorManager();
        this.imageLoader = new ColorConvertedImageCachedLoader();
        this.imageBuilder = new AsyncImageBuilder(this.imageLoader);
        this.partsSelectionManager = new PartsSelectionManager(partsColorManager);
        this.colorGroupCoordinator = new ColorGroupCoordinator(this.partsSelectionManager, partsColorManager);
        this.partsColorCoordinator = new PartsColorCoordinator(characterData, partsColorManager, this.colorGroupCoordinator);
        PartsImageDirectoryWatchAgentFactory agentFactory = PartsImageDirectoryWatchAgentFactory.getFactory();
        this.watchAgent = agentFactory.getAgent(characterData);
        this.previewPane = new PreviewPanel();
        this.previewPane.setTitle(this.defaultPartsSetTitle);
        this.previewPane.addPreviewPanelListener(new PreviewPanel.PreviewPanelListener(){

            public void addFavorite(PreviewPanel.PreviewPanelEvent e) {
                MainFrame.this.onRegisterFavorite();
            }

            public void changeBackgroundColor(PreviewPanel.PreviewPanelEvent e) {
                MainFrame.this.onChangeBgColor();
            }

            public void copyPicture(PreviewPanel.PreviewPanelEvent e) {
                MainFrame.this.onCopy();
            }

            public void savePicture(PreviewPanel.PreviewPanelEvent e) {
                MainFrame.this.onSavePicture();
            }

            public void showInformation(PreviewPanel.PreviewPanelEvent e) {
                MainFrame.this.onInformation();
            }

            public void flipHorizontal(PreviewPanel.PreviewPanelEvent e) {
                MainFrame.this.onFlipHolizontal();
            }
        });
        this.imageSelectPanels = new ImageSelectPanelList();
        JPanel imgSelectPanelsPanel = new JPanel();
        BoxLayout bl = new BoxLayout(imgSelectPanelsPanel, 3);
        imgSelectPanelsPanel.setLayout(bl);
        for (PartsCategory category : characterData.getPartsCategories()) {
            ImageSelectPanel imageSelectPanel = new ImageSelectPanel(category, characterData);
            imgSelectPanelsPanel.add(imageSelectPanel);
            this.imageSelectPanels.add(imageSelectPanel);
            this.partsSelectionManager.register(imageSelectPanel);
        }
        this.imgSelectPanelsPanelSp = new JScrollPane(imgSelectPanelsPanel){
            private static final long serialVersionUID = 1L;

            public JScrollBar createVerticalScrollBar() {
                JScrollBar sb = super.createVerticalScrollBar();
                sb.setUnitIncrement(12);
                return sb;
            }
        };
        this.imgSelectPanelsPanelSp.setVerticalScrollBarPolicy(22);
        JSplitPane splitPane = new JSplitPane(1, true, this.imgSelectPanelsPanelSp, this.previewPane);
        contentPane.add((Component)splitPane, "Center");
        this.imgSelectPanelsPanelSp.requestFocus();
        ArrayList<ColorGroup> colorGroups = new ArrayList<ColorGroup>();
        colorGroups.addAll(characterData.getColorGroups());
        ColorChangeListener colorChangeListener = new ColorChangeListener(){

            public void onColorGroupChange(ColorChangeEvent event) {
            }

            public void onColorChange(ColorChangeEvent event) {
                MainFrame.this.requestPreview();
            }
        };
        this.colorGroupCoordinator.addColorChangeListener(colorChangeListener);
        int idx = 0;
        while (idx < this.imageSelectPanels.size()) {
            ImageSelectPanel imageSelectPanel = this.imageSelectPanels.get(idx);
            PartsCategory partsCategory = imageSelectPanel.getPartsCategory();
            final ColorDialog colorDialog = new ColorDialog(this, partsCategory, colorGroups);
            this.colorGroupCoordinator.registerColorDialog(colorDialog);
            this.partsColorCoordinator.register(imageSelectPanel, colorDialog);
            final int curidx = idx++;
            imageSelectPanel.addImageSelectListener(new ImageSelectPanel.ImageSelectPanelListener(){

                public void onChangeColor(ImageSelectPanel.ImageSelectPanelEvent event) {
                    colorDialog.adjustLocation(curidx);
                    colorDialog.setVisible(!colorDialog.isVisible());
                }

                public void onPreferences(ImageSelectPanel.ImageSelectPanelEvent event) {
                }

                public void onChange(ImageSelectPanel.ImageSelectPanelEvent event) {
                    MainFrame.this.requestPreview();
                }

                public void onSelectChange(ImageSelectPanel.ImageSelectPanelEvent event) {
                }

                public void onTitleClick(ImageSelectPanel.ImageSelectPanelEvent event) {
                    PartsCategory partsCategory = event != null ? event.getImageSelectPanel().getPartsCategory() : null;
                    MainFrame.this.onClickPartsCategoryTitle(partsCategory, false);
                }

                public void onTitleDblClick(ImageSelectPanel.ImageSelectPanelEvent event) {
                    PartsCategory partsCategory = event != null ? event.getImageSelectPanel().getPartsCategory() : null;
                    MainFrame.this.onClickPartsCategoryTitle(partsCategory, true);
                }
            });
            imageSelectPanel.addAncestorListener(new AncestorListener(){

                public void ancestorAdded(AncestorEvent event) {
                }

                public void ancestorMoved(AncestorEvent event) {
                }

                public void ancestorRemoved(AncestorEvent event) {
                    colorDialog.setVisible(false);
                }
            });
        }
        this.partsSelectionManager.loadParts();
        if (!this.loadWorkingSet() && this.showDefaultParts(true)) {
            this.requestPreview();
        }
        this.scrollToSelectedParts();
        if (!this.imageBuilder.isAlive()) {
            this.imageBuilder.start();
        }
        new DropTarget(this.imgSelectPanelsPanelSp, new FileDropTarget(){

            @Override
            protected void onDropFiles(final List<File> dropFiles) {
                if (dropFiles == null || dropFiles.isEmpty()) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MainFrame.this.onImport(dropFiles);
                    }
                });
            }

            @Override
            protected void onException(Exception ex) {
                ErrorMessageHelper.showErrorDialog(MainFrame.this, ex);
            }
        });
        this.watchAgent.addPartsImageDirectoryWatchListener(new PartsImageDirectoryWatchListener(){

            public void detectPartsImageChange(PartsImageDirectoryWatchEvent e) {
                Runnable refreshJob = new Runnable(){

                    public void run() {
                        MainFrame.this.onDetectPartsImageChange();
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    refreshJob.run();
                } else {
                    SwingUtilities.invokeLater(refreshJob);
                }
            }
        });
        if (appConfig.isEnableDirWatch() && characterData.isWatchDirectory()) {
            this.watchAgent.connect();
        }
        this.minimizeMode = false;
        if (appConfig.isEnableAutoShrinkPanel()) {
            this.onClickPartsCategoryTitle(null, true);
        }
        if (oldCd != null) {
            this.validate();
        }
    }

    protected void onDetectPartsImageChange() {
        try {
            this.reloadPartsAndFavorites(null, true);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "parts reload failed. " + this.characterData, ex);
        }
    }

    protected void scrollToSelectedParts() {
        this.partsSelectionManager.scrollToSelectedParts();
    }

    protected void onClickPartsCategoryTitle(PartsCategory partsCategory, boolean dblClick) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "onClickPartsCategoryTitle category=" + partsCategory + "/clickCount=" + dblClick);
        }
        if (dblClick) {
            boolean bl = this.minimizeMode = !this.minimizeMode;
            if (!this.minimizeMode) {
                this.partsSelectionManager.setMinimizeModeIfOther(null, false);
                return;
            }
        }
        if (this.minimizeMode) {
            if (this.partsSelectionManager.isNotMinimizeModeOnly(partsCategory)) {
                this.partsSelectionManager.setMinimizeModeIfOther(null, true);
            } else {
                this.partsSelectionManager.setMinimizeModeIfOther(partsCategory, true);
                if (partsCategory != null) {
                    final ImageSelectPanel panel = this.imageSelectPanels.findByPartsCategory(partsCategory);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            Point pt = panel.getLocation();
                            JViewport viewPort = MainFrame.this.imgSelectPanelsPanelSp.getViewport();
                            viewPort.setViewPosition(pt);
                            viewPort.revalidate();
                        }
                    });
                }
            }
        }
    }

    protected boolean showDefaultParts(boolean force) {
        try {
            List<PartsSet> partssets;
            PartsSet sel;
            if (!force && !(sel = this.partsSelectionManager.createPartsSet()).isEmpty()) {
                return false;
            }
            String defaultPresetId = this.characterData.getDefaultPartsSetId();
            PartsSet partsSet = null;
            if (defaultPresetId != null) {
                partsSet = this.characterData.getPartsSets().get(defaultPresetId);
            }
            if (partsSet == null && !(partssets = this.getPartsSetList()).isEmpty()) {
                partsSet = partssets.get(0);
            }
            if (partsSet == null) {
                this.partsColorCoordinator.initColorDialog();
            } else {
                this.selectPresetParts(partsSet);
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "\u30d1\u30fc\u30c4\u306e\u30c7\u30d5\u30a9\u30eb\u30c8\u9069\u7528\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", ex);
            return false;
        }
        return true;
    }

    protected void selectPresetParts(PartsSet presetParts) {
        if (presetParts == null) {
            return;
        }
        try {
            this.lastUsePresetParts = presetParts;
            this.partsSelectionManager.selectPartsSet(presetParts);
            this.partsColorCoordinator.initColorDialog();
            this.requestPreview();
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected List<PartsSet> getPartsSetList() {
        ArrayList<PartsSet> partssets = new ArrayList<PartsSet>();
        partssets.addAll(this.characterData.getPartsSets().values());
        Collections.sort(partssets, new Comparator<PartsSet>(){

            @Override
            public int compare(PartsSet o1, PartsSet o2) {
                int ret = o1.getLocalizedName().compareTo(o2.getLocalizedName());
                if (ret == 0) {
                    ret = o1.getPartsSetId().compareTo(o2.getPartsSetId());
                }
                if (ret == 0) {
                    ret = o1.hashCode() - o2.hashCode();
                }
                return ret;
            }
        });
        return partssets;
    }

    protected void onSelectedFavoriteMenu(JMenu menu) {
        int mx = menu.getMenuComponentCount();
        int separatorIdx = -1;
        for (int idx = 0; idx < mx; ++idx) {
            Component item = menu.getMenuComponent(idx);
            if (!(item instanceof JSeparator)) continue;
            separatorIdx = idx;
            break;
        }
        if (separatorIdx > 0) {
            while (menu.getMenuComponentCount() > separatorIdx + 1) {
                menu.remove(separatorIdx + 1);
            }
        }
        List<PartsSet> partssets = this.getPartsSetList();
        MenuBuilder menuBuilder = new MenuBuilder();
        for (final PartsSet presetParts : partssets) {
            JMenuItem favoriteMenu = menuBuilder.createJMenuItem();
            favoriteMenu.setName(presetParts.getPartsSetId());
            favoriteMenu.setText(presetParts.getLocalizedName());
            if (presetParts.isPresetParts()) {
                Font font = favoriteMenu.getFont();
                favoriteMenu.setFont(font.deriveFont(1));
            }
            favoriteMenu.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.selectPresetParts(presetParts);
                }
            });
            menu.add(favoriteMenu);
        }
    }

    protected void onSelectedRecommendationMenu(JMenu mnuRecomendation) {
        while (mnuRecomendation.getMenuComponentCount() > 0) {
            mnuRecomendation.remove(0);
        }
        CharacterDataPersistent persist = CharacterDataPersistent.getInstance();
        persist.CompensateRecommendationList(this.characterData);
        List<RecommendationURL> recommendations = this.characterData.getRecommendationURLList();
        if (recommendations != null) {
            MenuBuilder menuBuilder = new MenuBuilder();
            for (RecommendationURL recommendation : recommendations) {
                String displayName = recommendation.getDisplayName();
                String url = recommendation.getUrl();
                JMenuItem mnuItem = menuBuilder.createJMenuItem();
                mnuItem.setText(displayName);
                mnuItem.addActionListener(DesktopUtilities.createBrowseAction(this, url, displayName));
                mnuRecomendation.add(mnuItem);
            }
        }
        mnuRecomendation.setEnabled(recommendations != null && !recommendations.isEmpty());
    }

    protected void showPresetName(PartsSet requestPartsSet) {
        this.previewPane.setTitle(this.getSuggestPartsSetName(requestPartsSet, true, this.defaultPartsSetTitle));
    }

    private String getSuggestPartsSetName(PartsSet requestPartsSet, boolean markColorChange, String defaultPartsSetName) {
        String partsSetTitle = null;
        if (this.lastUsePresetParts != null && PartsSet.isSameStructure(requestPartsSet, this.lastUsePresetParts)) {
            partsSetTitle = this.lastUsePresetParts.getLocalizedName();
            if (markColorChange && !PartsSet.isSameColor(requestPartsSet, this.lastUsePresetParts) && partsSetTitle != null) {
                partsSetTitle = partsSetTitle + "*";
            }
        }
        if (partsSetTitle != null && partsSetTitle.trim().length() > 0) {
            return partsSetTitle;
        }
        return defaultPartsSetName;
    }

    protected void requestPreview() {
        if (!this.characterData.isValid()) {
            return;
        }
        this.imageBuilder.requestJob(new ImageBuildJobAbstractAdaptor(this.characterData){
            private PartsSet requestPartsSet;
            private long ticket;

            public void onQueueing(long ticket) {
                this.ticket = ticket;
                MainFrame.this.previewPane.setLoadingRequest(ticket);
            }

            public void buildImage(ImageBuilder.ImageOutput output) {
                final BufferedImage img = output.getImageOutput();
                final Color bgColor = output.getImageBgColor();
                Runnable refreshJob = new Runnable(){

                    public void run() {
                        MainFrame.this.previewPane.setImageBgColor(bgColor);
                        MainFrame.this.previewPane.setPreviewImage(img);
                        MainFrame.this.previewPane.setLoadingComplete(ticket);
                        MainFrame.this.showPresetName(requestPartsSet);
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    refreshJob.run();
                } else {
                    try {
                        SwingUtilities.invokeAndWait(refreshJob);
                    }
                    catch (Exception ex) {
                        logger.log(Level.WARNING, "build image failed.", ex);
                    }
                }
            }

            public void handleException(final Throwable ex) {
                Runnable showExceptionJob = new Runnable(){

                    public void run() {
                        ErrorMessageHelper.showErrorDialog(MainFrame.this, ex);
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    showExceptionJob.run();
                } else {
                    SwingUtilities.invokeLater(showExceptionJob);
                }
            }

            protected PartsSet getPartsSet() {
                final PartsSet[] result = new PartsSet[1];
                Runnable collectPartsSetJob = new Runnable(){

                    public void run() {
                        PartsSet partsSet;
                        result[0] = partsSet = MainFrame.this.partsSelectionManager.createPartsSet();
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    collectPartsSetJob.run();
                } else {
                    try {
                        SwingUtilities.invokeAndWait(collectPartsSetJob);
                    }
                    catch (InvocationTargetException e) {
                        throw new RuntimeException(e.getMessage(), e);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException("interrupted:" + e, e);
                    }
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "preview: " + result[0]);
                }
                this.requestPartsSet = result[0];
                return this.requestPartsSet;
            }
        });
    }

    protected void onOpenProfile() {
        try {
            MainFrame main2 = ProfileListManager.openProfile(this);
            if (main2 != null) {
                main2.showMainFrame();
            }
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onChangeBgColor() {
        this.getJMenuBar().setEnabled(false);
        try {
            Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
            Color color = this.partsSelectionManager.getImageBgColor();
            color = JColorChooser.showDialog(this, strings.getProperty("chooseBgColor"), color);
            if (color != null) {
                this.partsSelectionManager.setImageBgColor(color);
                this.requestPreview();
            }
        }
        finally {
            this.getJMenuBar().setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onSavePicture() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        BufferedImage img = this.previewPane.getPreviewImage();
        Color imgBgColor = this.partsSelectionManager.getImageBgColor();
        if (img == null) {
            tk.beep();
            return;
        }
        try {
            File outFile = this.imageSaveHelper.showSaveFileDialog(this);
            if (outFile == null) {
                return;
            }
            StringBuilder warnings = new StringBuilder();
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.imageSaveHelper.savePicture(img, imgBgColor, outFile, warnings);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
            if (warnings.length() > 0) {
                JOptionPane.showMessageDialog(this, warnings.toString(), "WARNINGS", 2);
            }
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected void onBrowseProfileDir() {
        if (!this.characterData.isValid()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return;
        }
        try {
            DesktopUtilities.browseBaseDir(this.characterData.getDocBase());
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected void onEditProfile() {
        if (!this.characterData.isValid()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return;
        }
        try {
            CharacterData cd = this.characterData;
            CharacterData newCd = ProfileListManager.editProfile(this, cd);
            if (newCd != null) {
                MainFrame.notifyChangeCharacterData(cd, newCd, this);
            }
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected void onManageParts() {
        if (!this.characterData.isValid()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return;
        }
        PartsManageDialog mrgDlg = new PartsManageDialog(this, this.characterData);
        mrgDlg.setVisible(true);
        if (mrgDlg.isUpdated() && this.characterData.reloadPartsData()) {
            this.partsSelectionManager.loadParts();
            this.requestPreview();
        }
    }

    protected void openSearchDialog() {
        if (!this.characterData.isValid()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return;
        }
        if (this.lastUseSearchPartsDialog != null && this.lastUseSearchPartsDialog.isDisplayable() && this.lastUseSearchPartsDialog.isVisible()) {
            this.lastUseSearchPartsDialog.requestFocus();
            return;
        }
        SearchPartsDialog searchPartsDlg = new SearchPartsDialog(this, this.characterData, this.partsSelectionManager);
        searchPartsDlg.adjustLocation(0);
        searchPartsDlg.setVisible(true);
        this.lastUseSearchPartsDialog = searchPartsDlg;
    }

    protected void closeSearchDialog() {
        this.lastUsePresetParts = null;
        for (SearchPartsDialog dlg : SearchPartsDialog.getDialogs()) {
            if (dlg == null || !dlg.isDisplayable() || dlg.getParent() != this) continue;
            dlg.dispose();
        }
    }

    protected void onCopy() {
        try {
            BufferedImage img = this.previewPane.getPreviewImage();
            if (img == null) {
                Toolkit tk = Toolkit.getDefaultToolkit();
                tk.beep();
                return;
            }
            Color imgBgColor = this.partsSelectionManager.getImageBgColor();
            ClipboardUtil.setImage(img, imgBgColor);
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected void onPreferences() {
        AppConfigDialog appConfigDlg = new AppConfigDialog(this);
        appConfigDlg.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onImportNew() {
        block6: {
            if (!this.characterData.isValid()) {
                Toolkit tk = Toolkit.getDefaultToolkit();
                tk.beep();
                return;
            }
            try {
                CharacterData cd;
                ImportWizardDialog importWizDialog = new ImportWizardDialog(this, null, null);
                importWizDialog.setVisible(true);
                int exitCode = importWizDialog.getExitCode();
                if (exitCode != 2 || (cd = importWizDialog.getImportedCharacterData()) == null || !cd.isValid()) break block6;
                this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    MainFrame mainFrame = ProfileListManager.openProfile(cd);
                    mainFrame.setVisible(true);
                }
                finally {
                    this.setCursor(Cursor.getDefaultCursor());
                }
            }
            catch (Exception ex) {
                ErrorMessageHelper.showErrorDialog(this, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onImport(List<File> initFiles) {
        if (!this.characterData.isValid()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return;
        }
        try {
            this.watchAgent.suspend();
            try {
                ImportWizardDialog importWizDialog = new ImportWizardDialog(this, this.characterData, initFiles);
                importWizDialog.setVisible(true);
                if (importWizDialog.getExitCode() == 1) {
                    CharacterData importedCd = importWizDialog.getImportedCharacterData();
                    MainFrame.notifyImportedPartsOrFavorites(this.characterData, importedCd, this);
                }
            }
            finally {
                this.watchAgent.resume();
            }
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected synchronized void reloadPartsAndFavorites(CharacterData newCd, boolean forceRepaint) throws IOException {
        if (newCd != null) {
            this.characterData.setDescription(newCd.getDescription());
        }
        if (!this.characterData.isPartsLoaded()) {
            ProfileListManager.loadCharacterData(this.characterData);
            ProfileListManager.loadFavorites(this.characterData);
            this.partsSelectionManager.loadParts();
        } else {
            if (this.characterData.reloadPartsData()) {
                this.partsSelectionManager.loadParts();
            }
            CharacterDataPersistent persiste = CharacterDataPersistent.getInstance();
            persiste.loadFavorites(this.characterData);
            MainFrame.notifyChangeFavorites(this.characterData);
        }
        if (this.showDefaultParts(false) || forceRepaint) {
            this.requestPreview();
        }
    }

    protected void onExport() {
        if (!this.characterData.isValid()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return;
        }
        ExportWizardDialog exportWizDlg = new ExportWizardDialog(this, this.characterData, this.previewPane.getPreviewImage());
        exportWizDlg.setVisible(true);
    }

    protected void onResetColor() {
        if (!this.characterData.isValid()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return;
        }
        Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
        if (JOptionPane.showConfirmDialog(this, strings.get("confirm.resetcolors"), strings.getProperty("confirm"), 0, 3) != 0) {
            return;
        }
        this.characterData.getPartsColorManager().resetPartsColorInfo();
        this.partsColorCoordinator.initColorDialog();
        this.requestPreview();
    }

    protected void onCloseProfile() {
        this.saveWorkingSet();
        ProfileListManager.unregisterUsedCharacterData(this.characterData);
        if (this.characterData.isValid()) {
            try {
                RecentDataPersistent recentPersist = RecentDataPersistent.getInstance();
                recentPersist.saveRecent(this.characterData);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "recent data saving failed.", ex);
            }
        }
        this.stopAgents();
        this.dispose();
        logger.log(Level.INFO, "dispose mainframe.");
    }

    public static void closeAllProfiles() {
        MainFrame mainFrame = activedMainFrame;
        SystemUtil.gc();
        for (Frame frame : JFrame.getFrames()) {
            try {
                if (!frame.isDisplayable() || !(frame instanceof MainFrame) || frame == mainFrame) continue;
                ((MainFrame)frame).onCloseProfile();
            }
            catch (Throwable ex) {
                logger.log(Level.SEVERE, "mainframe closing failed.", ex);
            }
        }
        if (activedMainFrame != null && activedMainFrame.isDisplayable()) {
            try {
                activedMainFrame.onCloseProfile();
            }
            catch (Throwable ex) {
                logger.log(Level.SEVERE, "mainframe closing failed.", ex);
            }
        }
    }

    protected UserData getWorkingSetUserData(boolean modeRead) {
        return MainFrame.getWorkingSetUserData(this.characterData, modeRead);
    }

    public static UserData getWorkingSetUserData(CharacterData cd, boolean modeRead) {
        if (cd == null || !cd.isValid()) {
            return null;
        }
        UserDataFactory userDataFactory = UserDataFactory.getInstance();
        return userDataFactory.getMangledNamedUserData(cd.getDocBase(), "workingset.ser");
    }

    protected void saveWorkingSet() {
        if (!this.characterData.isValid()) {
            return;
        }
        try {
            WorkingSet workingSet = new WorkingSet();
            workingSet.setCharacterDocBase(this.characterData.getDocBase());
            workingSet.setCharacterDataRev(this.characterData.getRev());
            PartsSet partsSet = this.partsSelectionManager.createPartsSet();
            workingSet.setPartsSet(partsSet);
            workingSet.setPartsColorInfoMap(this.characterData.getPartsColorManager().getPartsColorInfoMap());
            workingSet.setLastUsedSaveDir(this.imageSaveHelper.getLastUsedSaveDir());
            workingSet.setLastUsedExportDir(ExportWizardDialog.getLastUsedDir());
            workingSet.setLastUsePresetParts(this.lastUsePresetParts);
            workingSet.setCharacterData(this.characterData.duplicateBasicInfo(false));
            UserData workingSetStore = this.getWorkingSetUserData(false);
            workingSetStore.save(workingSet);
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected boolean loadWorkingSet() {
        if (!this.characterData.isValid()) {
            return false;
        }
        try {
            UserData workingSetStore = this.getWorkingSetUserData(true);
            if (workingSetStore != null && workingSetStore.exists()) {
                PartsSet partsSet;
                WorkingSet workingSet = (WorkingSet)workingSetStore.load();
                if (!this.characterData.getDocBase().equals(workingSet.getCharacterDocBase())) {
                    logger.info("workingset data mismatch:" + this.characterData);
                    return false;
                }
                CharacterData workingCd = workingSet.getCharacterData();
                if (workingCd == null) {
                    String docRev = this.characterData.getRev();
                    String workRev = workingSet.getCharacterDataRev();
                    if (docRev == null || workRev == null || !docRev.equals(workRev)) {
                        logger.info("workingset revision mismatch: actual=" + this.characterData + "/workingSet=" + workingSet);
                        return false;
                    }
                } else if (!workingCd.isUpperCompatibleStructure(this.characterData)) {
                    logger.info("workingset cd-structure mismatch: actual=" + this.characterData + "/workingSet=" + workingSet);
                    return false;
                }
                Map<PartsIdentifier, PartsColorInfo> partsColorInfoMap = this.characterData.getPartsColorManager().getPartsColorInfoMap();
                Map<PartsIdentifier, PartsColorInfo> workingPartsColorInfoMap = workingSet.getPartsColorInfoMap();
                if (workingPartsColorInfoMap != null) {
                    for (Map.Entry<PartsIdentifier, PartsColorInfo> entry : workingPartsColorInfoMap.entrySet()) {
                        PartsIdentifier partsIdentifier = entry.getKey();
                        PartsColorInfo partsColorInfo = entry.getValue();
                        partsColorInfoMap.put(partsIdentifier, partsColorInfo);
                    }
                }
                if ((partsSet = workingSet.getPartsSet()) != null) {
                    partsSet = partsSet.createCompatible(this.characterData);
                    this.selectPresetParts(partsSet);
                    PartsSet lastUsePresetParts = workingSet.getLastUsePresetParts();
                    if (lastUsePresetParts != null && lastUsePresetParts.hasName() && lastUsePresetParts.isSameStructure(partsSet)) {
                        this.lastUsePresetParts = lastUsePresetParts;
                        this.showPresetName(lastUsePresetParts);
                    }
                }
                this.imageSaveHelper.setLastUseSaveDir(workingSet.getLastUsedSaveDir());
                ExportWizardDialog.setLastUsedDir(workingSet.getLastUsedExportDir());
                return true;
            }
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
        return false;
    }

    protected void onAbout() {
        try {
            AboutBox aboutBox = new AboutBox(this);
            aboutBox.showAboutBox();
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected void onHelp() {
        Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
        String helpURL = strings.getProperty("help.url");
        String helpDescription = strings.getProperty("help.show");
        DesktopUtilities.browse(this, helpURL, helpDescription);
    }

    protected void onFlipHolizontal() {
        if (!this.characterData.isValid()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return;
        }
        double[] affineTransformParameter = this.partsSelectionManager.getAffineTransformParameter();
        if (affineTransformParameter == null) {
            Dimension siz = this.characterData.getImageSize();
            if (siz != null) {
                affineTransformParameter = new double[]{-1.0, 0.0, 0.0, 1.0, siz.width, 0.0};
            }
        } else {
            affineTransformParameter = null;
        }
        this.partsSelectionManager.setAffineTransformParameter(affineTransformParameter);
        this.requestPreview();
    }

    protected void onSetDefaultPicture() {
        if (!this.characterData.isValid()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return;
        }
        try {
            BufferedImage samplePicture = this.previewPane.getPreviewImage();
            if (samplePicture != null) {
                CharacterDataPersistent persist = CharacterDataPersistent.getInstance();
                persist.saveSamplePicture(this.characterData, samplePicture);
            }
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected void onInformation() {
        if (!this.characterData.isValid()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return;
        }
        PartsSet partsSet = this.partsSelectionManager.createPartsSet();
        InformationDialog infoDlg = new InformationDialog(this, this.characterData, partsSet);
        infoDlg.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onManageFavorites() {
        if (!this.characterData.isValid()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return;
        }
        this.refreshFavorites();
        ManageFavoriteDialog dlg = new ManageFavoriteDialog(this, this.characterData);
        dlg.setVisible(true);
        if (!dlg.isModified()) {
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                CharacterDataPersistent persiste = CharacterDataPersistent.getInstance();
                persiste.saveFavorites(this.characterData);
                MainFrame.notifyChangeFavorites(this.characterData);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshFavorites() {
        logger.log(Level.INFO, "refresh Favorites.: " + this.characterData);
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                CharacterDataPersistent persiste = CharacterDataPersistent.getInstance();
                this.characterData.clearPartsSets(true);
                persiste.loadFavorites(this.characterData);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "can't refresh favorites: " + this.characterData, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onRegisterFavorite() {
        if (!this.characterData.isValid()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return;
        }
        try {
            PartsSet partsSet = this.partsSelectionManager.createPartsSet();
            if (partsSet.isEmpty()) {
                return;
            }
            Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
            JCheckBox chkColorInfo = new JCheckBox(strings.getProperty("input.favoritesColorInfo"));
            chkColorInfo.setSelected(true);
            String initName = this.getSuggestPartsSetName(partsSet, false, "");
            String name = (String)JOptionPane.showInputDialog(this, chkColorInfo, strings.getProperty("input.favorites"), 3, null, null, initName);
            if (name == null || name.trim().length() == 0) {
                return;
            }
            boolean includeColorInfo = chkColorInfo.isSelected();
            if (!includeColorInfo) {
                partsSet.removeColorInfo();
            }
            String partsSetId = "ps" + UUID.randomUUID().toString();
            partsSet.setPartsSetId(partsSetId);
            partsSet.setLocalizedName(name);
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                CharacterDataPersistent persiste = CharacterDataPersistent.getInstance();
                this.characterData.clearPartsSets(true);
                persiste.loadFavorites(this.characterData);
                this.characterData.addPartsSet(partsSet);
                persiste.saveFavorites(this.characterData);
                MainFrame.notifyChangeFavorites(this.characterData);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
            this.lastUsePresetParts = partsSet;
            this.showPresetName(partsSet);
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected void onDeselectAll() {
        this.partsSelectionManager.deselectAll();
    }

    protected void onDeselectableAllCategory() {
        this.partsSelectionManager.setDeselectableSingleCategory(!this.partsSelectionManager.isDeselectableSingleCategory());
    }

    protected JMenuBar createMenuBar() {
        Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
        MenuDataFactory[] menus = new MenuDataFactory[]{new MenuDataFactory("menu.file", new MenuDataFactory[]{new MenuDataFactory("file.openProfile", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onOpenProfile();
            }
        }), new MenuDataFactory("file.savePicture", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onSavePicture();
            }
        }), null, new MenuDataFactory("file.editprofile", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onEditProfile();
            }
        }), new MenuDataFactory("file.opendir", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onBrowseProfileDir();
            }
        }), new MenuDataFactory("file.import", new MenuDataFactory[]{new MenuDataFactory("file.importMe", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onImport(null);
            }
        }), new MenuDataFactory("file.importNew", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onImportNew();
            }
        })}), new MenuDataFactory("file.export", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onExport();
            }
        }), new MenuDataFactory("file.manageParts", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onManageParts();
            }
        }), new MenuDataFactory("file.preferences", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onPreferences();
            }
        }), null, new MenuDataFactory("file.closeProfile", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onCloseProfile();
            }
        })}), new MenuDataFactory("menu.edit", new MenuDataFactory[]{new MenuDataFactory("edit.search", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.openSearchDialog();
            }
        }), new MenuDataFactory("edit.copy", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onCopy();
            }
        }), new MenuDataFactory("edit.flipHorizontal", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onFlipHolizontal();
            }
        }), new MenuDataFactory("edit.resetcolor", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onResetColor();
            }
        }), null, new MenuDataFactory("edit.setDefaultPicture", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onSetDefaultPicture();
            }
        }), new MenuDataFactory("edit.information", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onInformation();
            }
        }), null, new MenuDataFactory("edit.deselectall", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onDeselectAll();
            }
        }), new MenuDataFactory("edit.deselectparts", true, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onDeselectableAllCategory();
            }
        }), new MenuDataFactory("edit.enableAutoShrink", true, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onClickPartsCategoryTitle(null, true);
            }
        })}), new MenuDataFactory("menu.favorite", new MenuDataFactory[]{new MenuDataFactory("favorite.register", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onRegisterFavorite();
            }
        }), new MenuDataFactory("favorite.manage", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onManageFavorites();
            }
        }), null}), new MenuDataFactory("menu.help", new MenuDataFactory[]{new MenuDataFactory("help.recommendations", (ActionListener)null), null, new MenuDataFactory("help.help", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onHelp();
            }
        }), new MenuDataFactory("help.forum", DesktopUtilities.createBrowseAction(this, strings.getProperty("help.forum.url"), strings.getProperty("help.forum.description"))), new MenuDataFactory("help.bugreport", DesktopUtilities.createBrowseAction(this, strings.getProperty("help.reportbugs.url"), strings.getProperty("help.reportbugs.description"))), new MenuDataFactory("help.about", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.onAbout();
            }
        })})};
        final MenuBuilder menuBuilder = new MenuBuilder();
        JMenuBar menuBar = menuBuilder.createMenuBar(menus);
        menuBuilder.getJMenu("menu.edit").addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent e) {
            }

            public void menuDeselected(MenuEvent e) {
            }

            public void menuSelected(MenuEvent e) {
                menuBuilder.getJMenuItem("edit.copy").setEnabled(MainFrame.this.previewPane.getPreviewImage() != null);
                menuBuilder.getJMenuItem("edit.deselectparts").setSelected(MainFrame.this.partsSelectionManager.isDeselectableSingleCategory());
                menuBuilder.getJMenuItem("edit.enableAutoShrink").setSelected(MainFrame.this.minimizeMode);
            }
        });
        final JMenu mnuFavorites = menuBuilder.getJMenu("menu.favorite");
        mnuFavorites.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent e) {
            }

            public void menuDeselected(MenuEvent e) {
            }

            public void menuSelected(MenuEvent e) {
                MainFrame.this.onSelectedFavoriteMenu(mnuFavorites);
            }
        });
        if (System.getProperty("java.version").startsWith("1.5")) {
            menuBuilder.getJMenuItem("file.opendir").setEnabled(false);
        }
        final JMenu mnuRecomendation = menuBuilder.getJMenu("help.recommendations");
        JMenu mnuHelp = menuBuilder.getJMenu("menu.help");
        mnuHelp.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent e) {
            }

            public void menuDeselected(MenuEvent e) {
            }

            public void menuSelected(MenuEvent e) {
                MainFrame.this.onSelectedRecommendationMenu(mnuRecomendation);
            }
        });
        return menuBar;
    }
}

