/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.AppConfig;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

class PreviewImagePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Color bgColor;
    private BufferedImage previewImg;

    public PreviewImagePanel() {
        AppConfig appConfig = AppConfig.getInstance();
        this.bgColor = appConfig.getDefaultImageBgColor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.previewImg != null) {
            int client_w = this.getWidth();
            int client_h = this.getHeight();
            Color oldc = g.getColor();
            try {
                g.setColor(this.bgColor);
                g.fillRect(0, 0, client_w, client_h);
            }
            finally {
                g.setColor(oldc);
            }
            int w = this.previewImg.getWidth();
            int h = this.previewImg.getHeight();
            int offset_x = 0;
            if (w < client_w) {
                offset_x = (client_w - w) / 2;
            }
            int offset_y = 0;
            if (h < client_h) {
                offset_y = (client_h - h) / 2;
            }
            g.drawImage(this.previewImg, offset_x, offset_y, offset_x + w, offset_y + h, 0, 0, w, h, null);
        }
    }

    public void setPreviewImage(BufferedImage previewImg) {
        this.previewImg = previewImg;
        if (previewImg != null) {
            int w = previewImg.getWidth();
            int h = previewImg.getHeight();
            this.setPreferredSize(new Dimension(w, h));
            this.revalidate();
        }
        this.repaint();
    }

    public BufferedImage getPreviewImage() {
        return this.previewImg;
    }

    public void setImageBgColor(Color bgColor) {
        if (bgColor == null) {
            return;
        }
        if (this.bgColor != bgColor) {
            this.bgColor = bgColor;
            this.repaint();
        }
    }

    public Color getImageBgColor() {
        return this.bgColor;
    }
}

