/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.AppConfig;
import charactermanaj.ui.PreviewImagePanel;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import charactermanaj.util.UIHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.Timer;

public class PreviewPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected static final String STRINGS_RESOURCE = "languages/previewpanel";
    private final long indicatorDelay;
    private final String indicatorText;
    private final Timer timer = new Timer(100, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            PreviewPanel.this.onTimer();
        }
    });
    private final Object lock = new Object();
    private long loadingTicket;
    private long loadedTicket;
    private long firstWaitingTimestamp;
    private boolean indicatorShown;
    private String title;
    private JLabel lblTitle;
    private PreviewImagePanel previewImgPanel;
    private LinkedList<PreviewPanelListener> listeners = new LinkedList();

    public void addNotify() {
        super.addNotify();
        if (!this.timer.isRunning()) {
            this.timer.start();
        }
    }

    public void removeNotify() {
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        super.removeNotify();
    }

    public PreviewPanel() {
        this.setLayout(new BorderLayout());
        AppConfig appConfig = AppConfig.getInstance();
        Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
        this.indicatorText = strings.getProperty("indicatorText");
        this.indicatorDelay = appConfig.getPreviewIndicatorDelay();
        UIHelper uiUtl = UIHelper.getInstance();
        JButton saveBtn = uiUtl.createIconButton("icons/save.png");
        JButton copyBtn = uiUtl.createIconButton("icons/copy.png");
        JButton colorBtn = uiUtl.createIconButton("icons/color.png");
        JButton informationBtn = uiUtl.createIconButton("icons/information.png");
        JButton favoriteBtn = uiUtl.createIconButton("icons/favorite.png");
        JButton flipHolizontalBtn = uiUtl.createIconButton("icons/flip.png");
        saveBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreviewPanel.this.savePicture(new PreviewPanelEvent(PreviewPanel.this));
            }
        });
        copyBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreviewPanel.this.copyPicture(new PreviewPanelEvent(PreviewPanel.this));
            }
        });
        colorBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreviewPanel.this.changeBackgroundColor(new PreviewPanelEvent(PreviewPanel.this));
            }
        });
        informationBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreviewPanel.this.showInformation(new PreviewPanelEvent(PreviewPanel.this));
            }
        });
        favoriteBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreviewPanel.this.addFavorite(new PreviewPanelEvent(PreviewPanel.this));
            }
        });
        flipHolizontalBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreviewPanel.this.flipHolizontal(new PreviewPanelEvent(PreviewPanel.this));
            }
        });
        saveBtn.setToolTipText(strings.getProperty("tooltip.save"));
        copyBtn.setToolTipText(strings.getProperty("tooltip.copy"));
        colorBtn.setToolTipText(strings.getProperty("tooltip.changeBgColor"));
        informationBtn.setToolTipText(strings.getProperty("tooltip.showInformation"));
        favoriteBtn.setToolTipText(strings.getProperty("tooltip.registerFavorites"));
        flipHolizontalBtn.setToolTipText(strings.getProperty("tooltip.flipHorizontal"));
        final JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.add(flipHolizontalBtn);
        toolBar.add(copyBtn);
        toolBar.add(saveBtn);
        toolBar.add(Box.createHorizontalStrut(8));
        toolBar.add(colorBtn);
        toolBar.add(Box.createHorizontalStrut(4));
        toolBar.add(favoriteBtn);
        toolBar.add(informationBtn);
        this.lblTitle = new JLabel(){
            private static final long serialVersionUID = 1L;

            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                int maxWidth = this.getParent().getWidth() - toolBar.getWidth();
                if (dim.width > maxWidth) {
                    dim.width = maxWidth;
                }
                return dim;
            }

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            public Dimension getMinimumSize() {
                Dimension dim = this.getPreferredSize();
                dim.width = 50;
                return dim;
            }
        };
        this.lblTitle.setBorder(BorderFactory.createEmptyBorder(3, 10, 3, 3));
        JPanel previewPaneHeader = new JPanel();
        previewPaneHeader.setLayout(new BorderLayout());
        previewPaneHeader.add((Component)this.lblTitle, "West");
        previewPaneHeader.add((Component)toolBar, "East");
        this.previewImgPanel = new PreviewImagePanel();
        JScrollPane sp2 = new JScrollPane(this.previewImgPanel);
        sp2.setAutoscrolls(false);
        sp2.setVerticalScrollBarPolicy(22);
        sp2.setHorizontalScrollBarPolicy(32);
        this.add((Component)previewPaneHeader, "North");
        this.add((Component)sp2, "Center");
    }

    public void setTitle(String title) {
        if (title == null) {
            title = "";
        }
        if (!title.equals(this.title)) {
            this.title = title;
            this.lblTitle.setText(title + (this.indicatorShown ? this.indicatorText : ""));
            this.lblTitle.setToolTipText(title);
        }
    }

    public String getTitle() {
        return this.title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onTimer() {
        boolean indicatorShown;
        long firstRequest;
        boolean waiting;
        Object object = this.lock;
        synchronized (object) {
            waiting = this.loadingTicket > this.loadedTicket;
            firstRequest = this.firstWaitingTimestamp;
        }
        boolean bl = indicatorShown = waiting && System.currentTimeMillis() - firstRequest > this.indicatorDelay;
        if (this.indicatorShown != indicatorShown) {
            this.indicatorShown = indicatorShown;
            this.lblTitle.setText(this.title + (indicatorShown ? this.indicatorText : ""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoadingRequest(long ticket) {
        Object object = this.lock;
        synchronized (object) {
            if (this.loadingTicket <= this.loadedTicket) {
                this.firstWaitingTimestamp = System.currentTimeMillis();
            }
            this.loadingTicket = ticket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoadingComplete(long ticket) {
        Object object = this.lock;
        synchronized (object) {
            this.loadedTicket = ticket;
        }
    }

    public void setPreviewImage(BufferedImage previewImg) {
        this.previewImgPanel.setPreviewImage(previewImg);
    }

    public BufferedImage getPreviewImage() {
        return this.previewImgPanel.getPreviewImage();
    }

    public Color getImageBgColor() {
        return this.previewImgPanel.getImageBgColor();
    }

    public void setImageBgColor(Color bgColor) {
        this.previewImgPanel.setImageBgColor(bgColor);
    }

    public void addPreviewPanelListener(PreviewPanelListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.listeners.add(listener);
    }

    public void removePreviewPanelListener(PreviewPanelListener listener) {
        this.listeners.remove(listener);
    }

    protected void savePicture(PreviewPanelEvent e) {
        for (PreviewPanelListener listener : this.listeners) {
            listener.savePicture(e);
        }
    }

    protected void flipHolizontal(PreviewPanelEvent e) {
        for (PreviewPanelListener listener : this.listeners) {
            listener.flipHorizontal(e);
        }
    }

    protected void copyPicture(PreviewPanelEvent e) {
        for (PreviewPanelListener listener : this.listeners) {
            listener.copyPicture(e);
        }
    }

    protected void changeBackgroundColor(PreviewPanelEvent e) {
        for (PreviewPanelListener listener : this.listeners) {
            listener.changeBackgroundColor(e);
        }
    }

    protected void showInformation(PreviewPanelEvent e) {
        for (PreviewPanelListener listener : this.listeners) {
            listener.showInformation(e);
        }
    }

    protected void addFavorite(PreviewPanelEvent e) {
        for (PreviewPanelListener listener : this.listeners) {
            listener.addFavorite(e);
        }
    }

    public static class PreviewPanelEvent
    extends EventObject {
        private static final long serialVersionUID = 1L;

        public PreviewPanelEvent(Object src) {
            super(src);
        }
    }

    public static interface PreviewPanelListener {
        public void savePicture(PreviewPanelEvent var1);

        public void copyPicture(PreviewPanelEvent var1);

        public void changeBackgroundColor(PreviewPanelEvent var1);

        public void showInformation(PreviewPanelEvent var1);

        public void addFavorite(PreviewPanelEvent var1);

        public void flipHorizontal(PreviewPanelEvent var1);
    }
}

