/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj;

import charactermanaj.clipboardSupport.ImageSelection;
import charactermanaj.graphics.io.ImageCacheMBeanImpl;
import charactermanaj.model.AppConfig;
import charactermanaj.model.util.StartupSupport;
import charactermanaj.ui.MainFrame;
import charactermanaj.ui.MainFramePartialForMacOSX9;
import charactermanaj.ui.ProfileListManager;
import charactermanaj.ui.SelectCharatersDirDialog;
import charactermanaj.util.AWTExceptionLoggingHandler;
import charactermanaj.util.ApplicationLoggerConfigurator;
import charactermanaj.util.ConfigurationDirUtilities;
import charactermanaj.util.DirectoryConfig;
import charactermanaj.util.ErrorMessageHelper;
import charactermanaj.util.FileNameNormalizer;
import charactermanaj.util.JavaVersionUtils;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public final class Main
implements Runnable {
    private static final Logger logger = Logger.getLogger(Main.class.getName());
    private static final boolean isMacOSX;
    private static final boolean isLinux;

    static {
        String lcOS = System.getProperty("os.name").toLowerCase();
        isMacOSX = lcOS.startsWith("mac os x");
        isLinux = lcOS.indexOf("linux") >= 0;
    }

    private static void initLogger() {
        try {
            ApplicationLoggerConfigurator.configure();
            if (JavaVersionUtils.getJavaVersion() >= 1.7) {
                final AWTExceptionLoggingHandler logHandler = new AWTExceptionLoggingHandler();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        final Thread.UncaughtExceptionHandler handler = Thread.getDefaultUncaughtExceptionHandler();
                        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                            @Override
                            public void uncaughtException(Thread t, Throwable ex) {
                                logHandler.handle(ex);
                                if (handler != null) {
                                    handler.uncaughtException(t, ex);
                                }
                            }
                        });
                    }
                });
            } else {
                System.setProperty("sun.awt.exception.handler", AWTExceptionLoggingHandler.class.getName());
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            logger.log(Level.SEVERE, "logger initiation failed. " + ex, ex);
        }
    }

    private static void setupUIManager(AppConfig appConfig) throws Exception {
        if (Main.isMacOSX()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "CharacterManaJ");
            if (JavaVersionUtils.getJavaVersion() >= 1.7) {
                FileNameNormalizer.setupNFCNormalizer();
            }
        }
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        UIManager.put("Slider.paintValue", Boolean.FALSE);
        TreeSet<String> availablePriorityFontSets = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties("menu/menu");
        HashSet<Integer> useCodePoints = new HashSet<Integer>();
        Enumeration<?> enmStrings = strings.propertyNames();
        while (enmStrings.hasMoreElements()) {
            String propertyName = (String)enmStrings.nextElement();
            String propertyValue = strings.getProperty(propertyName);
            int len = propertyValue.length();
            int idx = 0;
            while (idx < len) {
                int codepoint = propertyValue.codePointAt(idx);
                useCodePoints.add(codepoint);
                idx += Character.charCount(codepoint);
            }
        }
        String selectedFontFamily = null;
        String fontPriorityStr = appConfig.getFontPriority();
        if (fontPriorityStr.trim().length() > 0) {
            String[] fontPriority = fontPriorityStr.split(",");
            String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames(Locale.ENGLISH);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String availableFontFamily = stringArray[n2];
                String[] stringArray2 = fontPriority;
                int n3 = fontPriority.length;
                int n4 = 0;
                while (n4 < n3) {
                    String fontFamily = stringArray2[n4];
                    if ((fontFamily = fontFamily.trim()).length() > 0 && availableFontFamily.equalsIgnoreCase(fontFamily)) {
                        Font font = Font.decode(availableFontFamily);
                        logger.log(Level.INFO, "\u5b9f\u5728\u3059\u308b\u30d5\u30a9\u30f3\u30c8\u306e\u78ba\u8a8d:" + availableFontFamily);
                        boolean canDisplay = false;
                        for (Integer codepoint : useCodePoints) {
                            canDisplay = font.canDisplay(codepoint);
                            if (canDisplay) continue;
                            logger.log(Level.INFO, "\u3053\u306e\u30d5\u30a9\u30f3\u30c8\u306f\u30e1\u30cb\u30e5\u30fc\u8868\u793a\u306b\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093: " + selectedFontFamily + "/codepoint=0x" + Integer.toHexString(codepoint));
                            break;
                        }
                        if (canDisplay) {
                            if (selectedFontFamily == null) {
                                selectedFontFamily = availableFontFamily;
                            }
                            availablePriorityFontSets.add(fontFamily);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
            if (selectedFontFamily == null) {
                selectedFontFamily = "Dialog";
            }
        }
        int defFontSize = appConfig.getDefaultFontSize();
        for (Map.Entry entry : UIManager.getDefaults().entrySet()) {
            Object key = entry.getKey();
            Object val = UIManager.get(key);
            if (!(val instanceof FontUIResource)) continue;
            FontUIResource fontUIResource = (FontUIResource)val;
            int fontSize = fontUIResource.getSize();
            String fontFamily = fontUIResource.getFamily();
            if (defFontSize > 0) {
                fontSize = defFontSize;
            }
            if (selectedFontFamily != null && !availablePriorityFontSets.contains(fontFamily)) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "UIDefaultFont: " + key + "= " + fontFamily + " -> " + selectedFontFamily);
                }
                fontFamily = selectedFontFamily;
            }
            fontUIResource = new FontUIResource(fontFamily, fontUIResource.getStyle(), fontSize);
            UIManager.put(entry.getKey(), fontUIResource);
        }
    }

    @Override
    public void run() {
        try {
            File defaultCharacterDir;
            File charsDir;
            AppConfig appConfig = AppConfig.getInstance();
            appConfig.loadConfig();
            try {
                Main.setupUIManager(appConfig);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                logger.log(Level.WARNING, "UIManager setup failed.", ex);
            }
            if (!ImageSelection.setupSystemFlavorMap()) {
                logger.log(Level.WARNING, "failed to set the clipboard-support.");
            }
            int[] versions = JavaVersionUtils.getJavaVersions();
            if (Main.isMacOSX() && versions[0] == 1 && versions[1] == 7 && versions[3] < 60) {
                String lang = System.getenv("LANG");
                String lcctype = System.getenv("LC_CTYPE");
                if (!(lang != null && lang.trim().length() != 0 || lcctype != null && lcctype.trim().length() != 0)) {
                    JOptionPane.showMessageDialog(null, "\"LANG\" or \"LC_CTYPE\" environment variable must be set.", "Configuration Error", 0);
                }
            }
            File currentCharacterDir = null;
            String charactersDir = System.getProperty("charactersDir");
            if (charactersDir != null && charactersDir.length() > 0 && (charsDir = new File(charactersDir)).exists() && charsDir.isDirectory()) {
                currentCharacterDir = charsDir;
            }
            if (currentCharacterDir == null && (currentCharacterDir = SelectCharatersDirDialog.getCharacterDir(defaultCharacterDir = ConfigurationDirUtilities.getDefaultCharactersDir())) == null) {
                logger.info("luncher canceled.");
                return;
            }
            DirectoryConfig.getInstance().setCharactersDir(currentCharacterDir);
            StartupSupport.getInstance().doStartup();
            MainFrame mainFrame = ProfileListManager.openDefaultProfile();
            if (Main.isMacOSX()) {
                try {
                    if (JavaVersionUtils.getJavaVersion() >= 9.0) {
                        MainFramePartialForMacOSX9.setupScreenMenu(mainFrame);
                    } else {
                        Class<?> clz = Class.forName("charactermanaj.ui.MainFramePartialForMacOSX");
                        Method mtd = clz.getMethod("setupScreenMenu", MainFrame.class);
                        mtd.invoke(null, mainFrame);
                    }
                }
                catch (Throwable ex) {
                    logger.log(Level.CONFIG, "Failed to setup the screen menu.", ex);
                }
            }
            mainFrame.showMainFrame();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            logger.log(Level.SEVERE, "Application initiation failed.", ex);
            ErrorMessageHelper.showErrorDialog(null, ex);
            MainFrame.closeAllProfiles();
        }
    }

    public static void main(String[] args) {
        Main.initLogger();
        try {
            ImageCacheMBeanImpl.setupMBean();
        }
        catch (JMException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        SwingUtilities.invokeLater(new Main());
    }

    public static boolean isMacOSX() {
        return isMacOSX;
    }

    public static boolean isLinuxOrMacOSX() {
        return isLinux || isMacOSX;
    }
}

