/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics;

import charactermanaj.graphics.ColorConvertedImageCachedLoader;
import charactermanaj.graphics.ImageBuildPartsInfo;
import charactermanaj.graphics.colormodel.ColorModels;
import charactermanaj.graphics.filters.ColorConvertParameter;
import charactermanaj.graphics.io.ImageResource;
import charactermanaj.graphics.io.LoadedImage;
import charactermanaj.model.AppConfig;
import charactermanaj.model.Layer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class ImageBuilder {
    private static final int MAX_TIMEOUT = 20;
    private ColorConvertedImageCachedLoader imageLoader;
    private ImageBuildInfo lastUsedImageBuildInfo;

    public ImageBuilder(ColorConvertedImageCachedLoader imageLoader) {
        if (imageLoader == null) {
            throw new IllegalArgumentException();
        }
        this.imageLoader = imageLoader;
    }

    protected ImageBuildInfo getPartsInfo(ImageBuildJob imageBuildJob) throws IOException, InterruptedException {
        final ImageBuildInfo imageBuildInfo = new ImageBuildInfo();
        final Semaphore compliteLock = new Semaphore(0);
        imageBuildJob.loadParts(new ImageSourceCollector(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSize(Dimension size) {
                ImageBuildInfo imageBuildInfo2 = imageBuildInfo;
                synchronized (imageBuildInfo2) {
                    imageBuildInfo.setRect(size.width, size.height);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setImageBgColor(Color color) {
                ImageBuildInfo imageBuildInfo2 = imageBuildInfo;
                synchronized (imageBuildInfo2) {
                    imageBuildInfo.setImageBgColor(color);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAffineTramsform(double[] param) {
                if (param != null && param.length != 4 && param.length != 6) {
                    throw new IllegalArgumentException("affineTransformParameter invalid length.");
                }
                ImageBuildInfo imageBuildInfo2 = imageBuildInfo;
                synchronized (imageBuildInfo2) {
                    imageBuildInfo.setAffineParamHolder(param);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setImageSource(Layer layer, ImageResource imageResource, ColorConvertParameter param) {
                ImageBuildInfo imageBuildInfo2 = imageBuildInfo;
                synchronized (imageBuildInfo2) {
                    imageBuildInfo.add(new ImageBuildPartsInfo(imageBuildInfo.getPartsCount(), layer, imageResource, param));
                }
            }

            @Override
            public void setComplite() {
                compliteLock.release();
            }
        });
        if (!compliteLock.tryAcquire(20L, TimeUnit.SECONDS)) {
            throw new RuntimeException("ImageCollector Timeout.");
        }
        return imageBuildInfo;
    }

    protected void buildImage(ImageBuildInfo imageBuildInfo) throws IOException {
        BufferedImage affineTransformedCanvas;
        int w = imageBuildInfo.getRct().width;
        int h = imageBuildInfo.getRct().height;
        BufferedImage canvas = new BufferedImage(w, h, 2);
        Graphics2D g = (Graphics2D)canvas.getGraphics();
        try {
            AppConfig appConfig = AppConfig.getInstance();
            if (appConfig.isEnableRenderingHints()) {
                g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                g.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
                g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            }
            this.imageLoader.unlockImages();
            for (ImageBuildPartsInfo partsInfo : imageBuildInfo.getPartsInfos()) {
                ImageResource imageFile = partsInfo.getFile();
                ColorConvertParameter colorConvParam = partsInfo.getColorParam();
                Layer layer = partsInfo.getLayer();
                String colorModelName = layer.getColorModelName();
                ColorModels colorModel = ColorModels.safeValueOf(colorModelName);
                LoadedImage loadedImage = this.imageLoader.load(imageFile, colorConvParam, colorModel);
                imageBuildInfo.addUsedPartsInfo(partsInfo, loadedImage);
                BufferedImage img = loadedImage.getImage();
                g.drawImage(img, 0, 0, w, h, 0, 0, w, h, null);
            }
        }
        finally {
            g.dispose();
        }
        double[] affineTransformParameter = imageBuildInfo.getAffineParamHolder();
        if (affineTransformParameter == null || affineTransformParameter.length != 6) {
            affineTransformedCanvas = canvas;
        } else {
            AffineTransform affineTransform = new AffineTransform(affineTransformParameter);
            AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
            affineTransformedCanvas = new BufferedImage(w, h, 2);
            affineTransformOp.filter(canvas, affineTransformedCanvas);
        }
        imageBuildInfo.setCanvas(affineTransformedCanvas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestJob(ImageBuildJob imageBuildJob) {
        ImageBuildInfo imageBuildInfo;
        if (imageBuildJob == null) {
            throw new IllegalArgumentException();
        }
        try {
            imageBuildInfo = this.getPartsInfo(imageBuildJob);
        }
        catch (Throwable ex) {
            imageBuildJob.handleException(ex);
            return false;
        }
        try {
            ImageBuildInfo ex = imageBuildInfo;
            synchronized (ex) {
                BufferedImage canvas;
                if (imageBuildInfo.isAlreadyLoaded(this.lastUsedImageBuildInfo)) {
                    canvas = this.lastUsedImageBuildInfo.getCanvas();
                } else {
                    this.buildImage(imageBuildInfo);
                    canvas = imageBuildInfo.getCanvas();
                    this.lastUsedImageBuildInfo = imageBuildInfo;
                }
                imageBuildJob.buildImage(new ImageOutput(){

                    @Override
                    public BufferedImage getImageOutput() {
                        return canvas;
                    }

                    @Override
                    public Color getImageBgColor() {
                        return imageBuildInfo.getImageBgColor();
                    }
                });
            }
        }
        catch (Throwable ex) {
            imageBuildJob.handleException(ex);
            return false;
        }
        return true;
    }

    private static final class BuildedPartsInfo {
        private final ImageBuildPartsInfo partsInfo;
        private final long lastModified;

        public BuildedPartsInfo(ImageBuildPartsInfo partsInfo, LoadedImage loadedImage) {
            this.partsInfo = partsInfo;
            this.lastModified = loadedImage.getLastModified();
        }

        public ImageBuildPartsInfo getPartsInfo() {
            return this.partsInfo;
        }

        public long getLastModified() {
            return this.lastModified;
        }
    }

    private static final class ImageBuildInfo {
        private ArrayList<ImageBuildPartsInfo> partsInfos = new ArrayList();
        private ArrayList<BuildedPartsInfo> buildPartsInfos = new ArrayList();
        private BufferedImage canvas;
        private Rectangle rct = new Rectangle(0, 0, 0, 0);
        private Color imageBgColor;
        private double[] affineParamHolder;
        private boolean sorted;

        private ImageBuildInfo() {
        }

        public int hashCode() {
            return this.partsInfos.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof ImageBuildInfo) {
                ImageBuildInfo other = (ImageBuildInfo)obj;
                if (!this.getPartsInfos().equals(other.getPartsInfos())) {
                    return false;
                }
                if (!this.rct.equals(other.rct)) {
                    return false;
                }
                if (this.imageBgColor == null ? other.imageBgColor != null : !this.imageBgColor.equals(other.imageBgColor)) {
                    return false;
                }
                return !(this.affineParamHolder == null ? other.affineParamHolder != null : !Arrays.equals(this.affineParamHolder, other.affineParamHolder));
            }
            return false;
        }

        public boolean isAlreadyLoaded(ImageBuildInfo usedInfo) {
            int mxUsed;
            if (usedInfo == null || usedInfo.getCanvas() == null) {
                return false;
            }
            if (!usedInfo.equals(this)) {
                return false;
            }
            int mx = this.partsInfos.size();
            if (mx != (mxUsed = usedInfo.buildPartsInfos.size())) {
                return false;
            }
            int idx = 0;
            while (idx < mx) {
                BuildedPartsInfo buildedPartsInfo;
                ImageBuildPartsInfo partsInfo = this.partsInfos.get(idx);
                if (!partsInfo.equals((buildedPartsInfo = usedInfo.buildPartsInfos.get(idx)).getPartsInfo())) {
                    return false;
                }
                long lastModified = partsInfo.getFile().lastModified();
                if (lastModified != buildedPartsInfo.getLastModified()) {
                    return false;
                }
                ++idx;
            }
            return true;
        }

        public void addUsedPartsInfo(ImageBuildPartsInfo partsInfo, LoadedImage loadedImage) {
            this.buildPartsInfos.add(new BuildedPartsInfo(partsInfo, loadedImage));
        }

        public BufferedImage getCanvas() {
            return this.canvas;
        }

        public void setCanvas(BufferedImage canvas) {
            this.canvas = canvas;
        }

        public double[] getAffineParamHolder() {
            return this.affineParamHolder;
        }

        public void setAffineParamHolder(double[] affineParamHolder) {
            this.affineParamHolder = affineParamHolder;
        }

        public Color getImageBgColor() {
            return this.imageBgColor;
        }

        public void setImageBgColor(Color imageBgColor) {
            this.imageBgColor = imageBgColor;
        }

        public Rectangle getRct() {
            return this.rct;
        }

        public void setRect(int w, int h) {
            this.rct.width = w;
            this.rct.height = h;
        }

        public List<ImageBuildPartsInfo> getPartsInfos() {
            if (!this.sorted) {
                Collections.sort(this.partsInfos);
                this.sorted = true;
            }
            return Collections.unmodifiableList(this.partsInfos);
        }

        public void add(ImageBuildPartsInfo imageBuildPartsInfo) {
            this.sorted = false;
            this.partsInfos.add(imageBuildPartsInfo);
        }

        public int getPartsCount() {
            return this.partsInfos.size();
        }
    }

    public static interface ImageBuildJob {
        public void loadParts(ImageSourceCollector var1) throws IOException;

        public void buildImage(ImageOutput var1);

        public void handleException(Throwable var1);
    }

    public static interface ImageOutput {
        public Color getImageBgColor();

        public BufferedImage getImageOutput();
    }

    public static interface ImageSourceCollector {
        public void setSize(Dimension var1);

        public void setImageBgColor(Color var1);

        public void setAffineTramsform(double[] var1);

        public void setImageSource(Layer var1, ImageResource var2, ColorConvertParameter var3);

        public void setComplite();
    }
}

