/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics.filters;

import charactermanaj.graphics.colormodel.ColorModel;
import charactermanaj.graphics.filters.AbstractFilter;
import charactermanaj.graphics.filters.ContrastTableFactory;
import charactermanaj.graphics.filters.GammaTableFactory;

public class ColorConvertFilter
extends AbstractFilter {
    private final ColorModel colorModel;
    private final ColorReplace colorReplace;
    private final float[] hsbOffsets;
    private final float grayLevel;
    private final int[][] gammaTbl;
    private final int[][] contrastTbl;

    public ColorConvertFilter(ColorModel colorModel, ColorReplace colorReplace, float[] hsbOffsets, float grayLevel, GammaTableFactory gammaTableFactory, ContrastTableFactory contrastTableFactory) {
        if (colorModel == null) {
            throw new IllegalArgumentException();
        }
        this.colorModel = colorModel;
        if (gammaTableFactory == null) {
            gammaTableFactory = new GammaTableFactory(1.0f);
        }
        if (contrastTableFactory == null) {
            contrastTableFactory = new ContrastTableFactory(1.0f);
        }
        if (hsbOffsets != null && ((float[])hsbOffsets).length < 3) {
            throw new IllegalArgumentException("hsbOffset too short.");
        }
        if (hsbOffsets != null) {
            hsbOffsets = hsbOffsets[0] == 0.0f && hsbOffsets[1] == 0.0f && hsbOffsets[2] == 0.0f ? null : (float[])hsbOffsets.clone();
        }
        if (grayLevel < 0.0f) {
            grayLevel = 0.0f;
        } else if (grayLevel > 1.0f) {
            grayLevel = 1.0f;
        }
        this.grayLevel = grayLevel;
        this.gammaTbl = gammaTableFactory.createTable();
        this.contrastTbl = contrastTableFactory.createTable();
        this.hsbOffsets = hsbOffsets;
        this.colorReplace = colorReplace;
    }

    @Override
    protected void filter(int[] pixcels) {
        float grayLevel = this.grayLevel;
        float negGrayLevel = 1.0f - grayLevel;
        int[] precalc = new int[256];
        int[] negPrecalc = new int[256];
        int i = 0;
        while (i < 256) {
            precalc[i] = (int)((float)i * grayLevel) & 0xFF;
            negPrecalc[i] = (int)((float)i * negGrayLevel) & 0xFF;
            ++i;
        }
        ColorReplace colorReplace = this.colorReplace;
        int[] rgbvals = new int[3];
        float[] hsbOffsets = this.hsbOffsets;
        float[] hsvvals = new float[3];
        int[][] gammaTbl = this.gammaTbl;
        int mx = pixcels.length;
        int i2 = 0;
        while (i2 < mx) {
            int argb = pixcels[i2];
            int a = gammaTbl[0][argb >> 24 & 0xFF];
            int r = gammaTbl[1][argb >> 16 & 0xFF];
            int g = gammaTbl[2][argb >> 8 & 0xFF];
            int b = gammaTbl[3][argb & 0xFF];
            if (colorReplace != null) {
                rgbvals[0] = r;
                rgbvals[1] = g;
                rgbvals[2] = b;
                colorReplace.convert(rgbvals);
                r = rgbvals[0];
                g = rgbvals[1];
                b = rgbvals[2];
            }
            int br = 77 * r + 150 * g + 29 * b >> 8 & 0xFF;
            r = precalc[r] + negPrecalc[br] & 0xFF;
            g = precalc[g] + negPrecalc[br] & 0xFF;
            b = precalc[b] + negPrecalc[br] & 0xFF;
            if (hsbOffsets != null) {
                this.colorModel.RGBtoHSV(r, g, b, hsvvals);
                int l = 0;
                while (l < 3) {
                    int n = l;
                    hsvvals[n] = hsvvals[n] + hsbOffsets[l];
                    ++l;
                }
                l = 1;
                while (l < 3) {
                    if (hsvvals[l] < 0.0f) {
                        hsvvals[l] = 0.0f;
                    } else if (hsvvals[l] > 1.0f) {
                        hsvvals[l] = 1.0f;
                    }
                    ++l;
                }
                int rgb = this.colorModel.HSVtoRGB(hsvvals[0], hsvvals[1], hsvvals[2]);
                r = rgb >> 16 & 0xFF;
                g = rgb >> 8 & 0xFF;
                b = rgb & 0xFF;
            }
            r = this.contrastTbl[0][r];
            g = this.contrastTbl[1][g];
            b = this.contrastTbl[2][b];
            pixcels[i2] = argb = a << 24 | r << 16 | g << 8 | b;
            ++i2;
        }
    }

    public static interface ColorReplace {
        public void convert(int[] var1);
    }
}

