/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model;

import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsCategoryResolver;
import charactermanaj.model.PartsColorInfo;
import charactermanaj.model.PartsIdentifier;
import java.awt.Color;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class PartsSet
extends AbstractMap<PartsCategory, List<PartsIdentifier>>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 5972528889825451761L;
    public static final Comparator<PartsSet> DEFAULT_COMPARATOR = new Comparator<PartsSet>(){

        @Override
        public int compare(PartsSet o1, PartsSet o2) {
            int ret = o1.getLocalizedName().compareTo(o2.getLocalizedName());
            if (ret == 0) {
                ret = o1.getPartsSetId().compareTo(o2.getPartsSetId());
            }
            if (ret == 0) {
                ret = o1.hashCode() - o2.hashCode();
            }
            return ret;
        }
    };
    private String partsSetId;
    private String localizedName;
    private boolean presetParts;
    private Color bgColor;
    private double[] affineTransformParameter;
    private HashMap<PartsCategory, List<PartsIdentifier>> parts = new HashMap();
    private HashMap<PartsIdentifier, PartsColorInfo> partsColorInfoMap = new HashMap();

    public PartsSet() {
        this(null, null, false);
    }

    public PartsSet(String partsSetId, String localizedName, boolean presetParts) {
        this.partsSetId = partsSetId;
        this.localizedName = localizedName;
        this.presetParts = presetParts;
    }

    protected PartsSet(PartsSet org, PartsCategoryResolver resolver) {
        PartsCategory repPartsCategory;
        if (org == null) {
            throw new IllegalArgumentException();
        }
        this.partsSetId = org.partsSetId;
        this.localizedName = org.localizedName;
        this.presetParts = org.presetParts;
        this.bgColor = org.bgColor;
        this.affineTransformParameter = org.affineTransformParameter == null ? null : (double[])org.affineTransformParameter.clone();
        for (Map.Entry<PartsIdentifier, PartsColorInfo> entry : org.partsColorInfoMap.entrySet()) {
            PartsIdentifier partsIdentifier = entry.getKey();
            if (resolver != null) {
                PartsCategory orgPartsCategory = partsIdentifier.getPartsCategory();
                repPartsCategory = resolver.getPartsCategory(orgPartsCategory.getCategoryId());
                if (repPartsCategory == null) continue;
                if (orgPartsCategory != repPartsCategory) {
                    partsIdentifier = new PartsIdentifier(repPartsCategory, partsIdentifier.getPartsName(), partsIdentifier.getLocalizedPartsName());
                }
            }
            PartsCategory repPartsCategory2 = partsIdentifier.getPartsCategory();
            PartsColorInfo copiedPartsColorInfo = entry.getValue().createCompatible(repPartsCategory2);
            this.partsColorInfoMap.put(partsIdentifier, copiedPartsColorInfo);
        }
        for (Map.Entry<Comparable<PartsIdentifier>, Object> entry : org.parts.entrySet()) {
            PartsCategory orgPartsCategory;
            PartsCategory partsCategory = orgPartsCategory = (PartsCategory)entry.getKey();
            if (resolver != null) {
                repPartsCategory = resolver.getPartsCategory(orgPartsCategory.getCategoryId());
                if (repPartsCategory == null) continue;
                if (repPartsCategory != orgPartsCategory) {
                    partsCategory = repPartsCategory;
                }
            }
            ArrayList partsIdentifiers = new ArrayList((Collection)entry.getValue());
            this.parts.put(partsCategory, partsIdentifiers);
        }
    }

    public PartsSet createCompatible(PartsCategoryResolver resolver) {
        if (resolver == null) {
            throw new IllegalArgumentException();
        }
        return new PartsSet(this, resolver);
    }

    @Override
    public PartsSet clone() {
        return new PartsSet(this, null);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ (this.partsSetId == null ? 0 : this.partsSetId.hashCode());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && o instanceof PartsSet) {
            PartsSet obj = (PartsSet)o;
            if ((this.partsSetId == obj.partsSetId || this.partsSetId != null && this.partsSetId.equals(obj.partsSetId)) && super.equals(obj) && this.partsColorInfoMap.equals(obj.partsColorInfoMap) && (this.bgColor == obj.bgColor || this.bgColor != null && this.bgColor.equals(obj.bgColor)) && (this.affineTransformParameter == obj.affineTransformParameter || this.affineTransformParameter != null && Arrays.equals(this.affineTransformParameter, obj.affineTransformParameter))) {
                return true;
            }
        }
        return false;
    }

    public void setPresetParts(boolean presetParts) {
        this.presetParts = presetParts;
    }

    public boolean isPresetParts() {
        return this.presetParts;
    }

    public void setBgColor(Color bgColor) {
        this.bgColor = bgColor;
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public void setAffineTransformParameter(double[] affineTransformParameter) {
        if (affineTransformParameter != null && affineTransformParameter.length != 4 && affineTransformParameter.length != 6) {
            throw new IllegalArgumentException("affineTransformParameter invalid length.");
        }
        this.affineTransformParameter = affineTransformParameter == null ? null : (double[])affineTransformParameter.clone();
    }

    public double[] getAffineTransformParameter() {
        return this.affineTransformParameter == null ? null : (double[])this.affineTransformParameter.clone();
    }

    public void setPartsSetId(String partsSetId) {
        this.partsSetId = partsSetId;
    }

    public void setLocalizedName(String localizedName) {
        this.localizedName = localizedName;
    }

    public String getPartsSetId() {
        return this.partsSetId;
    }

    public String getLocalizedName() {
        return this.localizedName;
    }

    @Override
    public Set<Map.Entry<PartsCategory, List<PartsIdentifier>>> entrySet() {
        return this.parts.entrySet();
    }

    public PartsColorInfo getColorInfo(PartsIdentifier partsIdentifier) {
        PartsColorInfo partsColorInfo = this.partsColorInfoMap.get(partsIdentifier);
        return partsColorInfo == null ? null : partsColorInfo.clone();
    }

    public void appendParts(PartsCategory category, PartsIdentifier partsIdentifier, PartsColorInfo partsColorInfo) {
        if (category == null) {
            throw new IllegalArgumentException();
        }
        List<PartsIdentifier> partsIdentifiers = this.parts.get(category);
        if (partsIdentifiers == null) {
            partsIdentifiers = new ArrayList<PartsIdentifier>();
            this.parts.put(category, partsIdentifiers);
        }
        if (partsIdentifier != null) {
            partsIdentifiers.add(partsIdentifier);
            if (partsColorInfo != null) {
                this.partsColorInfoMap.put(partsIdentifier, partsColorInfo.clone());
            }
        }
    }

    public void removeColorInfo() {
        this.partsColorInfoMap.clear();
    }

    public boolean isSameStructure(PartsSet other) {
        if (other != null && other.size() == this.size()) {
            for (Map.Entry<PartsCategory, List<PartsIdentifier>> entry : this.entrySet()) {
                PartsCategory category = entry.getKey();
                List<PartsIdentifier> ownList = entry.getValue();
                List otherList = (List)other.get(category);
                if (ownList != null && otherList != null && ownList.equals(otherList)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isSameStructure(PartsSet a, PartsSet b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.isSameStructure(b);
    }

    public boolean isSameColor(PartsSet other) {
        if (other != null && other.size() == this.size()) {
            for (List partsIdentifiers : this.values()) {
                for (PartsIdentifier partsIdentifier : partsIdentifiers) {
                    PartsColorInfo otherColorInfo;
                    PartsColorInfo ownColorInfo = this.getColorInfo(partsIdentifier);
                    if (PartsColorInfo.equals(ownColorInfo, otherColorInfo = other.getColorInfo(partsIdentifier))) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean isSameColor(PartsSet a, PartsSet b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.isSameColor(b);
    }

    public boolean hasName() {
        return this.localizedName != null && this.localizedName.length() > 0;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(String.valueOf(this.getClass().getSimpleName()) + "@" + Integer.toHexString(System.identityHashCode(this)));
        buf.append("(");
        buf.append("partsSetId: " + this.partsSetId + ", ");
        buf.append("localizedName: " + this.localizedName + ", ");
        buf.append("presetFlg: " + this.presetParts + ", ");
        buf.append("background-color: " + this.bgColor + ", ");
        buf.append("affin-trans-param: " + Arrays.toString(this.affineTransformParameter) + ", ");
        buf.append("parts: " + this.parts + ", ");
        buf.append("partsColorMap: " + this.partsColorInfoMap);
        buf.append(")");
        return buf.toString();
    }
}

