/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.graphics.filters.ColorConv;
import charactermanaj.graphics.filters.ColorConvertParameter;
import charactermanaj.model.CharacterData;
import charactermanaj.model.ColorGroup;
import charactermanaj.model.ColorInfo;
import charactermanaj.model.Layer;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsColorInfo;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSet;
import charactermanaj.model.RecommendationURL;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CharacterDataXMLWriter {
    private static final String VERSION_SIG_1_0 = "1.0";
    private static final String DEFAULT_NS = "http://charactermanaj.sourceforge.jp/schema/charactermanaj";
    private final String NS;

    public CharacterDataXMLWriter() {
        this(DEFAULT_NS);
    }

    public CharacterDataXMLWriter(String ns) {
        this.NS = ns;
    }

    public void writeXMLCharacterData(CharacterData characterData, OutputStream outstm) throws IOException {
        Transformer tfmr;
        Element nodePresets;
        List<RecommendationURL> recommendations;
        Document doc;
        if (outstm == null || characterData == null) {
            throw new IllegalArgumentException();
        }
        Locale locale = Locale.getDefault();
        String lang = locale.getLanguage();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.newDocument();
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException("JAXP Configuration failed.", ex);
        }
        Element root = doc.createElementNS(this.NS, "character");
        root.setAttribute("version", VERSION_SIG_1_0);
        root.setAttribute("xmlns:xml", "http://www.w3.org/XML/1998/namespace");
        root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttribute("xsi:schemaLocation", String.valueOf(this.NS) + " character.xsd");
        root.setAttribute("id", characterData.getId());
        root.setAttribute("rev", characterData.getRev());
        doc.appendChild(root);
        Element nodeName = doc.createElementNS(this.NS, "name");
        Attr attrLang = doc.createAttributeNS("http://www.w3.org/XML/1998/namespace", "lang");
        attrLang.setValue(lang);
        nodeName.setAttributeNodeNS(attrLang);
        nodeName.setTextContent(characterData.getName());
        root.appendChild(nodeName);
        String author = characterData.getAuthor();
        String description = characterData.getDescription();
        if (author != null && author.length() > 0 || description != null && description.length() > 0) {
            Element nodeInfomation = doc.createElementNS(this.NS, "information");
            if (author != null && author.length() > 0) {
                Element nodeAuthor = doc.createElementNS(this.NS, "author");
                Attr attrNodeAuthorLang = doc.createAttributeNS("http://www.w3.org/XML/1998/namespace", "lang");
                attrNodeAuthorLang.setValue(lang);
                nodeAuthor.setAttributeNodeNS(attrNodeAuthorLang);
                nodeAuthor.setTextContent(author);
                nodeInfomation.appendChild(nodeAuthor);
            }
            if (description != null && description.length() > 0) {
                description = description.replace("\r\n", "\n");
                description = description.replace("\r", "\n");
                Element nodeDescription = doc.createElementNS(this.NS, "description");
                Attr attrNodeDescriptionLang = doc.createAttributeNS("http://www.w3.org/XML/1998/namespace", "lang");
                attrNodeDescriptionLang.setValue(lang);
                nodeDescription.setAttributeNodeNS(attrNodeDescriptionLang);
                nodeDescription.setTextContent(description);
                nodeInfomation.appendChild(nodeDescription);
            }
            root.appendChild(nodeInfomation);
        }
        Element nodeSize = doc.createElementNS(this.NS, "image-size");
        Element nodeWidth = doc.createElementNS(this.NS, "width");
        nodeWidth.setTextContent(Integer.toString((int)characterData.getImageSize().getWidth()));
        Element nodeHeight = doc.createElementNS(this.NS, "height");
        nodeHeight.setTextContent(Integer.toString((int)characterData.getImageSize().getHeight()));
        nodeSize.appendChild(nodeWidth);
        nodeSize.appendChild(nodeHeight);
        root.appendChild(nodeSize);
        Element nodeSettings = doc.createElementNS(this.NS, "settings");
        root.appendChild(nodeSettings);
        for (String settingsEntryName : characterData.getPropertyNames()) {
            String value = characterData.getProperty(settingsEntryName);
            if (value == null) continue;
            Element nodeEntry = doc.createElementNS(this.NS, "entry");
            nodeEntry.setAttribute("key", settingsEntryName);
            nodeEntry.setTextContent(value);
            nodeSettings.appendChild(nodeEntry);
        }
        Element nodeCategories = doc.createElementNS(this.NS, "categories");
        for (PartsCategory category : characterData.getPartsCategories()) {
            Element nodeCategory = doc.createElementNS(this.NS, "category");
            nodeCategory.setAttribute("id", category.getCategoryId());
            nodeCategory.setAttribute("multipleSelectable", category.isMultipleSelectable() ? "true" : "false");
            Element nodeVisibleRows = doc.createElementNS(this.NS, "visible-rows");
            nodeVisibleRows.setTextContent(Integer.toString(category.getVisibleRows()));
            nodeCategory.appendChild(nodeVisibleRows);
            Element nodeCategoryName = doc.createElementNS(this.NS, "display-name");
            Attr attrCategoryNameLang = doc.createAttributeNS("http://www.w3.org/XML/1998/namespace", "lang");
            attrCategoryNameLang.setValue(lang);
            nodeCategoryName.setAttributeNodeNS(attrCategoryNameLang);
            nodeCategoryName.setTextContent(category.getLocalizedCategoryName());
            nodeCategory.appendChild(nodeCategoryName);
            Element nodeLayers = doc.createElementNS(this.NS, "layers");
            for (Layer layer : category.getLayers()) {
                Element nodeLayer = doc.createElementNS(this.NS, "layer");
                nodeLayer.setAttribute("id", layer.getId());
                Element nodeLayerName = doc.createElementNS(this.NS, "display-name");
                Attr attrLayerNameLang = doc.createAttributeNS("http://www.w3.org/XML/1998/namespace", "lang");
                attrLayerNameLang.setValue(lang);
                nodeLayerName.setAttributeNodeNS(attrLayerNameLang);
                nodeLayerName.setTextContent(layer.getLocalizedName());
                nodeLayer.appendChild(nodeLayerName);
                Element nodeOrder = doc.createElementNS(this.NS, "order");
                nodeOrder.setTextContent(Integer.toString(layer.getOrder()));
                nodeLayer.appendChild(nodeOrder);
                ColorGroup colorGroup = layer.getColorGroup();
                if (colorGroup != null && colorGroup.isEnabled()) {
                    Element nodeColorGroup = doc.createElementNS(this.NS, "colorGroup");
                    nodeColorGroup.setAttribute("refid", colorGroup.getId());
                    nodeColorGroup.setAttribute("init-sync", layer.isInitSync() ? "true" : "false");
                    nodeLayer.appendChild(nodeColorGroup);
                }
                Element nodeDir = doc.createElementNS(this.NS, "dir");
                nodeDir.setTextContent(layer.getDir());
                nodeLayer.appendChild(nodeDir);
                String colorModelName = layer.getColorModelName();
                if (colorModelName != null && colorModelName.length() > 0) {
                    Element nodeColorModel = doc.createElementNS(this.NS, "colorModel");
                    nodeColorModel.setTextContent(layer.getColorModelName());
                    nodeLayer.appendChild(nodeColorModel);
                }
                nodeLayers.appendChild(nodeLayer);
            }
            nodeCategory.appendChild(nodeLayers);
            nodeCategories.appendChild(nodeCategory);
        }
        root.appendChild(nodeCategories);
        Collection<ColorGroup> colorGroups = characterData.getColorGroups();
        if (colorGroups.size() > 0) {
            Element nodeColorGroups = doc.createElementNS(this.NS, "colorGroups");
            int colorGroupCount = 0;
            for (ColorGroup colorGroup : colorGroups) {
                if (!colorGroup.isEnabled()) continue;
                Element nodeColorGroup = doc.createElementNS(this.NS, "colorGroup");
                nodeColorGroup.setAttribute("id", colorGroup.getId());
                Element nodeColorGroupName = doc.createElementNS(this.NS, "display-name");
                Attr attrColorGroupNameLang = doc.createAttributeNS("http://www.w3.org/XML/1998/namespace", "lang");
                attrColorGroupNameLang.setValue(lang);
                nodeColorGroupName.setAttributeNodeNS(attrColorGroupNameLang);
                nodeColorGroupName.setTextContent(colorGroup.getLocalizedName());
                nodeColorGroup.appendChild(nodeColorGroupName);
                nodeColorGroups.appendChild(nodeColorGroup);
                ++colorGroupCount;
            }
            if (colorGroupCount > 0) {
                root.appendChild(nodeColorGroups);
            }
        }
        if ((recommendations = characterData.getRecommendationURLList()) != null) {
            Element nodeRecommendations = doc.createElementNS(this.NS, "recommendations");
            for (RecommendationURL recommendation : recommendations) {
                Element nodeRecommendation = doc.createElementNS(this.NS, "recommendation");
                String displayName = recommendation.getDisplayName();
                String url = recommendation.getUrl();
                Element nodeDescription = doc.createElementNS(this.NS, "description");
                Attr attrRecommendationDescriptionLang = doc.createAttributeNS("http://www.w3.org/XML/1998/namespace", "lang");
                attrRecommendationDescriptionLang.setValue(lang);
                nodeDescription.setAttributeNodeNS(attrRecommendationDescriptionLang);
                nodeDescription.setTextContent(displayName);
                Element nodeURL = doc.createElementNS(this.NS, "URL");
                Attr attrRecommendationURLLang = doc.createAttributeNS("http://www.w3.org/XML/1998/namespace", "lang");
                attrRecommendationURLLang.setValue(lang);
                nodeURL.setAttributeNodeNS(attrRecommendationURLLang);
                nodeURL.setTextContent(url);
                nodeRecommendation.appendChild(nodeDescription);
                nodeRecommendation.appendChild(nodeURL);
                nodeRecommendations.appendChild(nodeRecommendation);
            }
            root.appendChild(nodeRecommendations);
        }
        if (this.writePartsSetElements(doc, nodePresets = doc.createElementNS(this.NS, "presets"), characterData, true, false) > 0) {
            root.appendChild(nodePresets);
        }
        TransformerFactory txFactory = TransformerFactory.newInstance();
        txFactory.setAttribute("indent-number", 4);
        try {
            tfmr = txFactory.newTransformer();
        }
        catch (TransformerConfigurationException ex) {
            throw new RuntimeException("JAXP Configuration Failed.", ex);
        }
        tfmr.setOutputProperty("indent", "yes");
        String encoding = "UTF-8";
        tfmr.setOutputProperty("encoding", "UTF-8");
        try {
            tfmr.transform(new DOMSource(doc), new StreamResult(new OutputStreamWriter(outstm, Charset.forName("UTF-8"))));
        }
        catch (TransformerException ex) {
            IOException ex2 = new IOException("XML Convert failed.");
            ex2.initCause(ex);
            throw ex2;
        }
    }

    protected int writePartsSetElements(Document doc, Element baseElement, CharacterData characterData, boolean writePresets, boolean writeFavorites) {
        PartsSet defaultPartsSet;
        String defaultPresetId;
        Map<String, PartsSet> partsSetMap = characterData.getPartsSets();
        Locale locale = Locale.getDefault();
        String lang = locale.getLanguage();
        HashMap<String, PartsSet> registeredPartsSetMap = new HashMap<String, PartsSet>();
        for (Map.Entry<String, PartsSet> partsSetsEntry : partsSetMap.entrySet()) {
            PartsSet partsSet = partsSetsEntry.getValue();
            if (partsSet.isPresetParts() && !writePresets || !partsSet.isPresetParts() && !writeFavorites || partsSet.isEmpty()) continue;
            Element nodePreset = this.createPartsSetXML(doc, lang, partsSet);
            baseElement.appendChild(nodePreset);
            registeredPartsSetMap.put(partsSet.getPartsSetId(), partsSet);
        }
        if (writePresets && (defaultPresetId = characterData.getDefaultPartsSetId()) != null && defaultPresetId.length() > 0 && (defaultPartsSet = (PartsSet)registeredPartsSetMap.get(defaultPresetId)) != null && defaultPartsSet.isPresetParts()) {
            baseElement.setAttribute("default-preset", defaultPresetId);
        }
        return registeredPartsSetMap.size();
    }

    public Element createPartsSetXML(Document doc, String lang, PartsSet partsSet) {
        Object object;
        double[] affineTransformParameter;
        if (doc == null || lang == null) {
            throw new IllegalArgumentException();
        }
        String partsSetId = partsSet.getPartsSetId();
        String localizedName = partsSet.getLocalizedName();
        Element nodePreset = doc.createElementNS(this.NS, "preset");
        if (partsSet == null || partsSet.isEmpty()) {
            nodePreset.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:nil", "true");
            return nodePreset;
        }
        nodePreset.setAttribute("id", partsSetId);
        Element nodeName = doc.createElementNS(this.NS, "display-name");
        Attr attrLang = doc.createAttributeNS("http://www.w3.org/XML/1998/namespace", "lang");
        attrLang.setValue(lang);
        nodeName.setAttributeNode(attrLang);
        nodeName.setTextContent(localizedName);
        nodePreset.appendChild(nodeName);
        Color bgColor = partsSet.getBgColor();
        if (bgColor != null) {
            Element nodeBgColor = doc.createElementNS(this.NS, "background-color");
            nodeBgColor.setAttribute("color", "#" + Integer.toHexString(bgColor.getRGB() & 0xFFFFFF));
            nodePreset.appendChild(nodeBgColor);
        }
        if ((affineTransformParameter = partsSet.getAffineTransformParameter()) != null) {
            Element nodeAffineTransform = doc.createElementNS(this.NS, "affine-transform-parameter");
            StringBuilder tmp = new StringBuilder();
            object = affineTransformParameter;
            int n = affineTransformParameter.length;
            int n2 = 0;
            while (n2 < n) {
                double affineItem = object[n2];
                if (tmp.length() > 0) {
                    tmp.append(" ");
                }
                tmp.append(Double.toString(affineItem));
                ++n2;
            }
            nodeAffineTransform.setTextContent(tmp.toString());
            nodePreset.appendChild(nodeAffineTransform);
        }
        for (Map.Entry<PartsCategory, List<PartsIdentifier>> entry : partsSet.entrySet()) {
            PartsCategory partsCategory = entry.getKey();
            Element nodeCategory = doc.createElementNS(this.NS, "category");
            nodeCategory.setAttribute("refid", partsCategory.getCategoryId());
            nodePreset.appendChild(nodeCategory);
            List<PartsIdentifier> partsIdentifiers = entry.getValue();
            object = partsIdentifiers.iterator();
            while (object.hasNext()) {
                PartsIdentifier partsIdentifier = (PartsIdentifier)object.next();
                String partsName = partsIdentifier.getPartsName();
                Element nodeParts = doc.createElementNS(this.NS, "parts");
                nodeParts.setAttribute("name", partsName);
                nodeCategory.appendChild(nodeParts);
                PartsColorInfo partsColorInfo = partsSet.getColorInfo(partsIdentifier);
                if (partsColorInfo == null) continue;
                Element nodeColor = this.createPartsColorInfoXML(doc, partsColorInfo);
                nodeParts.appendChild(nodeColor);
            }
        }
        return nodePreset;
    }

    public Element createPartsColorInfoXML(Document doc, PartsColorInfo partsColorInfo) {
        if (doc == null || partsColorInfo == null) {
            throw new IllegalArgumentException();
        }
        Element nodeColor = doc.createElementNS(this.NS, "color");
        for (Map.Entry<Layer, ColorInfo> colorInfoEntry : partsColorInfo.entrySet()) {
            Object[][] rgbArgss;
            Layer layer = colorInfoEntry.getKey();
            ColorInfo colorInfo = colorInfoEntry.getValue();
            Element nodeLayer = doc.createElementNS(this.NS, "layer");
            nodeLayer.setAttribute("refid", layer.getId());
            nodeColor.appendChild(nodeLayer);
            ColorGroup colorGroup = colorInfo.getColorGroup();
            boolean colorSync = colorInfo.isSyncColorGroup();
            if (colorGroup.isEnabled()) {
                Element nodeColorGroup = doc.createElementNS(this.NS, "color-group");
                nodeColorGroup.setAttribute("group", colorGroup.getId());
                nodeColorGroup.setAttribute("synchronized", colorSync ? "true" : "false");
                nodeLayer.appendChild(nodeColorGroup);
            }
            ColorConvertParameter param = colorInfo.getColorParameter();
            Element nodeRGB = doc.createElementNS(this.NS, "rgb");
            Object[][] objectArrayArray = rgbArgss = new Object[][]{{"red", param.getOffsetR(), Float.valueOf(param.getFactorR()), Float.valueOf(param.getGammaR())}, {"green", param.getOffsetG(), Float.valueOf(param.getFactorG()), Float.valueOf(param.getGammaG())}, {"blue", param.getOffsetB(), Float.valueOf(param.getFactorB()), Float.valueOf(param.getGammaB())}, {"alpha", param.getOffsetA(), Float.valueOf(param.getFactorA()), Float.valueOf(param.getGammaA())}};
            int n = rgbArgss.length;
            int n2 = 0;
            while (n2 < n) {
                Object[] rgbArgs = objectArrayArray[n2];
                Element nodeRGBItem = doc.createElementNS(this.NS, rgbArgs[0].toString());
                nodeRGBItem.setAttribute("offset", rgbArgs[1].toString());
                nodeRGBItem.setAttribute("factor", rgbArgs[2].toString());
                nodeRGBItem.setAttribute("gamma", rgbArgs[3].toString());
                nodeRGB.appendChild(nodeRGBItem);
                ++n2;
            }
            nodeLayer.appendChild(nodeRGB);
            Element nodeHSB = doc.createElementNS(this.NS, "hsb");
            nodeHSB.setAttribute("hue", Float.toString(param.getHue()));
            nodeHSB.setAttribute("saturation", Float.toString(param.getSaturation()));
            nodeHSB.setAttribute("brightness", Float.toString(param.getBrightness()));
            if (param.getContrast() != 0.0f) {
                nodeHSB.setAttribute("contrast", Float.toString(param.getContrast()));
            }
            nodeLayer.appendChild(nodeHSB);
            Element nodeRGBReplace = doc.createElementNS(this.NS, "rgb-replace");
            ColorConv colorConv = param.getColorReplace();
            if (colorConv == null) {
                colorConv = ColorConv.NONE;
            }
            nodeRGBReplace.setAttribute("replace-type", colorConv.name());
            nodeRGBReplace.setAttribute("gray", Float.toString(param.getGrayLevel()));
            nodeLayer.appendChild(nodeRGBReplace);
        }
        return nodeColor;
    }

    public void saveFavorites(CharacterData characterData, OutputStream outstm) throws IOException {
        Transformer tfmr;
        Document doc;
        if (characterData == null || outstm == null) {
            throw new IllegalArgumentException();
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.newDocument();
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException("JAXP Configuration Exception.", ex);
        }
        Element root = doc.createElementNS(this.NS, "partssets");
        root.setAttribute("xmlns:xml", "http://www.w3.org/XML/1998/namespace");
        root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttribute("xsi:schemaLocation", String.valueOf(this.NS) + " partsset.xsd");
        doc.appendChild(root);
        this.writePartsSetElements(doc, root, characterData, false, true);
        TransformerFactory txFactory = TransformerFactory.newInstance();
        txFactory.setAttribute("indent-number", 4);
        try {
            tfmr = txFactory.newTransformer();
        }
        catch (TransformerConfigurationException ex) {
            throw new RuntimeException("JAXP Configuration Failed.", ex);
        }
        tfmr.setOutputProperty("indent", "yes");
        String encoding = "UTF-8";
        tfmr.setOutputProperty("encoding", "UTF-8");
        try {
            tfmr.transform(new DOMSource(doc), new StreamResult(new OutputStreamWriter(outstm, Charset.forName("UTF-8"))));
        }
        catch (TransformerException ex) {
            IOException ex2 = new IOException("XML Convert failed.");
            ex2.initCause(ex);
            throw ex2;
        }
    }
}

