/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.io;

import charactermanaj.model.CharacterData;
import charactermanaj.model.io.CharacterDataPersistent;
import charactermanaj.util.DirectoryConfig;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class RecentDataPersistent {
    private static final String RECENT_CAHARCTER_INFO_XML = "recent-character.xml";
    private static final Logger logger = Logger.getLogger(RecentDataPersistent.class.getName());
    private static final RecentDataPersistent inst = new RecentDataPersistent();

    private RecentDataPersistent() {
    }

    public static RecentDataPersistent getInstance() {
        return inst;
    }

    private File getRecentCharacterXML() {
        File currentCharactersDir = DirectoryConfig.getInstance().getCharactersDir();
        File recentCharacterXML = new File(currentCharactersDir, RECENT_CAHARCTER_INFO_XML);
        return recentCharacterXML;
    }

    public boolean saveRecent(CharacterData characterData) throws IOException {
        File characterXml;
        File characterDir;
        File baseDir;
        File currentCharactersDir;
        URI docBase = null;
        if (characterData != null) {
            docBase = characterData.getDocBase();
        }
        String characterDataName = null;
        if (docBase != null && (currentCharactersDir = DirectoryConfig.getInstance().getCharactersDir()).equals(baseDir = (characterDir = (characterXml = new File(docBase)).getParentFile()).getParentFile())) {
            characterDataName = characterDir.getName();
        }
        Properties props = new Properties();
        props.setProperty("lastUseCharacterData", characterDataName == null ? "" : characterDataName);
        File recentCharacterXML = this.getRecentCharacterXML();
        if (recentCharacterXML.exists() && !recentCharacterXML.canWrite()) {
            logger.log(Level.FINE, "recent-character.xml is readonly.");
            return false;
        }
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(recentCharacterXML));
        try {
            String comment = "recent-character: lastModified=" + new Timestamp(System.currentTimeMillis()).toString();
            props.storeToXML(os, comment);
        }
        finally {
            ((OutputStream)os).close();
        }
        return true;
    }

    public CharacterData loadRecent() {
        File recentCharacterXML = this.getRecentCharacterXML();
        if (recentCharacterXML.exists()) {
            try {
                File currentCharactersDir;
                File characterDir;
                File characterXml;
                Properties props = new Properties();
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(recentCharacterXML));
                try {
                    props.loadFromXML(is);
                }
                finally {
                    ((InputStream)is).close();
                }
                String characterDataName = props.getProperty("lastUseCharacterData");
                if (characterDataName != null && characterDataName.trim().length() > 0 && (characterXml = new File(characterDir = new File(currentCharactersDir = DirectoryConfig.getInstance().getCharactersDir(), characterDataName), "character.xml")).exists()) {
                    CharacterDataPersistent persist = CharacterDataPersistent.getInstance();
                    return persist.loadProfile(characterXml.toURI());
                }
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "recent data loading failed. " + recentCharacterXML, ex);
            }
        }
        return null;
    }
}

