/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;

class CheckInfoLayerPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(CheckInfoLayerPanel.class.getName());
    private Insets padding = new Insets(3, 3, 3, 3);
    private Point pos = new Point();
    private String message = "";
    private String[] messageLines;
    private int fontHeight;
    private Rectangle eraseRect;
    private Rectangle requestRect;
    private boolean requestRecalcOnAdd;
    private Map desktopHintsForFont;

    public CheckInfoLayerPanel() {
        this.setOpaque(false);
        Toolkit tk = Toolkit.getDefaultToolkit();
        this.desktopHintsForFont = (Map)tk.getDesktopProperty("awt.font.desktophints");
        logger.log(Level.CONFIG, "awt.font.desktophints=" + this.desktopHintsForFont);
    }

    @Override
    protected void paintComponent(Graphics g0) {
        Graphics2D g = (Graphics2D)g0;
        super.paintComponent(g);
        Rectangle clip = g.getClipBounds();
        if (clip == null || this.eraseRect != null && clip.contains(this.eraseRect)) {
            this.eraseRect = null;
        }
        if (this.requestRect == null || this.requestRect.isEmpty() || clip == null || !clip.intersects(this.requestRect)) {
            return;
        }
        if (this.messageLines == null || this.messageLines.length == 0) {
            return;
        }
        if (this.desktopHintsForFont != null) {
            g.addRenderingHints(this.desktopHintsForFont);
        }
        g.setColor(new Color(255, 255, 255, 192));
        g.fillRect(this.requestRect.x, this.requestRect.y, this.requestRect.width, this.requestRect.height);
        g.setColor(Color.GRAY);
        g.drawRect(this.requestRect.x, this.requestRect.y, this.requestRect.width - 1, this.requestRect.height - 1);
        g.setColor(Color.BLACK);
        int oy = this.fontHeight;
        String[] stringArray = this.messageLines;
        int n = this.messageLines.length;
        int n2 = 0;
        while (n2 < n) {
            String messageLine = stringArray[n2];
            g.drawString(messageLine, this.requestRect.x + this.padding.left, this.requestRect.y + this.padding.top - 1 + oy);
            oy += this.fontHeight;
            ++n2;
        }
        if (this.eraseRect == null || this.eraseRect.isEmpty()) {
            this.eraseRect = (Rectangle)this.requestRect.clone();
        } else {
            this.eraseRect.add(this.requestRect);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.requestRecalcOnAdd) {
            this.requestRecalcOnAdd = false;
            this.calcRepaint();
        }
    }

    protected void calcRepaint() {
        Graphics2D g = (Graphics2D)this.getGraphics();
        if (g == null) {
            this.requestRecalcOnAdd = true;
            return;
        }
        try {
            if (this.eraseRect != null && !this.eraseRect.isEmpty()) {
                this.repaint(this.eraseRect);
            }
            if (this.message.length() == 0) {
                this.requestRect = null;
                return;
            }
            FontMetrics fm = g.getFontMetrics();
            String[] messageLines = this.message.split("\u00a5n");
            RectangularShape rct = null;
            String[] stringArray = messageLines;
            int n = messageLines.length;
            int n2 = 0;
            while (n2 < n) {
                String messageLine = stringArray[n2];
                Rectangle2D tmp = fm.getStringBounds(messageLine, g);
                if (rct != null) {
                    ((Rectangle2D)rct).add(tmp);
                } else {
                    rct = tmp;
                }
                ++n2;
            }
            int fw = (int)rct.getWidth();
            int fh = (int)rct.getHeight();
            int w = fw + this.padding.left + this.padding.right;
            int h = fh * messageLines.length + this.padding.top + this.padding.bottom;
            int x = this.pos.x + 16;
            int y = this.pos.y - h;
            int client_w = this.getWidth();
            int client_h = this.getHeight();
            if (x + w > client_w) {
                x = this.pos.x - w - 10;
            }
            if (y < 0) {
                y = this.pos.y + 10;
            }
            if (y + h > client_h) {
                y -= y + h - client_h;
            }
            this.requestRect = new Rectangle(x, y, w, h);
            this.messageLines = messageLines;
            this.fontHeight = fh;
            Rectangle paintRect = (Rectangle)this.requestRect.clone();
            this.repaint(paintRect);
        }
        finally {
            g.dispose();
        }
    }

    public void setPotision(Point requestPt) {
        if (requestPt == null) {
            throw new IllegalArgumentException();
        }
        if (!requestPt.equals(this.pos)) {
            Point oldpos = this.pos;
            this.pos = (Point)requestPt.clone();
            this.calcRepaint();
            this.firePropertyChange("position", oldpos, this.pos);
        }
    }

    public Point getPosition() {
        return (Point)this.pos.clone();
    }

    public void setMessage(String message) {
        if (message == null) {
            message = "";
        }
        if (!(message = message.replace("\u00a5r\u00a5n", "\u00a5n")).equals(this.message)) {
            String oldmes = this.message;
            this.message = message;
            this.calcRepaint();
            this.firePropertyChange("message", oldmes, message);
        }
    }

    public String getMessage() {
        return this.message;
    }
}

