/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.AppConfig;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSet;
import charactermanaj.ui.AbstractImportPanel;
import charactermanaj.ui.ExportInformationResolver;
import charactermanaj.ui.ExportPartsResolver;
import charactermanaj.ui.ExportPresetModel;
import charactermanaj.ui.ExportPresetResolve;
import charactermanaj.ui.ExportPresetTableModel;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;

class ExportPresetSelectPanel
extends AbstractImportPanel
implements ExportPresetResolve {
    private static final long serialVersionUID = 1L;
    private ExportPartsResolver exportPartsResolver;
    private ExportPresetTableModel presetTableModel;
    private JTable presetTable;
    private Action actSelectAll;
    private Action actDeselectAll;

    protected ExportPresetSelectPanel(ExportPartsResolver exportPartsResolver, ExportInformationResolver exportInfoResolver, Collection<PartsSet> partsSets, String defaultPresetId) {
        this.exportPartsResolver = exportPartsResolver;
        this.setName("presetSelectPanel");
        Properties strings = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties("languages/exportwizdialog");
        this.setName("choosePartsPanel");
        this.setBorder(BorderFactory.createTitledBorder(strings.getProperty("preset.title")));
        this.setLayout(new BorderLayout());
        this.presetTableModel = new ExportPresetTableModel();
        this.presetTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getType() == 0) {
                    ExportPresetSelectPanel.this.fireChangeEvent();
                }
            }
        });
        exportPartsResolver.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ExportPresetSelectPanel.this.checkMissingParts();
            }
        });
        this.loadPresetInfo(partsSets, defaultPresetId);
        AppConfig appConfig = AppConfig.getInstance();
        final Color warningForegroundColor = appConfig.getExportPresetWarningsForegroundColor();
        final Color disabledForeground = appConfig.getDisabledCellForgroundColor();
        this.presetTable = new JTable(this.presetTableModel){
            private static final long serialVersionUID = 1L;

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                ExportPresetModel presetModel;
                Component comp = super.prepareRenderer(renderer, row, column);
                if (comp instanceof JCheckBox) {
                    comp.setEnabled(this.isCellEditable(row, column) && this.isEnabled());
                }
                if ((presetModel = (ExportPresetModel)ExportPresetSelectPanel.this.presetTableModel.getRow(row)).isPresetParts()) {
                    comp.setFont(this.getFont().deriveFont(1));
                } else {
                    comp.setFont(this.getFont());
                }
                if (!this.isEnabled()) {
                    comp.setForeground(disabledForeground);
                } else if (presetModel.isSelected() && presetModel.getMissingPartsIdentifiers().size() > 0) {
                    comp.setForeground(warningForegroundColor);
                } else {
                    comp.setForeground(this.getForeground());
                }
                return comp;
            }
        };
        this.presetTable.setShowGrid(true);
        this.presetTable.setGridColor(appConfig.getGridColor());
        this.presetTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        AbstractAction actSelectUsedParts = new AbstractAction(strings.getProperty("preset.popup.selectUsedParts")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportPresetSelectPanel.this.exportUsedParts();
            }
        };
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(actSelectUsedParts);
        this.presetTable.setComponentPopupMenu(popupMenu);
        this.presetTable.setAutoResizeMode(0);
        this.presetTableModel.adjustColumnModel(this.presetTable.getColumnModel());
        this.add((Component)new JScrollPane(this.presetTable), "Center");
        this.actSelectAll = new AbstractAction(strings.getProperty("parts.btn.selectAll")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportPresetSelectPanel.this.onSelectAll();
            }
        };
        this.actDeselectAll = new AbstractAction(strings.getProperty("parts.btn.deselectAll")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportPresetSelectPanel.this.onDeselectAll();
            }
        };
        AbstractAction actSort = new AbstractAction(strings.getProperty("parts.btn.sort")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportPresetSelectPanel.this.onSort();
            }
        };
        JPanel btnPanel = new JPanel();
        GridBagLayout btnPanelLayout = new GridBagLayout();
        btnPanel.setLayout(btnPanelLayout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 13;
        gbc.fill = 1;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.ipadx = 0;
        gbc.ipady = 0;
        JButton btnSelectAll = new JButton(this.actSelectAll);
        btnPanel.add((Component)btnSelectAll, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        JButton btnDeselectAll = new JButton(this.actDeselectAll);
        btnPanel.add((Component)btnDeselectAll, gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        JButton btnSort = new JButton(actSort);
        btnPanel.add((Component)btnSort, gbc);
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        btnPanel.add(Box.createHorizontalGlue(), gbc);
        this.add((Component)btnPanel, "South");
    }

    protected void loadPresetInfo(Collection<PartsSet> partsSets, String defaultPresetId) {
        this.presetTableModel.clear();
        for (PartsSet orgPartsSet : partsSets) {
            PartsSet partsSet = orgPartsSet.clone();
            ExportPresetModel model = new ExportPresetModel(partsSet, partsSet.isPresetParts());
            this.presetTableModel.addRow(model);
        }
        this.presetTableModel.setDefaultPresetId(defaultPresetId);
        this.presetTableModel.sort();
        this.checkMissingParts();
    }

    public void checkMissingParts() {
        ArrayList<PartsSet> changedPartsSets = new ArrayList<PartsSet>();
        HashMap<PartsSet, ExportPresetModel> partsSetModelMap = new HashMap<PartsSet, ExportPresetModel>();
        int mx = this.presetTableModel.getRowCount();
        int idx = 0;
        while (idx < mx) {
            ExportPresetModel presetModel = (ExportPresetModel)this.presetTableModel.getRow(idx);
            PartsSet partsSet = presetModel.getPartsSet();
            partsSetModelMap.put(partsSet, presetModel);
            changedPartsSets.add(partsSet);
            ++idx;
        }
        Map<PartsSet, List<PartsIdentifier>> missingPartsIdentifiersMap = this.exportPartsResolver.checkMissingPartsList(changedPartsSets);
        for (Map.Entry<PartsSet, List<PartsIdentifier>> entry : missingPartsIdentifiersMap.entrySet()) {
            PartsSet partsSet = entry.getKey();
            List<PartsIdentifier> missingPartsIdentifiers = entry.getValue();
            ExportPresetModel presetModel = (ExportPresetModel)partsSetModelMap.get(partsSet);
            presetModel.setMissingPartsIdentifiers(missingPartsIdentifiers);
        }
        if (!missingPartsIdentifiersMap.isEmpty()) {
            this.presetTableModel.fireTableDataChanged();
        }
    }

    protected void onSelectAll() {
        this.presetTableModel.selectAll();
    }

    protected void onDeselectAll() {
        this.presetTableModel.deselectAll();
    }

    protected void onSort() {
        this.presetTableModel.sort();
        if (this.presetTableModel.getRowCount() > 0) {
            Rectangle rct = this.presetTable.getCellRect(0, 0, true);
            this.presetTable.scrollRectToVisible(rct);
        }
    }

    @Override
    public List<PartsSet> getSelectedPresets() {
        return this.presetTableModel.getSelectedPresets();
    }

    protected void exportUsedParts() {
        int[] selRows;
        ArrayList<PartsSet> partsSets = new ArrayList<PartsSet>();
        int[] nArray = selRows = this.presetTable.getSelectedRows();
        int n = selRows.length;
        int n2 = 0;
        while (n2 < n) {
            int selRow = nArray[n2];
            ExportPresetModel presetModel = (ExportPresetModel)this.presetTableModel.getRow(selRow);
            partsSets.add(presetModel.getPartsSet());
            ++n2;
        }
        this.exportPartsResolver.selectByPartsSet(partsSets);
    }

    @Override
    public int getSelectedCount() {
        return this.presetTableModel.getSelectedCount();
    }

    public String getDefaultPresetId() {
        return this.presetTableModel.getDefaultPresetId();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.presetTable.setEnabled(enabled);
        this.presetTableModel.setEnabled(enabled);
        this.actSelectAll.setEnabled(enabled);
        this.actDeselectAll.setEnabled(enabled);
        super.setEnabled(enabled);
    }
}

