/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.ui.MenuData;
import charactermanaj.ui.MenuDataFactory;
import charactermanaj.ui.scrollablemenu.JScrollableMenu;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;

public class MenuBuilder {
    protected static final String MENU_STRINGS_RESOURCE = "menu/menu";
    private static final boolean needAntiAlias = MenuBuilder.isNeedAntialias();
    private final HashMap<String, JMenu> menuMap = new HashMap();
    private final HashMap<String, JMenuItem> menuItemMap = new HashMap();

    private static boolean isNeedAntialias() {
        return System.getProperty("java.specification.version").startsWith("1.5");
    }

    public JMenu getJMenu(String name) {
        JMenu menu = this.menuMap.get(name);
        if (menu == null) {
            throw new RuntimeException("\u767b\u9332\u3055\u308c\u3066\u3044\u306a\u3044\u30e1\u30cb\u30e5\u30fc\u3067\u3059. " + name);
        }
        return menu;
    }

    public JMenuItem getJMenuItem(String name) {
        JMenuItem menuItem = this.menuItemMap.get(name);
        if (menuItem == null) {
            throw new RuntimeException("\u767b\u9332\u3055\u308c\u3066\u3044\u306a\u3044\u30e1\u30cb\u30e5\u30fc\u9805\u76ee\u3067\u3059. " + name);
        }
        return menuItem;
    }

    public JMenuBar createMenuBar(MenuDataFactory[] menus) {
        Properties menuProps = LocalizedResourcePropertyLoader.getCachedInstance().getLocalizedProperties(MENU_STRINGS_RESOURCE);
        final JMenuBar menuBar = this.createJMenuBar();
        this.menuMap.clear();
        this.menuItemMap.clear();
        MenuDataFactory[] menuDataFactoryArray = menus;
        int n = menus.length;
        int n2 = 0;
        while (n2 < n) {
            MenuDataFactory menuDataFactory = menuDataFactoryArray[n2];
            MenuData menuData = menuDataFactory.createMenuData(menuProps);
            this.createMenu(new MenuAppender(){

                @Override
                public void addMenu(JMenu menu) {
                    menuBar.add(menu);
                }
            }, menuData, menuProps);
            ++n2;
        }
        return menuBar;
    }

    protected void createMenu(MenuAppender parentMenu, MenuData menuData, Properties menuProps) {
        final JMenu menu = this.createJMenu();
        if (menuData.makeMenu(menu)) {
            parentMenu.addMenu(menu);
            this.menuMap.put(menuData.getName(), menu);
            for (MenuData child : menuData) {
                if (child == null) {
                    menu.add(new JSeparator());
                    continue;
                }
                if (child.getActionListener() == null) {
                    this.createMenu(new MenuAppender(){

                        @Override
                        public void addMenu(JMenu childMenu) {
                            menu.add(childMenu);
                        }
                    }, child, menuProps);
                    continue;
                }
                JMenuItem menuItem = child.isCheckbox() ? this.createJCheckBoxMenuItem() : this.createJMenuItem();
                if (!child.makeMenu(menuItem)) continue;
                menu.add(menuItem);
                this.menuItemMap.put(child.getName(), menuItem);
            }
        }
    }

    public JMenuBar createJMenuBar() {
        return new JMenuBar(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paint(Graphics g) {
                MenuBuilder.setAntiAlias(g);
                super.paint(g);
            }
        };
    }

    public JMenu createJMenu() {
        if (JScrollableMenu.isScreenMenu()) {
            return new JMenu(){
                private static final long serialVersionUID = 1L;

                @Override
                public void paint(Graphics g) {
                    MenuBuilder.setAntiAlias(g);
                    super.paint(g);
                }
            };
        }
        return new JScrollableMenu(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paint(Graphics g) {
                MenuBuilder.setAntiAlias(g);
                super.paint(g);
            }
        };
    }

    public JCheckBoxMenuItem createJCheckBoxMenuItem() {
        return new JCheckBoxMenuItem(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paint(Graphics g) {
                MenuBuilder.setAntiAlias(g);
                super.paint(g);
            }
        };
    }

    public JMenuItem createJMenuItem() {
        return new JMenuItem(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paint(Graphics g) {
                MenuBuilder.setAntiAlias(g);
                super.paint(g);
            }
        };
    }

    private static void setAntiAlias(Graphics g) {
        if (needAntiAlias) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
    }

    private static interface MenuAppender {
        public void addMenu(JMenu var1);
    }
}

