/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui.util;

import charactermanaj.model.AppConfig;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public class ScrollPaneDragScrollSupport {
    private JScrollPane scrollPane;
    private int wheelDivider;
    private Point dragPt;
    private MouseListener mouseListener;
    private MouseMotionListener mouseMotionListener;
    private MouseWheelListener mouseWheelListener;
    private JComponent installTarget;

    public ScrollPaneDragScrollSupport(JScrollPane scrollPane) {
        if (scrollPane == null) {
            throw new IllegalArgumentException();
        }
        this.scrollPane = scrollPane;
        AppConfig appConfig = AppConfig.getInstance();
        this.wheelDivider = Math.max(2, appConfig.getWheelScrollUnit());
    }

    public boolean isDragScrollable() {
        JViewport vp = this.scrollPane.getViewport();
        Dimension viewSize = vp.getViewSize();
        Dimension visibleSize = vp.getExtentSize();
        return viewSize.width > visibleSize.width || viewSize.height > visibleSize.height;
    }

    public Point getDragPt() {
        return this.dragPt;
    }

    public boolean isDragging() {
        return this.dragPt != null;
    }

    protected void setCursor(Cursor cursor) {
        this.scrollPane.setCursor(cursor);
    }

    public void drag(boolean start, Point mousePt) {
        if (start) {
            if (this.dragPt == null) {
                JViewport vp = this.scrollPane.getViewport();
                Dimension viewSize = vp.getViewSize();
                Dimension visibleSize = vp.getExtentSize();
                if (viewSize.width <= visibleSize.width && viewSize.height <= visibleSize.height) {
                    this.dragPt = null;
                    return;
                }
                this.dragPt = mousePt;
                this.setCursor(Cursor.getPredefinedCursor(12));
            }
        } else if (this.dragPt != null) {
            this.dragging(mousePt);
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.dragPt = null;
        }
    }

    public void dragging(Point mousePt) {
        if (this.dragPt == null || mousePt == null) {
            return;
        }
        int diff_x = this.dragPt.x - mousePt.x;
        int diff_y = this.dragPt.y - mousePt.y;
        this.scroll(diff_x, diff_y);
        this.dragPt = mousePt;
    }

    public void scroll(int diff_x, int diff_y) {
        if (diff_x == 0 && diff_y == 0) {
            return;
        }
        JViewport vp = this.scrollPane.getViewport();
        Dimension viewSize = vp.getViewSize();
        Dimension visibleSize = vp.getExtentSize();
        Point vpt = vp.getViewPosition();
        vpt.x += diff_x;
        if (vpt.x < 0) {
            vpt.x = 0;
        } else if (vpt.x + visibleSize.width > viewSize.width) {
            vpt.x -= vpt.x + visibleSize.width - viewSize.width;
        }
        vpt.y += diff_y;
        if (vpt.y < 0) {
            vpt.y = 0;
        } else if (vpt.y + visibleSize.height > viewSize.height) {
            vpt.y -= vpt.y + visibleSize.height - viewSize.height;
        }
        vp.setViewPosition(vpt);
    }

    public int getWheelDivider() {
        return this.wheelDivider;
    }

    public void setWheelFactor(int wheelDivider) {
        this.wheelDivider = Math.max(2, wheelDivider);
    }

    public void scrollByWheel(MouseWheelEvent e) {
        if (e == null) {
            return;
        }
        JViewport vp = this.scrollPane.getViewport();
        Dimension visibleSize = vp.getExtentSize();
        int rotation = e.getWheelRotation();
        int diff_x = 0;
        int diff_y = 0;
        if (e.isShiftDown()) {
            int unit = visibleSize.width / this.getWheelDivider();
            diff_x = rotation * unit;
        } else {
            int unit = visibleSize.height / this.getWheelDivider();
            diff_y = rotation * unit;
        }
        this.scroll(diff_x, diff_y);
    }

    public void installDraggingListener(final JComponent comp, final DragPridicator predicator) {
        if (comp == null) {
            throw new IllegalArgumentException();
        }
        if (this.mouseListener == null) {
            this.mouseListener = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (predicator == null || predicator.isDraggable(e)) {
                        Point pt = SwingUtilities.convertPoint(comp, e.getPoint(), ScrollPaneDragScrollSupport.this.scrollPane);
                        ScrollPaneDragScrollSupport.this.drag(true, pt);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (predicator == null || predicator.isDraggable(e)) {
                        Point pt = SwingUtilities.convertPoint(comp, e.getPoint(), ScrollPaneDragScrollSupport.this.scrollPane);
                        ScrollPaneDragScrollSupport.this.drag(false, pt);
                    }
                }
            };
            comp.addMouseListener(this.mouseListener);
        }
        if (this.mouseMotionListener == null) {
            this.mouseMotionListener = new MouseMotionListener(){

                @Override
                public void mouseMoved(MouseEvent e) {
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    Point pt = SwingUtilities.convertPoint(comp, e.getPoint(), ScrollPaneDragScrollSupport.this.scrollPane);
                    ScrollPaneDragScrollSupport.this.dragging(pt);
                }
            };
            comp.addMouseMotionListener(this.mouseMotionListener);
        }
        if (this.mouseWheelListener == null) {
            this.mouseWheelListener = new MouseWheelListener(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent e) {
                    ScrollPaneDragScrollSupport.this.scrollByWheel(e);
                    e.consume();
                }
            };
            this.scrollPane.setWheelScrollingEnabled(false);
            comp.addMouseWheelListener(this.mouseWheelListener);
        }
        this.installTarget = comp;
    }

    public void uninstallDraggingListener() {
        if (this.mouseListener != null && this.installTarget != null) {
            this.installTarget.removeMouseListener(this.mouseListener);
            this.mouseListener = null;
        }
        if (this.mouseMotionListener != null && this.installTarget != null) {
            this.installTarget.removeMouseMotionListener(this.mouseMotionListener);
            this.mouseMotionListener = null;
        }
        if (this.mouseWheelListener != null && this.installTarget != null) {
            this.installTarget.removeMouseWheelListener(this.mouseWheelListener);
            this.mouseWheelListener = null;
        }
    }

    public static interface DragPridicator {
        public boolean isDraggable(MouseEvent var1);
    }
}

