/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.util;

import java.awt.Color;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class BeanPropertiesUtilities {
    private static final Logger logger = Logger.getLogger(BeanPropertiesUtilities.class.getName());

    private BeanPropertiesUtilities() {
        throw new RuntimeException("utilities class.");
    }

    public static Set<String> loadFromProperties(Object bean, Properties props) {
        if (bean == null || props == null) {
            throw new IllegalArgumentException();
        }
        HashSet<String> rejectNames = new HashSet<String>();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass());
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            int n = propertyDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                block29: {
                    String name;
                    String strVal;
                    PropertyDescriptor propDesc = propertyDescriptorArray[n2];
                    Class<?> typ = propDesc.getPropertyType();
                    Method mtdReader = propDesc.getReadMethod();
                    Method mtdWriter = propDesc.getWriteMethod();
                    if (mtdReader != null && mtdWriter != null && (strVal = props.getProperty(name = propDesc.getName())) != null) {
                        Exception reject = null;
                        try {
                            Object val;
                            if (String.class.equals(typ)) {
                                val = strVal;
                            } else if (strVal.length() == 0) {
                                val = null;
                            } else if (Boolean.class.equals(typ) || Boolean.TYPE.equals(typ)) {
                                val = Boolean.valueOf(strVal);
                            } else if (Integer.class.equals(typ) || Integer.TYPE.equals(typ)) {
                                val = Integer.valueOf(strVal);
                            } else if (Long.class.equals(typ) || Long.TYPE.equals(typ)) {
                                val = Long.valueOf(strVal);
                            } else if (Float.class.equals(typ) || Float.TYPE.equals(typ)) {
                                val = Float.valueOf(strVal);
                            } else if (Double.class.equals(typ) || Double.TYPE.equals(typ)) {
                                val = Double.valueOf(strVal);
                            } else if (BigInteger.class.equals(typ)) {
                                val = new BigInteger(strVal);
                            } else if (BigDecimal.class.equals(typ)) {
                                val = new BigDecimal(strVal);
                            } else {
                                if (!Color.class.equals(typ)) {
                                    rejectNames.add(name);
                                    logger.log(Level.WARNING, "unsupported propery type: " + typ + "/beanClass=" + bean.getClass() + " #" + name);
                                    break block29;
                                }
                                val = Color.decode(strVal);
                            }
                            mtdWriter.invoke(bean, val);
                            reject = null;
                        }
                        catch (InvocationTargetException ex) {
                            reject = ex;
                        }
                        catch (IllegalAccessException ex) {
                            reject = ex;
                        }
                        catch (RuntimeException ex) {
                            reject = ex;
                        }
                        if (reject != null) {
                            rejectNames.add(name);
                            logger.log(Level.WARNING, "invalid propery: " + typ + "/beanClass=" + bean.getClass() + " #" + name + " /val=" + strVal, reject);
                        }
                    }
                }
                ++n2;
            }
        }
        catch (IntrospectionException ex) {
            throw new RuntimeException("bean intorospector failed. :" + bean.getClass(), ex);
        }
        return rejectNames;
    }

    /*
     * Unable to fully structure code
     */
    public static void saveToProperties(Object bean, Properties props) {
        if (bean == null || props == null) {
            throw new IllegalArgumentException();
        }
        try {
            beanInfo = Introspector.getBeanInfo(bean.getClass());
            var6_6 = beanInfo.getPropertyDescriptors();
            var5_7 = var6_6.length;
            var4_8 = 0;
            while (var4_8 < var5_7) {
                block8: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    propDesc = var6_6[var4_8];
                                    mtdReader = propDesc.getReadMethod();
                                    mtdWriter = propDesc.getWriteMethod();
                                    if (mtdReader == null || mtdWriter == null) break block8;
                                    name = propDesc.getName();
                                    val = mtdReader.invoke(bean, new Object[0]);
                                    if (val != null) break block9;
                                    strVal = "";
                                    ** GOTO lbl35
                                }
                                if (!(val instanceof String)) break block10;
                                strVal = (String)val;
                                ** GOTO lbl35
                            }
                            if (!(val instanceof Number)) break block11;
                            strVal = ((Number)val).toString();
                            ** GOTO lbl35
                        }
                        if (!(val instanceof Boolean)) break block12;
                        strVal = (Boolean)val != false ? "true" : "false";
                        ** GOTO lbl35
                    }
                    if (!(val instanceof Color)) {
                        BeanPropertiesUtilities.logger.log(Level.WARNING, "unsupported propery type: " + val.getClass() + "/beanClass=" + bean.getClass() + " #" + name);
                    } else {
                        strVal = "#" + Integer.toHexString(((Color)val).getRGB() & 0xFFFFFF);
lbl35:
                        // 5 sources

                        props.setProperty(name, strVal);
                    }
                }
                ++var4_8;
            }
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("bean property read failed. :" + bean.getClass(), ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException("bean property read failed. :" + bean.getClass(), ex);
        }
        catch (IntrospectionException ex) {
            throw new RuntimeException("bean intorospector failed. :" + bean.getClass(), ex);
        }
    }
}

