/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.util;

import charactermanaj.util.ResourceNames;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Locale;

public abstract class LocalizedTextResource {
    public String getText(String name, Charset cs) {
        return this.getText(name, cs, Locale.getDefault());
    }

    public String getText(String name, Charset cs, Locale locale) {
        ResourceNames resourceNames = this.createResourceNames(name, locale);
        String text = this.loadText(resourceNames, cs);
        if (text == null) {
            throw new RuntimeException("resource not found: " + resourceNames);
        }
        return text;
    }

    protected ResourceNames createResourceNames(String name, Locale locale) {
        String ext;
        String basename;
        if (name == null || name.length() == 0 || locale == null) {
            throw new IllegalArgumentException();
        }
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        int extpos = name.lastIndexOf(".");
        int folderpos = name.lastIndexOf("/");
        if (folderpos > extpos) {
            basename = name;
            ext = "";
        } else {
            basename = name.substring(0, extpos);
            ext = name.substring(extpos);
        }
        String[] resourceNamesStr = new String[]{String.valueOf(basename) + "_" + language + "_" + country + "_" + variant + ext, String.valueOf(basename) + "_" + language + "_" + country + ext, String.valueOf(basename) + "_" + language + ext, String.valueOf(basename) + ext};
        return new ResourceNames(resourceNamesStr);
    }

    protected String loadText(ResourceNames resourceNames, Charset cs) {
        if (resourceNames == null || cs == null) {
            throw new IllegalArgumentException();
        }
        for (String resourceName : resourceNames) {
            URL url = this.getResource(resourceName);
            if (url == null) continue;
            StringBuilder buf = new StringBuilder();
            try {
                InputStream is = url.openStream();
                try {
                    BufferedReader rd = new BufferedReader(new InputStreamReader(is, cs));
                    try {
                        int ch;
                        while ((ch = rd.read()) != -1) {
                            buf.append((char)ch);
                        }
                    }
                    finally {
                        rd.close();
                    }
                }
                finally {
                    is.close();
                }
            }
            catch (IOException ex) {
                throw new RuntimeException("resource loading error: " + ex, ex);
            }
            return buf.toString();
        }
        return null;
    }

    protected abstract URL getResource(String var1);
}

