/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model;

import charactermanaj.model.Layer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class PartsCategory
implements Comparable<PartsCategory> {
    private final int order;
    private final String categoryId;
    private final String localizedCategoryName;
    private final boolean multipleSelectable;
    private final int visibleRows;
    private final List<Layer> layers;

    public PartsCategory(int order, String categoryId, String localizedCategoryName, boolean multipleSelectable, int visibleRows, Layer[] layers) {
        if (categoryId == null || categoryId.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        if (layers == null) {
            layers = new Layer[]{};
        }
        if (localizedCategoryName == null || localizedCategoryName.trim().length() == 0) {
            localizedCategoryName = categoryId;
        }
        this.order = order;
        this.categoryId = categoryId.trim();
        this.localizedCategoryName = localizedCategoryName.trim();
        this.multipleSelectable = multipleSelectable;
        this.layers = Collections.unmodifiableList(Arrays.asList((Object[])layers.clone()));
        this.visibleRows = visibleRows;
    }

    @Override
    public int compareTo(PartsCategory o) {
        if (o == this) {
            return 0;
        }
        int ret = this.order - o.order;
        if (ret == 0) {
            ret = this.localizedCategoryName.compareTo(o.localizedCategoryName);
        }
        if (ret == 0) {
            ret = this.categoryId.compareTo(o.categoryId);
        }
        return ret;
    }

    public int hashCode() {
        return this.categoryId.hashCode();
    }

    public boolean equals(Object obj) {
        PartsCategory o;
        if (obj == this) {
            return true;
        }
        return obj != null && obj instanceof PartsCategory && this.categoryId.equals((o = (PartsCategory)obj).getCategoryId()) && this.order == o.order && this.localizedCategoryName.equals(o.localizedCategoryName) && this.multipleSelectable == o.multipleSelectable && this.visibleRows == o.visibleRows && this.layers.equals(o.layers);
    }

    public boolean isSameCategoryID(PartsCategory obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null) {
            return this.categoryId.equals(obj.categoryId);
        }
        return false;
    }

    public static boolean equals(PartsCategory o1, PartsCategory o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public int getOrder() {
        return this.order;
    }

    public boolean isMultipleSelectable() {
        return this.multipleSelectable;
    }

    public int getVisibleRows() {
        return this.visibleRows;
    }

    public boolean hasLayer(Layer layer) {
        if (layer == null) {
            return false;
        }
        for (Layer memberLayer : this.layers) {
            if (!Layer.equals(memberLayer, layer)) continue;
            return true;
        }
        return false;
    }

    public List<Layer> getLayers() {
        return this.layers;
    }

    public Layer getLayer(String layerId) {
        if (layerId == null) {
            return null;
        }
        for (Layer layer : this.layers) {
            if (!layer.getId().equals(layerId)) continue;
            return layer;
        }
        return null;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public String getLocalizedCategoryName() {
        return this.localizedCategoryName;
    }

    public String toString() {
        return this.getLocalizedCategoryName();
    }
}

